/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.editors.TGExternalBeatViewerListener;
import org.herac.tuxguitar.gui.editors.TGRedrawListener;
import org.herac.tuxguitar.gui.editors.TGUpdateListener;
import org.herac.tuxguitar.song.models.TGBeat;

public class TGEditorManager {
    private List redrawListeners = new ArrayList();
    private List updateListeners = new ArrayList();
    private List beatViewerListeners = new ArrayList();

    public void doRedraw(int n) {
        for (int i = 0; i < this.redrawListeners.size(); ++i) {
            TGRedrawListener tGRedrawListener = (TGRedrawListener)this.redrawListeners.get(i);
            tGRedrawListener.doRedraw(n);
        }
    }

    public void doUpdate(int n) {
        for (int i = 0; i < this.updateListeners.size(); ++i) {
            TGUpdateListener tGUpdateListener = (TGUpdateListener)this.updateListeners.get(i);
            tGUpdateListener.doUpdate(n);
        }
    }

    public void showExternalBeat(TGBeat tGBeat) {
        for (int i = 0; i < this.beatViewerListeners.size(); ++i) {
            TGExternalBeatViewerListener tGExternalBeatViewerListener = (TGExternalBeatViewerListener)this.beatViewerListeners.get(i);
            tGExternalBeatViewerListener.showExternalBeat(tGBeat);
        }
    }

    public void hideExternalBeat() {
        for (int i = 0; i < this.beatViewerListeners.size(); ++i) {
            TGExternalBeatViewerListener tGExternalBeatViewerListener = (TGExternalBeatViewerListener)this.beatViewerListeners.get(i);
            tGExternalBeatViewerListener.hideExternalBeat();
        }
    }

    public void addRedrawListener(TGRedrawListener tGRedrawListener) {
        if (!this.redrawListeners.contains(tGRedrawListener)) {
            this.redrawListeners.add(tGRedrawListener);
        }
    }

    public void removeRedrawListener(TGRedrawListener tGRedrawListener) {
        if (this.redrawListeners.contains(tGRedrawListener)) {
            this.redrawListeners.remove(tGRedrawListener);
        }
    }

    public void addUpdateListener(TGUpdateListener tGUpdateListener) {
        if (!this.updateListeners.contains(tGUpdateListener)) {
            this.updateListeners.add(tGUpdateListener);
        }
    }

    public void removeUpdateListener(TGUpdateListener tGUpdateListener) {
        if (this.updateListeners.contains(tGUpdateListener)) {
            this.updateListeners.remove(tGUpdateListener);
        }
    }

    public void addBeatViewerListener(TGExternalBeatViewerListener tGExternalBeatViewerListener) {
        if (!this.beatViewerListeners.contains(tGExternalBeatViewerListener)) {
            this.beatViewerListeners.add(tGExternalBeatViewerListener);
        }
    }

    public void removeBeatViewerListener(TGExternalBeatViewerListener tGExternalBeatViewerListener) {
        if (this.beatViewerListeners.contains(tGExternalBeatViewerListener)) {
            this.beatViewerListeners.remove(tGExternalBeatViewerListener);
        }
    }
}

