/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.util.MidiTickUtil;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;

public class EditorCache {
    private boolean editUpdate;
    private TGBeatImpl editBeat;
    private int playTrack;
    private long playTick;
    private long playStart;
    private long playBeatEnd;
    private boolean playChanges;
    private boolean playUpdate;
    private TGBeatImpl playBeat;
    private TGMeasureImpl playMeasure;

    public EditorCache() {
        this.reset();
    }

    public void reset() {
        this.resetEditMode();
        this.resetPlayMode();
    }

    private void resetEditMode() {
        this.editBeat = null;
        this.editUpdate = false;
    }

    private void resetPlayMode() {
        this.playBeat = null;
        this.playMeasure = null;
        this.playUpdate = false;
        this.playChanges = false;
        this.playTrack = 0;
        this.playTick = 0L;
        this.playStart = 0L;
        this.playBeatEnd = 0L;
    }

    public void updateEditMode() {
        this.editUpdate = true;
        this.resetPlayMode();
        this.getEditBeat();
    }

    public void updatePlayMode() {
        this.playUpdate = true;
        this.resetEditMode();
        this.getPlayBeat();
    }

    public TGBeatImpl getEditBeat() {
        if (this.editUpdate) {
            this.editBeat = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSelectedBeat();
            this.editUpdate = false;
        }
        return this.editBeat;
    }

    public TGBeatImpl getPlayBeat() {
        if (this.playUpdate) {
            this.playChanges = false;
            TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
            if (TuxGuitar.instance().getPlayer().isRunning()) {
                Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
                TGTrackImpl tGTrackImpl = caret.getTrack();
                long l = TuxGuitar.instance().getPlayer().getTickPosition();
                long l2 = this.playStart + (l - this.playTick);
                if (this.playMeasure == null || l2 < this.playMeasure.getStart() || l2 > this.playMeasure.getStart() + this.playMeasure.getLength()) {
                    this.playMeasure = null;
                    l2 = MidiTickUtil.getStart(l);
                }
                if (this.playMeasure == null || this.playBeatEnd == 0L || l2 > this.playBeatEnd || l2 < this.playStart || tGTrackImpl.getNumber() != this.playTrack) {
                    this.playBeat = null;
                    this.playBeatEnd = 0L;
                    this.playChanges = true;
                    if (this.playMeasure == null || !this.playMeasure.hasTrack(tGTrackImpl.getNumber()) || !this.isPlaying(this.playMeasure)) {
                        this.playMeasure = (TGMeasureImpl)tGSongManager.getTrackManager().getMeasureAt(tGTrackImpl, l2);
                    }
                    if (this.playMeasure != null) {
                        this.playBeat = (TGBeatImpl)tGSongManager.getMeasureManager().getBeatIn(this.playMeasure, l2);
                        if (this.playBeat != null) {
                            TGBeat tGBeat = tGSongManager.getMeasureManager().getNextBeat(this.playMeasure.getBeats(), this.playBeat);
                            if (tGBeat != null) {
                                this.playBeatEnd = tGBeat.getStart();
                            } else {
                                TGDuration tGDuration = tGSongManager.getMeasureManager().getMinimumDuration(this.playBeat);
                                this.playBeatEnd = this.playBeat.getStart() + tGDuration.getTime();
                            }
                        }
                    }
                }
                this.playTrack = tGTrackImpl.getNumber();
                this.playTick = l;
                this.playStart = l2;
            }
            this.playUpdate = false;
        }
        return this.playBeat;
    }

    public long getPlayTick() {
        return this.playTick;
    }

    public long getPlayStart() {
        return this.playStart;
    }

    public TGMeasureImpl getPlayMeasure() {
        return this.playMeasure;
    }

    public boolean shouldRedraw() {
        return this.playChanges;
    }

    public boolean isPlaying(TGMeasure tGMeasure) {
        return TuxGuitar.instance().getPlayer().isRunning() && this.playMeasure != null && tGMeasure.equals(this.playMeasure);
    }

    public boolean isPlaying(TGMeasure tGMeasure, TGBeat tGBeat) {
        return this.isPlaying(tGMeasure) && this.playBeat != null && this.playBeat.getStart() == tGBeat.getStart();
    }
}

