/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;

public class InsertNoteAction
extends Action {
    public static final String NAME = "action.note.general.insert";

    public InsertNoteAction() {
        super(NAME, 23);
    }

    protected int execute(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        TGBeatImpl tGBeatImpl = caret.getSelectedBeat();
        if (tGBeatImpl != null) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            if (tGBeatImpl.getVoice(caret.getVoice()).isEmpty()) {
                this.getSongManager().getMeasureManager().addSilence(tGBeatImpl, caret.getDuration().clone(this.getSongManager().getFactory()), caret.getVoice());
            } else {
                long l = tGBeatImpl.getStart();
                long l2 = tGBeatImpl.getVoice(caret.getVoice()).getDuration().getTime();
                this.getSongManager().getMeasureManager().moveVoices(caret.getMeasure(), l, l2, caret.getVoice(), tGBeatImpl.getVoice(caret.getVoice()).getDuration());
            }
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
            this.updateTablature();
        }
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

