/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGNote;

public class DecrementNoteSemitoneAction
extends Action {
    public static final String NAME = "action.note.general.decrement-semitone";

    public DecrementNoteSemitoneAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGNote tGNote = this.getEditor().getTablature().getCaret().getSelectedNote();
        if (tGNote != null) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            if (this.getSongManager().getMeasureManager().moveSemitoneDown(this.getEditor().getTablature().getCaret().getMeasure(), tGNote.getVoice().getBeat().getStart(), tGNote.getString())) {
                this.addUndoableEdit(undoableMeasureGeneric.endUndo());
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
            }
            this.updateTablature();
        }
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

