/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import java.util.Iterator;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGVoice;

public class ChangeTiedNoteAction
extends Action {
    public static final String NAME = "action.note.general.tied";

    public ChangeTiedNoteAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        if (caret.getSelectedNote() != null) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            this.getSongManager().getMeasureManager().changeTieNote(caret.getSelectedNote());
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        } else {
            TGNote tGNote = this.getSongManager().getFactory().newNote();
            tGNote.setValue(0);
            tGNote.setVelocity(caret.getVelocity());
            tGNote.setString(caret.getSelectedString().getNumber());
            tGNote.setTiedNote(true);
            TGDuration tGDuration = this.getSongManager().getFactory().newDuration();
            caret.getDuration().copy(tGDuration);
            this.setTiedNoteValue(tGNote, caret);
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            this.getSongManager().getMeasureManager().addNote(caret.getSelectedBeat(), tGNote, tGDuration, caret.getVoice());
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        }
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        return 0;
    }

    private void setTiedNoteValue(TGNote tGNote, Caret caret) {
        TGMeasure tGMeasure = caret.getMeasure();
        TGVoice tGVoice = this.getSongManager().getMeasureManager().getPreviousVoice(tGMeasure.getBeats(), caret.getSelectedBeat(), caret.getVoice());
        while (tGMeasure != null) {
            while (tGVoice != null) {
                if (tGVoice.isRestVoice()) {
                    tGNote.setValue(0);
                    return;
                }
                Iterator iterator = tGVoice.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNote tGNote2 = (TGNote)iterator.next();
                    if (tGNote2.getString() != tGNote.getString()) continue;
                    tGNote.setValue(tGNote2.getValue());
                    return;
                }
                tGVoice = this.getSongManager().getMeasureManager().getPreviousVoice(tGMeasure.getBeats(), tGVoice.getBeat(), caret.getVoice());
            }
            tGMeasure = this.getSongManager().getTrackManager().getPrevMeasure(tGMeasure);
            if (tGMeasure == null) continue;
            tGVoice = this.getSongManager().getMeasureManager().getLastVoice(tGMeasure.getBeats(), caret.getVoice());
        }
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

