/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTempo;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.util.TGSynchronizer;

public class ChangeTempoAction
extends Action {
    public static final String NAME = "action.composition.change-tempo";
    private static final int MIN_TEMPO = 30;
    private static final int MAX_TEMPO = 320;
    protected static final int[] DEFAULT_PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 175, 200};

    public ChangeTempoAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        if (tGMeasureImpl != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout((Layout)new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.tempo"));
            Group group = new Group((Composite)shell2, 16);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("composition.tempo"));
            TGTempo tGTempo = tGMeasureImpl.getTempo();
            Label label = new Label((Composite)group, 0);
            label.setText(TuxGuitar.getProperty("composition.tempo"));
            final Spinner spinner = new Spinner((Composite)group, 2048);
            spinner.setLayoutData((Object)this.getSpinnerData());
            spinner.setMinimum(30);
            spinner.setMaximum(320);
            spinner.setSelection(tGTempo.getValue());
            Group group2 = new Group((Composite)shell2, 16);
            group2.setLayout((Layout)new GridLayout());
            group2.setLayoutData((Object)new GridData(4, 4, true, true));
            group2.setText(TuxGuitar.getProperty("options"));
            final Button button = new Button((Composite)group2, 16);
            button.setText(TuxGuitar.getProperty("composition.tempo.start-to-end"));
            final Button button2 = new Button((Composite)group2, 16);
            button2.setText(TuxGuitar.getProperty("composition.tempo.position-to-end"));
            Button button3 = new Button((Composite)group2, 16);
            button3.setText(TuxGuitar.getProperty("composition.tempo.position-to-next"));
            button.setSelection(true);
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
            Button button4 = new Button(composite, 8);
            button4.setText(TuxGuitar.getProperty("ok"));
            button4.setLayoutData((Object)this.getButtonData());
            button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    final int n = spinner.getSelection();
                    final boolean bl = button2.getSelection();
                    final boolean bl2 = button.getSelection();
                    shell2.dispose();
                    try {
                        TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                            public void run() throws Throwable {
                                ActionLock.lock();
                                TuxGuitar.instance().loadCursor(1);
                                ChangeTempoAction.this.setTempo(n, bl2, bl);
                                TuxGuitar.instance().updateCache(true);
                                TuxGuitar.instance().loadCursor(0);
                                ActionLock.unlock();
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        MessageDialog.errorMessage(throwable);
                    }
                }
            });
            Button button5 = new Button(composite, 8);
            button5.setText(TuxGuitar.getProperty("cancel"));
            button5.setLayoutData((Object)this.getButtonData());
            button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button4);
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private GridData getSpinnerData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 150;
        return gridData;
    }

    protected void setTempo(int n, boolean bl, boolean bl2) {
        if (n >= 30) {
            TGTempo tGTempo = this.getSongManager().getFactory().newTempo();
            tGTempo.setValue(n);
            long l = bl ? 960L : this.getEditor().getTablature().getCaret().getMeasure().getStart();
            boolean bl3 = bl || bl2;
            UndoableChangeTempo undoableChangeTempo = UndoableChangeTempo.startUndo();
            this.getSongManager().changeTempos(l, tGTempo, bl3);
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.updateTablature();
            this.addUndoableEdit(undoableChangeTempo.endUndo());
        }
    }

    public TGSongManager getSongManager() {
        return super.getSongManager();
    }
}

