/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionAdapter;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.util.TGSynchronizer;

public abstract class Action
extends ActionAdapter {
    protected static final int AUTO_LOCK = 1;
    protected static final int AUTO_UNLOCK = 2;
    protected static final int AUTO_UPDATE = 4;
    protected static final int KEY_BINDING_AVAILABLE = 8;
    protected static final int DISABLE_ON_PLAYING = 16;
    private String name;
    private int flags;

    public Action(String string, int n) {
        this.name = string;
        this.flags = n;
    }

    protected abstract int execute(TypedEvent var1);

    public synchronized void process(final TypedEvent typedEvent) {
        if (!ActionLock.isLocked() && !TuxGuitar.instance().isLocked()) {
            final int n = this.getFlags();
            if ((n & 0x10) != 0 && TuxGuitar.instance().getPlayer().isRunning()) {
                TuxGuitar.instance().updateCache((n & 4) != 0);
                return;
            }
            if ((n & 1) != 0) {
                ActionLock.lock();
            }
            try {
                TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                    public void run() throws Throwable {
                        if (!TuxGuitar.isDisposed()) {
                            int n2 = Action.this.execute(typedEvent);
                            TuxGuitar.instance().updateCache(((n | n2) & 4) != 0);
                            if (((n | n2) & 2) != 0) {
                                ActionLock.unlock();
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected int getFlags() {
        return this.flags;
    }

    public TGSongManager getSongManager() {
        return TuxGuitar.instance().getSongManager();
    }

    public TablatureEditor getEditor() {
        return TuxGuitar.instance().getTablatureEditor();
    }

    public String getName() {
        return this.name;
    }

    public boolean isKeyBindingAvailable() {
        return (this.getFlags() & 8) != 0;
    }

    public synchronized void updateTablature() {
        TuxGuitar.instance().fireUpdate();
    }

    public void fireUpdate(int n) {
        this.getEditor().getTablature().getViewLayout().fireUpdate(n);
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
        TuxGuitar.instance().getUndoableManager().addEdit(undoableEdit);
    }
}

