/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortImpl;

public class MidiSynth {
    private static final String JNI_LIBRARY_NAME = new String("tuxguitar-fluidsynth-jni");
    private long instance = this.malloc();
    private List drivers = new ArrayList();
    private MidiOutputPortImpl loadedPort = null;

    public boolean isInitialized() {
        return this.instance != 0L;
    }

    public void finalize() {
        if (this.isInitialized()) {
            this.free(this.instance);
            this.instance = 0L;
        }
    }

    public List getDrivers() {
        this.drivers.clear();
        if (this.isInitialized()) {
            this.findDrivers(this.instance);
        }
        return this.drivers;
    }

    public void loadDriver(String string) {
        if (this.isInitialized()) {
            this.loadDriver(this.instance, string);
        }
    }

    public boolean isConnected(MidiOutputPortImpl midiOutputPortImpl) {
        return midiOutputPortImpl != null && this.loadedPort != null && ((Object)((Object)this.loadedPort)).equals((Object)midiOutputPortImpl);
    }

    public void connect(MidiOutputPortImpl midiOutputPortImpl) {
        if (this.isInitialized()) {
            this.disconnect(this.loadedPort);
            this.loadFont(this.instance, midiOutputPortImpl.getSoundFont());
            this.loadedPort = midiOutputPortImpl;
        }
    }

    public void disconnect(MidiOutputPortImpl midiOutputPortImpl) {
        if (this.isInitialized() && this.isConnected(midiOutputPortImpl)) {
            this.unloadFont(this.instance);
            this.loadedPort = null;
        }
    }

    public void sendSystemReset() {
        if (this.isInitialized()) {
            this.systemReset(this.instance);
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        if (this.isInitialized()) {
            this.noteOn(this.instance, n, n2, n3);
        }
    }

    public void sendNoteOff(int n, int n2, int n3) {
        if (this.isInitialized()) {
            this.noteOff(this.instance, n, n2, n3);
        }
    }

    public void sendControlChange(int n, int n2, int n3) {
        if (this.isInitialized()) {
            this.controlChange(this.instance, n, n2, n3);
        }
    }

    public void sendProgramChange(int n, int n2) {
        if (this.isInitialized()) {
            this.programChange(this.instance, n, n2);
        }
    }

    public void sendPitchBend(int n, int n2) {
        if (this.isInitialized()) {
            this.pitchBend(this.instance, n, n2);
        }
    }

    protected void addDriver(String string) {
        this.drivers.add(string);
    }

    private native long malloc();

    private native void free(long var1);

    private native void findDrivers(long var1);

    private native void loadDriver(long var1, String var3);

    private native void loadFont(long var1, String var3);

    private native void unloadFont(long var1);

    private native void systemReset(long var1);

    private native void noteOn(long var1, int var3, int var4, int var5);

    private native void noteOff(long var1, int var3, int var4, int var5);

    private native void controlChange(long var1, int var3, int var4, int var5);

    private native void programChange(long var1, int var3, int var4);

    private native void pitchBend(long var1, int var3, int var4);

    static {
        System.loadLibrary(JNI_LIBRARY_NAME);
    }
}

