/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.plugins.TGPluginConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortProviderImpl;

public class MidiOutputPortSettings {
    private static final int TABLE_WIDTH = 350;
    private static final int TABLE_HEIGHT = 200;
    private TGConfigManager config;
    private MidiOutputPortProviderImpl provider;

    public MidiOutputPortSettings(MidiOutputPortProviderImpl midiOutputPortProviderImpl) {
        this.provider = midiOutputPortProviderImpl;
    }

    public TGConfigManager getConfig() {
        if (this.config == null) {
            this.config = new TGPluginConfigManager("tuxguitar-fluidsynth");
            this.config.init();
        }
        return this.config;
    }

    public String getDriver() {
        return this.getConfig().getStringConfigValue("audio.driver");
    }

    public void setDriver(String string) {
        TGConfigManager tGConfigManager = this.getConfig();
        if (string == null) {
            tGConfigManager.removeProperty("audio.driver");
        } else {
            tGConfigManager.setProperty("audio.driver", string);
        }
    }

    public List getSoundfonts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TGConfigManager tGConfigManager = this.getConfig();
        int n = tGConfigManager.getIntConfigValue("soundfont.count");
        for (int i = 0; i < n; ++i) {
            String string = tGConfigManager.getStringConfigValue("soundfont.path" + i);
            if (string == null || string.length() <= 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setSoundfonts(List list) {
        TGConfigManager tGConfigManager = this.getConfig();
        tGConfigManager.setProperty("soundfont.count", list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            tGConfigManager.setProperty("soundfont.path" + i, string);
        }
    }

    public void configure(Shell shell) {
        String string;
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)67680);
        shell2.setText(TuxGuitar.getProperty((String)"fluidsynth.settings"));
        shell2.setLayout((Layout)new GridLayout());
        shell2.setLayoutData((Object)new GridData(4, 4, true, true));
        final List list = this.provider.getSynth().getDrivers();
        String string2 = this.getDriver();
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        label.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.driver"));
        final Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, true));
        combo.add(TuxGuitar.getProperty((String)"fluidsynth.settings.driver.default"));
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            string = (String)list.get(i);
            combo.add(string);
            if (string2 == null || !string2.equals(string)) continue;
            n = i + 1;
        }
        combo.select(n);
        Composite composite2 = new Composite((Composite)shell2, 0);
        composite2.setLayout((Layout)this.getGridLayout(2));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        string = new Composite(composite2, 0);
        string.setLayout((Layout)new GridLayout());
        string.setLayoutData((Object)new GridData(4, 4, true, true));
        final Table table = new Table((Composite)string, 68356);
        table.setLayoutData((Object)new GridData(350, 200));
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(350);
        tableColumn.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.soundfont-list"));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        Button button = new Button(composite3, 8);
        button.setLayoutData((Object)this.getButtonData(4, 128, true, false));
        button.setText(TuxGuitar.getProperty((String)"add"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidiOutputPortSettings.this.addMidiPort(table);
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setText(TuxGuitar.getProperty((String)"remove"));
        button2.setLayoutData((Object)this.getButtonData(4, 128, true, false));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidiOutputPortSettings.this.removeMidiPort(table);
            }
        });
        Button button3 = new Button(composite3, 8);
        button3.setText(TuxGuitar.getProperty((String)"ok"));
        button3.setLayoutData((Object)this.getButtonData(4, 1024, true, true));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                final List list2 = MidiOutputPortSettings.this.getSelectedMidiPorts(table);
                final String string = MidiOutputPortSettings.this.getSelectedDriver(list, combo.getSelectionIndex());
                new Thread(new Runnable(){

                    public void run() {
                        MidiOutputPortSettings.this.update(string, list2);
                    }
                }).start();
                shell2.dispose();
            }
        });
        Button button4 = new Button(composite3, 8);
        button4.setText(TuxGuitar.getProperty((String)"cancel"));
        button4.setLayoutData((Object)this.getButtonData(4, 1024, true, false));
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        this.addMidiPorts(table);
        shell2.setDefaultButton(button3);
        DialogUtils.openDialog((Shell)shell2, (int)11);
    }

    protected GridLayout getGridLayout(int n) {
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    protected GridData getButtonData(int n, int n2, boolean bl, boolean bl2) {
        GridData gridData = new GridData(n, n2, bl, bl2);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void addMidiPorts(Table table) {
        Iterator iterator = this.getSoundfonts().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addMidiPort(table, string);
        }
    }

    protected void addMidiPort(Table table) {
        FileDialog fileDialog = new FileDialog(table.getShell());
        String string = fileDialog.open();
        if (string != null && string.length() > 0) {
            this.addMidiPort(table, string);
        }
    }

    protected void addMidiPort(Table table, String string) {
        TableItem tableItem = new TableItem(table, 0);
        tableItem.setText(string);
        tableItem.setData((Object)string);
    }

    protected void removeMidiPort(Table table) {
        int n = table.getSelectionIndex();
        if (n >= 0 && n < table.getItemCount()) {
            table.remove(n);
        }
    }

    protected List getSelectedMidiPorts(Table table) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = table.getItemCount();
        for (int i = 0; i < n; ++i) {
            TableItem tableItem = table.getItem(i);
            if (!(tableItem.getData() instanceof String)) continue;
            arrayList.add(tableItem.getData());
        }
        return arrayList;
    }

    protected String getSelectedDriver(List list, int n) {
        return n > 0 && n <= list.size() ? (String)list.get(n - 1) : null;
    }

    protected void update(String string, List list) {
        this.setDriver(string);
        this.setSoundfonts(list);
        this.getConfig().save();
        this.provider.getSynth().loadDriver(string);
    }
}

