/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.v10;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.util.TGVersion;

public class TGStream {
    public static final String TG_FORMAT_NAME = "TuxGuitar File Format";
    public static final String TG_FORMAT_VERSION = "TuxGuitar File Format - " + new TGVersion(1, 0, 0).getVersion();
    public static final String TG_FORMAT_EXTENSION = ".tg";
    protected static final int TRACK_LYRICS = 1;
    protected static final int CHANNEL_SOLO = 1;
    protected static final int CHANNEL_MUTE = 2;
    protected static final int MEASURE_HEADER_TIMESIGNATURE = 1;
    protected static final int MEASURE_HEADER_TEMPO = 2;
    protected static final int MEASURE_HEADER_REPEAT_OPEN = 4;
    protected static final int MEASURE_HEADER_REPEAT_CLOSE = 8;
    protected static final int MEASURE_HEADER_REPEAT_ALTERNATIVE = 16;
    protected static final int MEASURE_HEADER_MARKER = 32;
    protected static final int MEASURE_HEADER_TRIPLET_FEEL = 64;
    protected static final int MEASURE_CLEF = 1;
    protected static final int MEASURE_KEYSIGNATURE = 2;
    protected static final int BEAT_HAS_NEXT = 1;
    protected static final int BEAT_NEXT_DURATION = 2;
    protected static final int BEAT_HAS_NOTES = 4;
    protected static final int BEAT_HAS_CHORD = 8;
    protected static final int BEAT_HAS_TEXT = 16;
    protected static final int NOTE_HAS_NEXT = 1;
    protected static final int NOTE_TIED = 2;
    protected static final int NOTE_EFFECT = 4;
    protected static final int NOTE_VELOCITY = 8;
    protected static final int DURATION_DOTTED = 1;
    protected static final int DURATION_DOUBLE_DOTTED = 2;
    protected static final int DURATION_NO_TUPLETO = 4;
    protected static final int EFFECT_BEND = 1;
    protected static final int EFFECT_TREMOLO_BAR = 2;
    protected static final int EFFECT_HARMONIC = 4;
    protected static final int EFFECT_GRACE = 8;
    protected static final int EFFECT_TRILL = 16;
    protected static final int EFFECT_TREMOLO_PICKING = 32;
    protected static final int EFFECT_VIBRATO = 64;
    protected static final int EFFECT_DEAD = 128;
    protected static final int EFFECT_SLIDE = 256;
    protected static final int EFFECT_HAMMER = 512;
    protected static final int EFFECT_GHOST = 1024;
    protected static final int EFFECT_ACCENTUATED = 2048;
    protected static final int EFFECT_HEAVY_ACCENTUATED = 4096;
    protected static final int EFFECT_PALM_MUTE = 8192;
    protected static final int EFFECT_STACCATO = 16384;
    protected static final int EFFECT_TAPPING = 32768;
    protected static final int EFFECT_SLAPPING = 65536;
    protected static final int EFFECT_POPPING = 131072;
    protected static final int EFFECT_FADE_IN = 262144;
    protected static final int GRACE_FLAG_DEAD = 1;
    protected static final int GRACE_FLAG_ON_BEAT = 2;

    protected class TGBeatData {
        private long start;
        private int velocity;
        private TGDuration duration;

        protected TGBeatData(TGMeasure tGMeasure) {
            this.init(tGMeasure);
        }

        private void init(TGMeasure tGMeasure) {
            this.setStart(tGMeasure.getStart());
            this.setVelocity(95);
            this.setDuration(new TGFactory().newDuration());
        }

        public TGDuration getDuration() {
            return this.duration;
        }

        public void setDuration(TGDuration tGDuration) {
            this.duration = tGDuration;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long l) {
            this.start = l;
        }

        public int getVelocity() {
            return this.velocity;
        }

        public void setVelocity(int n) {
            this.velocity = n;
        }
    }
}

