/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.v10;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongExporter;
import org.herac.tuxguitar.io.tg.v10.TGStream;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGOutputStream
extends TGStream
implements TGSongExporter {
    private DataOutputStream dataOutputStream;

    public boolean isSupportedExtension(String string) {
        return string.toLowerCase().equals(".tg");
    }

    public String getExportName() {
        return "TuxGuitar 1.0";
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("TuxGuitar", "*.tg");
    }

    public boolean configure(boolean bl) {
        return true;
    }

    public void exportSong(OutputStream outputStream, TGSong tGSong) throws TGFileFormatException {
        try {
            this.dataOutputStream = new DataOutputStream(outputStream);
            this.writeVersion();
            this.write(tGSong);
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void writeVersion() {
        this.writeUnsignedByteString(TG_FORMAT_VERSION);
    }

    private void write(TGSong tGSong) {
        this.writeUnsignedByteString(tGSong.getName());
        this.writeUnsignedByteString(tGSong.getArtist());
        this.writeUnsignedByteString(tGSong.getAlbum());
        this.writeUnsignedByteString(tGSong.getAuthor());
        this.writeShort((short)tGSong.countMeasureHeaders());
        TGMeasureHeader tGMeasureHeader = null;
        Iterator iterator = tGSong.getMeasureHeaders();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader2 = (TGMeasureHeader)iterator.next();
            this.writeMeasureHeader(tGMeasureHeader2, tGMeasureHeader);
            tGMeasureHeader = tGMeasureHeader2;
        }
        this.writeByte(tGSong.countTracks());
        for (int i = 0; i < tGSong.countTracks(); ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            this.writeTrack(tGTrack);
        }
    }

    private void writeTrack(TGTrack tGTrack) {
        Object object;
        int n = 0;
        if (!tGTrack.getLyrics().isEmpty()) {
            n |= 1;
        }
        this.writeHeader(n);
        this.writeUnsignedByteString(tGTrack.getName());
        this.writeChannel(tGTrack);
        TGMeasure tGMeasure = null;
        Iterator iterator = tGTrack.getMeasures();
        while (iterator.hasNext()) {
            object = (TGMeasure)iterator.next();
            this.writeMeasure((TGMeasure)object, tGMeasure);
            tGMeasure = object;
        }
        this.writeByte(tGTrack.getStrings().size());
        object = tGTrack.getStrings().iterator();
        while (object.hasNext()) {
            TGString tGString = (TGString)object.next();
            this.writeInstrumentString(tGString);
        }
        this.writeByte(tGTrack.getOffset() - -24);
        this.writeRGBColor(tGTrack.getColor());
        if ((n & 1) != 0) {
            this.writeLyrics(tGTrack.getLyrics());
        }
    }

    private void writeMeasureHeader(TGMeasureHeader tGMeasureHeader, TGMeasureHeader tGMeasureHeader2) {
        int n = 0;
        if (tGMeasureHeader2 == null) {
            n |= 1;
            n |= 2;
            if (tGMeasureHeader.getTripletFeel() != 1) {
                n |= 0x40;
            }
        } else {
            int n2 = tGMeasureHeader.getTimeSignature().getNumerator();
            int n3 = tGMeasureHeader.getTimeSignature().getDenominator().getValue();
            int n4 = tGMeasureHeader2.getTimeSignature().getNumerator();
            int n5 = tGMeasureHeader2.getTimeSignature().getDenominator().getValue();
            if (n2 != n4 || n3 != n5) {
                n |= 1;
            }
            if (tGMeasureHeader.getTempo().getValue() != tGMeasureHeader2.getTempo().getValue()) {
                n |= 2;
            }
            if (tGMeasureHeader.getTripletFeel() != tGMeasureHeader2.getTripletFeel()) {
                n |= 0x40;
            }
        }
        n = tGMeasureHeader.isRepeatOpen() ? (n = n | 4) : n;
        n = tGMeasureHeader.getRepeatClose() > 0 ? (n = n | 8) : n;
        n = tGMeasureHeader.getRepeatAlternative() > 0 ? (n = n | 0x10) : n;
        n = tGMeasureHeader.hasMarker() ? (n = n | 0x20) : n;
        this.writeHeader(n);
        if ((n & 1) != 0) {
            this.writeTimeSignature(tGMeasureHeader.getTimeSignature());
        }
        if ((n & 2) != 0) {
            this.writeTempo(tGMeasureHeader.getTempo());
        }
        if ((n & 8) != 0) {
            this.writeShort((short)tGMeasureHeader.getRepeatClose());
        }
        if ((n & 0x10) != 0) {
            this.writeByte(tGMeasureHeader.getRepeatAlternative());
        }
        if ((n & 0x20) != 0) {
            this.writeMarker(tGMeasureHeader.getMarker());
        }
        if ((n & 0x40) != 0) {
            this.writeByte(tGMeasureHeader.getTripletFeel());
        }
    }

    private void writeMeasure(TGMeasure tGMeasure, TGMeasure tGMeasure2) {
        TGMeasure tGMeasure3 = new TGVoiceJoiner(new TGFactory(), tGMeasure).process();
        int n = 0;
        if (tGMeasure2 == null) {
            n |= 1;
            n |= 2;
        } else {
            if (tGMeasure3.getClef() != tGMeasure2.getClef()) {
                n |= 1;
            }
            if (tGMeasure3.getKeySignature() != tGMeasure2.getKeySignature()) {
                n |= 2;
            }
        }
        this.writeHeader(n);
        TGStream.TGBeatData tGBeatData = new TGStream.TGBeatData(this, tGMeasure3);
        this.writeBeats(tGMeasure3, tGBeatData);
        if ((n & 1) != 0) {
            this.writeByte(tGMeasure3.getClef());
        }
        if ((n & 2) != 0) {
            this.writeByte(tGMeasure3.getKeySignature());
        }
    }

    private void writeChannel(TGTrack tGTrack) {
        int n = 0;
        n = tGTrack.isSolo() ? (n = n | 1) : n;
        n = tGTrack.isMute() ? (n = n | 2) : n;
        this.writeHeader(n);
        this.writeByte(tGTrack.getChannel().getChannel());
        this.writeByte(tGTrack.getChannel().getEffectChannel());
        this.writeByte(tGTrack.getChannel().getInstrument());
        this.writeByte(tGTrack.getChannel().getVolume());
        this.writeByte(tGTrack.getChannel().getBalance());
        this.writeByte(tGTrack.getChannel().getChorus());
        this.writeByte(tGTrack.getChannel().getReverb());
        this.writeByte(tGTrack.getChannel().getPhaser());
        this.writeByte(tGTrack.getChannel().getTremolo());
    }

    private void writeBeats(TGMeasure tGMeasure, TGStream.TGBeatData tGBeatData) {
        int n = tGMeasure.countBeats();
        for (int i = 0; i < n; ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            this.writeBeat(tGBeat, tGBeatData, i + 1 < n);
        }
    }

    private void writeBeat(TGBeat tGBeat, TGStream.TGBeatData tGBeatData, boolean bl) {
        int n;
        TGVoice tGVoice = tGBeat.getVoice(0);
        int n2 = n = bl ? 1 : 0;
        if (!tGVoice.getDuration().isEqual(tGBeatData.getDuration())) {
            n |= 2;
            tGBeatData.setDuration(tGVoice.getDuration());
        }
        if (!tGBeat.isRestBeat()) {
            n |= 4;
        }
        if (tGBeat.getChord() != null) {
            n |= 8;
        }
        if (tGBeat.getText() != null) {
            n |= 0x10;
        }
        this.writeHeader(n);
        if ((n & 2) != 0) {
            this.writeDuration(tGVoice.getDuration());
        }
        if ((n & 4) != 0) {
            this.writeNotes(tGVoice, tGBeatData);
        }
        if ((n & 8) != 0) {
            this.writeChord(tGBeat.getChord());
        }
        if ((n & 0x10) != 0) {
            this.writeText(tGBeat.getText());
        }
    }

    private void writeNotes(TGVoice tGVoice, TGStream.TGBeatData tGBeatData) {
        for (int i = 0; i < tGVoice.countNotes(); ++i) {
            TGNote tGNote = tGVoice.getNote(i);
            int n = i + 1 < tGVoice.countNotes() ? 1 : 0;
            int n2 = n = tGNote.isTiedNote() ? (n = n | 2) : n;
            if (tGNote.getVelocity() != tGBeatData.getVelocity()) {
                tGBeatData.setVelocity(tGNote.getVelocity());
                n |= 8;
            }
            n = tGNote.getEffect().hasAnyEffect() ? (n = n | 4) : n;
            this.writeHeader(n);
            this.writeNote(n, tGNote);
        }
    }

    private void writeNote(int n, TGNote tGNote) {
        this.writeByte(tGNote.getValue());
        this.writeByte(tGNote.getString());
        if ((n & 8) != 0) {
            this.writeByte(tGNote.getVelocity());
        }
        if ((n & 4) != 0) {
            this.writeNoteEffect(tGNote.getEffect());
        }
    }

    private void writeChord(TGChord tGChord) {
        this.writeByte(tGChord.countStrings());
        this.writeUnsignedByteString(tGChord.getName());
        this.writeByte(tGChord.getFirstFret());
        for (int i = 0; i < tGChord.countStrings(); ++i) {
            this.writeByte(tGChord.getFretValue(i));
        }
    }

    private void writeText(TGText tGText) {
        this.writeUnsignedByteString(tGText.getValue());
    }

    private void writeInstrumentString(TGString tGString) {
        this.writeByte(tGString.getValue());
    }

    private void writeTempo(TGTempo tGTempo) {
        this.writeShort((short)tGTempo.getValue());
    }

    private void writeTimeSignature(TGTimeSignature tGTimeSignature) {
        this.writeByte(tGTimeSignature.getNumerator());
        this.writeDuration(tGTimeSignature.getDenominator());
    }

    private void writeDuration(TGDuration tGDuration) {
        int n = 0;
        n = tGDuration.isDotted() ? (n = n | 1) : n;
        n = tGDuration.isDoubleDotted() ? (n = n | 2) : n;
        n = !tGDuration.getTupleto().isEqual(TGTupleto.NORMAL) ? (n = n | 4) : n;
        this.writeHeader(n);
        this.writeByte(tGDuration.getValue());
        if ((n & 4) != 0) {
            this.writeTupleto(tGDuration.getTupleto());
        }
    }

    private void writeTupleto(TGTupleto tGTupleto) {
        this.writeByte(tGTupleto.getEnters());
        this.writeByte(tGTupleto.getTimes());
    }

    private void writeNoteEffect(TGNoteEffect tGNoteEffect) {
        int n = 0;
        n = tGNoteEffect.isBend() ? (n = n | 1) : n;
        n = tGNoteEffect.isTremoloBar() ? (n = n | 2) : n;
        n = tGNoteEffect.isHarmonic() ? (n = n | 4) : n;
        n = tGNoteEffect.isGrace() ? (n = n | 8) : n;
        n = tGNoteEffect.isTrill() ? (n = n | 0x10) : n;
        n = tGNoteEffect.isTremoloPicking() ? (n = n | 0x20) : n;
        n = tGNoteEffect.isVibrato() ? (n = n | 0x40) : n;
        n = tGNoteEffect.isDeadNote() ? (n = n | 0x80) : n;
        n = tGNoteEffect.isSlide() ? (n = n | 0x100) : n;
        n = tGNoteEffect.isHammer() ? (n = n | 0x200) : n;
        n = tGNoteEffect.isGhostNote() ? (n = n | 0x400) : n;
        n = tGNoteEffect.isAccentuatedNote() ? (n = n | 0x800) : n;
        n = tGNoteEffect.isHeavyAccentuatedNote() ? (n = n | 0x1000) : n;
        n = tGNoteEffect.isPalmMute() ? (n = n | 0x2000) : n;
        n = tGNoteEffect.isStaccato() ? (n = n | 0x4000) : n;
        n = tGNoteEffect.isTapping() ? (n = n | 0x8000) : n;
        n = tGNoteEffect.isSlapping() ? (n = n | 0x10000) : n;
        n = tGNoteEffect.isPopping() ? (n = n | 0x20000) : n;
        n = tGNoteEffect.isFadeIn() ? (n = n | 0x40000) : n;
        this.writeHeader(n, 3);
        if ((n & 1) != 0) {
            this.writeBendEffect(tGNoteEffect.getBend());
        }
        if ((n & 2) != 0) {
            this.writeTremoloBarEffect(tGNoteEffect.getTremoloBar());
        }
        if ((n & 4) != 0) {
            this.writeHarmonicEffect(tGNoteEffect.getHarmonic());
        }
        if ((n & 8) != 0) {
            this.writeGraceEffect(tGNoteEffect.getGrace());
        }
        if ((n & 0x10) != 0) {
            this.writeTrillEffect(tGNoteEffect.getTrill());
        }
        if ((n & 0x20) != 0) {
            this.writeTremoloPickingEffect(tGNoteEffect.getTremoloPicking());
        }
    }

    private void writeBendEffect(TGEffectBend tGEffectBend) {
        this.writeByte(tGEffectBend.getPoints().size());
        Iterator iterator = tGEffectBend.getPoints().iterator();
        while (iterator.hasNext()) {
            TGEffectBend.BendPoint bendPoint = (TGEffectBend.BendPoint)iterator.next();
            this.writeByte(bendPoint.getPosition());
            this.writeByte(bendPoint.getValue());
        }
    }

    private void writeTremoloBarEffect(TGEffectTremoloBar tGEffectTremoloBar) {
        this.writeByte(tGEffectTremoloBar.getPoints().size());
        Iterator iterator = tGEffectTremoloBar.getPoints().iterator();
        while (iterator.hasNext()) {
            TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint = (TGEffectTremoloBar.TremoloBarPoint)iterator.next();
            this.writeByte(tremoloBarPoint.getPosition());
            this.writeByte(tremoloBarPoint.getValue() + 12);
        }
    }

    private void writeHarmonicEffect(TGEffectHarmonic tGEffectHarmonic) {
        this.writeByte(tGEffectHarmonic.getType());
        if (tGEffectHarmonic.getType() != 1) {
            this.writeByte(tGEffectHarmonic.getData());
        }
    }

    private void writeGraceEffect(TGEffectGrace tGEffectGrace) {
        int n = 0;
        n = tGEffectGrace.isDead() ? (n = n | 1) : n;
        n = tGEffectGrace.isOnBeat() ? (n = n | 2) : n;
        this.writeHeader(n);
        this.writeByte(tGEffectGrace.getFret());
        this.writeByte(tGEffectGrace.getDuration());
        this.writeByte(tGEffectGrace.getDynamic());
        this.writeByte(tGEffectGrace.getTransition());
    }

    private void writeTremoloPickingEffect(TGEffectTremoloPicking tGEffectTremoloPicking) {
        this.writeByte(tGEffectTremoloPicking.getDuration().getValue());
    }

    private void writeTrillEffect(TGEffectTrill tGEffectTrill) {
        this.writeByte(tGEffectTrill.getFret());
        this.writeByte(tGEffectTrill.getDuration().getValue());
    }

    private void writeMarker(TGMarker tGMarker) {
        this.writeUnsignedByteString(tGMarker.getTitle());
        this.writeRGBColor(tGMarker.getColor());
    }

    private void writeRGBColor(TGColor tGColor) {
        this.writeByte(tGColor.getR());
        this.writeByte(tGColor.getG());
        this.writeByte(tGColor.getB());
    }

    private void writeLyrics(TGLyric tGLyric) {
        this.writeShort((short)tGLyric.getFrom());
        this.writeIntegerString(tGLyric.getLyrics());
    }

    public void writeByte(int n) {
        try {
            this.dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeUnsignedByteString(String string) {
        try {
            String string2 = string == null ? new String() : (string.length() > 255 ? string.substring(0, 255) : string);
            this.dataOutputStream.write(string2.length());
            this.dataOutputStream.writeChars(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeIntegerString(String string) {
        try {
            this.dataOutputStream.writeInt(string.length());
            this.dataOutputStream.writeChars(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeHeader(int n) {
        try {
            this.dataOutputStream.write(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeHeader(int n, int n2) {
        for (int i = n2; i > 0; --i) {
            this.writeHeader(n >>> 8 * i - 8 & 0xFF);
        }
    }

    public void writeShort(short s) {
        try {
            this.dataOutputStream.writeShort(s);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public class TGVoiceJoiner {
        private TGFactory factory;
        private TGMeasure measure;

        public TGVoiceJoiner(TGFactory tGFactory, TGMeasure tGMeasure) {
            this.factory = tGFactory;
            this.measure = tGMeasure.clone(tGFactory, tGMeasure.getHeader());
            this.measure.setTrack(tGMeasure.getTrack());
        }

        public TGMeasure process() {
            this.orderBeats();
            this.joinBeats();
            return this.measure;
        }

        public void joinBeats() {
            TGBeat tGBeat = null;
            boolean bl = true;
            long l = this.measure.getStart();
            long l2 = l + this.measure.getLength();
            for (int i = 0; i < this.measure.countBeats(); ++i) {
                TGVoice tGVoice;
                TGBeat tGBeat2 = this.measure.getBeat(i);
                TGVoice tGVoice2 = tGBeat2.getVoice(0);
                for (int j = 1; j < tGBeat2.countVoices(); ++j) {
                    TGVoice tGVoice3 = tGBeat2.getVoice(j);
                    if (tGVoice3.isEmpty()) continue;
                    for (int k = 0; k < tGVoice3.countNotes(); ++k) {
                        TGNote tGNote = tGVoice3.getNote(k);
                        tGVoice2.addNote(tGNote);
                    }
                }
                if (tGVoice2.isEmpty()) {
                    this.measure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                long l3 = tGBeat2.getStart();
                if (tGBeat != null) {
                    long l4 = tGBeat.getStart();
                    tGVoice = null;
                    for (int j = 0; j < tGBeat.countVoices(); ++j) {
                        long l5;
                        TGVoice tGVoice4 = tGBeat.getVoice(j);
                        if (tGVoice4.isEmpty() || l4 + (l5 = tGVoice4.getDuration().getTime()) > l3 || tGVoice != null && l5 <= tGVoice.getTime()) continue;
                        tGVoice = tGVoice4.getDuration();
                    }
                    if (tGVoice != null) {
                        tGVoice.copy(tGBeat.getVoice(0).getDuration());
                    } else {
                        if (tGVoice2.isRestVoice()) {
                            this.measure.removeBeat(tGBeat2);
                            bl = false;
                            break;
                        }
                        TGDuration tGDuration = TGDuration.fromTime((TGFactory)this.factory, (long)(l3 - l4));
                        tGDuration.copy(tGBeat.getVoice(0).getDuration());
                    }
                }
                TGDuration tGDuration = null;
                for (int j = 0; j < tGBeat2.countVoices(); ++j) {
                    long l6;
                    tGVoice = tGBeat2.getVoice(j);
                    if (tGVoice.isEmpty() || l3 + (l6 = tGVoice.getDuration().getTime()) > l2 || tGDuration != null && l6 <= tGDuration.getTime()) continue;
                    tGDuration = tGVoice.getDuration();
                }
                if (tGDuration == null) {
                    if (tGVoice2.isRestVoice()) {
                        this.measure.removeBeat(tGBeat2);
                        bl = false;
                        break;
                    }
                    TGDuration tGDuration2 = TGDuration.fromTime((TGFactory)this.factory, (long)(l2 - l3));
                    tGDuration2.copy(tGVoice2.getDuration());
                }
                tGBeat = tGBeat2;
            }
            if (!bl) {
                this.joinBeats();
            }
        }

        public void orderBeats() {
            for (int i = 0; i < this.measure.countBeats(); ++i) {
                TGBeat tGBeat = null;
                for (int j = i; j < this.measure.countBeats(); ++j) {
                    TGBeat tGBeat2 = this.measure.getBeat(j);
                    if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
                    tGBeat = tGBeat2;
                }
                this.measure.moveBeat(i, tGBeat);
            }
        }
    }
}

