/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.converter;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.tools.custom.converter.TGConverter;
import org.herac.tuxguitar.gui.tools.custom.converter.TGConverterListener;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGConverterProcess
implements TGConverterListener,
LanguageLoader,
IconLoader {
    private static final int SHELL_WIDTH = 650;
    private static final int SHELL_HEIGHT = 350;
    protected static final String EOL = "\n";
    protected static final Color COLOR_INFO = TuxGuitar.instance().getDisplay().getSystemColor(9);
    protected static final Color COLOR_ERROR = TuxGuitar.instance().getDisplay().getSystemColor(3);
    protected Shell dialog;
    protected StyledText output;
    protected Button buttonCancel;
    protected Button buttonClose;
    protected TGConverter converter;
    protected boolean finished;

    public void start(String string, String string2, String string3) {
        this.converter = new TGConverter(string, string2);
        this.converter.setExtension(string3);
        this.converter.setListener(this);
        this.showProcess();
        new Thread(new Runnable(){

            public void run() {
                TGConverterProcess.this.converter.process();
            }
        }).start();
    }

    protected void showProcess() {
        this.finished = false;
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)1264);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setSize(650, 350);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TuxGuitar.instance().getIconManager().removeLoader((IconLoader)TGConverterProcess.this);
                TuxGuitar.instance().getLanguageManager().removeLoader((LanguageLoader)TGConverterProcess.this);
            }
        });
        this.dialog.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                shellEvent.doit = TGConverterProcess.this.finished;
            }
        });
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.output = new StyledText(composite, 2818);
        this.output.setLayoutData((Object)new GridData(4, 4, true, true));
        this.output.setEditable(false);
        Composite composite2 = new Composite((Composite)this.dialog, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this.buttonCancel = new Button(composite2, 8);
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.setLayoutData((Object)this.getButtonsData());
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGConverterProcess.this.converter.setCancelled(true);
            }
        });
        this.buttonClose = new Button(composite2, 8);
        this.buttonClose.setEnabled(false);
        this.buttonClose.setLayoutData((Object)this.getButtonsData());
        this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGConverterProcess.this.dialog.dispose();
            }
        });
        this.loadIcons(false);
        this.loadProperties(false);
        TuxGuitar.instance().getIconManager().addLoader((IconLoader)this);
        TuxGuitar.instance().getLanguageManager().addLoader((LanguageLoader)this);
        DialogUtils.openDialog((Shell)this.dialog, (int)8);
    }

    private GridData getButtonsData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean bl) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"batch.converter"));
            this.buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
            this.buttonClose.setText(TuxGuitar.getProperty((String)"close"));
            if (bl) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean bl) {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
            if (bl) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void notifyFileProcess(final String string) {
        if (!this.isDisposed()) {
            try {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() {
                        if (!TGConverterProcess.this.isDisposed()) {
                            TGConverterProcess.this.output.append(TuxGuitar.getProperty((String)"batch.converter.messages.converting", (String[])new String[]{string}));
                            TGConverterProcess.this.output.setSelection(TGConverterProcess.this.output.getCharCount());
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void notifyFileResult(final String string, final int n) {
        if (!this.isDisposed()) {
            try {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() {
                        if (!TGConverterProcess.this.isDisposed()) {
                            TGConverterProcess.this.appendLogMessage(n, string);
                            TGConverterProcess.this.output.setSelection(TGConverterProcess.this.output.getCharCount());
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void notifyStart() {
        if (!this.isDisposed()) {
            try {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() {
                        if (!TGConverterProcess.this.isDisposed()) {
                            TGConverterProcess.this.finished = false;
                            TGConverterProcess.this.buttonClose.setEnabled(TGConverterProcess.this.finished);
                            TGConverterProcess.this.buttonCancel.setEnabled(!TGConverterProcess.this.finished);
                            TGConverterProcess.this.output.setCursor(TGConverterProcess.this.dialog.getDisplay().getSystemCursor(1));
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void notifyFinish() {
        if (!this.isDisposed()) {
            try {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() {
                        if (!TGConverterProcess.this.isDisposed()) {
                            TGConverterProcess.this.finished = true;
                            TGConverterProcess.this.buttonClose.setEnabled(TGConverterProcess.this.finished);
                            TGConverterProcess.this.buttonCancel.setEnabled(!TGConverterProcess.this.finished);
                            TGConverterProcess.this.output.setCursor(TGConverterProcess.this.dialog.getDisplay().getSystemCursor(0));
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void appendLogMessage(int n, String string) {
        String string2 = TuxGuitar.getProperty((String)("batch.converter.messages." + (n == 250 ? "ok" : "failed"))) + EOL;
        switch (n) {
            case 401: {
                string2 = string2 + TuxGuitar.getProperty((String)"batch.converter.messages.couldnt-write", (String[])new String[]{string}) + EOL;
                break;
            }
            case 403: {
                string2 = string2 + TuxGuitar.getProperty((String)"batch.converter.messages.bad-file", (String[])new String[]{string}) + EOL;
                break;
            }
            case 404: {
                string2 = string2 + TuxGuitar.getProperty((String)"batch.converter.messages.file-not-found", (String[])new String[]{string}) + EOL;
                break;
            }
            case 500: {
                string2 = string2 + TuxGuitar.getProperty((String)"batch.converter.messages.out-of-memory", (String[])new String[]{string}) + EOL;
                break;
            }
            case 590: {
                string2 = string2 + TuxGuitar.getProperty((String)"batch.converter.messages.exporter-not-found", (String[])new String[]{string}) + EOL;
                break;
            }
            case 666: {
                string2 = string2 + TuxGuitar.getProperty((String)"batch.converter.messages.unknown-error", (String[])new String[]{string}) + EOL;
            }
        }
        StyleRange styleRange = new StyleRange();
        styleRange.foreground = n == 250 ? COLOR_INFO : COLOR_ERROR;
        styleRange.start = this.output.getCharCount();
        styleRange.length = string2.length();
        this.output.append(string2);
        this.output.setStyleRange(styleRange);
    }
}

