/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.tools.custom.converter.TGConverterProcess;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGSongExporter;

public class TGConverterDialog
implements LanguageLoader,
IconLoader {
    private static final int SHELL_WIDTH = 500;
    protected List outputFormats = new ArrayList();
    protected Shell dialog;
    protected Group group;
    protected Label outputFormatLabel;
    protected Label outputFolderLabel;
    protected Label inputFolderLabel;
    protected Button inputFolderChooser;
    protected Button outputFolderChooser;
    protected Button buttonOK;
    protected Button buttonCancel;

    public void show() {
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)2144);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setMinimumSize(500, -1);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TuxGuitar.instance().getIconManager().removeLoader((IconLoader)TGConverterDialog.this);
                TuxGuitar.instance().getLanguageManager().removeLoader((LanguageLoader)TGConverterDialog.this);
            }
        });
        this.group = new Group((Composite)this.dialog, 16);
        this.group.setLayout((Layout)new GridLayout());
        this.group.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)this.group, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputFormatLabel = new Label(composite, 16384);
        this.outputFormatLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.addFileFormats(combo);
        this.inputFolderLabel = new Label(composite, 16384);
        this.inputFolderLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputFolderChooser = new Button(composite, 8);
        this.inputFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(TGConverterDialog.this.dialog);
                String string = directoryDialog.open();
                if (string != null) {
                    text.setText(string);
                }
            }
        });
        this.outputFolderLabel = new Label(composite, 16384);
        this.outputFolderLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text text2 = new Text(composite, 2048);
        text2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.outputFolderChooser = new Button(composite, 8);
        this.outputFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(TGConverterDialog.this.dialog);
                String string = directoryDialog.open();
                if (string != null) {
                    text2.setText(string);
                }
            }
        });
        Composite composite2 = new Composite((Composite)this.dialog, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this.buttonOK = new Button(composite2, 8);
        this.buttonOK.setLayoutData((Object)this.getGridData(80, 25));
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = text.getText();
                String string2 = text2.getText();
                String string3 = TGConverterDialog.this.getFileFormat(combo.getSelectionIndex());
                if (string == null || string.trim().length() == 0) {
                    MessageDialog.errorMessage((Shell)TGConverterDialog.this.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.input.folder.invalid"));
                } else if (string2 == null || string2.trim().length() == 0) {
                    MessageDialog.errorMessage((Shell)TGConverterDialog.this.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.output.folder.invalid"));
                } else if (string3 == null || string3.trim().length() == 0) {
                    MessageDialog.errorMessage((Shell)TGConverterDialog.this.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.output.format.invalid"));
                } else {
                    TGConverterProcess tGConverterProcess = new TGConverterProcess();
                    tGConverterProcess.start(string.trim(), string2.trim(), string3.trim());
                    TGConverterDialog.this.dialog.dispose();
                }
            }
        });
        this.buttonCancel = new Button(composite2, 8);
        this.buttonCancel.setLayoutData((Object)this.getGridData(80, 25));
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGConverterDialog.this.dialog.dispose();
            }
        });
        this.dialog.setDefaultButton(this.buttonOK);
        this.loadIcons(false);
        this.loadProperties(false);
        TuxGuitar.instance().getIconManager().addLoader((IconLoader)this);
        TuxGuitar.instance().getLanguageManager().addLoader((LanguageLoader)this);
        DialogUtils.openDialog((Shell)this.dialog, (int)10);
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    private GridData getGridData(int n, int n2) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = n;
        gridData.minimumHeight = n2;
        return gridData;
    }

    private void addFileFormats(Combo combo) {
        Iterator iterator;
        this.outputFormats.clear();
        Iterator iterator2 = TGFileFormatManager.instance().getOutputFormats().iterator();
        while (iterator2.hasNext()) {
            iterator = (TGFileFormat)iterator2.next();
            this.addFileFormats(combo, (TGFileFormat)iterator);
        }
        iterator = TGFileFormatManager.instance().getExporters();
        while (iterator.hasNext()) {
            TGSongExporter tGSongExporter = (TGSongExporter)iterator.next();
            this.addFileFormats(combo, tGSongExporter.getFileFormat());
        }
        if (this.outputFormats.size() > 0) {
            combo.select(0);
        }
    }

    private void addFileFormats(Combo combo, TGFileFormat tGFileFormat) {
        String[] stringArray;
        if (tGFileFormat.getSupportedFormats() != null && (stringArray = tGFileFormat.getSupportedFormats().split(TGFileFormat.EXTENSION_SEPARATOR)) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].indexOf(".");
                if (n < 0) continue;
                combo.add(tGFileFormat.getName() + " (" + stringArray[i] + ")");
                this.outputFormats.add(stringArray[i].substring(n));
            }
        }
    }

    protected String getFileFormat(int n) {
        if (n >= 0 && n < this.outputFormats.size()) {
            return (String)this.outputFormats.get(n);
        }
        return null;
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean bl) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"batch.converter"));
            this.group.setText(TuxGuitar.getProperty((String)"batch.converter.settings"));
            this.inputFolderLabel.setText(TuxGuitar.getProperty((String)"batch.converter.input.folder"));
            this.outputFolderLabel.setText(TuxGuitar.getProperty((String)"batch.converter.output.folder"));
            this.outputFormatLabel.setText(TuxGuitar.getProperty((String)"batch.converter.output.format"));
            this.buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
            this.buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
            if (bl) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean bl) {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
            this.inputFolderChooser.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
            this.outputFolderChooser.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
            if (bl) {
                this.dialog.layout(true, true);
            }
        }
    }
}

