/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MINMAXINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHACTIVATEINFO;
import org.eclipse.swt.internal.win32.SIPINFO;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    Menu activeMenu;
    ToolTip[] toolTips;
    int hIMC;
    int hwndMDIClient;
    int lpstrTip;
    int toolTipHandle;
    int balloonTipHandle;
    int minWidth = -1;
    int minHeight = -1;
    int[] brushes;
    boolean showWithParent;
    boolean fullScreen;
    boolean wasMaximized;
    boolean modified;
    String toolTitle;
    String balloonTitle;
    int toolIcon;
    int balloonIcon;
    int windowProc;
    Control lastActive;
    SHACTIVATEINFO psai;
    static int ToolTipProc;
    static final int DialogProc;
    static final TCHAR DialogClass;
    static final int[] SYSTEM_COLORS;
    static final int BRUSHES_SIZE = 32;

    static {
        DialogClass = new TCHAR(0, OS.IsWinCE ? "Dialog" : "#32770", true);
        SYSTEM_COLORS = new int[]{OS.COLOR_BTNFACE, OS.COLOR_WINDOW, OS.COLOR_BTNTEXT, OS.COLOR_WINDOWTEXT, OS.COLOR_HIGHLIGHT, OS.COLOR_SCROLLBAR};
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, DialogClass, wNDCLASS);
        DialogProc = wNDCLASS.lpfnWndProc;
    }

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, OS.IsWinCE ? 0 : 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0, false);
    }

    Shell(Display display, Shell shell, int n, int n2, boolean bl) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.style = Shell.checkStyle(n);
        this.parent = shell;
        this.display = display;
        this.handle = n2;
        if (n2 != 0 && !bl) {
            this.state |= 0x4000;
        }
        this.createWidget();
    }

    public Shell(Shell shell) {
        this(shell, OS.IsWinCE ? 0 : 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0, false);
    }

    public static Shell win32_new(Display display, int n) {
        return new Shell(display, null, 8, n, true);
    }

    public static Shell internal_new(Display display, int n) {
        return new Shell(display, null, 8, n, false);
    }

    static int checkStyle(int n) {
        n = Decorations.checkStyle(n);
        int n2 = 229376;
        int n3 = (n &= 0xBFFFFFFF) & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    int balloonTipHandle() {
        if (this.balloonTipHandle == 0) {
            this.createBalloonTipHandle();
        }
        return this.balloonTipHandle;
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            return 0;
        }
        if (n == this.toolTipHandle || n == this.balloonTipHandle) {
            return OS.CallWindowProc(ToolTipProc, n, n2, n3, n4);
        }
        if (this.hwndMDIClient != 0) {
            return OS.DefFrameProc(n, this.hwndMDIClient, n2, n3, n4);
        }
        if (this.windowProc != 0) {
            return OS.CallWindowProc(this.windowProc, n, n2, n3, n4);
        }
        if ((this.style & 4) != 0 && (this.style & (n5 = 3312)) == 0) {
            return OS.DefWindowProc(n, n2, n3, n4);
        }
        if (this.parent != null) {
            switch (n2) {
                case 7: 
                case 8: {
                    return OS.DefWindowProc(n, n2, n3, n4);
                }
            }
            return OS.CallWindowProc(DialogProc, n, n2, n3, n4);
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void createBalloonTipHandle() {
        this.balloonTipHandle = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 67, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
        if (this.balloonTipHandle == 0) {
            this.error(2);
        }
        if (ToolTipProc == 0) {
            ToolTipProc = OS.GetWindowLongPtr(this.balloonTipHandle, -4);
        }
        OS.SendMessage(this.balloonTipHandle, 1048, 0, Short.MAX_VALUE);
        this.display.addControl(this.balloonTipHandle, this);
        OS.SetWindowLongPtr(this.balloonTipHandle, -4, this.display.windowProc);
    }

    void createHandle() {
        boolean bl;
        boolean bl2 = bl = this.handle != 0 && (this.state & 0x4000) == 0;
        if (this.handle == 0 || bl) {
            super.createHandle();
        } else {
            this.state |= 2;
            if ((this.style & 0x300) == 0) {
                this.state |= 0x100;
            }
            this.windowProc = OS.GetWindowLong(this.handle, -4);
        }
        if (!bl) {
            int n = OS.GetWindowLong(this.handle, -16);
            n &= ~(OS.WS_OVERLAPPED | 0xC00000);
            if (!OS.IsWinCE) {
                n |= Integer.MIN_VALUE;
            }
            if ((this.style & 0x20) != 0) {
                n |= 0xC00000;
            }
            if ((this.style & 8) == 0 && (this.style & 0x810) == 0) {
                n |= 0x800000;
            }
            OS.SetWindowLong(this.handle, -16, n);
            int n2 = 55;
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, n2);
            if (OS.IsWinCE) {
                this._setMaximized(true);
            }
            if (OS.IsPPC) {
                this.psai = new SHACTIVATEINFO();
                this.psai.cbSize = SHACTIVATEINFO.sizeof;
            }
        }
        if (OS.IsDBLocale) {
            this.hIMC = OS.ImmCreateContext();
            if (this.hIMC != 0) {
                OS.ImmAssociateContext(this.handle, this.hIMC);
            }
        }
    }

    void createToolTip(ToolTip toolTip) {
        Object object;
        int n = 0;
        if (this.toolTips == null) {
            this.toolTips = new ToolTip[4];
        }
        while (n < this.toolTips.length && this.toolTips[n] != null) {
            ++n;
        }
        if (n == this.toolTips.length) {
            object = new ToolTip[this.toolTips.length + 4];
            System.arraycopy(this.toolTips, 0, object, 0, this.toolTips.length);
            this.toolTips = object;
        }
        this.toolTips[n] = toolTip;
        toolTip.id = n + 108;
        if (OS.IsWinCE) {
            return;
        }
        object = new TOOLINFO();
        object.cbSize = TOOLINFO.sizeof;
        object.hwnd = this.handle;
        object.uId = toolTip.id;
        object.uFlags = 32;
        object.lpszText = -1;
        OS.SendMessage(toolTip.hwndToolTip(), OS.TTM_ADDTOOL, 0, (TOOLINFO)object);
    }

    void createToolTipHandle() {
        this.toolTipHandle = OS.CreateWindowEx(0, new TCHAR(0, "tooltips_class32", true), null, 3, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0, OS.GetModuleHandle(null), null);
        if (this.toolTipHandle == 0) {
            this.error(2);
        }
        if (ToolTipProc == 0) {
            ToolTipProc = OS.GetWindowLongPtr(this.toolTipHandle, -4);
        }
        OS.SendMessage(this.toolTipHandle, 1048, 0, Short.MAX_VALUE);
        this.display.addControl(this.toolTipHandle, this);
        OS.SetWindowLongPtr(this.toolTipHandle, -4, this.display.windowProc);
    }

    void deregister() {
        super.deregister();
        if (this.toolTipHandle != 0) {
            this.display.removeControl(this.toolTipHandle);
        }
        if (this.balloonTipHandle != 0) {
            this.display.removeControl(this.balloonTipHandle);
        }
    }

    void destroyToolTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            return;
        }
        this.toolTips[toolTip.id - 108] = null;
        if (OS.IsWinCE) {
            return;
        }
        if (this.balloonTipHandle != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.uId = toolTip.id;
            tOOLINFO.hwnd = this.handle;
            OS.SendMessage(this.balloonTipHandle, OS.TTM_DELTOOL, 0, tOOLINFO);
        }
        toolTip.id = -1;
    }

    void destroyWidget() {
        this.fixActiveShell();
        super.destroyWidget();
    }

    public void dispose() {
        super.dispose();
    }

    void enableWidget(boolean bl) {
        this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        if (Display.TrimEnabled) {
            if (this.isActive()) {
                this.setItemEnabled(61536, bl);
            }
        } else {
            OS.EnableWindow(this.handle, bl);
        }
    }

    int findBrush(int n, int n2) {
        int n3;
        if (n2 == 0) {
            int n4 = 0;
            while (n4 < SYSTEM_COLORS.length) {
                if (n == OS.GetSysColor(SYSTEM_COLORS[n4])) {
                    return OS.GetSysColorBrush(SYSTEM_COLORS[n4]);
                }
                ++n4;
            }
        }
        if (this.brushes == null) {
            this.brushes = new int[32];
        }
        LOGBRUSH lOGBRUSH = new LOGBRUSH();
        int n5 = 0;
        while (n5 < this.brushes.length) {
            n3 = this.brushes[n5];
            if (n3 == 0) break;
            OS.GetObject(n3, LOGBRUSH.sizeof, lOGBRUSH);
            switch (lOGBRUSH.lbStyle) {
                case 0: {
                    if (n2 != 0 || lOGBRUSH.lbColor != n) break;
                    return n3;
                }
                case 3: {
                    if (n2 != 3 || lOGBRUSH.lbHatch != n) break;
                    return n3;
                }
            }
            ++n5;
        }
        n5 = this.brushes.length;
        n3 = this.brushes[--n5];
        if (n3 != 0) {
            OS.DeleteObject(n3);
        }
        System.arraycopy(this.brushes, 0, this.brushes, 1, n5);
        switch (n2) {
            case 0: {
                n3 = OS.CreateSolidBrush(n);
                break;
            }
            case 3: {
                n3 = OS.CreatePatternBrush(n);
            }
        }
        this.brushes[0] = n3;
        return this.brushes[0];
    }

    Control findBackgroundControl() {
        return this.background != -1 || this.backgroundImage != null ? this : null;
    }

    Cursor findCursor() {
        return this.cursor;
    }

    Control findThemeControl() {
        return null;
    }

    ToolTip findToolTip(int n) {
        if (this.toolTips == null) {
            return null;
        }
        return (n -= 108) >= 0 && n < this.toolTips.length ? this.toolTips[n] : null;
    }

    void fixActiveShell() {
        int n = OS.GetParent(this.handle);
        if (n != 0 && this.handle == OS.GetActiveWindow() && !OS.IsWindowEnabled(n) && OS.IsWindowVisible(n)) {
            OS.SetActiveWindow(n);
        }
    }

    void fixShell(Shell shell, Control control) {
        String string;
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if ((string = control.toolTipText) != null) {
            control.setToolTipText(this, null);
            control.setToolTipText(shell, string);
        }
    }

    void fixToolTip() {
        if (OS.COMCTL32_MAJOR >= 6) {
            if (this.toolTipHandle == 0) {
                return;
            }
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(this.toolTipHandle, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) != 0) {
                OS.SendMessage(this.toolTipHandle, OS.TTM_DELTOOL, 0, tOOLINFO);
                OS.SendMessage(this.toolTipHandle, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        OS.SetForegroundWindow(this.handle);
    }

    void forceResize() {
    }

    public int getAlpha() {
        byte[] byArray;
        this.checkWidget();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1) && OS.GetLayeredWindowAttributes(this.handle, null, byArray = new byte[1], null)) {
            return byArray[0] & 0xFF;
        }
        return 255;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getBounds();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n, n2);
    }

    ToolTip getCurrentToolTip() {
        ToolTip toolTip;
        if (this.toolTipHandle != 0 && (toolTip = this.getCurrentToolTip(this.toolTipHandle)) != null) {
            return toolTip;
        }
        if (this.balloonTipHandle != 0 && (toolTip = this.getCurrentToolTip(this.balloonTipHandle)) != null) {
            return toolTip;
        }
        return null;
    }

    ToolTip getCurrentToolTip(int n) {
        if (n == 0) {
            return null;
        }
        if (OS.SendMessage(n, OS.TTM_GETCURRENTTOOL, 0, 0) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(n, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) == 0) {
                return this.findToolTip(tOOLINFO.uId);
            }
        }
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public int getImeInputMode() {
        this.checkWidget();
        if (!OS.IsDBLocale) {
            return 0;
        }
        int n = OS.ImmGetContext(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        boolean bl = OS.ImmGetOpenStatus(n);
        if (bl) {
            bl = OS.ImmGetConversionStatus(n, nArray, nArray2);
        }
        OS.ImmReleaseContext(this.handle, n);
        if (!bl) {
            return 0;
        }
        int n2 = 0;
        if ((nArray[0] & 0x10) != 0) {
            n2 |= 0x20;
        }
        if ((nArray[0] & 8) != 0) {
            n2 |= 2;
        }
        if ((nArray[0] & 2) != 0) {
            return n2 | 0x10;
        }
        if ((nArray[0] & 1) != 0) {
            return n2 | 8;
        }
        return n2 | 4;
    }

    public Point getLocation() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getLocation();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        return new Point(rECT.left, rECT.top);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int n = Math.max(0, this.minWidth);
        int n2 = 1248;
        if ((this.style & 8) == 0 && (this.style & n2) != 0) {
            n = Math.max(n, OS.GetSystemMetrics(34));
        }
        int n3 = Math.max(0, this.minHeight);
        if ((this.style & 8) == 0 && (this.style & n2) != 0) {
            if ((this.style & 0x10) != 0) {
                n3 = Math.max(n3, OS.GetSystemMetrics(35));
            } else {
                RECT rECT = new RECT();
                int n4 = OS.GetWindowLong(this.handle, -16);
                int n5 = OS.GetWindowLong(this.handle, -20);
                OS.AdjustWindowRectEx(rECT, n4, false, n5);
                n3 = Math.max(n3, rECT.bottom - rECT.top);
            }
        }
        return new Point(n, n3);
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Point getSize() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            return super.getSize();
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Point(n, n2);
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        this.checkWidget();
        int n = 0;
        Shell[] shellArray2 = this.display.getShells();
        int n2 = 0;
        while (n2 < shellArray2.length) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.parent) != null && shellArray != this) {
            }
            if (shellArray == this) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        shellArray = new Shell[n];
        int n3 = 0;
        while (n3 < shellArray2.length) {
            Composite composite = shellArray2[n3];
            while ((composite = composite.parent) != null && composite != this) {
            }
            if (composite == this) {
                shellArray[n2++] = shellArray2[n3];
            }
            ++n3;
        }
        return shellArray;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int hwndMDIClient() {
        if (this.hwndMDIClient == 0) {
            int n = 1174405121;
            this.hwndMDIClient = OS.CreateWindowEx(0, new TCHAR(0, "MDICLIENT", true), null, n, 0, 0, 0, 0, this.handle, 0, OS.GetModuleHandle(null), new CREATESTRUCT());
        }
        return this.hwndMDIClient;
    }

    public void open() {
        this.checkWidget();
        STARTUPINFO sTARTUPINFO = Display.lpStartupInfo;
        if (sTARTUPINFO == null || (sTARTUPINFO.dwFlags & 1) == 0) {
            this.bringToTop();
            if (this.isDisposed()) {
                return;
            }
        }
        if (OS.IsWinCE) {
            OS.SetForegroundWindow(this.handle);
        }
        OS.SendMessage(this.handle, 295, 3, 0);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        MSG mSG = new MSG();
        int n = 0x400002;
        OS.PeekMessage(mSG, 0, 0, 0, n);
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void register() {
        super.register();
        if (this.toolTipHandle != 0) {
            this.display.addControl(this.toolTipHandle, this);
        }
        if (this.balloonTipHandle != 0) {
            this.display.addControl(this.balloonTipHandle, this);
        }
    }

    void releaseBrushes() {
        if (this.brushes != null) {
            int n = 0;
            while (n < this.brushes.length) {
                if (this.brushes[n] != 0) {
                    OS.DeleteObject(this.brushes[n]);
                }
                ++n;
            }
        }
        this.brushes = null;
    }

    void releaseChildren(boolean bl) {
        Widget widget;
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            widget = shellArray[n];
            if (widget != null && !widget.isDisposed()) {
                widget.release(false);
            }
            ++n;
        }
        if (this.toolTips != null) {
            n = 0;
            while (n < this.toolTips.length) {
                widget = this.toolTips[n];
                if (widget != null && !widget.isDisposed()) {
                    widget.release(false);
                }
                ++n;
            }
        }
        this.toolTips = null;
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndMDIClient = 0;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.releaseBrushes();
        this.activeMenu = null;
        this.display.clearModal(this);
        if (this.lpstrTip != 0) {
            int n = OS.GetProcessHeap();
            OS.HeapFree(n, 0, this.lpstrTip);
        }
        this.lpstrTip = 0;
        this.balloonTipHandle = 0;
        this.toolTipHandle = 0;
        if (OS.IsDBLocale && this.hIMC != 0) {
            OS.ImmDestroyContext(this.hIMC);
        }
        this.lastActive = null;
        this.balloonTitle = null;
        this.toolTitle = null;
    }

    void removeMenu(Menu menu) {
        super.removeMenu(menu);
        if (menu == this.activeMenu) {
            this.activeMenu = null;
        }
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(27, shellListener);
    }

    LRESULT selectPalette(int n) {
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SelectPalette(n2, n, false);
        int n4 = OS.RealizePalette(n2);
        if (n4 > 0) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            OS.SelectPalette(n2, n3, true);
            OS.RealizePalette(n2);
        }
        OS.ReleaseDC(this.handle, n2);
        return n4 > 0 ? LRESULT.ONE : LRESULT.ZERO;
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4, Event event) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        return super.sendKeyEvent(n, n2, n3, n4, event);
    }

    public void setActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        this.bringToTop();
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n = 0;
        int n2 = Math.min(controlArray.length, controlArray2.length);
        while (n < n2) {
            if (controlArray[n] != controlArray2[n]) break;
            ++n;
        }
        int n3 = controlArray2.length - 1;
        while (n3 >= n) {
            if (!controlArray2[n3].isDisposed()) {
                controlArray2[n3].sendEvent(27);
            }
            --n3;
        }
        n3 = controlArray.length - 1;
        while (n3 >= n) {
            if (!controlArray[n3].isDisposed()) {
                controlArray[n3].sendEvent(26);
            }
            --n3;
        }
    }

    public void setAlpha(int n) {
        this.checkWidget();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            int n2 = OS.GetWindowLong(this.handle, -20);
            if ((n &= 0xFF) == 255) {
                OS.SetWindowLong(this.handle, -20, n2 & 0xFFF7FFFF);
                int n3 = 1157;
                OS.RedrawWindow(this.handle, null, 0, n3);
            } else {
                OS.SetWindowLong(this.handle, -20, n2 | 0x80000);
                OS.SetLayeredWindowAttributes(this.handle, 0, (byte)n, 2);
            }
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if (((n6 = OS.GetWindowLong(this.handle, -20)) & 0x80000) != 0) {
            n5 &= 0xFFFFFFDF;
        }
        super.setBounds(n, n2, n3, n4, n5, false);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl) {
            return;
        }
        super.setEnabled(bl);
        if (bl && this.handle == OS.GetActiveWindow() && !this.restoreFocus()) {
            this.traverseGroup(true);
        }
    }

    public void setFullScreen(boolean bl) {
        this.checkWidget();
        if (this.fullScreen == bl) {
            return;
        }
        int n = bl ? OS.SW_SHOWMAXIMIZED : OS.SW_RESTORE;
        int n2 = OS.GetWindowLong(this.handle, -16);
        int n3 = 1248;
        if ((this.style & n3) != 0) {
            n2 = bl ? (n2 &= 0xFF3FFFFF) : (n2 |= 0xC00000);
        }
        if (bl) {
            this.wasMaximized = this.getMaximized();
        }
        boolean bl2 = this.isVisible();
        OS.SetWindowLong(this.handle, -16, n2);
        if (this.wasMaximized) {
            OS.ShowWindow(this.handle, 0);
            n = OS.SW_SHOWMAXIMIZED;
        }
        if (bl2) {
            OS.ShowWindow(this.handle, n);
        }
        OS.UpdateWindow(this.handle);
        this.fullScreen = bl;
    }

    public void setImeInputMode(int n) {
        int[] nArray;
        int[] nArray2;
        this.checkWidget();
        if (!OS.IsDBLocale) {
            return;
        }
        boolean bl = n != 0;
        int n2 = OS.ImmGetContext(this.handle);
        OS.ImmSetOpenStatus(n2, bl);
        if (bl && OS.ImmGetConversionStatus(n2, nArray2 = new int[1], nArray = new int[1])) {
            int n3 = 0;
            int n4 = 3;
            if ((n & 0x10) != 0) {
                n3 = 3;
                n4 = 0;
            } else if ((n & 8) != 0) {
                n3 = 1;
                n4 = 2;
            }
            if ((n & 0xA) != 0) {
                n3 |= 8;
            } else {
                n4 |= 8;
            }
            if ((n & 0x20) != 0) {
                n3 |= 0x10;
            } else {
                n4 |= 0x10;
            }
            nArray2[0] = nArray2[0] | n3;
            nArray2[0] = nArray2[0] & ~n4;
            OS.ImmSetConversionStatus(n2, nArray2[0], nArray[0]);
        }
        OS.ImmReleaseContext(this.handle, n2);
    }

    public void setMinimumSize(int n, int n2) {
        int n3;
        int n4;
        Object object;
        this.checkWidget();
        int n5 = 0;
        int n6 = 0;
        int n7 = 1248;
        if ((this.style & 8) == 0 && (this.style & n7) != 0) {
            n5 = OS.GetSystemMetrics(34);
            if ((this.style & 0x10) != 0) {
                n6 = OS.GetSystemMetrics(35);
            } else {
                object = new RECT();
                n4 = OS.GetWindowLong(this.handle, -16);
                n3 = OS.GetWindowLong(this.handle, -20);
                OS.AdjustWindowRectEx((RECT)object, n4, false, n3);
                n6 = ((RECT)object).bottom - ((RECT)object).top;
            }
        }
        this.minWidth = Math.max(n5, n);
        this.minHeight = Math.max(n6, n2);
        object = this.getSize();
        n4 = Math.max(((Point)object).x, this.minWidth);
        n3 = Math.max(((Point)object).y, this.minHeight);
        if (this.minWidth <= n5) {
            this.minWidth = -1;
        }
        if (this.minHeight <= n6) {
            this.minHeight = -1;
        }
        if (n4 != ((Point)object).x || n3 != ((Point)object).y) {
            this.setSize(n4, n3);
        }
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void setModified(boolean bl) {
        this.checkWidget();
        this.modified = bl;
    }

    void setItemEnabled(int n, boolean bl) {
        int n2 = OS.GetSystemMenu(this.handle, false);
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        if (!bl) {
            n3 = 3;
        }
        OS.EnableMenuItem(n2, n, n3);
    }

    void setParent() {
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        super.setRegion(region);
    }

    void setToolTipText(int n, String string) {
        if (OS.IsWinCE) {
            return;
        }
        TOOLINFO tOOLINFO = new TOOLINFO();
        tOOLINFO.cbSize = TOOLINFO.sizeof;
        tOOLINFO.hwnd = this.handle;
        tOOLINFO.uId = n;
        int n2 = this.toolTipHandle();
        if (string == null) {
            OS.SendMessage(n2, OS.TTM_DELTOOL, 0, tOOLINFO);
        } else if (OS.SendMessage(n2, OS.TTM_GETTOOLINFO, 0, tOOLINFO) != 0) {
            OS.SendMessage(n2, 1053, 0, 0);
        } else {
            tOOLINFO.uFlags = 17;
            tOOLINFO.lpszText = -1;
            OS.SendMessage(n2, OS.TTM_ADDTOOL, 0, tOOLINFO);
        }
    }

    void setToolTipText(NMTTDISPINFO nMTTDISPINFO, byte[] byArray) {
        if (!this.hasCursor()) {
            return;
        }
        int n = OS.GetProcessHeap();
        if (this.lpstrTip != 0) {
            OS.HeapFree(n, 0, this.lpstrTip);
        }
        int n2 = byArray.length;
        this.lpstrTip = OS.HeapAlloc(n, 8, n2);
        OS.MoveMemory(this.lpstrTip, byArray, n2);
        nMTTDISPINFO.lpszText = this.lpstrTip;
    }

    void setToolTipText(NMTTDISPINFO nMTTDISPINFO, char[] cArray) {
        if (!this.hasCursor()) {
            return;
        }
        int n = OS.GetProcessHeap();
        if (this.lpstrTip != 0) {
            OS.HeapFree(n, 0, this.lpstrTip);
        }
        int n2 = cArray.length * 2;
        this.lpstrTip = OS.HeapAlloc(n, 8, n2);
        OS.MoveMemory(this.lpstrTip, cArray, n2);
        nMTTDISPINFO.lpszText = this.lpstrTip;
    }

    void setToolTipTitle(int n, String string, int n2) {
        if (n != this.toolTipHandle && n != this.balloonTipHandle) {
            return;
        }
        if (n == this.toolTipHandle) {
            if ((string == this.toolTitle || this.toolTitle != null && this.toolTitle.equals(string)) && n2 == this.toolIcon) {
                return;
            }
            this.toolTitle = string;
            this.toolIcon = n2;
        } else if (n == this.balloonTipHandle) {
            if ((string == this.balloonTitle || this.balloonTitle != null && this.balloonTitle.equals(string)) && n2 == this.toolIcon) {
                return;
            }
            this.balloonTitle = string;
            this.balloonIcon = n2;
        }
        if (string != null) {
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SendMessage(n, OS.TTM_SETTITLE, n2, tCHAR);
        } else {
            OS.SendMessage(n, OS.TTM_SETTITLE, 0, 0);
        }
    }

    public void setVisible(boolean bl) {
        int n;
        int n2;
        this.checkWidget();
        int n3 = 229376;
        if ((this.style & n3) != 0) {
            if (bl) {
                Control control;
                this.display.setModalShell(this);
                if ((this.style & 0x30000) != 0) {
                    this.display.setModalDialog(null);
                }
                if ((control = this.display._getFocusControl()) != null && !control.isActive()) {
                    this.bringToTop();
                    if (this.isDisposed()) {
                        return;
                    }
                }
                if ((n2 = OS.GetActiveWindow()) == 0 && this.parent != null) {
                    n2 = this.parent.handle;
                }
                if (n2 != 0) {
                    OS.SendMessage(n2, 31, 0, 0);
                }
                OS.ReleaseCapture();
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (this.showWithParent && !bl && !OS.IsWinCE) {
            OS.ShowOwnedPopups(this.handle, false);
        }
        if (!bl) {
            this.fixActiveShell();
        }
        super.setVisible(bl);
        if (this.isDisposed()) {
            return;
        }
        if (this.showWithParent != bl) {
            this.showWithParent = bl;
            if (bl && !OS.IsWinCE) {
                OS.ShowOwnedPopups(this.handle, true);
            }
        }
        if (bl && this.parent != null && (this.parent.state & 0x4000) != 0 && ((n2 = OS.GetWindowLong(n = this.parent.handle, -20)) & 0x80) != 0) {
            OS.SetWindowLong(n, -20, n2 & 0xFFFFFF7F);
            OS.ShowWindow(n, 0);
            OS.ShowWindow(n, OS.SW_RESTORE);
        }
    }

    void subclass() {
        super.subclass();
        if (ToolTipProc != 0) {
            int n = this.display.windowProc;
            if (this.toolTipHandle != 0) {
                OS.SetWindowLongPtr(this.toolTipHandle, -4, n);
            }
            if (this.balloonTipHandle != 0) {
                OS.SetWindowLongPtr(this.balloonTipHandle, -4, n);
            }
        }
    }

    int toolTipHandle() {
        if (this.toolTipHandle == 0) {
            this.createToolTipHandle();
        }
        return this.toolTipHandle;
    }

    boolean translateAccelerator(MSG mSG) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        return this.translateMDIAccelerator(mSG) || this.translateMenuAccelerator(mSG);
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void unsubclass() {
        super.unsubclass();
        if (ToolTipProc != 0) {
            if (this.toolTipHandle != 0) {
                OS.SetWindowLongPtr(this.toolTipHandle, -4, ToolTipProc);
            }
            if (this.toolTipHandle != 0) {
                OS.SetWindowLongPtr(this.toolTipHandle, -4, ToolTipProc);
            }
        }
    }

    void updateModal() {
        if (Display.TrimEnabled) {
            this.setItemEnabled(61536, this.isActive());
        } else {
            OS.EnableWindow(this.handle, this.isActive());
        }
    }

    CREATESTRUCT widgetCreateStruct() {
        return null;
    }

    int widgetParent() {
        if (this.handle != 0) {
            return this.handle;
        }
        return this.parent != null ? this.parent.handle : 0;
    }

    int widgetExtStyle() {
        int n = super.widgetExtStyle() & 0xFFFFFFBF;
        if ((this.style & 4) != 0) {
            n |= 0x80;
        }
        if (!OS.IsWinCE && this.parent == null && (this.style & 0x4000) != 0) {
            int n2 = 1248;
            if ((this.style & 8) != 0 || (this.style & n2) == 0) {
                n |= 0x80;
            }
        }
        if (this.parent != null) {
            if (OS.IsWin95) {
                return n;
            }
            if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                return n;
            }
        }
        if ((this.style & 0x4000) != 0) {
            n |= 8;
        }
        return n;
    }

    TCHAR windowClass() {
        int n;
        if (OS.IsSP) {
            return DialogClass;
        }
        if ((this.style & 4) != 0 && (this.style & (n = 3312)) == 0) {
            return this.display.windowShadowClass;
        }
        return this.parent != null ? DialogClass : super.windowClass();
    }

    int windowProc() {
        int n;
        if (this.windowProc != 0) {
            return this.windowProc;
        }
        if (OS.IsSP) {
            return DialogProc;
        }
        if ((this.style & 4) != 0 && (this.style & (n = 3312)) == 0) {
            return super.windowProc();
        }
        return this.parent != null ? DialogProc : super.windowProc();
    }

    int windowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (n == this.toolTipHandle || n == this.balloonTipHandle) {
            switch (n2) {
                case 275: {
                    ToolTip toolTip;
                    if (n3 != 100 || (toolTip = this.getCurrentToolTip(n)) == null || !toolTip.autoHide) break;
                    toolTip.setVisible(false);
                    break;
                }
                case 513: {
                    ToolTip toolTip = this.getCurrentToolTip(n);
                    if (toolTip == null) break;
                    toolTip.setVisible(false);
                    toolTip.postEvent(13);
                }
            }
            return this.callWindowProc(n, n2, n3, n4);
        }
        return super.windowProc(n, n2, n3, n4);
    }

    int widgetStyle() {
        int n = super.widgetStyle();
        if (this.handle != 0) {
            return n | 0x40000000;
        }
        n &= 0xBFFFFFFF;
        if (OS.IsWinCE) {
            if (OS.IsSP) {
                return n | Integer.MIN_VALUE;
            }
            return this.parent == null ? n : n | Integer.MIN_VALUE;
        }
        return n | OS.WS_OVERLAPPED | 0xC00000;
    }

    LRESULT WM_ACTIVATE(int n, int n2) {
        ToolTip toolTip;
        if (OS.IsPPC) {
            if (this.hooks(33) || this.hooks(34)) {
                int n3 = OS.LOWORD(n);
                int n4 = n3 != 0 ? this.handle : 0;
                int n5 = 193;
                while (n5 <= 198) {
                    OS.SHSetAppKeyWndAssoc((byte)n5, n4);
                    ++n5;
                }
            }
            if (OS.LOWORD(n) != 0) {
                OS.SHSipPreference(this.handle, this.psai.fSipUp == 0 ? 1 : 0);
            }
        }
        if (OS.WIN32_VERSION >= OS.VERSION(5, 1) && OS.LOWORD(n) == 0 && OS.IsDBLocale && this.hIMC != 0 && OS.ImmGetOpenStatus(this.hIMC)) {
            OS.ImmNotifyIME(this.hIMC, 21, 1, 0);
        }
        LRESULT lRESULT = super.WM_ACTIVATE(n, n2);
        if (OS.LOWORD(n) == 0 && (n2 == 0 || n2 != this.toolTipHandle && n2 != this.balloonTipHandle) && (toolTip = this.getCurrentToolTip()) != null) {
            toolTip.setVisible(false);
        }
        return this.parent != null ? LRESULT.ZERO : lRESULT;
    }

    LRESULT WM_COMMAND(int n, int n2) {
        int n3;
        if (OS.IsPPC && (n3 = OS.LOWORD(n)) == 1 && (n2 == 0 || n2 == this.handle)) {
            OS.PostMessage(this.handle, 16, 0, 0);
            return LRESULT.ZERO;
        }
        if ((OS.IsPPC || OS.IsSP) && this.menuBar != null) {
            n3 = this.menuBar.hwndCB;
            if (n2 != 0 && n3 != 0) {
                if (n2 == n3) {
                    return super.WM_COMMAND(n, 0);
                }
                int n4 = OS.GetWindow(n3, 5);
                if (n2 == n4) {
                    return super.WM_COMMAND(n, 0);
                }
            }
        }
        return super.WM_COMMAND(n, n2);
    }

    LRESULT WM_DESTROY(int n, int n2) {
        LRESULT lRESULT = super.WM_DESTROY(n, n2);
        int n3 = OS.GetWindowLong(this.handle, -16);
        if ((n3 & 0x40000000) != 0) {
            this.releaseParent();
            this.release(false);
        }
        return lRESULT;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            this.drawBackground(n);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_ENTERIDLE(int n, int n2) {
        LRESULT lRESULT = super.WM_ENTERIDLE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.display.runMessages && this.display.runAsyncMessages(false)) {
            this.display.wakeThread();
        }
        return lRESULT;
    }

    LRESULT WM_GETMINMAXINFO(int n, int n2) {
        LRESULT lRESULT = super.WM_GETMINMAXINFO(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.minWidth != -1 || this.minHeight != -1) {
            MINMAXINFO mINMAXINFO = new MINMAXINFO();
            OS.MoveMemory(mINMAXINFO, n2, MINMAXINFO.sizeof);
            if (this.minWidth != -1) {
                mINMAXINFO.ptMinTrackSize_x = this.minWidth;
            }
            if (this.minHeight != -1) {
                mINMAXINFO.ptMinTrackSize_y = this.minHeight;
            }
            OS.MoveMemory(n2, mINMAXINFO, MINMAXINFO.sizeof);
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEACTIVATE(int n, int n2) {
        int n3;
        int n4;
        Object object;
        LRESULT lRESULT = super.WM_MOUSEACTIVATE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        short s = (short)OS.LOWORD(n2);
        switch (s) {
            case -2: 
            case -1: 
            case 0: {
                break;
            }
            default: {
                Decorations decorations;
                object = this.display._getFocusControl();
                if (object == null || (decorations = ((Control)object).menuShell()).getShell() != this || decorations == this) break;
                this.display.ignoreRestoreFocus = true;
                this.display.lastHittest = s;
                this.display.lastHittestControl = null;
                if (s == 5 || s == 3) {
                    this.display.lastHittestControl = object;
                    return null;
                }
                if (OS.IsWin95 && s == 2) {
                    this.display.lastHittestControl = object;
                }
                return new LRESULT(3);
            }
        }
        if (s == 5) {
            return null;
        }
        object = new POINT();
        if (!OS.GetCursorPos((POINT)object)) {
            int n5 = OS.GetMessagePos();
            OS.POINTSTOPOINT((POINT)object, n5);
        }
        if ((n4 = OS.WindowFromPoint((POINT)object)) == 0) {
            return null;
        }
        Control control = this.display.findControl(n4);
        if (control != null && (control.state & 2) != 0 && (control.style & 0x80000) != 0 && (this.style & (n3 = 540672)) == n3 && (s == 18 || s == 1)) {
            return new LRESULT(3);
        }
        n3 = this.callWindowProc(this.handle, 33, n, n2);
        this.setActiveControl(control);
        return new LRESULT(n3);
    }

    LRESULT WM_MOVE(int n, int n2) {
        LRESULT lRESULT = super.WM_MOVE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        ToolTip toolTip = this.getCurrentToolTip();
        if (toolTip != null) {
            toolTip.setVisible(false);
        }
        return lRESULT;
    }

    LRESULT WM_NCHITTEST(int n, int n2) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isEnabled() || !this.isActive()) {
            if (!Display.TrimEnabled) {
                return new LRESULT(0);
            }
            int n3 = this.callWindowProc(this.handle, 132, n, n2);
            if (n3 == 1 || n3 == 5) {
                n3 = 18;
            }
            return new LRESULT(n3);
        }
        if (this.menuBar != null && !this.menuBar.getEnabled()) {
            int n4 = this.callWindowProc(this.handle, 132, n, n2);
            if (n4 == 5) {
                n4 = 18;
            }
            return new LRESULT(n4);
        }
        return null;
    }

    LRESULT WM_NCLBUTTONDOWN(int n, int n2) {
        Control control;
        boolean bl;
        LRESULT lRESULT = super.WM_NCLBUTTONDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!this.display.ignoreRestoreFocus) {
            return lRESULT;
        }
        Display display = this.display;
        int n3 = 0;
        boolean bl2 = bl = OS.IsWin95 && display.lastHittest == 2;
        if (bl) {
            n3 = OS.SetActiveWindow(this.handle);
        }
        display.lockActiveWindow = true;
        int n4 = this.callWindowProc(this.handle, 161, n, n2);
        display.lockActiveWindow = false;
        if (bl) {
            OS.SetActiveWindow(n3);
        }
        if ((control = display.lastHittestControl) != null && !control.isDisposed()) {
            control.setFocus();
        }
        display.lastHittestControl = null;
        display.ignoreRestoreFocus = false;
        return new LRESULT(n4);
    }

    LRESULT WM_PALETTECHANGED(int n, int n2) {
        int n3;
        if (n != this.handle && (n3 = this.display.hPalette) != 0) {
            return this.selectPalette(n3);
        }
        return super.WM_PALETTECHANGED(n, n2);
    }

    LRESULT WM_QUERYNEWPALETTE(int n, int n2) {
        int n3 = this.display.hPalette;
        if (n3 != 0) {
            return this.selectPalette(n3);
        }
        return super.WM_QUERYNEWPALETTE(n, n2);
    }

    LRESULT WM_SETCURSOR(int n, int n2) {
        Control control;
        short s;
        int n3 = OS.HIWORD(n2);
        if (n3 == 513) {
            int n4;
            int n5;
            Shell shell;
            if (!Display.TrimEnabled && (shell = this.display.getModalShell()) != null && !this.isActive() && OS.IsWindowEnabled(n5 = shell.handle)) {
                OS.SetActiveWindow(n5);
            }
            if (!OS.IsWindowEnabled(this.handle) && !OS.IsWinCE && (n4 = OS.GetLastActivePopup(this.handle)) != 0 && n4 != this.handle && this.display.getControl(n4) == null && OS.IsWindowEnabled(n4)) {
                OS.SetActiveWindow(n4);
            }
        }
        if ((s = (short)OS.LOWORD(n2)) == -2 && !this.getEnabled() && (control = this.display.getControl(n)) == this && this.cursor != null) {
            POINT pOINT = new POINT();
            int n6 = OS.GetMessagePos();
            OS.POINTSTOPOINT(pOINT, n6);
            OS.ScreenToClient(this.handle, pOINT);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            if (OS.PtInRect(rECT, pOINT)) {
                OS.SetCursor(this.cursor.handle);
                switch (n3) {
                    case 513: 
                    case 516: 
                    case 519: 
                    case 523: {
                        OS.MessageBeep(0);
                    }
                }
                return LRESULT.ONE;
            }
        }
        return super.WM_SETCURSOR(n, n2);
    }

    LRESULT WM_SETTINGCHANGE(int n, int n2) {
        LRESULT lRESULT = super.WM_SETTINGCHANGE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsPPC && n == 224) {
            if ((this.style & 0x10) != 0) {
                OS.SHHandleWMSettingChange(this.handle, n, n2, this.psai);
                return LRESULT.ZERO;
            }
            SIPINFO sIPINFO = new SIPINFO();
            sIPINFO.cbSize = SIPINFO.sizeof;
            OS.SipGetInfo(sIPINFO);
            this.psai.fSipUp = sIPINFO.fdwFlags & 1;
        }
        return lRESULT;
    }

    LRESULT WM_SHOWWINDOW(int n, int n2) {
        LRESULT lRESULT = super.WM_SHOWWINDOW(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (n2 == 3) {
            Composite composite = this;
            while (composite != null) {
                Shell shell = ((Control)composite).getShell();
                if (!shell.showWithParent) {
                    return LRESULT.ZERO;
                }
                composite = composite.parent;
            }
        }
        return lRESULT;
    }

    LRESULT WM_SYSCOMMAND(int n, int n2) {
        LRESULT lRESULT = super.WM_SYSCOMMAND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinNT) {
            int n3 = n & 0xFFF0;
            switch (n3) {
                case 61472: {
                    long l = Runtime.getRuntime().totalMemory();
                    if (l < 0x2000000L) break;
                    OS.ShowWindow(this.handle, 2);
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n2, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 1) == 0) {
            wINDOWPOS.cx = Math.max(wINDOWPOS.cx, this.minWidth);
            int n3 = 1248;
            if ((this.style & 8) == 0 && (this.style & n3) != 0) {
                wINDOWPOS.cx = Math.max(wINDOWPOS.cx, OS.GetSystemMetrics(34));
            }
            wINDOWPOS.cy = Math.max(wINDOWPOS.cy, this.minHeight);
            if ((this.style & 8) == 0 && (this.style & n3) != 0) {
                if ((this.style & 0x10) != 0) {
                    wINDOWPOS.cy = Math.max(wINDOWPOS.cy, OS.GetSystemMetrics(35));
                } else {
                    RECT rECT = new RECT();
                    int n4 = OS.GetWindowLong(this.handle, -16);
                    int n5 = OS.GetWindowLong(this.handle, -20);
                    OS.AdjustWindowRectEx(rECT, n4, false, n5);
                    wINDOWPOS.cy = Math.max(wINDOWPOS.cy, rECT.bottom - rECT.top);
                }
            }
            OS.MoveMemory(n2, wINDOWPOS, WINDOWPOS.sizeof);
        }
        return lRESULT;
    }
}

