/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.gtp.GTPOutputStream;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.io.gtp.GTPVoiceJoiner;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;

public class GP4OutputStream
extends GTPOutputStream {
    private static final String GP4_FORMAT_EXTENSION = ".gp4";
    private static final String GP4_VERSION = "FICHIER GUITAR PRO v4.00";
    private static final int GP_BEND_SEMITONE = 25;
    private static final int GP_BEND_POSITION = 60;

    public GP4OutputStream(GTPSettings gTPSettings) {
        super(gTPSettings);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Guitar Pro 4", "*.gp4");
    }

    public boolean isSupportedExtension(String string) {
        return string.toLowerCase().equals(GP4_FORMAT_EXTENSION);
    }

    public void writeSong(TGSong tGSong) {
        try {
            if (tGSong.isEmpty()) {
                throw new TGFileFormatException("Empty Song!!!");
            }
            TGMeasureHeader tGMeasureHeader = tGSong.getMeasureHeader(0);
            this.writeStringByte(GP4_VERSION, 30, "UTF-8");
            this.writeInfo(tGSong);
            this.writeBoolean(tGMeasureHeader.getTripletFeel() == 2);
            this.writeLyrics(tGSong);
            this.writeInt(tGMeasureHeader.getTempo().getValue());
            this.writeInt(0);
            this.writeByte((byte)0);
            this.writeChannels(tGSong);
            this.writeInt(tGSong.countMeasureHeaders());
            this.writeInt(tGSong.countTracks());
            this.writeMeasures(tGSong);
            this.writeTracks(tGSong);
            this.writeMeasures(tGSong, tGMeasureHeader.getTempo().clone(this.getFactory()));
            this.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeInfo(TGSong tGSong) throws IOException {
        this.writeStringByteSizeOfInteger(tGSong.getName());
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger(tGSong.getArtist());
        this.writeStringByteSizeOfInteger(tGSong.getAlbum());
        this.writeStringByteSizeOfInteger(tGSong.getAuthor());
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger("");
        this.writeInt(0);
    }

    private void writeChannels(TGSong tGSong) throws IOException {
        TGChannel[] tGChannelArray = this.makeChannels(tGSong);
        for (int i = 0; i < tGChannelArray.length; ++i) {
            this.writeInt(tGChannelArray[i].getInstrument());
            this.writeByte(this.toChannelByte(tGChannelArray[i].getVolume()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getBalance()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getChorus()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getReverb()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getPhaser()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getTremolo()));
            this.writeBytes(new byte[]{0, 0});
        }
    }

    private void writeMeasures(TGSong tGSong, TGTempo tGTempo) throws IOException {
        for (int i = 0; i < tGSong.countMeasureHeaders(); ++i) {
            TGMeasureHeader tGMeasureHeader = tGSong.getMeasureHeader(i);
            for (int j = 0; j < tGSong.countTracks(); ++j) {
                TGTrack tGTrack = tGSong.getTrack(j);
                TGMeasure tGMeasure = tGTrack.getMeasure(i);
                this.writeMeasure(tGMeasure, tGMeasureHeader.getTempo().getValue() != tGTempo.getValue());
            }
            tGMeasureHeader.getTempo().copy(tGTempo);
        }
    }

    private void writeLyrics(TGSong tGSong) throws IOException {
        TGTrack tGTrack = null;
        Iterator iterator = tGSong.getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack2 = (TGTrack)iterator.next();
            if (tGTrack2.getLyrics().isEmpty()) continue;
            tGTrack = tGTrack2;
            break;
        }
        this.writeInt(tGTrack == null ? 0 : tGTrack.getNumber());
        this.writeInt(tGTrack == null ? 0 : tGTrack.getLyrics().getFrom());
        this.writeStringInteger(tGTrack == null ? "" : tGTrack.getLyrics().getLyrics());
        for (int i = 0; i < 4; ++i) {
            this.writeInt(tGTrack == null ? 0 : 1);
            this.writeStringInteger("");
        }
    }

    private void writeMeasures(TGSong tGSong) throws IOException {
        TGTimeSignature tGTimeSignature = this.getFactory().newTimeSignature();
        if (tGSong.countMeasureHeaders() > 0) {
            for (int i = 0; i < tGSong.countMeasureHeaders(); ++i) {
                TGMeasureHeader tGMeasureHeader = tGSong.getMeasureHeader(i);
                this.writeMeasureHeader(tGMeasureHeader, tGTimeSignature);
                tGTimeSignature.setNumerator(tGMeasureHeader.getTimeSignature().getNumerator());
                tGTimeSignature.getDenominator().setValue(tGMeasureHeader.getTimeSignature().getDenominator().getValue());
            }
        }
    }

    private void writeMeasureHeader(TGMeasureHeader tGMeasureHeader, TGTimeSignature tGTimeSignature) throws IOException {
        int n = 0;
        if (tGMeasureHeader.getNumber() == 1 || tGMeasureHeader.getTimeSignature().getNumerator() != tGTimeSignature.getNumerator()) {
            n |= 1;
        }
        if (tGMeasureHeader.getNumber() == 1 || tGMeasureHeader.getTimeSignature().getDenominator().getValue() != tGTimeSignature.getDenominator().getValue()) {
            n |= 2;
        }
        if (tGMeasureHeader.isRepeatOpen()) {
            n |= 4;
        }
        if (tGMeasureHeader.getRepeatClose() > 0) {
            n |= 8;
        }
        if (tGMeasureHeader.hasMarker()) {
            n |= 0x20;
        }
        this.writeUnsignedByte(n);
        if ((n & 1) != 0) {
            this.writeByte((byte)tGMeasureHeader.getTimeSignature().getNumerator());
        }
        if ((n & 2) != 0) {
            this.writeByte((byte)tGMeasureHeader.getTimeSignature().getDenominator().getValue());
        }
        if ((n & 8) != 0) {
            this.writeByte((byte)tGMeasureHeader.getRepeatClose());
        }
        if ((n & 0x20) != 0) {
            this.writeMarker(tGMeasureHeader.getMarker());
        }
    }

    private void writeTracks(TGSong tGSong) throws IOException {
        for (int i = 0; i < tGSong.countTracks(); ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            this.writeTrack(tGTrack);
        }
    }

    private void writeTrack(TGTrack tGTrack) throws IOException {
        int n = 0;
        if (tGTrack.isPercussionTrack()) {
            n |= 1;
        }
        this.writeUnsignedByte(n);
        this.writeStringByte(tGTrack.getName(), 40);
        this.writeInt(tGTrack.getStrings().size());
        for (int i = 0; i < 7; ++i) {
            int n2 = 0;
            if (tGTrack.getStrings().size() > i) {
                TGString tGString = (TGString)tGTrack.getStrings().get(i);
                n2 = tGString.getValue();
            }
            this.writeInt(n2);
        }
        this.writeInt(1);
        this.writeInt(tGTrack.getChannel().getChannel() + 1);
        this.writeInt(tGTrack.getChannel().getEffectChannel() + 1);
        this.writeInt(24);
        this.writeInt(Math.min(Math.max(tGTrack.getOffset(), 0), 12));
        this.writeColor(tGTrack.getColor());
    }

    private void writeMeasure(TGMeasure tGMeasure, boolean bl) throws IOException {
        TGMeasure tGMeasure2 = new GTPVoiceJoiner(this.getFactory(), tGMeasure).process();
        int n = tGMeasure2.countBeats();
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            TGBeat tGBeat = tGMeasure2.getBeat(i);
            this.writeBeat(tGBeat, tGMeasure2, bl && i == 0);
        }
    }

    private void writeBeat(TGBeat tGBeat, TGMeasure tGMeasure, boolean bl) throws IOException {
        int n;
        int n2;
        TGVoice tGVoice = tGBeat.getVoice(0);
        TGDuration tGDuration = tGVoice.getDuration();
        TGNoteEffect tGNoteEffect = this.getFactory().newEffect();
        for (n2 = 0; n2 < tGVoice.countNotes(); ++n2) {
            TGNote tGNote = tGVoice.getNote(n2);
            if (tGNote.getEffect().isFadeIn()) {
                tGNoteEffect.setFadeIn(true);
            }
            if (tGNote.getEffect().isTremoloBar()) {
                tGNoteEffect.setTremoloBar(tGNote.getEffect().getTremoloBar().clone(this.getFactory()));
            }
            if (tGNote.getEffect().isTapping()) {
                tGNoteEffect.setTapping(true);
            }
            if (tGNote.getEffect().isSlapping()) {
                tGNoteEffect.setSlapping(true);
            }
            if (!tGNote.getEffect().isPopping()) continue;
            tGNoteEffect.setPopping(true);
        }
        n2 = 0;
        if (tGDuration.isDotted() || tGDuration.isDoubleDotted()) {
            n2 |= 1;
        }
        if (tGBeat.isChordBeat()) {
            n2 |= 2;
        }
        if (tGBeat.isTextBeat()) {
            n2 |= 4;
        }
        if (tGBeat.getStroke().getDirection() != 0) {
            n2 |= 8;
        } else if (tGNoteEffect.isTremoloBar() || tGNoteEffect.isTapping() || tGNoteEffect.isSlapping() || tGNoteEffect.isPopping() || tGNoteEffect.isFadeIn()) {
            n2 |= 8;
        }
        if (!tGDuration.getTupleto().isEqual(TGTupleto.NORMAL)) {
            n2 |= 0x20;
        }
        if (bl) {
            n2 |= 0x10;
        }
        if (tGVoice.isRestVoice()) {
            n2 |= 0x40;
        }
        this.writeUnsignedByte(n2);
        if ((n2 & 0x40) != 0) {
            this.writeUnsignedByte(2);
        }
        this.writeByte(this.parseDuration(tGDuration));
        if ((n2 & 0x20) != 0) {
            this.writeInt(tGDuration.getTupleto().getEnters());
        }
        if ((n2 & 2) != 0) {
            this.writeChord(tGBeat.getChord());
        }
        if ((n2 & 4) != 0) {
            this.writeText(tGBeat.getText());
        }
        if ((n2 & 8) != 0) {
            this.writeBeatEffects(tGBeat, tGNoteEffect);
        }
        if ((n2 & 0x10) != 0) {
            this.writeMixChange(tGMeasure.getTempo());
        }
        int n3 = 0;
        if (!tGVoice.isRestVoice()) {
            for (n = 0; n < tGVoice.countNotes(); ++n) {
                TGNote tGNote = tGVoice.getNote(n);
                int n4 = 7 - tGNote.getString();
                n3 |= 1 << n4;
            }
        }
        this.writeUnsignedByte(n3);
        block2: for (n = 6; n >= 0; --n) {
            if ((n3 & 1 << n) == 0) continue;
            for (int i = 0; i < tGVoice.countNotes(); ++i) {
                TGNote tGNote = tGVoice.getNote(i);
                if (tGNote.getString() != 6 - n + 1) continue;
                this.writeNote(tGNote);
                continue block2;
            }
        }
    }

    private void writeNote(TGNote tGNote) throws IOException {
        int n = 48;
        if (tGNote.getEffect().isGhostNote()) {
            n |= 4;
        }
        if (tGNote.getEffect().isAccentuatedNote()) {
            n |= 0x40;
        }
        if (tGNote.getEffect().isVibrato() || tGNote.getEffect().isBend() || tGNote.getEffect().isGrace() || tGNote.getEffect().isSlide() || tGNote.getEffect().isHammer() || tGNote.getEffect().isPalmMute() || tGNote.getEffect().isStaccato() || tGNote.getEffect().isTapping() || tGNote.getEffect().isSlapping() || tGNote.getEffect().isPopping() || tGNote.getEffect().isHarmonic() || tGNote.getEffect().isTremoloPicking() || tGNote.getEffect().isTrill()) {
            n |= 8;
        }
        this.writeUnsignedByte(n);
        if ((n & 0x20) != 0) {
            int n2 = 1;
            if (tGNote.isTiedNote()) {
                n2 = 2;
            } else if (tGNote.getEffect().isDeadNote()) {
                n2 = 3;
            }
            this.writeUnsignedByte(n2);
        }
        if ((n & 0x10) != 0) {
            this.writeByte((byte)((tGNote.getVelocity() - 15) / 16 + 1));
        }
        if ((n & 0x20) != 0) {
            this.writeByte((byte)tGNote.getValue());
        }
        if ((n & 8) != 0) {
            this.writeNoteEffects(tGNote.getEffect());
        }
    }

    private byte parseDuration(TGDuration tGDuration) {
        byte by = 0;
        switch (tGDuration.getValue()) {
            case 1: {
                by = -2;
                break;
            }
            case 2: {
                by = -1;
                break;
            }
            case 4: {
                by = 0;
                break;
            }
            case 8: {
                by = 1;
                break;
            }
            case 16: {
                by = 2;
                break;
            }
            case 32: {
                by = 3;
                break;
            }
            case 64: {
                by = 4;
            }
        }
        return by;
    }

    private void writeText(TGText tGText) throws IOException {
        this.writeStringByteSizeOfInteger(tGText.getValue());
    }

    private void writeChord(TGChord tGChord) throws IOException {
        this.writeUnsignedByte(1);
        this.skipBytes(16);
        this.writeStringByte(tGChord.getName(), 21);
        this.skipBytes(4);
        this.writeInt(tGChord.getFirstFret());
        for (int i = 0; i < 7; ++i) {
            this.writeInt(i < tGChord.countStrings() ? tGChord.getFretValue(i) : -1);
        }
        this.skipBytes(32);
    }

    private void writeBeatEffects(TGBeat tGBeat, TGNoteEffect tGNoteEffect) throws IOException {
        int n = 0;
        int n2 = 0;
        if (tGNoteEffect.isFadeIn()) {
            n |= 0x10;
        }
        if (tGNoteEffect.isTapping() || tGNoteEffect.isSlapping() || tGNoteEffect.isPopping()) {
            n |= 0x20;
        }
        if (tGNoteEffect.isTremoloBar()) {
            n2 |= 4;
        }
        if (tGBeat.getStroke().getDirection() != 0) {
            n |= 0x40;
        }
        this.writeUnsignedByte(n);
        this.writeUnsignedByte(n2);
        if ((n & 0x20) != 0) {
            if (tGNoteEffect.isTapping()) {
                this.writeUnsignedByte(1);
            } else if (tGNoteEffect.isSlapping()) {
                this.writeUnsignedByte(2);
            } else if (tGNoteEffect.isPopping()) {
                this.writeUnsignedByte(3);
            }
        }
        if ((n2 & 4) != 0) {
            this.writeTremoloBar(tGNoteEffect.getTremoloBar());
        }
        if ((n & 0x40) != 0) {
            this.writeUnsignedByte(tGBeat.getStroke().getDirection() == -1 ? this.toStrokeValue(tGBeat.getStroke()) : 0);
            this.writeUnsignedByte(tGBeat.getStroke().getDirection() == 1 ? this.toStrokeValue(tGBeat.getStroke()) : 0);
        }
    }

    private void writeNoteEffects(TGNoteEffect tGNoteEffect) throws IOException {
        int n = 0;
        int n2 = 0;
        if (tGNoteEffect.isBend()) {
            n |= 1;
        }
        if (tGNoteEffect.isHammer()) {
            n |= 2;
        }
        if (tGNoteEffect.isGrace()) {
            n |= 0x10;
        }
        if (tGNoteEffect.isStaccato()) {
            n2 |= 1;
        }
        if (tGNoteEffect.isPalmMute()) {
            n2 |= 2;
        }
        if (tGNoteEffect.isTremoloPicking()) {
            n2 |= 4;
        }
        if (tGNoteEffect.isSlide()) {
            n2 |= 8;
        }
        if (tGNoteEffect.isVibrato()) {
            n2 |= 0x40;
        }
        if (tGNoteEffect.isHarmonic()) {
            n2 |= 0x10;
        }
        if (tGNoteEffect.isTrill()) {
            n2 |= 0x20;
        }
        this.writeUnsignedByte(n);
        this.writeUnsignedByte(n2);
        if ((n & 1) != 0) {
            this.writeBend(tGNoteEffect.getBend());
        }
        if ((n & 0x10) != 0) {
            this.writeGrace(tGNoteEffect.getGrace());
        }
        if ((n2 & 4) != 0) {
            this.writeTremoloPicking(tGNoteEffect.getTremoloPicking());
        }
        if ((n2 & 8) != 0) {
            this.writeByte((byte)1);
        }
        if ((n2 & 0x10) != 0) {
            if (tGNoteEffect.getHarmonic().getType() == 1) {
                this.writeByte((byte)1);
            } else if (tGNoteEffect.getHarmonic().getType() == 3) {
                this.writeByte((byte)3);
            } else if (tGNoteEffect.getHarmonic().getType() == 4) {
                this.writeByte((byte)4);
            } else if (tGNoteEffect.getHarmonic().getType() == 5) {
                this.writeByte((byte)5);
            } else if (tGNoteEffect.getHarmonic().getType() == 2) {
                this.writeByte((byte)15);
            }
        }
        if ((n2 & 0x20) != 0) {
            this.writeByte((byte)tGNoteEffect.getTrill().getFret());
            if (tGNoteEffect.getTrill().getDuration().getValue() == 16) {
                this.writeByte((byte)1);
            } else if (tGNoteEffect.getTrill().getDuration().getValue() == 32) {
                this.writeByte((byte)2);
            } else if (tGNoteEffect.getTrill().getDuration().getValue() == 64) {
                this.writeByte((byte)3);
            }
        }
    }

    private void writeBend(TGEffectBend tGEffectBend) throws IOException {
        int n = tGEffectBend.getPoints().size();
        this.writeByte((byte)1);
        this.writeInt(0);
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            TGEffectBend.BendPoint bendPoint = (TGEffectBend.BendPoint)tGEffectBend.getPoints().get(i);
            this.writeInt(bendPoint.getPosition() * 60 / 12);
            this.writeInt(bendPoint.getValue() * 25 / 1);
            this.writeByte((byte)0);
        }
    }

    private void writeTremoloBar(TGEffectTremoloBar tGEffectTremoloBar) throws IOException {
        int n = tGEffectTremoloBar.getPoints().size();
        this.writeByte((byte)6);
        this.writeInt(0);
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint = (TGEffectTremoloBar.TremoloBarPoint)tGEffectTremoloBar.getPoints().get(i);
            this.writeInt(tremoloBarPoint.getPosition() * 60 / 12);
            this.writeInt(tremoloBarPoint.getValue() * 50);
            this.writeByte((byte)0);
        }
    }

    public void writeTremoloPicking(TGEffectTremoloPicking tGEffectTremoloPicking) throws IOException {
        if (tGEffectTremoloPicking.getDuration().getValue() == 8) {
            this.writeUnsignedByte(1);
        } else if (tGEffectTremoloPicking.getDuration().getValue() == 16) {
            this.writeUnsignedByte(2);
        } else if (tGEffectTremoloPicking.getDuration().getValue() == 32) {
            this.writeUnsignedByte(3);
        }
    }

    private void writeGrace(TGEffectGrace tGEffectGrace) throws IOException {
        if (tGEffectGrace.isDead()) {
            this.writeUnsignedByte(255);
        } else {
            this.writeUnsignedByte(tGEffectGrace.getFret());
        }
        this.writeUnsignedByte((tGEffectGrace.getDynamic() - 15) / 16 + 1);
        if (tGEffectGrace.getTransition() == 0) {
            this.writeUnsignedByte(0);
        } else if (tGEffectGrace.getTransition() == 1) {
            this.writeUnsignedByte(1);
        } else if (tGEffectGrace.getTransition() == 2) {
            this.writeUnsignedByte(2);
        } else if (tGEffectGrace.getTransition() == 3) {
            this.writeUnsignedByte(3);
        }
        this.writeUnsignedByte(tGEffectGrace.getDuration());
    }

    private void writeMixChange(TGTempo tGTempo) throws IOException {
        for (int i = 0; i < 7; ++i) {
            this.writeByte((byte)-1);
        }
        this.writeInt(tGTempo.getValue());
        this.writeByte((byte)0);
        this.writeUnsignedByte(1);
    }

    private void writeMarker(TGMarker tGMarker) throws IOException {
        this.writeStringByteSizeOfInteger(tGMarker.getTitle());
        this.writeColor(tGMarker.getColor());
    }

    private void writeColor(TGColor tGColor) throws IOException {
        this.writeUnsignedByte(tGColor.getR());
        this.writeUnsignedByte(tGColor.getG());
        this.writeUnsignedByte(tGColor.getB());
        this.writeByte((byte)0);
    }

    private TGChannel[] makeChannels(TGSong tGSong) {
        TGChannel[] tGChannelArray = new TGChannel[64];
        for (int i = 0; i < tGChannelArray.length; ++i) {
            tGChannelArray[i] = this.getFactory().newChannel();
            tGChannelArray[i].setChannel((short)i);
            tGChannelArray[i].setEffectChannel((short)i);
            tGChannelArray[i].setInstrument((short)24);
            tGChannelArray[i].setVolume((short)13);
            tGChannelArray[i].setBalance((short)8);
            tGChannelArray[i].setChorus((short)0);
            tGChannelArray[i].setReverb((short)0);
            tGChannelArray[i].setPhaser((short)0);
            tGChannelArray[i].setTremolo((short)0);
        }
        Iterator iterator = tGSong.getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            tGChannelArray[tGTrack.getChannel().getChannel()].setInstrument(tGTrack.getChannel().getInstrument());
            tGChannelArray[tGTrack.getChannel().getChannel()].setVolume(tGTrack.getChannel().getVolume());
            tGChannelArray[tGTrack.getChannel().getChannel()].setBalance(tGTrack.getChannel().getBalance());
            tGChannelArray[tGTrack.getChannel().getEffectChannel()].setInstrument(tGTrack.getChannel().getInstrument());
            tGChannelArray[tGTrack.getChannel().getEffectChannel()].setVolume(tGTrack.getChannel().getVolume());
            tGChannelArray[tGTrack.getChannel().getEffectChannel()].setBalance(tGTrack.getChannel().getBalance());
        }
        return tGChannelArray;
    }

    private int toStrokeValue(TGStroke tGStroke) {
        if (tGStroke.getValue() == 64) {
            return 2;
        }
        if (tGStroke.getValue() == 32) {
            return 3;
        }
        if (tGStroke.getValue() == 16) {
            return 4;
        }
        if (tGStroke.getValue() == 8) {
            return 5;
        }
        if (tGStroke.getValue() == 4) {
            return 6;
        }
        return 2;
    }

    private byte toChannelByte(short s) {
        return (byte)((s + 1) / 8);
    }
}

