/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.herac.tuxguitar.io.base.TGFileFormatException;

public class PDFWriter {
    public static void write(OutputStream outputStream, List list) throws TGFileFormatException {
        try {
            Document document = new Document();
            PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ImageData imageData = (ImageData)iterator.next();
                document.newPage();
                document.add((Element)PDFWriter.convertToIText(imageData));
            }
            document.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException("Could not write song!.", throwable);
        }
    }

    public static Image convertToIText(ImageData imageData) {
        try {
            PaletteData paletteData = imageData.palette;
            int n = imageData.width;
            int n2 = imageData.height;
            byte[] byArray = new byte[n * n2 * 3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    RGB rGB = paletteData.getRGB(imageData.getPixel(j, i));
                    byArray[i * (n * 3) + j * 3] = (byte)rGB.red;
                    byArray[i * (n * 3) + j * 3 + 1] = (byte)rGB.green;
                    byArray[i * (n * 3) + j * 3 + 2] = (byte)rGB.blue;
                }
            }
            return Image.getInstance((int)n, (int)n2, (int)3, (int)8, (byte[])byArray);
        }
        catch (BadElementException badElementException) {
            badElementException.printStackTrace();
            return null;
        }
    }
}

