/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pdf;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGFactoryImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintStyles;
import org.herac.tuxguitar.gui.printer.PrintStylesDialog;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGSongExporter;
import org.herac.tuxguitar.io.pdf.PDFWriter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGSynchronizer;

public class PDFSongExporter
implements TGSongExporter {
    private static final int PAGE_WIDTH = 550;
    private static final int PAGE_HEIGHT = 800;
    private PrintStyles styles;

    public String getExportName() {
        return "PDF";
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("PDF", "*.pdf");
    }

    public boolean configure(boolean bl) {
        this.styles = !bl ? PrintStylesDialog.open((Shell)TuxGuitar.instance().getShell()) : null;
        return this.styles != null || bl;
    }

    public PrintStyles getDefaultStyles(TGSong tGSong) {
        PrintStyles printStyles = new PrintStyles();
        printStyles.setStyle(8);
        printStyles.setFromMeasure(1);
        printStyles.setToMeasure(tGSong.countMeasureHeaders());
        printStyles.setTrackNumber(1);
        return printStyles;
    }

    public void exportSong(OutputStream outputStream, TGSong tGSong) {
        try {
            this.export(outputStream, tGSong, this.styles != null ? this.styles : this.getDefaultStyles(tGSong));
        }
        finally {
            return;
        }
    }

    public void export(final OutputStream outputStream, final TGSong tGSong, final PrintStyles printStyles) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    TGSongManager tGSongManager = new TGSongManager();
                    tGSongManager.setFactory((TGFactory)new TGFactoryImpl());
                    tGSongManager.setSong(tGSong.clone(tGSongManager.getFactory()));
                    PDFSongExporter.this.export(outputStream, tGSongManager, printStyles);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage((Throwable)throwable);
                }
            }
        }).start();
    }

    public void export(final OutputStream outputStream, final TGSongManager tGSongManager, final PrintStyles printStyles) {
        new SyncThread(new Runnable(){

            public void run() {
                try {
                    Tablature tablature = new Tablature((Composite)TuxGuitar.instance().getShell());
                    tablature.setSongManager(tGSongManager);
                    PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, printStyles, 1.0f);
                    PDFSongExporter.this.export(outputStream, printerViewLayout);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage((Throwable)throwable);
                }
            }
        }).start();
    }

    public void export(final OutputStream outputStream, final PrinterViewLayout printerViewLayout) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    printerViewLayout.getTablature().updateTablature();
                    printerViewLayout.makeDocument((PrintDocument)new PrintDocumentImpl(printerViewLayout, new Rectangle(0, 0, 550, 800), outputStream));
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage((Throwable)throwable);
                }
            }
        }).start();
    }

    private class PrintDocumentImpl
    implements PrintDocument {
        private PrinterViewLayout layout;
        private TGPainter painter;
        private Rectangle bounds;
        private OutputStream stream;
        private Image buffer;
        private List pages;

        public PrintDocumentImpl(PrinterViewLayout printerViewLayout, Rectangle rectangle, OutputStream outputStream) {
            this.layout = printerViewLayout;
            this.bounds = rectangle;
            this.stream = outputStream;
            this.painter = new TGPainter();
            this.pages = new ArrayList();
        }

        public TGPainter getPainter() {
            return this.painter;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void pageStart() {
            this.buffer = new Image((Device)this.layout.getTablature().getDisplay(), this.bounds.width - this.bounds.x, this.bounds.height - this.bounds.y);
            this.painter.init(this.buffer);
        }

        public void pageFinish() {
            this.pages.add(this.buffer.getImageData());
            this.painter.dispose();
            this.buffer.dispose();
        }

        public void start() {
        }

        public void finish() {
            try {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() {
                        PrintDocumentImpl.this.dispose();
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.write();
        }

        public boolean isPaintable(int n) {
            return true;
        }

        protected void write() {
            try {
                PDFWriter.write(this.stream, this.pages);
            }
            catch (Throwable throwable) {
                MessageDialog.errorMessage((Throwable)throwable);
            }
        }

        protected void dispose() {
            this.layout.getTablature().dispose();
        }
    }
}

