/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PageSizeArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Txt2Pdf
extends AbstractTool {
    public Txt2Pdf() {
        this.menuoptions = 11;
        this.arguments.add(new FileArgument((AbstractTool)this, "srcfile", "The file you want to convert", false));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted text has to be written", true, new PdfFilter()));
        PageSizeArgument pageSizeArgument = new PageSizeArgument(this, "pagesize", "Pagesize");
        this.arguments.add(pageSizeArgument);
        OptionArgument optionArgument = new OptionArgument(this, "orientation", "Orientation of the page");
        optionArgument.addOption("Portrait", "PORTRAIT");
        optionArgument.addOption("Landscape", "LANDSCAPE");
        this.arguments.add(optionArgument);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Txt2Pdf", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Txt2Pdf OPENED ===");
    }

    @Override
    public void execute() {
        try {
            Document document;
            Font font;
            String string = null;
            Rectangle rectangle = (Rectangle)this.getValue("pagesize");
            if ("LANDSCAPE".equals(this.getValue("orientation"))) {
                font = FontFactory.getFont("Courier", 10.0f);
                document = new Document(rectangle.rotate(), 36.0f, 9.0f, 36.0f, 36.0f);
            } else {
                font = FontFactory.getFont("Courier", 11.0f);
                document = new Document(rectangle, 72.0f, 36.0f, 36.0f, 36.0f);
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader((File)this.getValue("srcfile")));
            PdfWriter.getInstance(document, new FileOutputStream((File)this.getValue("destfile")));
            document.open();
            while ((string = bufferedReader.readLine()) != null) {
                document.add(new Paragraph(12.0f, string, font));
            }
            document.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    @Override
    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Txt2Pdf txt2Pdf = new Txt2Pdf();
        if (stringArray.length < 3) {
            System.err.println(txt2Pdf.getUsage());
        }
        txt2Pdf.setArguments(stringArray);
        txt2Pdf.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Txt2Pdf.addVersion("$Id: Txt2Pdf.java,v 1.9 2005/11/29 21:05:02 blowagie Exp $");
    }
}

