/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.ImageFilter;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class KnitTiff
extends AbstractTool {
    public KnitTiff() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "odd", "The tiff file with the odd pages", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "even", "The tiff file with the even pages", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("KnitTiff", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== KnitTiff OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("odd") == null) {
                throw new InstantiationException("You need to choose a sourcefile for the odd pages");
            }
            File file = (File)this.getValue("odd");
            if (this.getValue("even") == null) {
                throw new InstantiationException("You need to choose a sourcefile for the even pages");
            }
            File file2 = (File)this.getValue("even");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file3 = (File)this.getValue("destfile");
            RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(file.getAbsolutePath());
            RandomAccessFileOrArray randomAccessFileOrArray2 = new RandomAccessFileOrArray(file2.getAbsolutePath());
            Image image = TiffImage.getTiffImage(randomAccessFileOrArray, 1);
            Document document = new Document(new Rectangle(image.scaledWidth(), image.scaledHeight()));
            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file3));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            int n = Math.max(TiffImage.getNumberOfPages(randomAccessFileOrArray), TiffImage.getNumberOfPages(randomAccessFileOrArray2));
            for (int i = 0; i < n; ++i) {
                try {
                    Image image2 = TiffImage.getTiffImage(randomAccessFileOrArray, i + 1);
                    Image image3 = TiffImage.getTiffImage(randomAccessFileOrArray2, n - i);
                    document.setPageSize(new Rectangle(image2.scaledWidth(), image2.scaledHeight()));
                    document.newPage();
                    image2.setAbsolutePosition(0.0f, 0.0f);
                    pdfContentByte.addImage(image2);
                    document.setPageSize(new Rectangle(image3.scaledWidth(), image3.scaledHeight()));
                    document.newPage();
                    image3.setAbsolutePosition(0.0f, 0.0f);
                    pdfContentByte.addImage(image3);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Exception page " + (i + 1) + " " + exception.getMessage());
                }
            }
            randomAccessFileOrArray.close();
            randomAccessFileOrArray2.close();
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        KnitTiff knitTiff = new KnitTiff();
        if (stringArray.length < 3) {
            System.err.println(knitTiff.getUsage());
        }
        knitTiff.setArguments(stringArray);
        knitTiff.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        KnitTiff.addVersion("$Id: KnitTiff.java,v 1.7 2005/11/29 21:05:02 blowagie Exp $");
    }
}

