/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.LabelAccessory;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.JInternalFrame;

public class ExtractAttachments
extends AbstractTool {
    public ExtractAttachments() {
        FileArgument fileArgument = new FileArgument(this, "srcfile", "The file you want to operate on", false, new PdfFilter());
        fileArgument.setLabel(new LabelAccessory());
        this.arguments.add(fileArgument);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("ExtractAttachments", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== ExtractAttachments OPENED ===");
    }

    @Override
    public void execute() {
        try {
            PdfDictionary pdfDictionary;
            ListIterator listIterator;
            Object object;
            PdfDictionary pdfDictionary2;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            File file2 = file.getParentFile();
            String string = file2 != null ? file2.getAbsolutePath() : "";
            PdfDictionary pdfDictionary3 = pdfReader.getCatalog();
            PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.NAMES));
            if (pdfDictionary4 != null && (pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary4.get(new PdfName("EmbeddedFiles")))) != null) {
                object = PdfNameTree.readTree(pdfDictionary2);
                listIterator = ((HashMap)object).values().iterator();
                while (listIterator.hasNext()) {
                    pdfDictionary = (PdfDictionary)PdfReader.getPdfObject((PdfObject)listIterator.next());
                    ExtractAttachments.unpackFile(pdfReader, pdfDictionary, string);
                }
            }
            for (int i = 1; i <= pdfReader.getNumberOfPages(); ++i) {
                object = (PdfArray)PdfReader.getPdfObject(pdfReader.getPageN(i).get(PdfName.ANNOTS));
                if (object == null) continue;
                listIterator = ((PdfArray)object).listIterator();
                while (listIterator.hasNext()) {
                    pdfDictionary = (PdfDictionary)PdfReader.getPdfObject((PdfObject)listIterator.next());
                    PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.SUBTYPE));
                    if (!PdfName.FILEATTACHMENT.equals(pdfName)) continue;
                    PdfDictionary pdfDictionary5 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FS));
                    ExtractAttachments.unpackFile(pdfReader, pdfDictionary5, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        ExtractAttachments extractAttachments = new ExtractAttachments();
        if (stringArray.length < 1) {
            System.err.println(extractAttachments.getUsage());
        }
        extractAttachments.setArguments(stringArray);
        extractAttachments.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is more than one destfile.");
    }

    public static void unpackFile(PdfReader pdfReader, PdfDictionary pdfDictionary, String string) throws IOException {
        if (pdfDictionary == null) {
            return;
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.TYPE));
        if (!PdfName.F.equals(pdfName) && !PdfName.FILESPEC.equals(pdfName)) {
            return;
        }
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.EF));
        if (pdfDictionary2 == null) {
            return;
        }
        PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
        System.out.println("Unpacking file '" + pdfString + "' to " + string);
        if (pdfString == null) {
            return;
        }
        File file = new File(pdfString.toUnicodeString());
        File file2 = new File(string, file.getName());
        if (file2.exists()) {
            return;
        }
        PRStream pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.F));
        if (pRStream == null) {
            return;
        }
        byte[] byArray = PdfReader.getStreamBytes(pRStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    static {
        ExtractAttachments.addVersion("$Id: ExtractAttachments.java,v 1.6 2006/08/24 09:42:46 blowagie Exp $");
    }
}

