/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.arguments;

import com.lowagie.text.Image;
import com.lowagie.tools.plugins.AbstractTool;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ToolArgument
implements ActionListener,
PropertyChangeListener {
    protected AbstractTool tool;
    protected String description;
    protected String name;
    protected String classname;
    protected String value = null;
    transient Vector propertyChangeListeners;

    public ToolArgument() {
    }

    public ToolArgument(AbstractTool abstractTool, String string, String string2, String string3) {
        this.tool = abstractTool;
        this.name = string;
        this.description = string2;
        this.classname = string3;
    }

    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            if (String.class.getName().equals(this.classname)) {
                return this.value;
            }
            if (Image.class.getName().equals(this.classname)) {
                return Image.getInstance(this.value);
            }
            if (File.class.getName().equals(this.classname)) {
                return new File(this.value);
            }
            if (Color.class.getName().equals(this.classname)) {
                return Color.decode(this.value);
            }
        }
        catch (Exception exception) {
            throw new InstantiationException(exception.getMessage());
        }
        return this.value;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (String.class.getName().equals(this.classname)) {
            this.setValue(JOptionPane.showInputDialog(this.tool.getInternalFrame(), (Object)("Enter a value for " + this.name + ":")));
        }
        if (Image.class.getName().equals(this.classname)) {
            serializable = new JFileChooser();
            serializable.showOpenDialog(this.tool.getInternalFrame());
            this.setValue(serializable.getSelectedFile().getAbsolutePath());
        }
        if (File.class.getName().equals(this.classname)) {
            serializable = new JFileChooser();
            serializable.showOpenDialog(this.tool.getInternalFrame());
            this.setValue(serializable.getSelectedFile().getAbsolutePath());
        }
        if (Color.class.getName().equals(this.classname)) {
            serializable = new Color(255, 255, 255);
            if (this.value != null) {
                serializable = Color.decode(this.value);
            }
            Color color = JColorChooser.showDialog(this.tool.getInternalFrame(), "Choose Color", (Color)serializable);
            this.setValue("0x" + Integer.toHexString(color.getRed() << 16 | color.getGreen() << 8 | color.getBlue() << 0).toUpperCase());
        }
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer("  ");
        stringBuffer.append(this.name);
        stringBuffer.append(" -  ");
        stringBuffer.append(this.description);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        String string2 = this.value;
        this.value = string;
        this.tool.valueHasChanged(this);
        this.firePropertyChange(new PropertyChangeEvent(this, this.name, string2, this.value));
    }

    public void setValue(String string, String string2) {
        String string3 = this.value;
        this.value = string;
        this.tool.valueHasChanged(this);
        this.firePropertyChange(new PropertyChangeEvent(this, string2, string3, this.value));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Vector vector;
        Vector vector2 = vector = this.propertyChangeListeners == null ? new Vector(2) : (Vector)this.propertyChangeListeners.clone();
        if (!vector.contains(propertyChangeListener)) {
            vector.addElement(propertyChangeListener);
            this.propertyChangeListeners = vector;
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners != null && this.propertyChangeListeners.contains(propertyChangeListener)) {
            Vector vector = (Vector)this.propertyChangeListeners.clone();
            vector.removeElement(propertyChangeListener);
            this.propertyChangeListeners = vector;
        }
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.propertyChangeListeners != null) {
            Vector vector = this.propertyChangeListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((PropertyChangeListener)vector.elementAt(i)).propertyChange(propertyChangeEvent);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

