/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.arguments;

import com.lowagie.tools.arguments.DirFilter;
import com.lowagie.tools.arguments.LabelAccessory;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileArgument
extends ToolArgument {
    private FileFilter filter;
    private boolean newFile;
    LabelAccessory label = null;

    public FileArgument(AbstractTool abstractTool, String string, String string2, boolean bl, FileFilter fileFilter) {
        super(abstractTool, string, string2, File.class.getName());
        this.newFile = bl;
        this.filter = fileFilter;
    }

    public FileArgument(AbstractTool abstractTool, String string, String string2, boolean bl) {
        this(abstractTool, string, string2, bl, null);
    }

    @Override
    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return new File(this.value);
        }
        catch (Exception exception) {
            throw new InstantiationException(exception.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        if (this.filter != null) {
            jFileChooser.setFileFilter(this.filter);
            if (this.filter instanceof DirFilter) {
                jFileChooser.setFileSelectionMode(1);
            }
        }
        if (this.label != null) {
            jFileChooser.setAccessory(this.label);
            jFileChooser.addPropertyChangeListener("SelectedFileChangedProperty", this.label);
        }
        if (this.newFile) {
            jFileChooser.showSaveDialog(this.tool.getInternalFrame());
        } else {
            jFileChooser.showOpenDialog(this.tool.getInternalFrame());
        }
        try {
            this.setValue(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    public LabelAccessory getLabel() {
        return this.label;
    }

    public void setLabel(LabelAccessory labelAccessory) {
        this.label = labelAccessory;
    }
}

