/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfColorList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] COLOR_TABLE = "\\colortbl".getBytes();
    ArrayList colorList = new ArrayList();

    public RtfColorList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.colorList.add(new RtfColor(rtfDocument, 0, 0, 0, 0));
        this.colorList.add(new RtfColor(rtfDocument, 255, 255, 255, 1));
    }

    public int getColorNumber(RtfColor rtfColor) {
        int n = -1;
        for (int i = 0; i < this.colorList.size(); ++i) {
            if (!this.colorList.get(i).equals(rtfColor)) continue;
            n = i;
        }
        if (n == -1) {
            n = this.colorList.size();
            this.colorList.add(rtfColor);
        }
        return n;
    }

    @Override
    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(COLOR_TABLE);
            for (int i = 0; i < this.colorList.size(); ++i) {
                RtfColor rtfColor = (RtfColor)this.colorList.get(i);
                byteArrayOutputStream.write(rtfColor.writeDefinition());
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

