/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.field;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class RtfField
extends Chunk
implements RtfBasicElement {
    private static final byte[] FIELD = "\\field".getBytes();
    private static final byte[] FIELD_DIRTY = "\\flddirty".getBytes();
    private static final byte[] FIELD_PRIVATE = "\\fldpriv".getBytes();
    private static final byte[] FIELD_LOCKED = "\\fldlock".getBytes();
    private static final byte[] FIELD_EDIT = "\\fldedit".getBytes();
    private static final byte[] FIELD_ALT = "\\fldalt".getBytes();
    private static final byte[] FIELD_INSTRUCTIONS = "\\*\\fldinst".getBytes();
    private static final byte[] FIELD_RESULT = "\\fldrslt".getBytes();
    private boolean fieldDirty = false;
    private boolean fieldEdit = false;
    private boolean fieldLocked = false;
    private boolean fieldPrivate = false;
    private boolean fieldAlt = false;
    private boolean inTable = false;
    private boolean inHeader = false;
    protected RtfDocument document = null;
    private RtfFont font = null;

    protected RtfField(RtfDocument rtfDocument) {
        this(rtfDocument, new Font());
    }

    protected RtfField(RtfDocument rtfDocument, Font font) {
        super("", font);
        this.document = rtfDocument;
        this.font = new RtfFont(this.document, font);
    }

    @Override
    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        this.font.setRtfDocument(this.document);
    }

    private byte[] writeFieldBegin() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(OPEN_GROUP);
        byteArrayOutputStream.write(FIELD);
        if (this.fieldDirty) {
            byteArrayOutputStream.write(FIELD_DIRTY);
        }
        if (this.fieldEdit) {
            byteArrayOutputStream.write(FIELD_EDIT);
        }
        if (this.fieldLocked) {
            byteArrayOutputStream.write(FIELD_LOCKED);
        }
        if (this.fieldPrivate) {
            byteArrayOutputStream.write(FIELD_PRIVATE);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] writeFieldInstBegin() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(OPEN_GROUP);
        byteArrayOutputStream.write(FIELD_INSTRUCTIONS);
        byteArrayOutputStream.write(DELIMITER);
        return byteArrayOutputStream.toByteArray();
    }

    protected abstract byte[] writeFieldInstContent() throws IOException;

    private byte[] writeFieldInstEnd() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.fieldAlt) {
            byteArrayOutputStream.write(DELIMITER);
            byteArrayOutputStream.write(FIELD_ALT);
        }
        byteArrayOutputStream.write(CLOSE_GROUP);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] writeFieldResultBegin() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(OPEN_GROUP);
        byteArrayOutputStream.write(FIELD_RESULT);
        byteArrayOutputStream.write(DELIMITER);
        return byteArrayOutputStream.toByteArray();
    }

    protected abstract byte[] writeFieldResultContent() throws IOException;

    private byte[] writeFieldResultEnd() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(DELIMITER);
        byteArrayOutputStream.write(CLOSE_GROUP);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] writeFieldEnd() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(CLOSE_GROUP);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.font.writeBegin());
            byteArrayOutputStream.write(this.writeFieldBegin());
            byteArrayOutputStream.write(this.writeFieldInstBegin());
            byteArrayOutputStream.write(this.writeFieldInstContent());
            byteArrayOutputStream.write(this.writeFieldInstEnd());
            byteArrayOutputStream.write(this.writeFieldResultBegin());
            byteArrayOutputStream.write(this.writeFieldResultContent());
            byteArrayOutputStream.write(this.writeFieldResultEnd());
            byteArrayOutputStream.write(this.writeFieldEnd());
            byteArrayOutputStream.write(this.font.writeEnd());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isFieldAlt() {
        return this.fieldAlt;
    }

    public void setFieldAlt(boolean bl) {
        this.fieldAlt = bl;
    }

    public boolean isFieldDirty() {
        return this.fieldDirty;
    }

    public void setFieldDirty(boolean bl) {
        this.fieldDirty = bl;
    }

    public boolean isFieldEdit() {
        return this.fieldEdit;
    }

    public void setFieldEdit(boolean bl) {
        this.fieldEdit = bl;
    }

    public boolean isFieldLocked() {
        return this.fieldLocked;
    }

    public void setFieldLocked(boolean bl) {
        this.fieldLocked = bl;
    }

    public boolean isFieldPrivate() {
        return this.fieldPrivate;
    }

    public void setFieldPrivate(boolean bl) {
        this.fieldPrivate = bl;
    }

    @Override
    public void setInTable(boolean bl) {
        this.inTable = bl;
    }

    @Override
    public void setInHeader(boolean bl) {
        this.inHeader = bl;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

