/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.direct;

import com.lowagie.text.rtf.direct.RtfColorTableParser;
import com.lowagie.text.rtf.direct.RtfImportHeader;

public class RtfFontTableParser {
    private RtfImportHeader importHeader = null;
    private String fontNr = "";
    private String fontName = "";

    public RtfFontTableParser(RtfImportHeader rtfImportHeader) {
        this.importHeader = rtfImportHeader;
        this.fontNr = "";
        this.fontName = "";
    }

    public void handleCloseGroup(int n) {
        if (n == 3 && !this.fontNr.equals("") && !this.fontName.equals("")) {
            this.importHeader.importFont(this.fontNr, this.fontName);
            this.fontNr = "";
            this.fontName = "";
        }
    }

    public void handleCtrlWord(String string, int n) {
        if (RtfColorTableParser.stringMatches(string, "\\f") && n == 3) {
            this.fontNr = string.substring(2);
        }
    }

    public void handleText(String string, int n) {
        if (string.indexOf(";") >= 0 && n == 3) {
            this.fontName = string.substring(0, string.indexOf(";"));
        }
    }
}

