/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.postscript;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.codec.postscript.PainterException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Stack;

public class PAPencil {
    protected Dimension size;
    protected State state;
    protected Stack gStack;
    protected HashMap fonts;
    public Graphics2D graphics;

    public PAPencil(Component component) {
        this.graphics = (Graphics2D)component.getGraphics();
        this.size = component.getSize();
        this.initgraphics();
    }

    public PAPencil(Graphics graphics, Dimension dimension) {
        this.graphics = (Graphics2D)graphics;
        this.size = dimension;
        this.initgraphics();
    }

    public void gsave() {
        this.state.recordState(this.graphics);
        State state = (State)this.state.clone();
        this.gStack.push(this.state);
        this.state = state;
    }

    public void grestore() {
        if (this.gStack.empty()) {
            this.initgraphics();
        } else {
            this.state = (State)this.gStack.pop();
            this.state.stampState(this.graphics, this.size);
        }
    }

    public void grestoreall() {
        this.initgraphics();
    }

    public void initgraphics() {
        AffineTransform affineTransform = new AffineTransform();
        this.graphics.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.graphics.setRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        affineTransform.translate(0.0, this.size.getHeight());
        affineTransform.scale(1.0, -1.0);
        this.graphics.setTransform(affineTransform);
        this.state = new State(this.graphics);
        this.gStack = new Stack();
        this.erasepage();
    }

    public void newpath() {
        this.state.path.reset();
    }

    public void moveto(double d, double d2) {
        this.state.path.moveTo((float)d, (float)d2);
    }

    public void moveto(Point2D point2D) {
        this.moveto(point2D.getX(), point2D.getY());
    }

    public void rmoveto(double d, double d2) throws PainterException {
        Point2D point2D = this.state.path.getCurrentPoint();
        if (point2D == null) {
            throw new PainterException("no current point");
        }
        this.state.path.moveTo((float)(point2D.getX() + d), (float)(point2D.getY() + d2));
    }

    public void lineto(double d, double d2) throws PainterException {
        Point2D point2D = this.state.path.getCurrentPoint();
        if (point2D == null) {
            throw new PainterException("no current point");
        }
        this.state.path.lineTo((float)d, (float)d2);
    }

    public void lineto(Point2D point2D) throws PainterException {
        this.lineto(point2D.getX(), point2D.getY());
    }

    public void rlineto(double d, double d2) throws PainterException {
        Point2D point2D = this.state.path.getCurrentPoint();
        if (point2D == null) {
            throw new PainterException("no current point");
        }
        this.state.path.lineTo((float)(point2D.getX() + d), (float)(point2D.getY() + d2));
    }

    public void arc(double d, double d2, double d3, double d4, double d5) {
        Arc2D.Float float_ = new Arc2D.Float((float)(d - d3), (float)(d2 - d3), (float)d3 * 2.0f, (float)d3 * 2.0f, -((float)d4), -((float)(d5 - d4)), 0);
        Point2D point2D = this.state.path.getCurrentPoint();
        if (point2D == null) {
            this.state.path.append(float_, false);
        } else {
            this.state.path.append(float_, true);
        }
    }

    public void arcn(double d, double d2, double d3, double d4, double d5) {
        Arc2D.Float float_ = new Arc2D.Float((float)(d - d3), (float)(d2 - d3), (float)d3 * 2.0f, (float)d3 * 2.0f, -((float)d4), -((float)(d5 - d4)), 0);
        Point2D point2D = this.state.path.getCurrentPoint();
        if (point2D == null) {
            this.state.path.append(float_, false);
        } else {
            this.state.path.append(float_, true);
        }
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) throws PainterException {
        Point2D point2D = this.state.path.getCurrentPoint();
        if (point2D == null) {
            throw new PainterException("no current point");
        }
        this.state.path.curveTo((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    public void rcurveto(double d, double d2, double d3, double d4, double d5, double d6) throws PainterException {
        Point2D point2D = this.state.path.getCurrentPoint();
        if (point2D == null) {
            throw new PainterException("no current point");
        }
        double d7 = point2D.getX();
        double d8 = point2D.getY();
        this.curveto(d7 + d, d8 + d2, d7 + d3, d8 + d4, d7 + d5, d8 + d6);
    }

    public void closepath() {
        this.state.path.closePath();
    }

    public void clippath() {
        this.rectpath(0.0, 0.0, this.size.width, this.size.height);
    }

    public void clip() {
        PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)this.graphics;
        pdfGraphics2D.clip(this.state.path);
        this.newpath();
    }

    public void erasepage() {
        this.graphics.clearRect(0, 0, this.size.width, this.size.height);
    }

    public void charpath(String string, boolean bl) throws PainterException {
        FontRenderContext fontRenderContext = this.graphics.getFontRenderContext();
        Font font = this.state.font;
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        Point2D point2D = this.state.path.getCurrentPoint();
        Shape shape = glyphVector.getOutline();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        shape = affineTransform.createTransformedShape(shape);
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance((float)point2D.getX(), (float)point2D.getY());
        shape = affineTransform2.createTransformedShape(shape);
        this.state.path.append(shape, false);
    }

    public void showpage() {
        PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)this.graphics;
        PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
        try {
            pdfContentByte.getPdfWriter().newPage();
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public void show(String string) throws PainterException {
        Point2D point2D = this.state.path.getCurrentPoint();
        AffineTransform affineTransform = this.graphics.getTransform();
        Point2D point2D2 = affineTransform.transform(point2D, null);
        if (point2D == null) {
            throw new PainterException("no current point");
        }
        this.graphics.setTransform(new AffineTransform());
        this.graphics.drawString(string, (float)point2D2.getX(), (float)point2D2.getY());
        this.graphics.setTransform(affineTransform);
    }

    public void fill() {
        this.graphics.fill(this.state.path);
        this.newpath();
    }

    public void eofill() {
        this.state.path.setWindingRule(0);
        this.graphics.fill(this.state.path);
        this.state.path.setWindingRule(1);
        this.newpath();
    }

    public void stroke() throws PainterException {
        this.graphics.draw(this.state.path);
        this.newpath();
    }

    public void rectfill(double d, double d2, double d3, double d4) {
        this.gsave();
        this.rectpath(d, d2, d3, d4);
        this.fill();
        this.grestore();
    }

    public void rectfill(Rectangle2D rectangle2D) {
        this.rectfill(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void rectstroke(double d, double d2, double d3, double d4) throws PainterException {
        this.gsave();
        this.rectpath(d, d2, d3, d4);
        this.stroke();
        this.grestore();
    }

    public void rectstroke(Rectangle2D rectangle2D) throws PainterException {
        this.rectstroke(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void rectpath(double d, double d2, double d3, double d4) {
        this.newpath();
        this.moveto(d, d2);
        try {
            this.rlineto(d3, 0.0);
            this.rlineto(0.0, d4);
            this.rlineto(-d3, 0.0);
        }
        catch (PainterException painterException) {
            // empty catch block
        }
        this.closepath();
    }

    public Font findFont(String string) {
        Font font;
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        for (n = 0; n < n2; ++n) {
            if (stringBuffer.charAt(n) != '-') continue;
            stringBuffer.setCharAt(n, ' ');
        }
        string = stringBuffer.toString();
        if (this.fonts == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] fontArray = graphicsEnvironment.getAllFonts();
            this.fonts = new HashMap();
            for (n = 0; n < fontArray.length; ++n) {
                String string2 = fontArray[n].getPSName();
                this.fonts.put(string2, fontArray[n]);
            }
        }
        if ((font = (Font)this.fonts.get(string)) == null) {
            font = new Font("Arial", 0, 12);
        }
        return font;
    }

    protected static class State
    implements Cloneable {
        public Stroke stroke;
        public Paint paint;
        public AffineTransform at;
        public Shape clipShape;
        public Font font;
        public Composite composite;
        public GeneralPath path;

        public State() {
            this(null);
        }

        public State(Graphics2D graphics2D) {
            if (graphics2D == null) {
                this.stroke = new BasicStroke();
                this.paint = Color.black;
                this.at = new AffineTransform();
                this.font = new Font("SansSerif", 0, 12);
                this.composite = AlphaComposite.getInstance(4, 1.0f);
                this.clipShape = null;
            } else {
                this.recordState(graphics2D);
            }
            this.path = new GeneralPath();
        }

        public void recordState(Graphics2D graphics2D) {
            this.stroke = graphics2D.getStroke();
            this.paint = graphics2D.getPaint();
            this.at = graphics2D.getTransform();
            this.font = graphics2D.getFont();
            this.composite = graphics2D.getComposite();
            this.clipShape = graphics2D.getClip();
        }

        public void stampState(Graphics2D graphics2D, Dimension dimension) {
            graphics2D.setTransform(new AffineTransform());
            graphics2D.setClip(new Rectangle(0, 0, dimension.width, dimension.height));
            graphics2D.setStroke(this.stroke);
            graphics2D.setPaint(this.paint);
            graphics2D.setTransform(this.at);
            graphics2D.setFont(this.font);
            graphics2D.setComposite(this.composite);
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
        }

        public Object clone() {
            try {
                State state = (State)super.clone();
                state.at = (AffineTransform)this.at.clone();
                state.path = new GeneralPath();
                state.path.append(this.path, false);
                return state;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }
}

