/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgPostscript;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColorDetails;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PatternColor;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfLayerMembership;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfOCProperties;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfPages;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfStructureTreeRoot;
import com.lowagie.text.pdf.PdfTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfXConformanceException;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.ShadingColor;
import com.lowagie.text.pdf.SpotColor;
import com.lowagie.text.pdf.events.PdfPageEventForwarder;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class PdfWriter
extends DocWriter {
    public static final int PageLayoutSinglePage = 1;
    public static final int PageLayoutOneColumn = 2;
    public static final int PageLayoutTwoColumnLeft = 4;
    public static final int PageLayoutTwoColumnRight = 8;
    public static final int PageLayoutTwoPageLeft = 0x400000;
    public static final int PageLayoutTwoPageRight = 0x800000;
    public static final int PageModeUseNone = 16;
    public static final int PageModeUseOutlines = 32;
    public static final int PageModeUseThumbs = 64;
    public static final int PageModeFullScreen = 128;
    public static final int PageModeUseOC = 0x100000;
    public static final int PageModeUseAttachments = 0x1000000;
    public static final int HideToolbar = 256;
    public static final int HideMenubar = 512;
    public static final int HideWindowUI = 1024;
    public static final int FitWindow = 2048;
    public static final int CenterWindow = 4096;
    public static final int NonFullScreenPageModeUseNone = 8192;
    public static final int NonFullScreenPageModeUseOutlines = 16384;
    public static final int NonFullScreenPageModeUseThumbs = 32768;
    public static final int NonFullScreenPageModeUseOC = 524288;
    public static final int DirectionL2R = 65536;
    public static final int DirectionR2L = 131072;
    public static final int DisplayDocTitle = 262144;
    public static final int PrintScalingNone = 0x200000;
    static final int ViewerPreferencesMask = 0xFFFF00;
    public static final int AllowPrinting = 2052;
    public static final int AllowModifyContents = 8;
    public static final int AllowCopy = 16;
    public static final int AllowModifyAnnotations = 32;
    public static final int AllowFillIn = 256;
    public static final int AllowScreenReaders = 512;
    public static final int AllowAssembly = 1024;
    public static final int AllowDegradedPrinting = 4;
    public static final boolean STRENGTH40BITS = false;
    public static final boolean STRENGTH128BITS = true;
    public static final PdfName DOCUMENT_CLOSE = PdfName.WC;
    public static final PdfName WILL_SAVE = PdfName.WS;
    public static final PdfName DID_SAVE = PdfName.DS;
    public static final PdfName WILL_PRINT = PdfName.WP;
    public static final PdfName DID_PRINT = PdfName.DP;
    public static final PdfName PAGE_OPEN = PdfName.O;
    public static final PdfName PAGE_CLOSE = PdfName.C;
    public static final int SIGNATURE_EXISTS = 1;
    public static final int SIGNATURE_APPEND_ONLY = 2;
    public static final char VERSION_1_2 = '2';
    public static final char VERSION_1_3 = '3';
    public static final char VERSION_1_4 = '4';
    public static final char VERSION_1_5 = '5';
    public static final char VERSION_1_6 = '6';
    private static final int VPOINT = 7;
    protected byte[] HEADER = PdfWriter.getISOBytes("%PDF-1.4\n%\u00e2\u00e3\u00cf\u00d3\n");
    protected int prevxref = 0;
    protected PdfPages root = new PdfPages(this);
    protected PdfDictionary imageDictionary = new PdfDictionary();
    private HashMap images = new HashMap();
    protected HashMap formXObjects = new HashMap();
    protected int formXObjectsCounter = 1;
    protected int fontNumber = 1;
    protected int colorNumber = 1;
    protected int patternNumber = 1;
    protected PdfContentByte directContent;
    protected PdfContentByte directContentUnder;
    protected HashMap documentFonts = new HashMap();
    protected HashMap documentColors = new HashMap();
    protected HashMap documentPatterns = new HashMap();
    protected HashMap documentShadings = new HashMap();
    protected HashMap documentShadingPatterns = new HashMap();
    protected ColorDetails patternColorspaceRGB;
    protected ColorDetails patternColorspaceGRAY;
    protected ColorDetails patternColorspaceCMYK;
    protected HashMap documentSpotPatterns = new HashMap();
    protected HashMap documentExtGState = new HashMap();
    protected HashMap documentProperties = new HashMap();
    protected HashSet documentOCG = new HashSet();
    protected ArrayList documentOCGorder = new ArrayList();
    protected PdfOCProperties OCProperties;
    protected PdfArray OCGRadioGroup = new PdfArray();
    protected PdfDictionary defaultColorspace = new PdfDictionary();
    protected float userunit = 0.0f;
    public static final int PDFXNONE = 0;
    public static final int PDFX1A2001 = 1;
    public static final int PDFX32002 = 2;
    private int pdfxConformance = 0;
    static final int PDFXKEY_COLOR = 1;
    static final int PDFXKEY_CMYK = 2;
    static final int PDFXKEY_RGB = 3;
    static final int PDFXKEY_FONT = 4;
    static final int PDFXKEY_IMAGE = 5;
    static final int PDFXKEY_GSTATE = 6;
    static final int PDFXKEY_LAYER = 7;
    protected PdfBody body;
    protected PdfDocument pdf;
    private PdfPageEvent pageEvent;
    protected PdfEncryption crypto;
    protected HashMap importedPages = new HashMap();
    protected PdfReaderInstance currentPdfReaderInstance;
    protected ArrayList pageReferences = new ArrayList();
    protected int currentPageNumber = 1;
    protected PdfDictionary group;
    public static final float SPACE_CHAR_RATIO_DEFAULT = 2.5f;
    public static final float NO_SPACE_CHAR_RATIO = 1.0E7f;
    public static final int RUN_DIRECTION_DEFAULT = 0;
    public static final int RUN_DIRECTION_NO_BIDI = 1;
    public static final int RUN_DIRECTION_LTR = 2;
    public static final int RUN_DIRECTION_RTL = 3;
    protected int runDirection = 1;
    private float spaceCharRatio = 2.5f;
    private PdfDictionary extraCatalog;
    protected byte[] xmpMetadata = null;
    protected boolean fullCompression = false;
    protected boolean tagged = false;
    protected PdfStructureTreeRoot structureTreeRoot;

    protected PdfWriter() {
    }

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.pdf = pdfDocument;
        this.directContent = new PdfContentByte(this);
        this.directContentUnder = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, DocListener docListener) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.addDocListener(docListener);
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    PdfIndirectReference add(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        PdfIndirectObject pdfIndirectObject;
        if (!this.open) {
            throw new PdfException("The document isn't open.");
        }
        try {
            pdfIndirectObject = this.addToBody(pdfContents);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        pdfPage.add(pdfIndirectObject.getIndirectReference());
        if (this.group != null) {
            pdfPage.put(PdfName.GROUP, this.group);
            this.group = null;
        }
        this.root.addPage(pdfPage);
        ++this.currentPageNumber;
        return null;
    }

    public PdfName addDirectImageSimple(Image image) throws PdfException, DocumentException {
        return this.addDirectImageSimple(image, null);
    }

    public PdfName addDirectImageSimple(Image image, PdfIndirectReference pdfIndirectReference) throws PdfException, DocumentException {
        PdfName pdfName;
        if (this.images.containsKey(image.getMySerialId())) {
            pdfName = (PdfName)this.images.get(image.getMySerialId());
        } else {
            if (image.isImgTemplate()) {
                pdfName = new PdfName("img" + this.images.size());
                if (image.templateData() == null) {
                    if (image instanceof ImgWMF) {
                        try {
                            ImgWMF imgWMF = (ImgWMF)image;
                            imgWMF.readWMF(this.getDirectContent().createTemplate(0.0f, 0.0f));
                        }
                        catch (Exception exception) {
                            throw new DocumentException(exception);
                        }
                    } else {
                        try {
                            ((ImgPostscript)image).readPostscript(this.getDirectContent().createTemplate(0.0f, 0.0f));
                        }
                        catch (Exception exception) {
                            throw new DocumentException(exception);
                        }
                    }
                }
            } else {
                PdfObject pdfObject;
                PdfIndirectReference pdfIndirectReference2 = image.getDirectReference();
                if (pdfIndirectReference2 != null) {
                    PdfName pdfName2 = new PdfName("img" + this.images.size());
                    this.images.put(image.getMySerialId(), pdfName2);
                    this.imageDictionary.put(pdfName2, pdfIndirectReference2);
                    return pdfName2;
                }
                Image image2 = image.getImageMask();
                PdfIndirectReference pdfIndirectReference3 = null;
                if (image2 != null) {
                    pdfObject = (PdfName)this.images.get(image2.getMySerialId());
                    pdfIndirectReference3 = this.getImageReference((PdfName)pdfObject);
                }
                pdfObject = new PdfImage(image, "img" + this.images.size(), pdfIndirectReference3);
                if (image.hasICCProfile()) {
                    PdfICCBased pdfICCBased = new PdfICCBased(image.getICCProfile());
                    PdfIndirectReference pdfIndirectReference4 = this.add(pdfICCBased);
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.ICCBASED);
                    pdfArray.add(pdfIndirectReference4);
                    PdfObject pdfObject2 = ((PdfDictionary)pdfObject).get(PdfName.COLORSPACE);
                    if (pdfObject2 != null && pdfObject2.isArray()) {
                        ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                        if (arrayList.size() > 1 && PdfName.INDEXED.equals(arrayList.get(0))) {
                            arrayList.set(1, pdfArray);
                        } else {
                            ((PdfDictionary)pdfObject).put(PdfName.COLORSPACE, pdfArray);
                        }
                    } else {
                        ((PdfDictionary)pdfObject).put(PdfName.COLORSPACE, pdfArray);
                    }
                }
                this.add((PdfImage)pdfObject, pdfIndirectReference);
                pdfName = ((PdfImage)pdfObject).name();
            }
            this.images.put(image.getMySerialId(), pdfName);
        }
        return pdfName;
    }

    PdfIndirectReference add(PdfImage pdfImage, PdfIndirectReference pdfIndirectReference) throws PdfException {
        if (!this.imageDictionary.contains(pdfImage.name())) {
            PdfWriter.checkPDFXConformance(this, 5, pdfImage);
            if (pdfIndirectReference != null && pdfIndirectReference instanceof PRIndirectReference) {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfIndirectReference;
                pdfIndirectReference = new PdfIndirectReference(0, this.getNewObjectNumber(pRIndirectReference.getReader(), pRIndirectReference.getNumber(), pRIndirectReference.getGeneration()));
            }
            try {
                if (pdfIndirectReference == null) {
                    pdfIndirectReference = this.addToBody(pdfImage).getIndirectReference();
                } else {
                    this.addToBody((PdfObject)pdfImage, pdfIndirectReference);
                }
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.imageDictionary.put(pdfImage.name(), pdfIndirectReference);
            return pdfIndirectReference;
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    protected PdfIndirectReference add(PdfICCBased pdfICCBased) throws PdfException {
        PdfIndirectObject pdfIndirectObject;
        try {
            pdfIndirectObject = this.addToBody(pdfICCBased);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        return pdfIndirectObject.getIndirectReference();
    }

    PdfIndirectReference getImageReference(PdfName pdfName) {
        return (PdfIndirectReference)this.imageDictionary.get(pdfName);
    }

    @Override
    public void open() {
        super.open();
        try {
            this.os.write(this.HEADER);
            this.body = new PdfBody(this);
            if (this.pdfxConformance == 2) {
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.GAMMA, new PdfArray(new float[]{2.2f, 2.2f, 2.2f}));
                pdfDictionary.put(PdfName.MATRIX, new PdfArray(new float[]{0.4124f, 0.2126f, 0.0193f, 0.3576f, 0.7152f, 0.1192f, 0.1805f, 0.0722f, 0.9505f}));
                pdfDictionary.put(PdfName.WHITEPOINT, new PdfArray(new float[]{0.9505f, 1.0f, 1.089f}));
                PdfArray pdfArray = new PdfArray(PdfName.CALRGB);
                pdfArray.add(pdfDictionary);
                this.setDefaultColorspace(PdfName.DEFAULTRGB, this.addToBody(pdfArray).getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private static void getOCGOrder(PdfArray pdfArray, PdfLayer pdfLayer) {
        ArrayList arrayList;
        if (!pdfLayer.isOnPanel()) {
            return;
        }
        if (pdfLayer.getTitle() == null) {
            pdfArray.add(pdfLayer.getRef());
        }
        if ((arrayList = pdfLayer.getChildren()) == null) {
            return;
        }
        PdfArray pdfArray2 = new PdfArray();
        if (pdfLayer.getTitle() != null) {
            pdfArray2.add(new PdfString(pdfLayer.getTitle(), "UnicodeBig"));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PdfWriter.getOCGOrder(pdfArray2, (PdfLayer)arrayList.get(i));
        }
        if (pdfArray2.size() > 0) {
            pdfArray.add(pdfArray2);
        }
    }

    private void addASEvent(PdfName pdfName, PdfName pdfName2) {
        PdfDictionary pdfDictionary;
        PdfObject pdfObject2;
        PdfArray pdfArray = new PdfArray();
        for (PdfObject pdfObject2 : this.documentOCG) {
            pdfDictionary = (PdfDictionary)((PdfDictionary)pdfObject2).get(PdfName.USAGE);
            if (pdfDictionary == null || pdfDictionary.get(pdfName2) == null) continue;
            pdfArray.add(((PdfLayer)pdfObject2).getRef());
        }
        if (pdfArray.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = (PdfDictionary)this.OCProperties.get(PdfName.D);
        pdfObject2 = (PdfArray)pdfDictionary2.get(PdfName.AS);
        if (pdfObject2 == null) {
            pdfObject2 = new PdfArray();
            pdfDictionary2.put(PdfName.AS, pdfObject2);
        }
        pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.EVENT, pdfName);
        pdfDictionary.put(PdfName.CATEGORY, new PdfArray(pdfName2));
        pdfDictionary.put(PdfName.OCGS, pdfArray);
        ((PdfArray)pdfObject2).add(pdfDictionary);
    }

    private void fillOCProperties(boolean bl) {
        PdfObject pdfObject;
        Object object3;
        Object object2;
        if (this.OCProperties == null) {
            this.OCProperties = new PdfOCProperties();
        }
        if (bl) {
            this.OCProperties.remove(PdfName.OCGS);
            this.OCProperties.remove(PdfName.D);
        }
        if (this.OCProperties.get(PdfName.OCGS) == null) {
            object2 = new PdfArray();
            for (Object object3 : this.documentOCG) {
                ((PdfArray)object2).add(((PdfLayer)object3).getRef());
            }
            this.OCProperties.put(PdfName.OCGS, (PdfObject)object2);
        }
        if (this.OCProperties.get(PdfName.D) != null) {
            return;
        }
        object2 = new ArrayList(this.documentOCGorder);
        Object object4 = ((ArrayList)object2).iterator();
        while (object4.hasNext()) {
            object3 = (PdfLayer)object4.next();
            if (((PdfLayer)object3).getParent() == null) continue;
            object4.remove();
        }
        object4 = new PdfArray();
        object3 = ((ArrayList)object2).iterator();
        while (object3.hasNext()) {
            pdfObject = (PdfLayer)object3.next();
            PdfWriter.getOCGOrder((PdfArray)object4, (PdfLayer)pdfObject);
        }
        object3 = new PdfDictionary();
        this.OCProperties.put(PdfName.D, (PdfObject)object3);
        ((PdfDictionary)object3).put(PdfName.ORDER, (PdfObject)object4);
        pdfObject = new PdfArray();
        for (PdfLayer pdfLayer : this.documentOCG) {
            if (pdfLayer.isOn()) continue;
            ((PdfArray)pdfObject).add(pdfLayer.getRef());
        }
        if (((PdfArray)pdfObject).size() > 0) {
            ((PdfDictionary)object3).put(PdfName.OFF, pdfObject);
        }
        if (this.OCGRadioGroup.size() > 0) {
            ((PdfDictionary)object3).put(PdfName.RBGROUPS, this.OCGRadioGroup);
        }
        this.addASEvent(PdfName.VIEW, PdfName.ZOOM);
        this.addASEvent(PdfName.VIEW, PdfName.VIEW);
        this.addASEvent(PdfName.PRINT, PdfName.PRINT);
        this.addASEvent(PdfName.EXPORT, PdfName.EXPORT);
        ((PdfDictionary)object3).put(PdfName.LISTMODE, PdfName.VISIBLEPAGES);
    }

    protected PdfDictionary getCatalog(PdfIndirectReference pdfIndirectReference) {
        PdfDocument.PdfCatalog pdfCatalog = ((PdfDocument)this.document).getCatalog(pdfIndirectReference);
        if (this.tagged) {
            try {
                this.getStructureTreeRoot().buildTree();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            pdfCatalog.put(PdfName.STRUCTTREEROOT, this.structureTreeRoot.getReference());
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.MARKED, PdfBoolean.PDFTRUE);
            pdfCatalog.put(PdfName.MARKINFO, pdfDictionary);
        }
        if (this.documentOCG.size() == 0) {
            return pdfCatalog;
        }
        this.fillOCProperties(false);
        pdfCatalog.put(PdfName.OCPROPERTIES, this.OCProperties);
        return pdfCatalog;
    }

    protected void addSharedObjectsToBody() throws IOException {
        PdfObject[] pdfObjectArray;
        for (Object object : this.documentFonts.values()) {
            ((FontDetails)object).writeFont(this);
        }
        for (Object object : this.formXObjects.values()) {
            pdfObjectArray = (PdfObject[])object[1];
            if (pdfObjectArray != null && pdfObjectArray.getIndirectReference() instanceof PRIndirectReference || pdfObjectArray == null || pdfObjectArray.getType() != 1) continue;
            this.addToBody((PdfObject)pdfObjectArray.getFormXObject(), pdfObjectArray.getIndirectReference());
        }
        for (PdfReaderInstance this.currentPdfReaderInstance : this.importedPages.values()) {
            this.currentPdfReaderInstance.writeAllPages();
        }
        this.currentPdfReaderInstance = null;
        for (Object object : this.documentColors.values()) {
            this.addToBody(((ColorDetails)object).getSpotColor(this), ((ColorDetails)object).getIndirectReference());
        }
        for (Object object : this.documentPatterns.keySet()) {
            this.addToBody((PdfObject)((PdfPatternPainter)object).getPattern(), ((PdfTemplate)object).getIndirectReference());
        }
        for (Object object : this.documentShadingPatterns.keySet()) {
            ((PdfShadingPattern)object).addToBody();
        }
        for (Object object : this.documentShadings.keySet()) {
            ((PdfShading)object).addToBody();
        }
        for (Object object : this.documentExtGState.keySet()) {
            pdfObjectArray = (PdfObject[])this.documentExtGState.get(object);
            this.addToBody((PdfObject)object, (PdfIndirectReference)pdfObjectArray[1]);
        }
        for (Object object : this.documentProperties.keySet()) {
            pdfObjectArray = (PdfObject[])this.documentProperties.get(object);
            if (object instanceof PdfLayerMembership) {
                PdfLayerMembership pdfLayerMembership = (PdfLayerMembership)object;
                this.addToBody(pdfLayerMembership.getPdfObject(), pdfLayerMembership.getRef());
                continue;
            }
            if (!(object instanceof PdfDictionary) || object instanceof PdfLayer) continue;
            this.addToBody((PdfObject)((PdfDictionary)object), (PdfIndirectReference)pdfObjectArray[1]);
        }
        for (Object object : this.documentOCG) {
            this.addToBody(object.getPdfObject(), object.getRef());
        }
    }

    @Override
    public synchronized void close() {
        if (this.open) {
            if (this.currentPageNumber - 1 != this.pageReferences.size()) {
                throw new RuntimeException("The page " + this.pageReferences.size() + " was requested but the document has only " + (this.currentPageNumber - 1) + " pages.");
            }
            this.pdf.close();
            try {
                Object object;
                Object object2;
                PdfDictionary pdfDictionary;
                this.addSharedObjectsToBody();
                PdfIndirectReference pdfIndirectReference = this.root.writePageTree();
                PdfDictionary pdfDictionary2 = this.getCatalog(pdfIndirectReference);
                if (this.xmpMetadata != null) {
                    pdfDictionary = new PdfStream(this.xmpMetadata);
                    pdfDictionary.put(PdfName.TYPE, PdfName.METADATA);
                    pdfDictionary.put(PdfName.SUBTYPE, PdfName.XML);
                    pdfDictionary2.put(PdfName.METADATA, this.body.add(pdfDictionary).getIndirectReference());
                }
                pdfDictionary = this.getInfo();
                if (this.pdfxConformance != 0) {
                    if (pdfDictionary.get(PdfName.GTS_PDFXVERSION) == null) {
                        if (this.pdfxConformance == 1) {
                            pdfDictionary.put(PdfName.GTS_PDFXVERSION, new PdfString("PDF/X-1:2001"));
                            pdfDictionary.put(new PdfName("GTS_PDFXConformance"), new PdfString("PDF/X-1a:2001"));
                        } else if (this.pdfxConformance == 2) {
                            pdfDictionary.put(PdfName.GTS_PDFXVERSION, new PdfString("PDF/X-3:2002"));
                        }
                    }
                    if (pdfDictionary.get(PdfName.TITLE) == null) {
                        pdfDictionary.put(PdfName.TITLE, new PdfString("Pdf document"));
                    }
                    if (pdfDictionary.get(PdfName.CREATOR) == null) {
                        pdfDictionary.put(PdfName.CREATOR, new PdfString("Unknown"));
                    }
                    if (pdfDictionary.get(PdfName.TRAPPED) == null) {
                        pdfDictionary.put(PdfName.TRAPPED, new PdfName("False"));
                    }
                    this.getExtraCatalog();
                    if (this.extraCatalog.get(PdfName.OUTPUTINTENTS) == null) {
                        object2 = new PdfDictionary(PdfName.OUTPUTINTENT);
                        ((PdfDictionary)object2).put(PdfName.OUTPUTCONDITION, new PdfString("SWOP CGATS TR 001-1995"));
                        ((PdfDictionary)object2).put(PdfName.OUTPUTCONDITIONIDENTIFIER, new PdfString("CGATS TR 001"));
                        ((PdfDictionary)object2).put(PdfName.REGISTRYNAME, new PdfString("http://www.color.org"));
                        ((PdfDictionary)object2).put(PdfName.INFO, new PdfString(""));
                        ((PdfDictionary)object2).put(PdfName.S, PdfName.GTS_PDFX);
                        this.extraCatalog.put(PdfName.OUTPUTINTENTS, new PdfArray((PdfObject)object2));
                    }
                }
                if (this.extraCatalog != null) {
                    pdfDictionary2.mergeDifferent(this.extraCatalog);
                }
                object2 = this.addToBody((PdfObject)pdfDictionary2, false);
                PdfIndirectObject pdfIndirectObject = this.addToBody((PdfObject)pdfDictionary, false);
                PdfIndirectReference pdfIndirectReference2 = null;
                PdfObject pdfObject = null;
                this.body.flushObjStm();
                if (this.crypto != null) {
                    object = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
                    pdfIndirectReference2 = ((PdfIndirectObject)object).getIndirectReference();
                    pdfObject = this.crypto.getFileID();
                } else {
                    pdfObject = PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
                }
                this.body.writeCrossReferenceTable(this.os, ((PdfIndirectObject)object2).getIndirectReference(), pdfIndirectObject.getIndirectReference(), pdfIndirectReference2, pdfObject, this.prevxref);
                if (this.fullCompression) {
                    this.os.write(PdfWriter.getISOBytes("startxref\n"));
                    this.os.write(PdfWriter.getISOBytes(String.valueOf(this.body.offset())));
                    this.os.write(PdfWriter.getISOBytes("\n%%EOF\n"));
                } else {
                    object = new PdfTrailer(this.body.size(), this.body.offset(), ((PdfIndirectObject)object2).getIndirectReference(), pdfIndirectObject.getIndirectReference(), pdfIndirectReference2, pdfObject, this.prevxref);
                    ((PdfTrailer)object).toPdf(this, this.os);
                }
                super.close();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    public float getTableBottom(Table table) {
        return this.pdf.bottom(table) - this.pdf.indentBottom();
    }

    public PdfTable getPdfTable(Table table) {
        return this.pdf.getPdfTable(table, true);
    }

    public boolean breakTableIfDoesntFit(PdfTable pdfTable) throws DocumentException {
        return this.pdf.breakTableIfDoesntFit(pdfTable);
    }

    public boolean fitsPage(Table table, float f) {
        return this.pdf.bottom(table) > this.pdf.indentBottom() + f;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0.0f);
    }

    public boolean fitsPage(PdfPTable pdfPTable, float f) {
        return this.pdf.fitsPage(pdfPTable, f);
    }

    public boolean fitsPage(PdfPTable pdfPTable) {
        return this.pdf.fitsPage(pdfPTable, 0.0f);
    }

    public float getVerticalPosition(boolean bl) {
        return this.pdf.getVerticalPosition(bl);
    }

    boolean isPaused() {
        return this.pause;
    }

    public PdfContentByte getDirectContent() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContent;
    }

    public PdfContentByte getDirectContentUnder() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContentUnder;
    }

    void resetContent() {
        this.directContent.reset();
        this.directContentUnder.reset();
    }

    public PdfAcroForm getAcroForm() {
        return this.pdf.getAcroForm();
    }

    public PdfOutline getRootOutline() {
        return this.directContent.getRootOutline();
    }

    public OutputStreamCounter getOs() {
        return this.os;
    }

    FontDetails addSimple(BaseFont baseFont) {
        if (baseFont.getFontType() == 4) {
            return new FontDetails(new PdfName("F" + this.fontNumber++), ((DocumentFont)baseFont).getIndirectReference(), baseFont);
        }
        FontDetails fontDetails = (FontDetails)this.documentFonts.get(baseFont);
        if (fontDetails == null) {
            PdfWriter.checkPDFXConformance(this, 4, baseFont);
            fontDetails = new FontDetails(new PdfName("F" + this.fontNumber++), this.body.getPdfIndirectReference(), baseFont);
            this.documentFonts.put(baseFont, fontDetails);
        }
        return fontDetails;
    }

    void eliminateFontSubset(PdfDictionary pdfDictionary) {
        for (FontDetails fontDetails : this.documentFonts.values()) {
            if (pdfDictionary.get(fontDetails.getFontName()) == null) continue;
            fontDetails.setSubset(false);
        }
    }

    PdfName getColorspaceName() {
        return new PdfName("CS" + this.colorNumber++);
    }

    ColorDetails addSimple(PdfSpotColor pdfSpotColor) {
        ColorDetails colorDetails = (ColorDetails)this.documentColors.get(pdfSpotColor);
        if (colorDetails == null) {
            colorDetails = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), pdfSpotColor);
            this.documentColors.put(pdfSpotColor, colorDetails);
        }
        return colorDetails;
    }

    ColorDetails addSimplePatternColorspace(Color color) {
        int n = ExtendedColor.getType(color);
        if (n == 4 || n == 5) {
            throw new RuntimeException("An uncolored tile pattern can not have another pattern or shading as color.");
        }
        try {
            switch (n) {
                case 0: {
                    if (this.patternColorspaceRGB == null) {
                        this.patternColorspaceRGB = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICERGB);
                        this.addToBody((PdfObject)pdfArray, this.patternColorspaceRGB.getIndirectReference());
                    }
                    return this.patternColorspaceRGB;
                }
                case 2: {
                    if (this.patternColorspaceCMYK == null) {
                        this.patternColorspaceCMYK = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICECMYK);
                        this.addToBody((PdfObject)pdfArray, this.patternColorspaceCMYK.getIndirectReference());
                    }
                    return this.patternColorspaceCMYK;
                }
                case 1: {
                    if (this.patternColorspaceGRAY == null) {
                        this.patternColorspaceGRAY = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICEGRAY);
                        this.addToBody((PdfObject)pdfArray, this.patternColorspaceGRAY.getIndirectReference());
                    }
                    return this.patternColorspaceGRAY;
                }
                case 3: {
                    ColorDetails colorDetails = this.addSimple(((SpotColor)color).getPdfSpotColor());
                    ColorDetails colorDetails2 = (ColorDetails)this.documentSpotPatterns.get(colorDetails);
                    if (colorDetails2 == null) {
                        colorDetails2 = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(colorDetails.getIndirectReference());
                        this.addToBody((PdfObject)pdfArray, colorDetails2.getIndirectReference());
                        this.documentSpotPatterns.put(colorDetails, colorDetails2);
                    }
                    return colorDetails2;
                }
            }
            throw new RuntimeException("Invalid color type in PdfWriter.addSimplePatternColorspace().");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    void addSimpleShadingPattern(PdfShadingPattern pdfShadingPattern) {
        if (!this.documentShadingPatterns.containsKey(pdfShadingPattern)) {
            pdfShadingPattern.setName(this.patternNumber);
            ++this.patternNumber;
            this.documentShadingPatterns.put(pdfShadingPattern, null);
            this.addSimpleShading(pdfShadingPattern.getShading());
        }
    }

    void addSimpleShading(PdfShading pdfShading) {
        if (!this.documentShadings.containsKey(pdfShading)) {
            this.documentShadings.put(pdfShading, null);
            pdfShading.setName(this.documentShadings.size());
        }
    }

    PdfObject[] addSimpleExtGState(PdfDictionary pdfDictionary) {
        if (!this.documentExtGState.containsKey(pdfDictionary)) {
            PdfWriter.checkPDFXConformance(this, 6, pdfDictionary);
            this.documentExtGState.put(pdfDictionary, new PdfObject[]{new PdfName("GS" + (this.documentExtGState.size() + 1)), this.getPdfIndirectReference()});
        }
        return (PdfObject[])this.documentExtGState.get(pdfDictionary);
    }

    void registerLayer(PdfOCG pdfOCG) {
        PdfWriter.checkPDFXConformance(this, 7, null);
        if (pdfOCG instanceof PdfLayer) {
            PdfLayer pdfLayer = (PdfLayer)pdfOCG;
            if (pdfLayer.getTitle() == null) {
                if (!this.documentOCG.contains(pdfOCG)) {
                    this.documentOCG.add(pdfOCG);
                    this.documentOCGorder.add(pdfOCG);
                }
            } else {
                this.documentOCGorder.add(pdfOCG);
            }
        } else {
            throw new IllegalArgumentException("Only PdfLayer is accepted.");
        }
    }

    PdfObject[] addSimpleProperty(Object object, PdfIndirectReference pdfIndirectReference) {
        if (!this.documentProperties.containsKey(object)) {
            if (object instanceof PdfOCG) {
                PdfWriter.checkPDFXConformance(this, 7, null);
            }
            this.documentProperties.put(object, new PdfObject[]{new PdfName("Pr" + (this.documentProperties.size() + 1)), pdfIndirectReference});
        }
        return (PdfObject[])this.documentProperties.get(object);
    }

    boolean propertyExists(Object object) {
        return this.documentProperties.containsKey(object);
    }

    PdfDocument getPdfDocument() {
        return this.pdf;
    }

    public PdfIndirectReference getPdfIndirectReference() {
        return this.body.getPdfIndirectReference();
    }

    int getIndirectReferenceNumber() {
        return this.body.getIndirectReferenceNumber();
    }

    PdfName addSimplePattern(PdfPatternPainter pdfPatternPainter) {
        PdfName pdfName = (PdfName)this.documentPatterns.get(pdfPatternPainter);
        try {
            if (pdfName == null) {
                pdfName = new PdfName("P" + this.patternNumber);
                ++this.patternNumber;
                this.documentPatterns.put(pdfPatternPainter, pdfName);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    PdfName addDirectTemplateSimple(PdfTemplate pdfTemplate, PdfName pdfName) {
        PdfIndirectReference pdfIndirectReference = pdfTemplate.getIndirectReference();
        Object[] objectArray = (Object[])this.formXObjects.get(pdfIndirectReference);
        PdfName pdfName2 = null;
        try {
            if (objectArray == null) {
                if (pdfName == null) {
                    pdfName2 = new PdfName("Xf" + this.formXObjectsCounter);
                    ++this.formXObjectsCounter;
                } else {
                    pdfName2 = pdfName;
                }
                if (pdfTemplate.getType() == 2) {
                    pdfTemplate = null;
                }
                this.formXObjects.put(pdfIndirectReference, new Object[]{pdfName2, pdfTemplate});
            } else {
                pdfName2 = (PdfName)objectArray[0];
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName2;
    }

    public void setPageEvent(PdfPageEvent pdfPageEvent) {
        if (pdfPageEvent == null) {
            this.pageEvent = null;
        } else if (this.pageEvent == null) {
            this.pageEvent = pdfPageEvent;
        } else if (this.pageEvent instanceof PdfPageEventForwarder) {
            ((PdfPageEventForwarder)this.pageEvent).addPageEvent(pdfPageEvent);
        } else {
            PdfPageEventForwarder pdfPageEventForwarder = new PdfPageEventForwarder();
            pdfPageEventForwarder.addPageEvent(this.pageEvent);
            pdfPageEventForwarder.addPageEvent(pdfPageEvent);
            this.pageEvent = pdfPageEventForwarder;
        }
    }

    public PdfPageEvent getPageEvent() {
        return this.pageEvent;
    }

    void addLocalDestinations(TreeMap treeMap) throws IOException {
        for (String string : treeMap.keySet()) {
            Object[] objectArray = (Object[])treeMap.get(string);
            PdfDestination pdfDestination = (PdfDestination)objectArray[2];
            if (pdfDestination == null) {
                throw new RuntimeException("The name '" + string + "' has no local destination.");
            }
            if (objectArray[1] == null) {
                objectArray[1] = this.getPdfIndirectReference();
            }
            this.addToBody((PdfObject)pdfDestination, (PdfIndirectReference)objectArray[1]);
        }
    }

    public int getPageNumber() {
        return this.pdf.getPageNumber();
    }

    public void setViewerPreferences(int n) {
        this.pdf.setViewerPreferences(n);
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n, boolean bl) throws DocumentException {
        if (this.pdf.isOpen()) {
            throw new DocumentException("Encryption can only be added before opening the document.");
        }
        this.crypto = new PdfEncryption();
        this.crypto.setupAllKeys(byArray, byArray2, n, bl);
    }

    public void setEncryption(boolean bl, String string, String string2, int n) throws DocumentException {
        this.setEncryption(PdfWriter.getISOBytes(string), PdfWriter.getISOBytes(string2), n, bl);
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, boolean bl) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, bl);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, pdfIndirectReference);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference, boolean bl) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, pdfIndirectReference, bl);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, int n) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, n);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, int n, boolean bl) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, n, bl);
        return pdfIndirectObject;
    }

    public void setOpenAction(String string) {
        this.pdf.setOpenAction(string);
    }

    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        this.pdf.addAdditionalAction(pdfName, pdfAction);
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.pdf.setOpenAction(pdfAction);
    }

    public void setPageLabels(PdfPageLabels pdfPageLabels) {
        this.pdf.setPageLabels(pdfPageLabels);
    }

    PdfEncryption getEncryption() {
        return this.crypto;
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        return this.currentPdfReaderInstance.getReaderFile();
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n) {
        PdfReaderInstance pdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (pdfReaderInstance == null) {
            pdfReaderInstance = pdfReader.getPdfReaderInstance(this);
            this.importedPages.put(pdfReader, pdfReaderInstance);
        }
        return pdfReaderInstance.getImportedPage(n);
    }

    public void addJavaScript(PdfAction pdfAction) {
        this.pdf.addJavaScript(pdfAction);
    }

    public void addJavaScript(String string, boolean bl) {
        this.addJavaScript(PdfAction.javaScript(string, this, bl));
    }

    public void addJavaScript(String string) {
        this.addJavaScript(string, false);
    }

    public void addFileAttachment(String string, byte[] byArray, String string2, String string3) throws IOException {
        this.addFileAttachment(string, PdfFileSpecification.fileEmbedded(this, string2, string3, byArray));
    }

    public void addFileAttachment(String string, PdfFileSpecification pdfFileSpecification) throws IOException {
        this.pdf.addFileAttachment(string, pdfFileSpecification);
    }

    public void setCropBoxSize(Rectangle rectangle) {
        this.pdf.setCropBoxSize(rectangle);
    }

    public PdfIndirectReference getPageReference(int n) {
        PdfIndirectReference pdfIndirectReference;
        if (--n < 0) {
            throw new IndexOutOfBoundsException("The page numbers start at 1.");
        }
        if (n < this.pageReferences.size()) {
            pdfIndirectReference = (PdfIndirectReference)this.pageReferences.get(n);
            if (pdfIndirectReference == null) {
                pdfIndirectReference = this.body.getPdfIndirectReference();
                this.pageReferences.set(n, pdfIndirectReference);
            }
        } else {
            int n2 = n - this.pageReferences.size();
            for (int i = 0; i < n2; ++i) {
                this.pageReferences.add(null);
            }
            pdfIndirectReference = this.body.getPdfIndirectReference();
            this.pageReferences.add(pdfIndirectReference);
        }
        return pdfIndirectReference;
    }

    PdfIndirectReference getCurrentPage() {
        return this.getPageReference(this.currentPageNumber);
    }

    int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.pdf.addCalculationOrder(pdfFormField);
    }

    public void setSigFlags(int n) {
        this.pdf.setSigFlags(n);
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.pdf.addAnnotation(pdfAnnotation);
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        this.addAnnotation(pdfAnnotation);
    }

    public void setPdfVersion(char c) {
        if (this.HEADER.length > 7) {
            this.HEADER[7] = (byte)c;
        }
    }

    public int reorderPages(int[] nArray) throws DocumentException {
        return this.root.reorderPages(nArray);
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f) {
        this.spaceCharRatio = f < 0.001f ? 0.001f : f;
    }

    public void setRunDirection(int n) {
        if (n < 1 || n > 3) {
            throw new RuntimeException("Invalid run direction: " + n);
        }
        this.runDirection = n;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public void setDuration(int n) {
        this.pdf.setDuration(n);
    }

    public void setTransition(PdfTransition pdfTransition) {
        this.pdf.setTransition(pdfTransition);
    }

    public void freeReader(PdfReader pdfReader) throws IOException {
        this.currentPdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (this.currentPdfReaderInstance == null) {
            return;
        }
        this.currentPdfReaderInstance.writeAllPages();
        this.currentPdfReaderInstance = null;
        this.importedPages.remove(pdfReader);
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        this.pdf.setPageAction(pdfName, pdfAction);
    }

    public int getCurrentDocumentSize() {
        return this.body.offset() + this.body.size() * 20 + 72;
    }

    public boolean isStrictImageSequence() {
        return this.pdf.isStrictImageSequence();
    }

    public void setStrictImageSequence(boolean bl) {
        this.pdf.setStrictImageSequence(bl);
    }

    public void setPageEmpty(boolean bl) {
        this.pdf.setPageEmpty(bl);
    }

    public PdfDictionary getInfo() {
        return ((PdfDocument)this.document).getInfo();
    }

    public PdfDictionary getExtraCatalog() {
        if (this.extraCatalog == null) {
            this.extraCatalog = new PdfDictionary();
        }
        return this.extraCatalog;
    }

    public void setLinearPageMode() {
        this.root.setLinearMode(null);
    }

    public PdfDictionary getGroup() {
        return this.group;
    }

    public void setGroup(PdfDictionary pdfDictionary) {
        this.group = pdfDictionary;
    }

    public void setPDFXConformance(int n) {
        if (this.pdfxConformance == n) {
            return;
        }
        if (this.pdf.isOpen()) {
            throw new PdfXConformanceException("PDFX conformance can only be set before opening the document.");
        }
        if (this.crypto != null) {
            throw new PdfXConformanceException("A PDFX conforming document cannot be encrypted.");
        }
        if (n != 0) {
            this.setPdfVersion('3');
        }
        this.pdfxConformance = n;
    }

    public int getPDFXConformance() {
        return this.pdfxConformance;
    }

    static void checkPDFXConformance(PdfWriter pdfWriter, int n, Object object) {
        if (pdfWriter == null || pdfWriter.pdfxConformance == 0) {
            return;
        }
        int n2 = pdfWriter.pdfxConformance;
        switch (n) {
            case 1: {
                switch (n2) {
                    case 1: {
                        if (object instanceof ExtendedColor) {
                            ExtendedColor extendedColor = (ExtendedColor)object;
                            switch (extendedColor.getType()) {
                                case 1: 
                                case 2: {
                                    return;
                                }
                                case 0: {
                                    throw new PdfXConformanceException("Colorspace RGB is not allowed.");
                                }
                                case 3: {
                                    SpotColor spotColor = (SpotColor)extendedColor;
                                    PdfWriter.checkPDFXConformance(pdfWriter, 1, spotColor.getPdfSpotColor().getAlternativeCS());
                                    break;
                                }
                                case 5: {
                                    ShadingColor shadingColor = (ShadingColor)extendedColor;
                                    PdfWriter.checkPDFXConformance(pdfWriter, 1, shadingColor.getPdfShadingPattern().getShading().getColorSpace());
                                    break;
                                }
                                case 4: {
                                    PatternColor patternColor = (PatternColor)extendedColor;
                                    PdfWriter.checkPDFXConformance(pdfWriter, 1, patternColor.getPainter().getDefaultColor());
                                }
                            }
                            break;
                        }
                        if (!(object instanceof Color)) break;
                        throw new PdfXConformanceException("Colorspace RGB is not allowed.");
                    }
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (n2 != 1) break;
                throw new PdfXConformanceException("Colorspace RGB is not allowed.");
            }
            case 4: {
                if (((BaseFont)object).isEmbedded()) break;
                throw new PdfXConformanceException("All the fonts must be embedded.");
            }
            case 5: {
                PdfImage pdfImage = (PdfImage)object;
                if (pdfImage.get(PdfName.SMASK) != null) {
                    throw new PdfXConformanceException("The /SMask key is not allowed in images.");
                }
                switch (n2) {
                    case 1: {
                        PdfObject pdfObject = pdfImage.get(PdfName.COLORSPACE);
                        if (pdfObject == null) {
                            return;
                        }
                        if (pdfObject.isName()) {
                            if (!PdfName.DEVICERGB.equals(pdfObject)) break;
                            throw new PdfXConformanceException("Colorspace RGB is not allowed.");
                        }
                        if (!pdfObject.isArray() || !PdfName.CALRGB.equals(((PdfArray)pdfObject).getArrayList().get(0))) break;
                        throw new PdfXConformanceException("Colorspace CalRGB is not allowed.");
                    }
                }
                break;
            }
            case 6: {
                PdfDictionary pdfDictionary = (PdfDictionary)object;
                PdfObject pdfObject = pdfDictionary.get(PdfName.BM);
                if (pdfObject != null && !PdfGState.BM_NORMAL.equals(pdfObject) && !PdfGState.BM_COMPATIBLE.equals(pdfObject)) {
                    throw new PdfXConformanceException("Blend mode " + pdfObject.toString() + " not allowed.");
                }
                pdfObject = pdfDictionary.get(PdfName.CA);
                double d = 0.0;
                if (pdfObject != null && (d = ((PdfNumber)pdfObject).doubleValue()) != 1.0) {
                    throw new PdfXConformanceException("Transparency is not allowed: /CA = " + d);
                }
                pdfObject = pdfDictionary.get(PdfName.ca);
                d = 0.0;
                if (pdfObject == null || (d = ((PdfNumber)pdfObject).doubleValue()) == 1.0) break;
                throw new PdfXConformanceException("Transparency is not allowed: /ca = " + d);
            }
            case 7: {
                throw new PdfXConformanceException("Layers are not allowed.");
            }
        }
    }

    public void setOutputIntents(String string, String string2, String string3, String string4, byte[] byArray) throws IOException {
        this.getExtraCatalog();
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.OUTPUTINTENT);
        if (string2 != null) {
            pdfDictionary.put(PdfName.OUTPUTCONDITION, new PdfString(string2, "UnicodeBig"));
        }
        if (string != null) {
            pdfDictionary.put(PdfName.OUTPUTCONDITIONIDENTIFIER, new PdfString(string, "UnicodeBig"));
        }
        if (string3 != null) {
            pdfDictionary.put(PdfName.REGISTRYNAME, new PdfString(string3, "UnicodeBig"));
        }
        if (string4 != null) {
            pdfDictionary.put(PdfName.INFO, new PdfString(string3, "UnicodeBig"));
        }
        if (byArray != null) {
            PdfStream pdfStream = new PdfStream(byArray);
            pdfStream.flateCompress();
            pdfDictionary.put(PdfName.DESTOUTPUTPROFILE, this.addToBody(pdfStream).getIndirectReference());
        }
        pdfDictionary.put(PdfName.S, PdfName.GTS_PDFX);
        this.extraCatalog.put(PdfName.OUTPUTINTENTS, new PdfArray(pdfDictionary));
    }

    private static String getNameString(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
        if (pdfObject == null || !pdfObject.isString()) {
            return null;
        }
        return ((PdfString)pdfObject).toUnicodeString();
    }

    public boolean setOutputIntents(PdfReader pdfReader, boolean bl) throws IOException {
        PdfDictionary pdfDictionary = pdfReader.getCatalog();
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OUTPUTINTENTS));
        if (pdfArray == null) {
            return false;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        if (arrayList.size() == 0) {
            return false;
        }
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(0));
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.S));
        if (pdfObject == null || !PdfName.GTS_PDFX.equals(pdfObject)) {
            return false;
        }
        if (bl) {
            return true;
        }
        PRStream pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.DESTOUTPUTPROFILE));
        byte[] byArray = null;
        if (pRStream != null) {
            byArray = PdfReader.getStreamBytes(pRStream);
        }
        this.setOutputIntents(PdfWriter.getNameString(pdfDictionary2, PdfName.OUTPUTCONDITIONIDENTIFIER), PdfWriter.getNameString(pdfDictionary2, PdfName.OUTPUTCONDITION), PdfWriter.getNameString(pdfDictionary2, PdfName.REGISTRYNAME), PdfWriter.getNameString(pdfDictionary2, PdfName.INFO), byArray);
        return true;
    }

    public void setBoxSize(String string, Rectangle rectangle) {
        this.pdf.setBoxSize(string, rectangle);
    }

    public Rectangle getBoxSize(String string) {
        return this.pdf.getBoxSize(string);
    }

    public Rectangle getPageSize() {
        return this.pdf.getPageSize();
    }

    public PdfDictionary getDefaultColorspace() {
        return this.defaultColorspace;
    }

    public void setDefaultColorspace(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            this.defaultColorspace.remove(pdfName);
        }
        this.defaultColorspace.put(pdfName, pdfObject);
    }

    public boolean isFullCompression() {
        return this.fullCompression;
    }

    public void setFullCompression() {
        this.fullCompression = true;
        this.setPdfVersion('5');
    }

    public PdfOCProperties getOCProperties() {
        this.fillOCProperties(true);
        return this.OCProperties;
    }

    public void addOCGRadioGroup(ArrayList arrayList) {
        PdfArray pdfArray = new PdfArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            PdfLayer pdfLayer = (PdfLayer)arrayList.get(i);
            if (pdfLayer.getTitle() != null) continue;
            pdfArray.add(pdfLayer.getRef());
        }
        if (pdfArray.size() == 0) {
            return;
        }
        this.OCGRadioGroup.add(pdfArray);
    }

    public void setThumbnail(Image image) throws PdfException, DocumentException {
        this.pdf.setThumbnail(image);
    }

    public float getUserunit() {
        return this.userunit;
    }

    public void setUserunit(float f) throws DocumentException {
        if (f < 1.0f || f > 75000.0f) {
            throw new DocumentException("UserUnit should be a value between 1 and 75000.");
        }
        this.userunit = f;
        this.setPdfVersion('6');
    }

    public void setXmpMetadata(byte[] byArray) {
        this.xmpMetadata = byArray;
    }

    public void createXmpMetadata() {
        this.setXmpMetadata(this.pdf.createXmpMetadata());
    }

    public void releaseTemplate(PdfTemplate pdfTemplate) throws IOException {
        PdfIndirectReference pdfIndirectReference = pdfTemplate.getIndirectReference();
        Object[] objectArray = (Object[])this.formXObjects.get(pdfIndirectReference);
        if (objectArray == null || objectArray[1] == null) {
            return;
        }
        PdfTemplate pdfTemplate2 = (PdfTemplate)objectArray[1];
        if (pdfTemplate2.getIndirectReference() instanceof PRIndirectReference) {
            return;
        }
        if (pdfTemplate2.getType() == 1) {
            this.addToBody((PdfObject)pdfTemplate2.getFormXObject(), pdfTemplate2.getIndirectReference());
            objectArray[1] = null;
        }
    }

    public void setTagged() {
        if (this.open) {
            throw new IllegalArgumentException("Tagging must be set before opening the document.");
        }
        this.tagged = true;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public PdfStructureTreeRoot getStructureTreeRoot() {
        if (this.tagged && this.structureTreeRoot == null) {
            this.structureTreeRoot = new PdfStructureTreeRoot(this);
        }
        return this.structureTreeRoot;
    }

    static class PdfTrailer
    extends PdfDictionary {
        int offset;

        PdfTrailer(int n, int n2, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfIndirectReference pdfIndirectReference3, PdfObject pdfObject, int n3) {
            this.offset = n2;
            this.put(PdfName.SIZE, new PdfNumber(n));
            this.put(PdfName.ROOT, pdfIndirectReference);
            if (pdfIndirectReference2 != null) {
                this.put(PdfName.INFO, pdfIndirectReference2);
            }
            if (pdfIndirectReference3 != null) {
                this.put(PdfName.ENCRYPT, pdfIndirectReference3);
            }
            if (pdfObject != null) {
                this.put(PdfName.ID, pdfObject);
            }
            if (n3 > 0) {
                this.put(PdfName.PREV, new PdfNumber(n3));
            }
        }

        @Override
        public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
            outputStream.write(DocWriter.getISOBytes("trailer\n"));
            super.toPdf(null, outputStream);
            outputStream.write(DocWriter.getISOBytes("\nstartxref\n"));
            outputStream.write(DocWriter.getISOBytes(String.valueOf(this.offset)));
            outputStream.write(DocWriter.getISOBytes("\n%%EOF\n"));
        }
    }

    public static class PdfBody {
        private TreeSet xrefs = new TreeSet();
        private int refnum;
        private int position;
        private PdfWriter writer;
        private static final int OBJSINSTREAM = 200;
        private ByteBuffer index;
        private ByteBuffer streamObjects;
        private int currentObjNum;
        private int numObj = 0;

        PdfBody(PdfWriter pdfWriter) {
            this.xrefs.add(new PdfCrossReference(0, 0, 65535));
            this.position = pdfWriter.getOs().getCounter();
            this.refnum = 1;
            this.writer = pdfWriter;
        }

        void setRefnum(int n) {
            this.refnum = n;
        }

        private PdfCrossReference addToObjStm(PdfObject pdfObject, int n) throws IOException {
            if (this.numObj >= 200) {
                this.flushObjStm();
            }
            if (this.index == null) {
                this.index = new ByteBuffer();
                this.streamObjects = new ByteBuffer();
                this.currentObjNum = this.getIndirectReferenceNumber();
                this.numObj = 0;
            }
            int n2 = this.streamObjects.size();
            int n3 = this.numObj++;
            PdfEncryption pdfEncryption = this.writer.crypto;
            this.writer.crypto = null;
            pdfObject.toPdf(this.writer, this.streamObjects);
            this.writer.crypto = pdfEncryption;
            this.streamObjects.append(' ');
            this.index.append(n).append(' ').append(n2).append(' ');
            return new PdfCrossReference(2, n, this.currentObjNum, n3);
        }

        private void flushObjStm() throws IOException {
            if (this.numObj == 0) {
                return;
            }
            int n = this.index.size();
            this.index.append(this.streamObjects);
            PdfStream pdfStream = new PdfStream(this.index.toByteArray());
            pdfStream.flateCompress();
            pdfStream.put(PdfName.TYPE, PdfName.OBJSTM);
            pdfStream.put(PdfName.N, new PdfNumber(this.numObj));
            pdfStream.put(PdfName.FIRST, new PdfNumber(n));
            this.add((PdfObject)pdfStream, this.currentObjNum);
            this.index = null;
            this.streamObjects = null;
            this.numObj = 0;
        }

        PdfIndirectObject add(PdfObject pdfObject) throws IOException {
            return this.add(pdfObject, this.getIndirectReferenceNumber());
        }

        PdfIndirectObject add(PdfObject pdfObject, boolean bl) throws IOException {
            return this.add(pdfObject, this.getIndirectReferenceNumber(), bl);
        }

        PdfIndirectReference getPdfIndirectReference() {
            return new PdfIndirectReference(0, this.getIndirectReferenceNumber());
        }

        int getIndirectReferenceNumber() {
            int n = this.refnum++;
            this.xrefs.add(new PdfCrossReference(n, 0, 65536));
            return n;
        }

        PdfIndirectObject add(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
            return this.add(pdfObject, pdfIndirectReference.getNumber());
        }

        PdfIndirectObject add(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference, boolean bl) throws IOException {
            return this.add(pdfObject, pdfIndirectReference.getNumber(), bl);
        }

        PdfIndirectObject add(PdfObject pdfObject, int n) throws IOException {
            return this.add(pdfObject, n, true);
        }

        PdfIndirectObject add(PdfObject pdfObject, int n, boolean bl) throws IOException {
            if (bl && pdfObject.canBeInObjStm() && this.writer.isFullCompression()) {
                PdfCrossReference pdfCrossReference = this.addToObjStm(pdfObject, n);
                PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n, pdfObject, this.writer);
                if (!this.xrefs.add(pdfCrossReference)) {
                    this.xrefs.remove(pdfCrossReference);
                    this.xrefs.add(pdfCrossReference);
                }
                return pdfIndirectObject;
            }
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n, pdfObject, this.writer);
            PdfCrossReference pdfCrossReference = new PdfCrossReference(n, this.position);
            if (!this.xrefs.add(pdfCrossReference)) {
                this.xrefs.remove(pdfCrossReference);
                this.xrefs.add(pdfCrossReference);
            }
            pdfIndirectObject.writeTo(this.writer.getOs());
            this.position = this.writer.getOs().getCounter();
            return pdfIndirectObject;
        }

        int offset() {
            return this.position;
        }

        int size() {
            return Math.max(((PdfCrossReference)this.xrefs.last()).getRefnum() + 1, this.refnum);
        }

        void writeCrossReferenceTable(OutputStream outputStream, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfIndirectReference pdfIndirectReference3, PdfObject pdfObject, int n) throws IOException {
            int n2 = 0;
            if (this.writer.isFullCompression()) {
                this.flushObjStm();
                n2 = this.getIndirectReferenceNumber();
                this.xrefs.add(new PdfCrossReference(n2, this.position));
            }
            PdfCrossReference pdfCrossReference2 = (PdfCrossReference)this.xrefs.first();
            int n3 = pdfCrossReference2.getRefnum();
            int n4 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PdfCrossReference pdfCrossReference2 : this.xrefs) {
                if (n3 + n4 == pdfCrossReference2.getRefnum()) {
                    ++n4;
                    continue;
                }
                arrayList.add(new Integer(n3));
                arrayList.add(new Integer(n4));
                n3 = pdfCrossReference2.getRefnum();
                n4 = 1;
            }
            arrayList.add(new Integer(n3));
            arrayList.add(new Integer(n4));
            if (this.writer.isFullCompression()) {
                int n5;
                int n6 = -16777216;
                for (n5 = 4; n5 > 1 && (n6 & this.position) == 0; --n5) {
                    n6 >>>= 8;
                }
                ByteBuffer byteBuffer = new ByteBuffer();
                for (PdfCrossReference pdfCrossReference2 : this.xrefs) {
                    pdfCrossReference2.toPdf(n5, byteBuffer);
                }
                PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
                byteBuffer = null;
                pdfStream.flateCompress();
                pdfStream.put(PdfName.SIZE, new PdfNumber(this.size()));
                pdfStream.put(PdfName.ROOT, pdfIndirectReference);
                if (pdfIndirectReference2 != null) {
                    pdfStream.put(PdfName.INFO, pdfIndirectReference2);
                }
                if (pdfIndirectReference3 != null) {
                    pdfStream.put(PdfName.ENCRYPT, pdfIndirectReference3);
                }
                if (pdfObject != null) {
                    pdfStream.put(PdfName.ID, pdfObject);
                }
                pdfStream.put(PdfName.W, new PdfArray(new int[]{1, n5, 2}));
                pdfStream.put(PdfName.TYPE, PdfName.XREF);
                PdfArray pdfArray = new PdfArray();
                for (int i = 0; i < arrayList.size(); ++i) {
                    pdfArray.add(new PdfNumber((Integer)arrayList.get(i)));
                }
                pdfStream.put(PdfName.INDEX, pdfArray);
                if (n > 0) {
                    pdfStream.put(PdfName.PREV, new PdfNumber(n));
                }
                PdfEncryption pdfEncryption = this.writer.crypto;
                this.writer.crypto = null;
                PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n2, (PdfObject)pdfStream, this.writer);
                pdfIndirectObject.writeTo(this.writer.getOs());
                this.writer.crypto = pdfEncryption;
            } else {
                outputStream.write(DocWriter.getISOBytes("xref\n"));
                Iterator iterator = this.xrefs.iterator();
                for (int i = 0; i < arrayList.size(); i += 2) {
                    n3 = (Integer)arrayList.get(i);
                    n4 = (Integer)arrayList.get(i + 1);
                    outputStream.write(DocWriter.getISOBytes(String.valueOf(n3)));
                    outputStream.write(DocWriter.getISOBytes(" "));
                    outputStream.write(DocWriter.getISOBytes(String.valueOf(n4)));
                    outputStream.write(10);
                    while (n4-- > 0) {
                        pdfCrossReference2 = (PdfCrossReference)iterator.next();
                        pdfCrossReference2.toPdf(outputStream);
                    }
                }
            }
        }

        static class PdfCrossReference
        implements Comparable {
            private int type;
            private int offset;
            private int refnum;
            private int generation;

            PdfCrossReference(int n, int n2, int n3) {
                this.type = 0;
                this.offset = n2;
                this.refnum = n;
                this.generation = n3;
            }

            PdfCrossReference(int n, int n2) {
                this.type = 1;
                this.offset = n2;
                this.refnum = n;
                this.generation = 0;
            }

            PdfCrossReference(int n, int n2, int n3, int n4) {
                this.type = n;
                this.offset = n3;
                this.refnum = n2;
                this.generation = n4;
            }

            int getRefnum() {
                return this.refnum;
            }

            public void toPdf(OutputStream outputStream) throws IOException {
                String string = "0000000000" + this.offset;
                StringBuffer stringBuffer = new StringBuffer(string.substring(string.length() - 10));
                string = "00000" + this.generation;
                String string2 = string.substring(string.length() - 5);
                if (this.generation == 65535) {
                    outputStream.write(DocWriter.getISOBytes(stringBuffer.append(' ').append(string2).append(" f \n").toString()));
                } else {
                    outputStream.write(DocWriter.getISOBytes(stringBuffer.append(' ').append(string2).append(" n \n").toString()));
                }
            }

            public void toPdf(int n, OutputStream outputStream) throws IOException {
                outputStream.write((byte)this.type);
                while (--n >= 0) {
                    outputStream.write((byte)(this.offset >>> 8 * n & 0xFF));
                }
                outputStream.write((byte)(this.generation >>> 8 & 0xFF));
                outputStream.write((byte)(this.generation & 0xFF));
            }

            public int compareTo(Object object) {
                PdfCrossReference pdfCrossReference = (PdfCrossReference)object;
                return this.refnum < pdfCrossReference.refnum ? -1 : (this.refnum == pdfCrossReference.refnum ? 0 : 1);
            }

            public boolean equals(Object object) {
                if (object instanceof PdfCrossReference) {
                    PdfCrossReference pdfCrossReference = (PdfCrossReference)object;
                    return this.refnum == pdfCrossReference.refnum;
                }
                return false;
            }
        }
    }
}

