/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.StampContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

class PdfStamperImp
extends PdfWriter {
    HashMap readers2intrefs = new HashMap();
    HashMap readers2file = new HashMap();
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected boolean flatFreeText = false;
    protected int[] namePtr = new int[]{0};
    protected boolean namedAsNames;
    protected List newBookmarks;
    protected HashSet partialFlattening = new HashSet();
    protected boolean useVp = false;
    protected int vp = 0;
    protected HashMap fieldTemplates = new HashMap();
    protected boolean fieldsAdded = false;
    protected int sigFlags = 0;
    protected boolean append;
    protected IntHashtable marked;
    protected int initialXrefSize;
    protected PdfAction openAction;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c, boolean bl) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        this.append = bl;
        if (bl) {
            int n;
            if (pdfReader.isRebuilt()) {
                throw new DocumentException("Append mode requires a document without errors even if recovery was possible.");
            }
            if (pdfReader.isEncrypted()) {
                this.crypto = new PdfEncryption(pdfReader.getDecrypt());
            }
            this.HEADER = PdfStamperImp.getISOBytes("\n");
            this.file.reOpen();
            byte[] byArray = new byte[8192];
            while ((n = this.file.read(byArray)) > 0) {
                this.os.write(byArray, 0, n);
            }
            this.file.close();
            this.prevxref = pdfReader.getLastXref();
            pdfReader.setAppendable(true);
        } else if (c == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c);
        }
        super.open();
        this.pdf.addWriter(this);
        if (bl) {
            this.body.setRefnum(pdfReader.getXrefSize());
            this.marked = new IntHashtable();
            if (pdfReader.isNewXrefType()) {
                this.fullCompression = true;
            }
            if (pdfReader.isHybridXref()) {
                this.fullCompression = false;
            }
        }
        this.initialXrefSize = pdfReader.getXrefSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(HashMap hashMap) throws DocumentException, IOException {
        PdfObject pdfObject;
        PdfObject pdfObject2;
        Object object;
        PdfObject pdfObject3;
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.reader.setViewerPreferences(this.vp);
            this.markUsed(this.reader.getTrailer().get(PdfName.ROOT));
        }
        if (this.flat) {
            this.flatFields();
        }
        if (this.flatFreeText) {
            this.flatFreeTextFields();
        }
        this.addFieldResources();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (this.acroFields != null && this.acroFields.getXfa().isChanged()) {
            this.markUsed(pdfDictionary);
            if (!this.flat) {
                this.acroFields.getXfa().setXfa(this);
            }
        }
        if (this.sigFlags != 0 && pdfDictionary != null) {
            pdfDictionary.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
            this.markUsed(pdfDictionary);
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        this.addFileAttachments();
        if (this.openAction != null) {
            this.reader.getCatalog().put(PdfName.OPENACTION, this.openAction);
        }
        if (this.xmpMetadata != null) {
            pdfObject3 = this.reader.getCatalog();
            PdfStream pdfStream = new PdfStream(this.xmpMetadata);
            pdfStream.put(PdfName.TYPE, PdfName.METADATA);
            pdfStream.put(PdfName.SUBTYPE, PdfName.XML);
            ((PdfDictionary)pdfObject3).put(PdfName.METADATA, this.body.add(pdfStream).getIndirectReference());
            this.markUsed(pdfObject3);
        }
        pdfObject3 = null;
        try {
            this.file.reOpen();
            this.alterContents();
            pdfObject3 = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
            int n = -1;
            if (pdfObject3 != null) {
                n = ((PdfIndirectReference)pdfObject3).getNumber();
            }
            int n2 = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
            if (this.append) {
                int n3;
                object = this.marked.getKeys();
                for (n3 = 0; n3 < ((int[])object).length; ++n3) {
                    int n4 = object[n3];
                    pdfObject2 = this.reader.getPdfObjectRelease(n4);
                    if (pdfObject2 == null || n == n4 || n4 >= this.initialXrefSize) continue;
                    this.addToBody(pdfObject2, n4, n4 != n2);
                }
                for (n3 = this.initialXrefSize; n3 < this.reader.getXrefSize(); ++n3) {
                    PdfObject pdfObject4 = this.reader.getPdfObject(n3);
                    if (pdfObject4 == null) continue;
                    this.addToBody(pdfObject4, this.getNewObjectNumber(this.reader, n3, 0));
                }
            } else {
                for (int i = 1; i < this.reader.getXrefSize(); ++i) {
                    PdfObject pdfObject5 = this.reader.getPdfObjectRelease(i);
                    if (pdfObject5 == null || n == i) continue;
                    this.addToBody(pdfObject5, this.getNewObjectNumber(this.reader, i, 0), i != n2);
                }
            }
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
        PdfIndirectReference pdfIndirectReference = null;
        PdfObject pdfObject6 = null;
        if (this.crypto != null) {
            if (this.append) {
                pdfIndirectReference = this.reader.getCryptoRef();
            } else {
                object = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
                pdfIndirectReference = ((PdfIndirectObject)object).getIndirectReference();
            }
            pdfObject6 = this.crypto.getFileID();
        }
        object = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference2 = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, ((PdfIndirectReference)object).getNumber(), 0));
        PdfIndirectReference pdfIndirectReference3 = null;
        pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(pdfObject3);
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (pdfObject2 != null) {
            for (Object object2 : ((PdfDictionary)pdfObject2).getKeys()) {
                pdfObject = PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get((PdfName)object2));
                pdfDictionary2.put((PdfName)object2, pdfObject);
            }
        }
        if (hashMap != null) {
            for (Object object2 : hashMap.keySet()) {
                pdfObject = new PdfName((String)object2);
                String string = (String)hashMap.get(object2);
                if (string == null) {
                    pdfDictionary2.remove((PdfName)pdfObject);
                    continue;
                }
                pdfDictionary2.put((PdfName)pdfObject, new PdfString(string, "UnicodeBig"));
            }
        }
        if (this.append) {
            pdfIndirectReference3 = pdfObject3 == null ? this.addToBody((PdfObject)pdfDictionary2, false).getIndirectReference() : this.addToBody((PdfObject)pdfDictionary2, ((PdfIndirectReference)pdfObject3).getNumber(), false).getIndirectReference();
        } else if (!pdfDictionary2.getKeys().isEmpty()) {
            pdfIndirectReference3 = this.addToBody((PdfObject)pdfDictionary2, false).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os, pdfIndirectReference2, pdfIndirectReference3, pdfIndirectReference, pdfObject6, this.prevxref);
        if (this.fullCompression) {
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            PdfWriter.PdfTrailer pdfTrailer = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference2, pdfIndirectReference3, pdfIndirectReference, pdfObject6, this.prevxref);
            pdfTrailer.toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
        this.reader.close();
    }

    void applyRotation(PdfDictionary pdfDictionary, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
        int n = rectangle.getRotation();
        switch (n) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.top());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.right());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.top());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.right());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        for (PageStamp pageStamp : this.pagesToContent.values()) {
            PdfDictionary pdfDictionary = pageStamp.pageN;
            this.markUsed(pdfDictionary);
            PdfArray pdfArray = null;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS), pdfDictionary);
            if (pdfObject == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
                this.markUsed(pdfArray);
            } else if (pdfObject.isStream()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfDictionary.get(PdfName.CONTENTS));
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
            try {
                pdfStream.flateCompress();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            pdfArray.addFirst(this.addToBody(pdfStream).getIndirectReference());
            byteBuffer.reset();
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.over.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
                pdfStream = new PdfStream(byteBuffer.toByteArray());
                try {
                    pdfStream.flateCompress();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                pdfArray.add(this.addToBody(pdfStream).getIndirectReference());
            }
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        pageStamp.pageN.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    @Override
    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        if (intHashtable != null) {
            int n3 = intHashtable.get(n);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                intHashtable.put(n, n3);
            }
            return n3;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append && n < this.initialXrefSize) {
                return n;
            }
            int n4 = this.myXref.get(n);
            if (n4 == 0) {
                n4 = this.getIndirectReferenceNumber();
                this.myXref.put(n, n4);
            }
            return n4;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    @Override
    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
            if (randomAccessFileOrArray != null) {
                return randomAccessFileOrArray;
            }
            return pdfReader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    public void registerReader(PdfReader pdfReader, boolean bl) throws IOException {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        if (bl) {
            RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
            this.readers2file.put(pdfReader, randomAccessFileOrArray);
            randomAccessFileOrArray.reOpen();
        }
    }

    public void unRegisterReader(PdfReader pdfReader) {
        if (!this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.remove(pdfReader);
        RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
        if (randomAccessFileOrArray == null) {
            return;
        }
        this.readers2file.remove(pdfReader);
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void findAllObjects(PdfReader pdfReader, PdfObject pdfObject, IntHashtable intHashtable) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                if (pdfReader != pRIndirectReference.getReader()) {
                    return;
                }
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    return;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
                PdfStamperImp.findAllObjects(pdfReader, PdfReader.getPdfObject(pdfObject), intHashtable);
                return;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    PdfStamperImp.findAllObjects(pdfReader, (PdfObject)arrayList.get(i), intHashtable);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                for (PdfName pdfName : pdfDictionary.getKeys()) {
                    PdfStamperImp.findAllObjects(pdfReader, pdfDictionary.get(pdfName), intHashtable);
                }
                return;
            }
        }
    }

    public void addComments(FdfReader fdfReader) throws IOException {
        PdfObject pdfObject;
        PdfObject pdfObject2;
        int n;
        PdfObject pdfObject3;
        PdfObject pdfObject4;
        if (this.readers2intrefs.containsKey(fdfReader)) {
            return;
        }
        PdfDictionary pdfDictionary = fdfReader.getCatalog();
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FDF))) == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        this.registerReader(fdfReader, false);
        IntHashtable intHashtable = new IntHashtable();
        HashMap<String, PdfObject> hashMap = new HashMap<String, PdfObject>();
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList arrayList2 = pdfArray.getArrayList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            PdfObject pdfObject5 = (PdfObject)arrayList2.get(i);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfObject5);
            pdfObject4 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.PAGE));
            if (pdfObject4 == null || ((PdfNumber)pdfObject4).intValue() >= this.reader.getNumberOfPages()) continue;
            PdfStamperImp.findAllObjects(fdfReader, pdfObject5, intHashtable);
            arrayList.add(pdfObject5);
            if (pdfObject5.type() != 10 || (pdfObject3 = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.NM))) == null || pdfObject3.type() != 3) continue;
            hashMap.put(pdfObject3.toString(), pdfObject5);
        }
        int[] nArray = intHashtable.getKeys();
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            pdfObject4 = fdfReader.getPdfObject(n2);
            if (pdfObject4.type() == 6 && (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.IRT))) != null && pdfObject3.type() == 3 && (pdfObject2 = (PdfObject)hashMap.get(pdfObject3.toString())) != null) {
                pdfObject = new PdfDictionary();
                ((PdfDictionary)pdfObject).merge((PdfDictionary)pdfObject4);
                ((PdfDictionary)pdfObject).put(PdfName.IRT, pdfObject2);
                pdfObject4 = pdfObject;
            }
            this.addToBody(pdfObject4, this.getNewObjectNumber(fdfReader, n2, 0));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            PdfObject pdfObject6 = (PdfObject)arrayList.get(n);
            pdfObject4 = (PdfDictionary)PdfReader.getPdfObject(pdfObject6);
            pdfObject3 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.PAGE));
            pdfObject2 = this.reader.getPageN(((PdfNumber)pdfObject3).intValue() + 1);
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS), pdfObject2);
            if (pdfObject == null) {
                pdfObject = new PdfArray();
                ((PdfDictionary)pdfObject2).put(PdfName.ANNOTS, pdfObject);
                this.markUsed(pdfObject2);
            }
            this.markUsed(pdfObject);
            ((PdfArray)pdfObject).add(pdfObject6);
        }
    }

    PageStamp getPageStamp(int n) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(pdfDictionary);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, pdfDictionary);
            this.pagesToContent.put(pdfDictionary, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, pageStamp);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, pageStamp);
        }
        return pageStamp.over;
    }

    void correctAcroFieldPages(int n) {
        if (this.acroFields == null) {
            return;
        }
        if (n > this.reader.getNumberOfPages()) {
            return;
        }
        HashMap hashMap = this.acroFields.getFields();
        for (AcroFields.Item item : hashMap.values()) {
            ArrayList arrayList = item.page;
            for (int i = 0; i < arrayList.size(); ++i) {
                int n2 = (Integer)arrayList.get(i);
                if (n2 < n) continue;
                arrayList.set(i, new Integer(n2 + 1));
            }
        }
    }

    void insertPage(int n, Rectangle rectangle) {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary;
        PRIndirectReference pRIndirectReference;
        PdfObject pdfObject2;
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n2 = rectangle2.getRotation() % 360;
        PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.PAGE);
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(PdfName.PDF);
        pdfArray.add(PdfName.TEXT);
        pdfArray.add(PdfName.IMAGEB);
        pdfArray.add(PdfName.IMAGEC);
        pdfArray.add(PdfName.IMAGEI);
        pdfDictionary3.put(PdfName.PROCSET, pdfArray);
        pdfDictionary2.put(PdfName.RESOURCES, pdfDictionary3);
        pdfDictionary2.put(PdfName.ROTATE, new PdfNumber(n2));
        pdfDictionary2.put(PdfName.MEDIABOX, new PdfRectangle(rectangle2, n2));
        PRIndirectReference pRIndirectReference2 = this.reader.addPdfObject(pdfDictionary2);
        if (n > this.reader.getNumberOfPages()) {
            pdfObject2 = this.reader.getPageNRelease(this.reader.getNumberOfPages());
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject2).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            ((PdfArray)pdfObject).add(pRIndirectReference2);
            this.markUsed(pdfObject);
            this.reader.pageRefs.insertPage(n, pRIndirectReference2);
        } else {
            if (n < 1) {
                n = 1;
            }
            pdfObject2 = this.reader.getPageN(n);
            pdfObject = this.reader.getPageOrigRef(n);
            this.reader.releasePage(n);
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject2).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            ArrayList arrayList = pdfArray2.getArrayList();
            int n3 = arrayList.size();
            int n4 = ((PdfIndirectReference)pdfObject).getNumber();
            for (int i = 0; i < n3; ++i) {
                PRIndirectReference pRIndirectReference3 = (PRIndirectReference)arrayList.get(i);
                if (n4 != pRIndirectReference3.getNumber()) continue;
                arrayList.add(i, pRIndirectReference2);
                break;
            }
            if (n3 == arrayList.size()) {
                throw new RuntimeException("Internal inconsistence.");
            }
            this.markUsed(pdfArray2);
            this.reader.pageRefs.insertPage(n, pRIndirectReference2);
            this.correctAcroFieldPages(n);
        }
        pdfDictionary2.put(PdfName.PARENT, pRIndirectReference);
        while (pdfDictionary != null) {
            this.markUsed(pdfDictionary);
            pdfObject2 = (PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.COUNT));
            pdfDictionary.put(PdfName.COUNT, new PdfNumber(((PdfNumber)pdfObject2).intValue() + 1));
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.PARENT));
        }
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    void setFreeTextFlattening(boolean bl) {
        this.flatFreeText = bl;
    }

    boolean partialFormFlattening(String string) {
        this.getAcroFields();
        if (this.acroFields.getXfa().isXfaPresent()) {
            throw new UnsupportedOperationException("Partial form flattening is not supported with XFA forms.");
        }
        if (!this.acroFields.getFields().containsKey(string)) {
            return false;
        }
        this.partialFlattening.add(string);
        return true;
    }

    void flatFields() {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        if (this.append) {
            throw new IllegalArgumentException("Field flattening is not supported in append mode.");
        }
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                this.partialFlattening.add(object3.next());
            }
        }
        object3 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        ArrayList arrayList = null;
        if (object3 != null && (object2 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.FIELDS), (PdfObject)object3)) != null) {
            arrayList = ((PdfArray)object2).getArrayList();
        }
        for (Object object4 : hashMap.keySet()) {
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object4)) continue;
            object = (AcroFields.Item)hashMap.get(object4);
            for (int i = 0; i < ((AcroFields.Item)object).merged.size(); ++i) {
                PdfObject pdfObject2;
                Object object5;
                Object object6;
                PdfObject pdfObject3;
                PdfDictionary pdfDictionary = (PdfDictionary)((AcroFields.Item)object).merged.get(i);
                pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
                int n = 0;
                if (pdfObject != null) {
                    n = ((PdfNumber)pdfObject).intValue();
                }
                int n2 = (Integer)((AcroFields.Item)object).page.get(i);
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
                if (pdfDictionary2 != null && (n & 4) != 0 && (n & 2) == 0) {
                    Object object7;
                    pdfObject3 = pdfDictionary2.get(PdfName.N);
                    object6 = null;
                    if (pdfObject3 != null) {
                        object5 = PdfReader.getPdfObject(pdfObject3);
                        if (pdfObject3 instanceof PdfIndirectReference && !pdfObject3.isIndirect()) {
                            object6 = new PdfAppearance((PdfIndirectReference)pdfObject3);
                        } else if (object5 instanceof PdfStream) {
                            ((PdfDictionary)object5).put(PdfName.SUBTYPE, PdfName.FORM);
                            object6 = new PdfAppearance((PdfIndirectReference)pdfObject3);
                        } else if (((PdfObject)object5).isDictionary() && (object7 = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AS))) != null && (pdfObject2 = (PdfIndirectReference)((PdfDictionary)object5).get((PdfName)object7)) != null) {
                            object6 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                            if (pdfObject2.isIndirect()) {
                                object5 = PdfReader.getPdfObject(pdfObject2);
                                ((PdfDictionary)object5).put(PdfName.SUBTYPE, PdfName.FORM);
                            }
                        }
                    }
                    if (object6 != null) {
                        object5 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT)));
                        object7 = this.getOverContent(n2);
                        ((PdfContentByte)object7).setLiteral("Q ");
                        ((PdfContentByte)object7).addTemplate((PdfTemplate)object6, ((Rectangle)object5).left(), ((Rectangle)object5).bottom());
                        ((PdfContentByte)object7).setLiteral("q ");
                    }
                }
                if (this.partialFlattening.isEmpty() || (object6 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)(pdfObject3 = this.reader.getPageN(n2))).get(PdfName.ANNOTS))) == null) continue;
                object5 = ((PdfArray)object6).getArrayList();
                block3: for (int j = 0; j < ((ArrayList)object5).size(); ++j) {
                    PdfObject pdfObject4;
                    pdfObject2 = (PdfObject)((ArrayList)object5).get(j);
                    if (!pdfObject2.isIndirect() || !(pdfObject4 = (PdfObject)((AcroFields.Item)object).widget_refs.get(i)).isIndirect() || ((PRIndirectReference)pdfObject2).getNumber() != ((PRIndirectReference)pdfObject4).getNumber()) continue;
                    ((ArrayList)object5).remove(j--);
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject4;
                    while (true) {
                        PdfObject pdfObject5;
                        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary3.get(PdfName.PARENT);
                        PdfReader.killIndirect(pRIndirectReference);
                        if (pRIndirectReference2 == null) {
                            for (int k = 0; k < arrayList.size(); ++k) {
                                pdfObject5 = (PdfObject)arrayList.get(k);
                                if (!pdfObject5.isIndirect() || ((PRIndirectReference)pdfObject5).getNumber() != pRIndirectReference.getNumber()) continue;
                                arrayList.remove(k);
                                --k;
                            }
                            continue block3;
                        }
                        PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                        pdfObject5 = (PdfArray)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.KIDS));
                        ArrayList arrayList2 = ((PdfArray)pdfObject5).getArrayList();
                        for (int k = 0; k < arrayList2.size(); ++k) {
                            PdfObject pdfObject6 = (PdfObject)arrayList2.get(k);
                            if (!pdfObject6.isIndirect() || ((PRIndirectReference)pdfObject6).getNumber() != pRIndirectReference.getNumber()) continue;
                            arrayList2.remove(k);
                            --k;
                        }
                        if (!arrayList2.isEmpty()) continue block3;
                        pRIndirectReference = pRIndirectReference2;
                    }
                }
                if (((ArrayList)object5).size() != 0) continue;
                PdfReader.killIndirect(((PdfDictionary)pdfObject3).get(PdfName.ANNOTS));
                ((PdfDictionary)pdfObject3).remove(PdfName.ANNOTS);
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
                Object object4;
                object4 = this.reader.getPageN(i);
                object = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.ANNOTS));
                if (object == null) continue;
                ArrayList arrayList3 = ((PdfArray)object).getArrayList();
                for (int j = 0; j < arrayList3.size(); ++j) {
                    PdfDictionary pdfDictionary;
                    pdfObject = PdfReader.getPdfObject((PdfObject)arrayList3.get(j));
                    if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !PdfName.WIDGET.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                    arrayList3.remove(j);
                    --j;
                }
                if (arrayList3.size() != 0) continue;
                PdfReader.killIndirect(((PdfDictionary)object4).get(PdfName.ANNOTS));
                ((PdfDictionary)object4).remove(PdfName.ANNOTS);
            }
            this.eliminateAcroformObjects();
        }
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        this.reader.killXref(pdfDictionary.get(PdfName.XFA));
        pdfDictionary.remove(PdfName.XFA);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
            PdfReader.killIndirect(pdfObject2);
            pdfDictionary.put(PdfName.FIELDS, new PdfArray());
        }
    }

    void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (pdfObject2 == null || !pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.sweepKids((PdfObject)arrayList.get(i));
        }
    }

    private void flatFreeTextFields() {
        if (this.append) {
            throw new IllegalArgumentException("FreeText flattening is not supported in append mode.");
        }
        for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
            PdfDictionary pdfDictionary;
            PdfObject pdfObject;
            int n;
            PdfDictionary pdfDictionary2 = this.reader.getPageN(i);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS));
            if (pdfArray == null) continue;
            ArrayList arrayList = pdfArray.getArrayList();
            for (n = 0; n < arrayList.size(); ++n) {
                int n2;
                pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !((PdfName)(pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE)).equals(PdfName.FREETEXT)) continue;
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
                int n3 = n2 = pdfNumber != null ? pdfNumber.intValue() : 0;
                if ((n2 & 4) != 0 && (n2 & 2) == 0) {
                    Object object;
                    Object object2;
                    PdfObject pdfObject2 = pdfDictionary.get(PdfName.AP);
                    if (pdfObject2 == null) continue;
                    PdfDictionary pdfDictionary3 = pdfObject2 instanceof PdfIndirectReference ? (PdfDictionary)PdfReader.getPdfObject(pdfObject2) : (PdfDictionary)pdfObject2;
                    PdfObject pdfObject3 = pdfDictionary3.get(PdfName.N);
                    PdfAppearance pdfAppearance = null;
                    PdfObject pdfObject4 = PdfReader.getPdfObject(pdfObject3);
                    if (pdfObject3 instanceof PdfIndirectReference && !pdfObject3.isIndirect()) {
                        pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                    } else if (pdfObject4 instanceof PdfStream) {
                        ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                        pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                    } else if (pdfObject4.isDictionary() && (object2 = (PdfName)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.AS))) != null && (object = (PdfIndirectReference)((PdfDictionary)pdfObject4).get((PdfName)object2)) != null) {
                        pdfAppearance = new PdfAppearance((PdfIndirectReference)object);
                        if (((PdfObject)object).isIndirect()) {
                            pdfObject4 = PdfReader.getPdfObject((PdfObject)object);
                            ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                        }
                    }
                    if (pdfAppearance != null) {
                        object2 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT)));
                        object = this.getOverContent(i);
                        ((PdfContentByte)object).setLiteral("Q ");
                        ((PdfContentByte)object).addTemplate(pdfAppearance, ((Rectangle)object2).left(), ((Rectangle)object2).bottom());
                        ((PdfContentByte)object).setLiteral("q ");
                    }
                }
                if (this.partialFlattening.size() != 0) continue;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                if (!(pdfObject instanceof PdfIndirectReference) || !pdfObject.isIndirect() || !PdfName.FREETEXT.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                arrayList.remove(n);
                --n;
            }
            if (arrayList.size() != 0) continue;
            PdfReader.killIndirect(pdfDictionary2.get(PdfName.ANNOTS));
            pdfDictionary2.remove(PdfName.ANNOTS);
        }
    }

    @Override
    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    @Override
    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS), pdfDictionary2)) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
            this.markUsed(pdfDictionary2);
        }
        pdfArray.add(pdfIndirectReference);
        this.markUsed(pdfArray);
    }

    void addFieldResources() {
        PdfDictionary pdfDictionary;
        if (this.fieldTemplates.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ACROFORM), pdfDictionary2);
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.ACROFORM, pdfDictionary3);
            this.markUsed(pdfDictionary2);
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR), pdfDictionary3)) == null) {
            pdfDictionary = new PdfDictionary();
            pdfDictionary3.put(PdfName.DR, pdfDictionary);
            this.markUsed(pdfDictionary3);
        }
        this.markUsed(pdfDictionary);
        for (PdfTemplate pdfTemplate : this.fieldTemplates.keySet()) {
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)pdfTemplate.getResources(), this);
        }
        PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONT));
        if (pdfDictionary4 != null && pdfDictionary3.get(PdfName.DA) == null) {
            pdfDictionary3.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary3);
        }
    }

    void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.expandFields((PdfFormField)arrayList2.get(i), arrayList);
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, PdfDictionary pdfDictionary) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(i);
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    pdfDictionary = this.reader.getPageN(pdfAnnotation.getPlaceInPage());
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS), pdfDictionary);
                    if (object == null) {
                        object = new PdfArray();
                        pdfDictionary.put(PdfName.ANNOTS, (PdfObject)object);
                        this.markUsed(pdfDictionary);
                    }
                    ((PdfArray)object).add(pdfAnnotation.getIndirectReference());
                    this.markUsed((PdfObject)object);
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)) == null || pdfRectangle.left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n = this.reader.getPageRotation(pdfDictionary);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
                        switch (n) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.top() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.top() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.right() - pdfRectangle.left(), rectangle.top() - pdfRectangle.bottom(), rectangle.right() - pdfRectangle.right(), rectangle.top() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.right() - pdfRectangle.left(), pdfRectangle.top(), rectangle.right() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (pdfAnnotation.isUsed()) continue;
                pdfAnnotation.setUsed();
                this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    @Override
    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        this.addAnnotation(pdfAnnotation, this.reader.getPageN(n));
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
        this.markUsed(pdfDictionary);
    }

    void setJavaScript() throws IOException {
        ArrayList arrayList = this.pdf.getDocumentJavaScript();
        if (arrayList.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        String string = String.valueOf(arrayList.size() - 1);
        int n = string.length();
        String string2 = "000000000000000";
        HashMap hashMap = new HashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            string = String.valueOf(i);
            string = string2.substring(0, n - string.length()) + string;
            hashMap.put(string, arrayList.get(i));
        }
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap, this);
        pdfDictionary2.put(PdfName.JAVASCRIPT, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void addFileAttachments() throws IOException {
        HashMap hashMap = this.pdf.getDocumentFileAttachment();
        if (hashMap.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        HashMap hashMap2 = PdfNameTree.readTree((PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.EMBEDDEDFILES)));
        for (String string : hashMap.keySet()) {
            int n = 0;
            String string2 = string;
            while (hashMap2.containsKey(string2)) {
                string2 = string2 + " " + ++n;
            }
            hashMap2.put(string2, hashMap.get(string));
        }
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap2, this);
        pdfDictionary2.put(PdfName.EMBEDDEDFILES, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.size() == 0) {
            return;
        }
        this.namedAsNames = this.reader.getCatalog().get(PdfName.DESTS) != null;
        PdfDictionary pdfDictionary = new PdfDictionary();
        PdfIndirectReference pdfIndirectReference = this.getPdfIndirectReference();
        Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference, this.newBookmarks, this.namedAsNames);
        pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
        pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
        pdfDictionary.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
        this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
        this.reader.getCatalog().put(PdfName.OUTLINES, pdfIndirectReference);
        this.markUsed(this.reader.getCatalog());
    }

    void setOutlines(List list) {
        this.newBookmarks = list;
    }

    @Override
    public void setViewerPreferences(int n) {
        this.useVp = true;
        this.vp |= n;
    }

    @Override
    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }

    @Override
    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setPageAction(PdfName pdfName, PdfAction pdfAction, int n) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AA), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.AA, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        pdfDictionary2.put(pdfName, pdfAction);
        this.markUsed(pdfDictionary2);
    }

    @Override
    public void setDuration(int n) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    @Override
    public void setTransition(PdfTransition pdfTransition) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setDuration(int n, int n2) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        if (n < 0) {
            pdfDictionary.remove(PdfName.DUR);
        } else {
            pdfDictionary.put(PdfName.DUR, new PdfNumber(n));
        }
        this.markUsed(pdfDictionary);
    }

    void setTransition(PdfTransition pdfTransition, int n) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        if (pdfTransition == null) {
            pdfDictionary.remove(PdfName.TRANS);
        } else {
            pdfDictionary.put(PdfName.TRANS, pdfTransition.getTransitionDictionary());
        }
        this.markUsed(pdfDictionary);
    }

    protected void markUsed(PdfObject pdfObject) {
        if (this.append && pdfObject != null) {
            PRIndirectReference pRIndirectReference = null;
            pRIndirectReference = pdfObject.type() == 10 ? (PRIndirectReference)pdfObject : pdfObject.getIndRef();
            if (pRIndirectReference != null) {
                this.marked.put(pRIndirectReference.getNumber(), 1);
            }
        }
    }

    protected void markUsed(int n) {
        if (this.append) {
            this.marked.put(n, 1);
        }
    }

    boolean isAppend() {
        return this.append;
    }

    @Override
    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.AA));
        if (pdfDictionary == null) {
            if (pdfAction == null) {
                return;
            }
            pdfDictionary = new PdfDictionary();
            this.reader.getCatalog().put(PdfName.AA, pdfDictionary);
        }
        this.markUsed(pdfDictionary);
        if (pdfAction == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, pdfAction);
        }
    }

    @Override
    public void setOpenAction(PdfAction pdfAction) {
        this.openAction = pdfAction;
    }

    @Override
    public void setOpenAction(String string) {
        throw new UnsupportedOperationException("Open actions by name are not supported.");
    }

    @Override
    public void setThumbnail(Image image) {
        throw new UnsupportedOperationException("Use PdfStamper.setThumbnail().");
    }

    void setThumbnail(Image image, int n) throws PdfException, DocumentException {
        PdfIndirectReference pdfIndirectReference = this.getImageReference(this.addDirectImageSimple(image));
        this.reader.resetReleasePage();
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        pdfDictionary.put(PdfName.THUMB, pdfIndirectReference);
        this.reader.resetReleasePage();
    }

    @Override
    public PdfContentByte getDirectContentUnder() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    @Override
    public PdfContentByte getDirectContent() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    static class PageStamp {
        PdfDictionary pageN;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp pdfStamperImp, PdfReader pdfReader, PdfDictionary pdfDictionary) {
            this.pageN = pdfDictionary;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp.namePtr);
        }
    }
}

