/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkupAttributes;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class Meta
implements Element,
MarkupAttributes {
    private int type;
    private StringBuffer content;
    protected Properties markupAttributes;

    Meta(int n, String string) {
        this.type = n;
        this.content = new StringBuffer(string);
    }

    public Meta(String string, String string2) {
        this.type = Meta.getType(string);
        this.content = new StringBuffer(string2);
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public ArrayList getChunks() {
        return new ArrayList();
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public String content() {
        return this.content.toString();
    }

    public String name() {
        switch (this.type) {
            case 2: {
                return "subject";
            }
            case 3: {
                return "keywords";
            }
            case 4: {
                return "author";
            }
            case 1: {
                return "title";
            }
            case 5: {
                return "producer";
            }
            case 6: {
                return "creationdate";
            }
        }
        return "unknown";
    }

    public static int getType(String string) {
        if ("subject".equals(string)) {
            return 2;
        }
        if ("keywords".equals(string)) {
            return 3;
        }
        if ("author".equals(string)) {
            return 4;
        }
        if ("title".equals(string)) {
            return 1;
        }
        if ("producer".equals(string)) {
            return 5;
        }
        if ("creationdate".equals(string)) {
            return 6;
        }
        return 0;
    }

    @Override
    public void setMarkupAttribute(String string, String string2) {
        if (this.markupAttributes == null) {
            this.markupAttributes = new Properties();
        }
        this.markupAttributes.put(string, string2);
    }

    @Override
    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    @Override
    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    @Override
    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    @Override
    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

