/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.markup.MarkupParser;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Chunk
implements Element,
MarkupAttributes {
    public static final String OBJECT_REPLACEMENT_CHARACTER = "\ufffc";
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final Chunk NEXTPAGE = new Chunk("");
    public static final String SUBSUPSCRIPT = "SUBSUPSCRIPT";
    public static final String UNDERLINE = "UNDERLINE";
    public static final String COLOR = "COLOR";
    public static final String ENCODING = "ENCODING";
    public static final String REMOTEGOTO = "REMOTEGOTO";
    public static final String LOCALGOTO = "LOCALGOTO";
    public static final String LOCALDESTINATION = "LOCALDESTINATION";
    public static final String IMAGE = "IMAGE";
    public static final String GENERICTAG = "GENERICTAG";
    public static final String NEWPAGE = "NEWPAGE";
    public static final String SPLITCHARACTER = "SPLITCHARACTER";
    public static final String ACTION = "ACTION";
    public static final String BACKGROUND = "BACKGROUND";
    public static final String PDFANNOTATION = "PDFANNOTATION";
    public static final String HYPHENATION = "HYPHENATION";
    public static final String TEXTRENDERMODE = "TEXTRENDERMODE";
    public static final String SKEW = "SKEW";
    public static final String HSCALE = "HSCALE";
    protected StringBuffer content = null;
    protected Font font = null;
    protected HashMap attributes = null;
    protected Properties markupAttributes = null;

    protected Chunk() {
    }

    public Chunk(Chunk chunk) {
        if (chunk.content != null) {
            this.content = new StringBuffer(chunk.content.toString());
        }
        if (chunk.font != null) {
            this.font = new Font(chunk.font);
        }
        if (chunk.attributes != null) {
            this.attributes = new HashMap(chunk.attributes);
        }
        if (chunk.markupAttributes != null) {
            this.markupAttributes = new Properties();
            this.markupAttributes.putAll((Map<?, ?>)chunk.markupAttributes);
        }
    }

    public Chunk(String string, Font font) {
        this.content = new StringBuffer(string);
        this.font = font;
    }

    public Chunk(String string) {
        this(string, new Font());
    }

    public Chunk(char c, Font font) {
        this.content = new StringBuffer();
        this.content.append(c);
        this.font = font;
    }

    public Chunk(char c) {
        this(c, new Font());
    }

    public Chunk(Image image, float f, float f2) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        Image image2 = Image.getInstance(image);
        image2.setAbsolutePosition(Float.NaN, Float.NaN);
        this.setAttribute(IMAGE, new Object[]{image2, new Float(f), new Float(f2), new Boolean(false)});
    }

    public Chunk(Image image, float f, float f2, boolean bl) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        this.setAttribute(IMAGE, new Object[]{image, new Float(f), new Float(f2), new Boolean(bl)});
    }

    public Chunk(Properties properties) {
        this("", FontFactory.getFont(properties));
        String string = (String)properties.remove("itext");
        if (string != null) {
            this.append(string);
        }
        if ((string = (String)properties.remove(ElementTags.LOCALGOTO)) != null) {
            this.setLocalGoto(string);
        }
        if ((string = (String)properties.remove(ElementTags.REMOTEGOTO)) != null) {
            String string2 = (String)properties.remove(ElementTags.DESTINATION);
            String string3 = (String)properties.remove(ElementTags.PAGE);
            if (string3 != null) {
                this.setRemoteGoto(string, Integer.parseInt(string3));
            } else if (string2 != null) {
                this.setRemoteGoto(string, string2);
            }
        }
        if ((string = (String)properties.remove(ElementTags.LOCALDESTINATION)) != null) {
            this.setLocalDestination(string);
        }
        if ((string = (String)properties.remove(ElementTags.SUBSUPSCRIPT)) != null) {
            this.setTextRise(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("vertical-align")) != null && string.endsWith("%")) {
            float f = Float.valueOf(string.substring(0, string.length() - 1) + "f").floatValue() / 100.0f;
            this.setTextRise(f * this.font.size());
        }
        if ((string = (String)properties.remove(ElementTags.GENERICTAG)) != null) {
            this.setGenericTag(string);
        }
        if ((string = (String)properties.remove("backgroundcolor")) != null) {
            this.setBackground(MarkupParser.decodeColor(string));
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 10;
    }

    @Override
    public ArrayList getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        arrayList.add(this);
        return arrayList;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public Font font() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String content() {
        return this.content.toString();
    }

    @Override
    public String toString() {
        return this.content.toString();
    }

    public boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && this.content.toString().indexOf("\n") == -1 && this.attributes == null;
    }

    public float getWidthPoint() {
        if (this.getImage() != null) {
            return this.getImage().scaledWidth();
        }
        return this.font.getCalculatedBaseFont(true).getWidthPoint(this.content(), this.font.getCalculatedSize()) * this.getHorizontalScaling();
    }

    public Chunk setTextRise(float f) {
        return this.setAttribute(SUBSUPSCRIPT, new Float(f));
    }

    public float getTextRise() {
        if (this.attributes.containsKey(SUBSUPSCRIPT)) {
            Float f = (Float)this.attributes.get(SUBSUPSCRIPT);
            return f.floatValue();
        }
        return 0.0f;
    }

    public Chunk setTextRenderMode(int n, float f, Color color) {
        return this.setAttribute(TEXTRENDERMODE, new Object[]{new Integer(n), new Float(f), color});
    }

    public Chunk setSkew(float f, float f2) {
        f = (float)Math.tan((double)f * Math.PI / 180.0);
        f2 = (float)Math.tan((double)f2 * Math.PI / 180.0);
        return this.setAttribute(SKEW, new float[]{f, f2});
    }

    public Chunk setHorizontalScaling(float f) {
        return this.setAttribute(HSCALE, new Float(f));
    }

    public float getHorizontalScaling() {
        if (this.attributes == null) {
            return 1.0f;
        }
        Float f = (Float)this.attributes.get(HSCALE);
        if (f == null) {
            return 1.0f;
        }
        return f.floatValue();
    }

    public Chunk setAction(PdfAction pdfAction) {
        return this.setAttribute(ACTION, pdfAction);
    }

    public Chunk setAnchor(URL uRL) {
        return this.setAttribute(ACTION, new PdfAction(uRL.toExternalForm()));
    }

    public Chunk setAnchor(String string) {
        return this.setAttribute(ACTION, new PdfAction(string));
    }

    public Chunk setLocalGoto(String string) {
        return this.setAttribute(LOCALGOTO, string);
    }

    public Chunk setBackground(Color color) {
        return this.setBackground(color, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Chunk setBackground(Color color, float f, float f2, float f3, float f4) {
        return this.setAttribute(BACKGROUND, new Object[]{color, new float[]{f, f2, f3, f4}});
    }

    public Chunk setUnderline(float f, float f2) {
        return this.setUnderline(null, f, 0.0f, f2, 0.0f, 0);
    }

    public Chunk setUnderline(Color color, float f, float f2, float f3, float f4, int n) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        Object[] objectArray = new Object[]{color, new float[]{f, f2, f3, f4, n}};
        Object[][] objectArray2 = Chunk.addToArray((Object[][])this.attributes.get(UNDERLINE), objectArray);
        return this.setAttribute(UNDERLINE, objectArray2);
    }

    public static Object[][] addToArray(Object[][] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            objectArray = new Object[][]{objectArray2};
            return objectArray;
        }
        Object[][] objectArray3 = new Object[objectArray.length + 1][];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        objectArray3[objectArray.length] = objectArray2;
        return objectArray3;
    }

    public Chunk setAnnotation(PdfAnnotation pdfAnnotation) {
        return this.setAttribute(PDFANNOTATION, pdfAnnotation);
    }

    public Chunk setHyphenation(HyphenationEvent hyphenationEvent) {
        return this.setAttribute(HYPHENATION, hyphenationEvent);
    }

    public Chunk setRemoteGoto(String string, String string2) {
        return this.setAttribute(REMOTEGOTO, new Object[]{string, string2});
    }

    public Chunk setRemoteGoto(String string, int n) {
        return this.setAttribute(REMOTEGOTO, new Object[]{string, new Integer(n)});
    }

    public Chunk setLocalDestination(String string) {
        return this.setAttribute(LOCALDESTINATION, string);
    }

    public Chunk setGenericTag(String string) {
        return this.setAttribute(GENERICTAG, string);
    }

    public Chunk setSplitCharacter(SplitCharacter splitCharacter) {
        return this.setAttribute(SPLITCHARACTER, splitCharacter);
    }

    public Chunk setNewPage() {
        return this.setAttribute(NEWPAGE, null);
    }

    private Chunk setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, object);
        return this;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public Image getImage() {
        if (this.attributes == null) {
            return null;
        }
        Object[] objectArray = (Object[])this.attributes.get(IMAGE);
        if (objectArray == null) {
            return null;
        }
        return (Image)objectArray[0];
    }

    public static boolean isTag(String string) {
        return "chunk".equals(string);
    }

    @Override
    public void setMarkupAttribute(String string, String string2) {
        if (this.markupAttributes == null) {
            this.markupAttributes = new Properties();
        }
        this.markupAttributes.put(string, string2);
    }

    @Override
    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    @Override
    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    @Override
    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    @Override
    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public static Set getKeySet(Hashtable hashtable) {
        return hashtable == null ? Collections.EMPTY_SET : hashtable.keySet();
    }

    static {
        NEXTPAGE.setNewPage();
    }
}

