/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1EncodableVector;
import com.lowagie.bc.asn1.BERConstructedOctetString;
import com.lowagie.bc.asn1.BERNull;
import com.lowagie.bc.asn1.BERSequence;
import com.lowagie.bc.asn1.BERSet;
import com.lowagie.bc.asn1.BERTaggedObject;
import com.lowagie.bc.asn1.DERApplicationSpecific;
import com.lowagie.bc.asn1.DERBMPString;
import com.lowagie.bc.asn1.DERBitString;
import com.lowagie.bc.asn1.DERBoolean;
import com.lowagie.bc.asn1.DEREnumerated;
import com.lowagie.bc.asn1.DERGeneralString;
import com.lowagie.bc.asn1.DERGeneralizedTime;
import com.lowagie.bc.asn1.DERIA5String;
import com.lowagie.bc.asn1.DERInputStream;
import com.lowagie.bc.asn1.DERInteger;
import com.lowagie.bc.asn1.DERNull;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DERObjectIdentifier;
import com.lowagie.bc.asn1.DEROctetString;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERPrintableString;
import com.lowagie.bc.asn1.DERSequence;
import com.lowagie.bc.asn1.DERSet;
import com.lowagie.bc.asn1.DERT61String;
import com.lowagie.bc.asn1.DERTaggedObject;
import com.lowagie.bc.asn1.DERUTCTime;
import com.lowagie.bc.asn1.DERUTF8String;
import com.lowagie.bc.asn1.DERUniversalString;
import com.lowagie.bc.asn1.DERUnknownTag;
import com.lowagie.bc.asn1.DERVisibleString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ASN1InputStream
extends DERInputStream {
    private DERObject END_OF_STREAM = new DERObject(){

        @Override
        void encode(DEROutputStream dEROutputStream) throws IOException {
            throw new IOException("Eeek!");
        }
    };
    boolean eofFound = false;

    public ASN1InputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    protected int readLength() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2 = n & 0x7F;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.read();
                if (n3 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n = (n << 8) + n3;
            }
        }
        return n;
    }

    @Override
    protected void readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            return;
        }
        while ((n = this.read(byArray, byArray.length - n2, n2)) > 0) {
            if ((n2 -= n) != 0) continue;
            return;
        }
        if (n2 != 0) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    @Override
    protected DERObject buildObject(int n, byte[] byArray) throws IOException {
        if ((n & 0x40) != 0) {
            return new DERApplicationSpecific(n, byArray);
        }
        switch (n) {
            case 5: {
                return new DERNull();
            }
            case 48: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                DERObject dERObject = aSN1InputStream.readObject();
                while (dERObject != null) {
                    aSN1EncodableVector.add(dERObject);
                    dERObject = aSN1InputStream.readObject();
                }
                return new DERSequence(aSN1EncodableVector);
            }
            case 49: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                DERObject dERObject = aSN1InputStream.readObject();
                while (dERObject != null) {
                    aSN1EncodableVector.add(dERObject);
                    dERObject = aSN1InputStream.readObject();
                }
                return new DERSet(aSN1EncodableVector);
            }
            case 1: {
                return new DERBoolean(byArray);
            }
            case 2: {
                return new DERInteger(byArray);
            }
            case 10: {
                return new DEREnumerated(byArray);
            }
            case 6: {
                return new DERObjectIdentifier(byArray);
            }
            case 3: {
                byte by = byArray[0];
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
                return new DERBitString(byArray2, (int)by);
            }
            case 12: {
                return new DERUTF8String(byArray);
            }
            case 19: {
                return new DERPrintableString(byArray);
            }
            case 22: {
                return new DERIA5String(byArray);
            }
            case 20: {
                return new DERT61String(byArray);
            }
            case 26: {
                return new DERVisibleString(byArray);
            }
            case 27: {
                return new DERGeneralString(byArray);
            }
            case 28: {
                return new DERUniversalString(byArray);
            }
            case 30: {
                return new DERBMPString(byArray);
            }
            case 4: {
                return new DEROctetString(byArray);
            }
            case 23: {
                return new DERUTCTime(byArray);
            }
            case 24: {
                return new DERGeneralizedTime(byArray);
            }
        }
        if ((n & 0x80) != 0) {
            int n2 = n & 0x1F;
            if (n2 == 31) {
                int n3 = 0;
                n2 = 0;
                while ((byArray[n3] & 0x80) != 0) {
                    n2 |= byArray[n3++] & 0x7F;
                    n2 <<= 7;
                }
                n2 |= byArray[n3] & 0x7F;
                byte[] byArray3 = byArray;
                byArray = new byte[byArray3.length - (n3 + 1)];
                System.arraycopy(byArray3, n3 + 1, byArray, 0, byArray.length);
            }
            if (byArray.length == 0) {
                if ((n & 0x20) == 0) {
                    return new DERTaggedObject(false, n2, new DERNull());
                }
                return new DERTaggedObject(false, n2, new DERSequence());
            }
            if ((n & 0x20) == 0) {
                return new DERTaggedObject(false, n2, new DEROctetString(byArray));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            DERObject dERObject = aSN1InputStream.readObject();
            if (aSN1InputStream.available() == 0) {
                return new DERTaggedObject(n2, dERObject);
            }
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            while (dERObject != null) {
                aSN1EncodableVector.add(dERObject);
                dERObject = aSN1InputStream.readObject();
            }
            return new DERTaggedObject(false, n2, new DERSequence(aSN1EncodableVector));
        }
        return new DERUnknownTag(n, byArray);
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = this.read();
        while ((n = this.read()) >= 0 && (n2 != 0 || n != 0)) {
            byteArrayOutputStream.write(n2);
            n2 = n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString() throws IOException {
        DERObject dERObject;
        Vector<DERObject> vector = new Vector<DERObject>();
        while ((dERObject = this.readObject()) != this.END_OF_STREAM) {
            vector.addElement(dERObject);
        }
        return new BERConstructedOctetString(vector);
    }

    @Override
    public DERObject readObject() throws IOException {
        int n = this.read();
        if (n == -1) {
            if (this.eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this.eofFound = true;
            return null;
        }
        int n2 = this.readLength();
        if (n2 < 0) {
            switch (n) {
                case 5: {
                    return new BERNull();
                }
                case 48: {
                    DERObject dERObject;
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    while ((dERObject = this.readObject()) != this.END_OF_STREAM) {
                        aSN1EncodableVector.add(dERObject);
                    }
                    return new BERSequence(aSN1EncodableVector);
                }
                case 49: {
                    DERObject dERObject;
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    while ((dERObject = this.readObject()) != this.END_OF_STREAM) {
                        aSN1EncodableVector.add(dERObject);
                    }
                    return new BERSet(aSN1EncodableVector);
                }
                case 36: {
                    return this.buildConstructedOctetString();
                }
            }
            if ((n & 0x80) != 0) {
                int n3 = n & 0x1F;
                if (n3 == 31) {
                    int n4 = this.read();
                    n3 = 0;
                    while (n4 >= 0 && (n4 & 0x80) != 0) {
                        n3 |= n4 & 0x7F;
                        n3 <<= 7;
                        n4 = this.read();
                    }
                    n3 |= n4 & 0x7F;
                }
                if ((n & 0x20) == 0) {
                    byte[] byArray = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, n3, new DEROctetString(byArray));
                }
                DERObject dERObject = this.readObject();
                if (dERObject == this.END_OF_STREAM) {
                    return new DERTaggedObject(n3);
                }
                DERObject dERObject2 = this.readObject();
                if (dERObject2 == this.END_OF_STREAM) {
                    return new BERTaggedObject(n3, dERObject);
                }
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(dERObject);
                do {
                    aSN1EncodableVector.add(dERObject2);
                } while ((dERObject2 = this.readObject()) != this.END_OF_STREAM);
                return new BERTaggedObject(false, n3, new BERSequence(aSN1EncodableVector));
            }
            throw new IOException("unknown BER object encountered");
        }
        if (n == 0 && n2 == 0) {
            return this.END_OF_STREAM;
        }
        byte[] byArray = new byte[n2];
        this.readFully(byArray);
        return this.buildObject(n, byArray);
    }
}

