/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.v07;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;

public class TGInputStream
implements TGInputStreamBase {
    private static final String TG_VERSION = "TG_DEVEL-0.01";
    private DataInputStream dataInputStream;
    private TGFactory factory;
    private String version;

    public void init(TGFactory tGFactory, InputStream inputStream) {
        this.factory = tGFactory;
        this.dataInputStream = new DataInputStream(inputStream);
        this.version = null;
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("TuxGuitar", "*.tg");
    }

    public boolean isSupportedVersion(String string) {
        return string.equals(TG_VERSION);
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.version);
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
    }

    private void readVersion() {
        if (this.version == null) {
            this.version = this.readString();
        }
    }

    public TGSong readSong() throws TGFileFormatException {
        try {
            if (this.isSupportedVersion()) {
                TGSong tGSong = this.read();
                this.dataInputStream.close();
                return tGSong;
            }
            throw new TGFileFormatException("Unsopported Version");
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private TGSong read() {
        TGSong tGSong = this.factory.newSong();
        tGSong.setName(this.readString());
        tGSong.setArtist(this.readString());
        tGSong.setAlbum(this.readString());
        tGSong.setAuthor(this.readString());
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            tGSong.addTrack(this.readTrack(tGSong));
        }
        return tGSong;
    }

    private TGTrack readTrack(TGSong tGSong) {
        int n;
        TGTrack tGTrack = this.factory.newTrack();
        tGTrack.setNumber((int)this.readLong());
        tGTrack.setName(this.readString());
        this.readChannel(tGTrack.getChannel());
        int n2 = this.readInt();
        if (tGSong.countMeasureHeaders() == 0) {
            for (n = 0; n < n2; ++n) {
                TGMeasureHeader tGMeasureHeader = this.factory.newHeader();
                tGSong.addMeasureHeader(tGMeasureHeader);
            }
        }
        for (n = 0; n < n2; ++n) {
            tGTrack.addMeasure(this.readMeasure(tGSong.getMeasureHeader(n)));
        }
        n = this.readInt();
        for (int i = 0; i < n; ++i) {
            tGTrack.getStrings().add(this.readInstrumentString());
        }
        this.readColor(tGTrack.getColor());
        return tGTrack;
    }

    private TGMeasure readMeasure(TGMeasureHeader tGMeasureHeader) {
        int n;
        TGMeasure tGMeasure = this.factory.newMeasure(tGMeasureHeader);
        tGMeasureHeader.setNumber(this.readInt());
        tGMeasureHeader.setStart(960L * this.readLong() / 1000L);
        int n2 = this.readInt();
        TGBeat tGBeat = null;
        for (n = 0; n < n2; ++n) {
            tGBeat = this.readNote(tGMeasure, tGBeat);
        }
        n = this.readInt();
        tGBeat = null;
        for (int i = 0; i < n; ++i) {
            tGBeat = this.readSilence(tGMeasure, tGBeat);
        }
        this.readTimeSignature(tGMeasureHeader.getTimeSignature());
        this.readTempo(tGMeasureHeader.getTempo());
        tGMeasure.setClef(this.readInt());
        tGMeasure.setKeySignature(this.readInt());
        tGMeasureHeader.setRepeatOpen(this.readBoolean());
        tGMeasureHeader.setRepeatClose(this.readInt());
        return tGMeasure;
    }

    private TGBeat readNote(TGMeasure tGMeasure, TGBeat tGBeat) {
        TGBeat tGBeat2 = tGBeat;
        int n = this.readInt();
        long l = 960L * this.readLong() / 1000L;
        if (tGBeat2 == null || tGBeat2.getStart() != l) {
            tGBeat2 = this.factory.newBeat();
            tGBeat2.setStart(l);
            tGMeasure.addBeat(tGBeat2);
        }
        this.readDuration(tGBeat2.getDuration());
        TGNote tGNote = this.factory.newNote();
        tGNote.setValue(n);
        tGNote.setVelocity(this.readInt());
        tGNote.setString(this.readInt());
        tGNote.setTiedNote(this.readBoolean());
        this.readNoteEffect(tGNote.getEffect());
        tGBeat2.addNote(tGNote);
        return tGBeat2;
    }

    private void readChannel(TGChannel tGChannel) {
        tGChannel.setChannel(this.readShort());
        tGChannel.setEffectChannel(this.readShort());
        tGChannel.setInstrument(this.readShort());
        tGChannel.setVolume(this.readShort());
        tGChannel.setBalance(this.readShort());
        tGChannel.setChorus(this.readShort());
        tGChannel.setReverb(this.readShort());
        tGChannel.setPhaser(this.readShort());
        tGChannel.setTremolo(this.readShort());
        tGChannel.setSolo(this.readBoolean());
        tGChannel.setMute(this.readBoolean());
    }

    private TGBeat readSilence(TGMeasure tGMeasure, TGBeat tGBeat) {
        TGBeat tGBeat2 = tGBeat;
        long l = 960L * this.readLong() / 1000L;
        if (tGBeat2 == null || tGBeat2.getStart() != l) {
            tGBeat2 = this.factory.newBeat();
            tGBeat2.setStart(l);
            tGMeasure.addBeat(tGBeat2);
        }
        this.readDuration(tGBeat2.getDuration());
        return tGBeat2;
    }

    private TGString readInstrumentString() {
        TGString tGString = this.factory.newString();
        tGString.setNumber(this.readInt());
        tGString.setValue(this.readInt());
        return tGString;
    }

    private void readTempo(TGTempo tGTempo) {
        tGTempo.setValue(this.readInt());
    }

    private void readTimeSignature(TGTimeSignature tGTimeSignature) {
        tGTimeSignature.setNumerator(this.readInt());
        this.readDuration(tGTimeSignature.getDenominator());
    }

    private void readDuration(TGDuration tGDuration) {
        tGDuration.setValue(this.readInt());
        tGDuration.setDotted(this.readBoolean());
        tGDuration.setDoubleDotted(this.readBoolean());
        this.readTupleto(tGDuration.getTupleto());
    }

    private void readTupleto(TGTupleto tGTupleto) {
        tGTupleto.setEnters(this.readInt());
        tGTupleto.setTimes(this.readInt());
    }

    private void readNoteEffect(TGNoteEffect tGNoteEffect) {
        tGNoteEffect.setVibrato(this.readBoolean());
        if (this.readBoolean()) {
            tGNoteEffect.setBend(this.readBendEffect());
        }
        tGNoteEffect.setDeadNote(this.readBoolean());
        tGNoteEffect.setSlide(this.readBoolean());
        tGNoteEffect.setHammer(this.readBoolean());
    }

    private TGEffectBend readBendEffect() {
        TGEffectBend tGEffectBend = this.factory.newEffectBend();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readInt();
            int n3 = this.readInt();
            tGEffectBend.addPoint(n2, n3 > 0 ? n3 / 2 : n3);
        }
        return tGEffectBend;
    }

    private void readColor(TGColor tGColor) {
        tGColor.setR(this.readInt());
        tGColor.setG(this.readInt());
        tGColor.setB(this.readInt());
    }

    private short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int readInt() {
        try {
            return this.dataInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private long readLong() {
        try {
            return this.dataInputStream.readLong();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0L;
        }
    }

    private String readString() {
        try {
            int n = this.dataInputStream.read();
            char[] cArray = new char[n];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(cArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private boolean readBoolean() {
        try {
            return this.dataInputStream.readBoolean();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }
}

