/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.gtp.GTPFormatException;
import org.herac.tuxguitar.io.gtp.GTPInputStream;
import org.herac.tuxguitar.io.gtp.JoinVoicesHelper;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class GP5InputStream
extends GTPInputStream
implements TGInputStreamBase {
    private static final String[] supportedVersions = new String[]{"FICHIER GUITAR PRO v5.00", "FICHIER GUITAR PRO v5.10"};
    private static final int GP_BEND_SEMITONE = 25;
    private static final int GP_BEND_POSITION = 60;

    public GP5InputStream() {
        super(supportedVersions);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Guitar Pro 5", "*.gp5");
    }

    public TGSong readSong() throws IOException, GTPFormatException {
        this.readVersion();
        if (!this.isSupportedVersion(this.getVersion())) {
            throw new GTPFormatException("Unsuported Version");
        }
        TGSong tGSong = this.getFactory().newSong();
        this.readInfo(tGSong);
        int n = this.readInt();
        TGLyric tGLyric = this.readLyrics();
        this.readPageSetup();
        int n2 = this.readInt();
        if (this.getVersionIndex() > 0) {
            this.skip(1);
        }
        this.readInt();
        this.readByte();
        List list = this.readChannels();
        this.skip(42);
        int n3 = this.readInt();
        int n4 = this.readInt();
        this.readMeasureHeaders(tGSong, n3);
        this.readTracks(tGSong, n4, list, tGLyric, n);
        this.readMeasures(tGSong, n3, n4, n2);
        return tGSong;
    }

    private void readInfo(TGSong tGSong) throws IOException {
        tGSong.setName(this.readStringByteSizeOfInteger());
        this.readStringByteSizeOfInteger();
        tGSong.setArtist(this.readStringByteSizeOfInteger());
        tGSong.setAlbum(this.readStringByteSizeOfInteger());
        tGSong.setAuthor(this.readStringByteSizeOfInteger());
        this.readStringByteSizeOfInteger();
        this.readStringByteSizeOfInteger();
        this.readStringByteSizeOfInteger();
        this.readStringByteSizeOfInteger();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            this.readStringByteSizeOfInteger();
        }
    }

    private void readPageSetup() throws IOException {
        this.skip(this.getVersionIndex() > 0 ? 49 : 30);
        for (int i = 0; i < 11; ++i) {
            this.skip(4);
            this.readStringByte(0);
        }
    }

    private void readMeasureHeaders(TGSong tGSong, int n) throws IOException {
        TGTimeSignature tGTimeSignature = this.getFactory().newTimeSignature();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.skip(1);
            }
            tGSong.addMeasureHeader(this.readMeasureHeader(i, tGTimeSignature));
        }
    }

    private void readTracks(TGSong tGSong, int n, List list, TGLyric tGLyric, int n2) throws IOException {
        for (int i = 1; i <= n; ++i) {
            tGSong.addTrack(this.readTrack(i, list, i == n2 ? tGLyric : this.getFactory().newLyric()));
        }
        this.skip(this.getVersionIndex() == 0 ? 2 : 1);
    }

    private void readMeasures(TGSong tGSong, int n, int n2, int n3) throws IOException {
        TGTempo tGTempo = this.getFactory().newTempo();
        tGTempo.setValue(n3);
        long l = 960L;
        for (int i = 0; i < n; ++i) {
            TGMeasureHeader tGMeasureHeader = tGSong.getMeasureHeader(i);
            tGMeasureHeader.setStart(l);
            for (int j = 0; j < n2; ++j) {
                TGTrack tGTrack = tGSong.getTrack(j);
                TGMeasure tGMeasure = this.getFactory().newMeasure(tGMeasureHeader);
                tGTrack.addMeasure(tGMeasure);
                this.readMeasure(tGMeasure, tGTrack, tGTempo);
                this.skip(1);
            }
            tGTempo.copy(tGMeasureHeader.getTempo());
            l += tGMeasureHeader.getLength();
        }
    }

    private TGLyric readLyrics() throws IOException {
        TGLyric tGLyric = this.getFactory().newLyric();
        tGLyric.setFrom(this.readInt());
        tGLyric.setLyrics(this.readStringInteger());
        for (int i = 0; i < 4; ++i) {
            this.readInt();
            this.readStringInteger();
        }
        return tGLyric;
    }

    private long readBeat(long l, TGMeasure tGMeasure, TGTrack tGTrack, TGTempo tGTempo) throws IOException {
        int n;
        int n2 = this.readUnsignedByte();
        if ((n2 & 0x40) != 0) {
            this.readUnsignedByte();
        }
        TGBeat tGBeat = this.getFactory().newBeat();
        TGDuration tGDuration = this.readDuration(n2);
        TGNoteEffect tGNoteEffect = this.getFactory().newEffect();
        if ((n2 & 2) != 0) {
            this.readChord(tGTrack.stringCount(), tGBeat);
        }
        if ((n2 & 4) != 0) {
            this.readText(tGBeat);
        }
        if ((n2 & 8) != 0) {
            this.readBeatEffects(tGNoteEffect);
        }
        if ((n2 & 0x10) != 0) {
            this.readMixChange(tGTempo);
        }
        int n3 = this.readUnsignedByte();
        for (n = 6; n >= 0; --n) {
            if ((n3 & 1 << n) == 0 || 6 - n >= tGTrack.stringCount()) continue;
            TGString tGString = tGTrack.getString(6 - n + 1).clone(this.getFactory());
            TGNote tGNote = this.readNote(tGString, tGTrack, tGNoteEffect.clone(this.getFactory()));
            tGBeat.addNote(tGNote);
        }
        this.skip(1);
        n = this.readByte();
        if (n == 8 || n == 10) {
            this.skip(1);
        }
        tGBeat.setStart(l);
        tGDuration.copy(tGBeat.getDuration());
        tGMeasure.addBeat(tGBeat);
        return tGDuration.getTime();
    }

    private List readChannels() throws IOException {
        ArrayList<TGChannel> arrayList = new ArrayList<TGChannel>();
        for (int i = 0; i < 64; ++i) {
            TGChannel tGChannel = this.getFactory().newChannel();
            tGChannel.setChannel((short)i);
            tGChannel.setEffectChannel((short)i);
            tGChannel.setInstrument((short)this.readInt());
            tGChannel.setVolume(this.toChannelShort(this.readByte()));
            tGChannel.setBalance(this.toChannelShort(this.readByte()));
            tGChannel.setChorus(this.toChannelShort(this.readByte()));
            tGChannel.setReverb(this.toChannelShort(this.readByte()));
            tGChannel.setPhaser(this.toChannelShort(this.readByte()));
            tGChannel.setTremolo(this.toChannelShort(this.readByte()));
            tGChannel.setSolo(false);
            tGChannel.setMute(false);
            arrayList.add(tGChannel);
            this.skip(2);
        }
        return arrayList;
    }

    private void readText(TGBeat tGBeat) throws IOException {
        TGText tGText = this.getFactory().newText();
        tGText.setValue(this.readStringByteSizeOfInteger());
        tGBeat.setText(tGText);
    }

    private TGDuration readDuration(int n) throws IOException {
        TGDuration tGDuration = this.getFactory().newDuration();
        tGDuration.setValue((int)(Math.pow(2.0, this.readByte() + 4) / 4.0));
        tGDuration.setDotted((n & 1) != 0);
        if ((n & 0x20) != 0) {
            int n2 = this.readInt();
            switch (n2) {
                case 3: {
                    tGDuration.getTupleto().setEnters(3);
                    tGDuration.getTupleto().setTimes(2);
                    break;
                }
                case 5: {
                    tGDuration.getTupleto().setEnters(5);
                    tGDuration.getTupleto().setTimes(4);
                    break;
                }
                case 6: {
                    tGDuration.getTupleto().setEnters(6);
                    tGDuration.getTupleto().setTimes(4);
                    break;
                }
                case 7: {
                    tGDuration.getTupleto().setEnters(7);
                    tGDuration.getTupleto().setTimes(4);
                    break;
                }
                case 9: {
                    tGDuration.getTupleto().setEnters(9);
                    tGDuration.getTupleto().setTimes(8);
                    break;
                }
                case 10: {
                    tGDuration.getTupleto().setEnters(10);
                    tGDuration.getTupleto().setTimes(8);
                    break;
                }
                case 11: {
                    tGDuration.getTupleto().setEnters(11);
                    tGDuration.getTupleto().setTimes(8);
                    break;
                }
                case 12: {
                    tGDuration.getTupleto().setEnters(12);
                    tGDuration.getTupleto().setTimes(8);
                }
            }
        }
        return tGDuration;
    }

    private int getTiedNoteValue(int n, TGTrack tGTrack) {
        int n2 = tGTrack.countMeasures();
        if (n2 > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                TGMeasure tGMeasure = tGTrack.getMeasure(i);
                for (int j = tGMeasure.countBeats() - 1; j >= 0; --j) {
                    TGBeat tGBeat = tGMeasure.getBeat(j);
                    for (int k = 0; k < tGBeat.countNotes(); ++k) {
                        TGNote tGNote = tGBeat.getNote(k);
                        if (tGNote.getString() != n) continue;
                        return tGNote.getValue();
                    }
                }
            }
        }
        return -1;
    }

    private void readColor(TGColor tGColor) throws IOException {
        tGColor.setR(this.readUnsignedByte());
        tGColor.setG(this.readUnsignedByte());
        tGColor.setB(this.readUnsignedByte());
        this.skip(1);
    }

    private TGMarker readMarker(int n) throws IOException {
        TGMarker tGMarker = this.getFactory().newMarker();
        tGMarker.setMeasure(n);
        tGMarker.setTitle(this.readStringByteSizeOfInteger());
        this.readColor(tGMarker.getColor());
        return tGMarker;
    }

    private TGMeasureHeader readMeasureHeader(int n, TGTimeSignature tGTimeSignature) throws IOException {
        byte by;
        int n2 = this.readUnsignedByte();
        TGMeasureHeader tGMeasureHeader = this.getFactory().newHeader();
        tGMeasureHeader.setNumber(n + 1);
        tGMeasureHeader.setStart(0L);
        tGMeasureHeader.getTempo().setValue(120);
        tGMeasureHeader.setRepeatOpen((n2 & 4) != 0);
        if ((n2 & 1) != 0) {
            tGTimeSignature.setNumerator((int)this.readByte());
        }
        if ((n2 & 2) != 0) {
            tGTimeSignature.getDenominator().setValue((int)this.readByte());
        }
        tGTimeSignature.copy(tGMeasureHeader.getTimeSignature());
        if ((n2 & 8) != 0) {
            tGMeasureHeader.setRepeatClose((this.readByte() & 0xFF) - 1);
        }
        if ((n2 & 0x20) != 0) {
            tGMeasureHeader.setMarker(this.readMarker(tGMeasureHeader.getNumber()));
        }
        if ((n2 & 0x10) != 0) {
            tGMeasureHeader.setRepeatAlternative(this.readUnsignedByte());
        }
        if ((n2 & 0x40) != 0) {
            this.readByte();
            this.readByte();
        }
        if ((n2 & 0x10) == 0) {
            this.skip(1);
        }
        if ((n2 & 1) != 0) {
            this.skip(4);
        }
        if ((by = this.readByte()) == 1) {
            tGMeasureHeader.setTripletFeel(2);
        } else if (by == 2) {
            tGMeasureHeader.setTripletFeel(3);
        } else {
            tGMeasureHeader.setTripletFeel(1);
        }
        return tGMeasureHeader;
    }

    private void readMeasure(TGMeasure tGMeasure, TGTrack tGTrack, TGTempo tGTempo) throws IOException {
        int n;
        long l = tGMeasure.getStart();
        int n2 = this.readInt();
        for (n = 0; n < n2; ++n) {
            l += this.readBeat(l, tGMeasure, tGTrack, tGTempo);
        }
        l = tGMeasure.getStart();
        n2 = this.readInt();
        for (n = 0; n < n2; ++n) {
            l += this.readBeat(l, tGMeasure, tGTrack, tGTempo);
        }
        new JoinVoicesHelper(this.getFactory(), tGMeasure).process();
    }

    private TGNote readNote(TGString tGString, TGTrack tGTrack, TGNoteEffect tGNoteEffect) throws IOException {
        int n;
        int n2 = this.readUnsignedByte();
        TGNote tGNote = this.getFactory().newNote();
        tGNote.setString(tGString.getNumber());
        tGNote.setEffect(tGNoteEffect);
        tGNote.getEffect().setAccentuatedNote((n2 & 0x40) != 0);
        tGNote.getEffect().setHeavyAccentuatedNote((n2 & 2) != 0);
        tGNote.getEffect().setGhostNote((n2 & 4) != 0);
        if ((n2 & 0x20) != 0) {
            n = this.readUnsignedByte();
            tGNote.setTiedNote(n == 2);
            tGNote.getEffect().setDeadNote(n == 3);
        }
        if ((n2 & 0x10) != 0) {
            tGNote.setVelocity(15 + 16 * this.readByte() - 16);
        }
        if ((n2 & 0x20) != 0) {
            n = this.readByte();
            int n3 = tGNote.isTiedNote() ? this.getTiedNoteValue(tGString.getNumber(), tGTrack) : n;
            tGNote.setValue(n3 >= 0 && n3 < 100 ? n3 : 0);
        }
        if ((n2 & 0x80) != 0) {
            this.skip(2);
        }
        if ((n2 & 1) != 0) {
            this.skip(8);
        }
        this.skip(1);
        if ((n2 & 8) != 0) {
            this.readNoteEffects(tGNote.getEffect());
        }
        return tGNote;
    }

    private TGTrack readTrack(int n, List list, TGLyric tGLyric) throws IOException {
        this.readUnsignedByte();
        if (n == 1 || this.getVersionIndex() == 0) {
            this.skip(1);
        }
        TGTrack tGTrack = this.getFactory().newTrack();
        tGTrack.setNumber(n);
        tGTrack.setLyrics(tGLyric);
        tGTrack.setName(this.readStringByte(40));
        int n2 = this.readInt();
        for (int i = 0; i < 7; ++i) {
            int n3 = this.readInt();
            if (n2 <= i) continue;
            TGString tGString = this.getFactory().newString();
            tGString.setNumber(i + 1);
            tGString.setValue(n3);
            tGTrack.getStrings().add(tGString);
        }
        this.readInt();
        this.readChannel(tGTrack.getChannel(), list);
        this.readInt();
        tGTrack.setOffset(this.readInt());
        this.readColor(tGTrack.getColor());
        this.skip(this.getVersionIndex() > 0 ? 49 : 44);
        if (this.getVersionIndex() > 0) {
            this.readStringByteSizeOfInteger();
            this.readStringByteSizeOfInteger();
        }
        return tGTrack;
    }

    private void readChannel(TGChannel tGChannel, List list) throws IOException {
        int n = this.readInt() - 1;
        int n2 = this.readInt() - 1;
        if (n >= 0 && n < list.size()) {
            ((TGChannel)list.get(n)).copy(tGChannel);
            if (tGChannel.getInstrument() < 0) {
                tGChannel.setInstrument((short)0);
            }
            if (!tGChannel.isPercussionChannel()) {
                tGChannel.setEffectChannel((short)n2);
            }
        }
    }

    private void readChord(int n, TGBeat tGBeat) throws IOException {
        TGChord tGChord = this.getFactory().newChord(n);
        this.skip(18);
        tGChord.setName(this.readString(21));
        this.skip(4);
        tGChord.setFirstFret(this.readInt());
        for (int i = 0; i < 7; ++i) {
            int n2 = this.readInt();
            if (i >= tGChord.countStrings()) continue;
            tGChord.addFretValue(i, n2);
        }
        this.skip(32);
        if (tGChord.countNotes() > 0) {
            tGBeat.setChord(tGChord);
        }
    }

    private void readGrace(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        TGEffectGrace tGEffectGrace = this.getFactory().newEffectGrace();
        tGEffectGrace.setDead(n == 255);
        tGEffectGrace.setFret(!tGEffectGrace.isDead() ? n : 0);
        tGEffectGrace.setDynamic(15 + 16 * this.readUnsignedByte() - 16);
        byte by = this.readByte();
        if (by == 0) {
            tGEffectGrace.setTransition(0);
        } else if (by == 1) {
            tGEffectGrace.setTransition(1);
        } else if (by == 2) {
            tGEffectGrace.setTransition(2);
        } else if (by == 3) {
            tGEffectGrace.setTransition(3);
        }
        tGEffectGrace.setDuration(this.readUnsignedByte());
        tGEffectGrace.setOnBeat(this.readByte() > 0);
        tGNoteEffect.setGrace(tGEffectGrace);
    }

    private void readBend(TGNoteEffect tGNoteEffect) throws IOException {
        this.skip(5);
        TGEffectBend tGEffectBend = this.getFactory().newEffectBend();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readInt();
            int n3 = this.readInt();
            this.readByte();
            tGEffectBend.addPoint(n2 * 12 / 60, n3 * 1 / 25);
        }
        if (!tGEffectBend.getPoints().isEmpty()) {
            tGNoteEffect.setBend(tGEffectBend);
        }
    }

    private void readTremoloBar(TGNoteEffect tGNoteEffect) throws IOException {
        this.skip(5);
        TGEffectTremoloBar tGEffectTremoloBar = this.getFactory().newEffectTremoloBar();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readInt();
            int n3 = this.readInt();
            this.readByte();
            tGEffectTremoloBar.addPoint(n2 * 12 / 60, n3 / 50);
        }
        if (!tGEffectTremoloBar.getPoints().isEmpty()) {
            tGNoteEffect.setTremoloBar(tGEffectTremoloBar);
        }
    }

    private void readNoteEffects(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        if ((n & 1) != 0) {
            this.readBend(tGNoteEffect);
        }
        if ((n & 0x10) != 0) {
            this.readGrace(tGNoteEffect);
        }
        if ((n2 & 4) != 0) {
            this.readTremoloPicking(tGNoteEffect);
        }
        if ((n2 & 8) != 0) {
            tGNoteEffect.setSlide(true);
            this.readByte();
        }
        if ((n2 & 0x10) != 0) {
            this.readArtificialHarmonic(tGNoteEffect);
        }
        if ((n2 & 0x20) != 0) {
            byte by = this.readByte();
            byte by2 = this.readByte();
            TGEffectTrill tGEffectTrill = this.getFactory().newEffectTrill();
            tGEffectTrill.setFret((int)by);
            if (by2 == 1) {
                tGEffectTrill.getDuration().setValue(16);
                tGNoteEffect.setTrill(tGEffectTrill);
            } else if (by2 == 2) {
                tGEffectTrill.getDuration().setValue(32);
                tGNoteEffect.setTrill(tGEffectTrill);
            } else if (by2 == 3) {
                tGEffectTrill.getDuration().setValue(64);
                tGNoteEffect.setTrill(tGEffectTrill);
            }
        }
        tGNoteEffect.setHammer((n & 2) != 0);
        tGNoteEffect.setVibrato((n2 & 0x40) != 0 || tGNoteEffect.isVibrato());
        tGNoteEffect.setPalmMute((n2 & 2) != 0);
        tGNoteEffect.setStaccato((n2 & 1) != 0);
    }

    private void readBeatEffects(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        tGNoteEffect.setFadeIn((n & 0x10) != 0);
        tGNoteEffect.setVibrato((n & 2) != 0);
        if ((n & 0x20) != 0) {
            int n3 = this.readUnsignedByte();
            tGNoteEffect.setTapping(n3 == 1);
            tGNoteEffect.setSlapping(n3 == 2);
            tGNoteEffect.setPopping(n3 == 3);
        }
        if ((n2 & 4) != 0) {
            this.readTremoloBar(tGNoteEffect);
        }
        if ((n & 0x40) != 0) {
            this.readByte();
            this.readByte();
        }
        if ((n2 & 2) != 0) {
            this.readByte();
        }
    }

    private void readMixChange(TGTempo tGTempo) throws IOException {
        this.readByte();
        this.skip(16);
        byte by = this.readByte();
        byte by2 = this.readByte();
        byte by3 = this.readByte();
        byte by4 = this.readByte();
        byte by5 = this.readByte();
        byte by6 = this.readByte();
        this.readStringByteSizeOfInteger();
        int n = this.readInt();
        if (by >= 0) {
            this.readByte();
        }
        if (by2 >= 0) {
            this.readByte();
        }
        if (by3 >= 0) {
            this.readByte();
        }
        if (by4 >= 0) {
            this.readByte();
        }
        if (by5 >= 0) {
            this.readByte();
        }
        if (by6 >= 0) {
            this.readByte();
        }
        if (n >= 0) {
            tGTempo.setValue(n);
            this.skip(1);
            if (this.getVersionIndex() > 0) {
                this.skip(1);
            }
        }
        this.readByte();
        this.skip(1);
        if (this.getVersionIndex() > 0) {
            this.readStringByteSizeOfInteger();
            this.readStringByteSizeOfInteger();
        }
    }

    private void readArtificialHarmonic(TGNoteEffect tGNoteEffect) throws IOException {
        byte by = this.readByte();
        TGEffectHarmonic tGEffectHarmonic = this.getFactory().newEffectHarmonic();
        tGEffectHarmonic.setData(0);
        if (by == 1) {
            tGEffectHarmonic.setType(1);
            tGNoteEffect.setHarmonic(tGEffectHarmonic);
        } else if (by == 2) {
            this.skip(3);
            tGEffectHarmonic.setType(2);
            tGNoteEffect.setHarmonic(tGEffectHarmonic);
        } else if (by == 3) {
            this.skip(1);
            tGEffectHarmonic.setType(3);
            tGNoteEffect.setHarmonic(tGEffectHarmonic);
        } else if (by == 4) {
            tGEffectHarmonic.setType(4);
            tGNoteEffect.setHarmonic(tGEffectHarmonic);
        } else if (by == 5) {
            tGEffectHarmonic.setType(5);
            tGNoteEffect.setHarmonic(tGEffectHarmonic);
        }
    }

    public void readTremoloPicking(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        TGEffectTremoloPicking tGEffectTremoloPicking = this.getFactory().newEffectTremoloPicking();
        if (n == 1) {
            tGEffectTremoloPicking.getDuration().setValue(8);
            tGNoteEffect.setTremoloPicking(tGEffectTremoloPicking);
        } else if (n == 2) {
            tGEffectTremoloPicking.getDuration().setValue(16);
            tGNoteEffect.setTremoloPicking(tGEffectTremoloPicking);
        } else if (n == 3) {
            tGEffectTremoloPicking.getDuration().setValue(32);
            tGNoteEffect.setTremoloPicking(tGEffectTremoloPicking);
        }
    }

    private short toChannelShort(byte by) {
        short s = (short)(by * 8 - 1);
        return (short)Math.max(s, 0);
    }
}

