/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.gtp.GTPFormatException;
import org.herac.tuxguitar.io.gtp.GTPInputStream;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;

public class GP2InputStream
extends GTPInputStream
implements TGInputStreamBase {
    private static final String[] SUPPORTED_VERSIONS = new String[]{"FICHIER GUITAR PRO v2.20", "FICHIER GUITAR PRO v2.21"};
    private static final int TRACK_COUNT = 8;
    private static final short[][] TRACK_CHANNELS = new short[][]{{0, 1}, {2, 3}, {4, 5}, {6, 7}, {8, 10}, {11, 12}, {13, 14}, {9, 9}};

    public GP2InputStream() {
        super(SUPPORTED_VERSIONS);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Guitar Pro 2", "*.gtp");
    }

    public TGSong readSong() throws GTPFormatException, IOException {
        TGMeasureHeader tGMeasureHeader;
        int n;
        int n2;
        this.readVersion();
        if (!this.isSupportedVersion(this.getVersion())) {
            throw new GTPFormatException("Unsuported Version");
        }
        TGSong tGSong = this.getFactory().newSong();
        this.readInfo(tGSong);
        int n3 = this.readInt();
        int n4 = this.readInt() == 1 ? 2 : 1;
        this.readInt();
        for (n2 = 0; n2 < 8; ++n2) {
            TGTrack tGTrack = this.getFactory().newTrack();
            tGTrack.setNumber(n2 + 1);
            tGTrack.getChannel().setChannel(TRACK_CHANNELS[n2][0]);
            tGTrack.getChannel().setEffectChannel(TRACK_CHANNELS[n2][1]);
            TGColor.RED.copy(tGTrack.getColor());
            int n5 = this.readInt();
            for (n = 0; n < n5; ++n) {
                tGMeasureHeader = this.getFactory().newString();
                tGMeasureHeader.setNumber(n + 1);
                tGMeasureHeader.setValue(this.readInt());
                tGTrack.getStrings().add(tGMeasureHeader);
            }
            tGSong.addTrack(tGTrack);
        }
        n2 = this.readInt();
        for (int i = 0; i < 8; ++i) {
            this.readTrack(tGSong.getTrack(i));
        }
        this.skip(10);
        TGMeasureHeader tGMeasureHeader2 = null;
        long[] lArray = new long[8];
        for (n = 0; n < n2; ++n) {
            tGMeasureHeader = this.getFactory().newHeader();
            tGMeasureHeader.setStart(tGMeasureHeader2 == null ? 960L : tGMeasureHeader2.getStart() + tGMeasureHeader2.getLength());
            tGMeasureHeader.setNumber(tGMeasureHeader2 == null ? 1 : tGMeasureHeader2.getNumber() + 1);
            tGMeasureHeader.getTempo().setValue(tGMeasureHeader2 == null ? n3 : tGMeasureHeader2.getTempo().getValue());
            tGMeasureHeader.setTripletFeel(n4);
            this.readTrackMeasures(tGSong, tGMeasureHeader, lArray);
            tGMeasureHeader2 = tGMeasureHeader;
        }
        TGSongManager tGSongManager = new TGSongManager(this.getFactory());
        tGSongManager.setSong(tGSong);
        tGSongManager.autoCompleteSilences();
        return tGSong;
    }

    private void readInfo(TGSong tGSong) throws IOException {
        tGSong.setName(this.readStringByteSizeOfByte());
        tGSong.setAuthor(this.readStringByteSizeOfByte());
        this.readStringByteSizeOfByte();
    }

    private TGDuration readDuration() throws IOException {
        TGDuration tGDuration = this.getFactory().newDuration();
        tGDuration.setValue((int)(Math.pow(2.0, this.readByte() + 4) / 4.0));
        return tGDuration;
    }

    private void readTrackMeasures(TGSong tGSong, TGMeasureHeader tGMeasureHeader, long[] lArray) throws IOException {
        int n;
        this.readTimeSignature(tGMeasureHeader.getTimeSignature());
        this.skip(6);
        int[] nArray = new int[8];
        for (n = 0; n < 8; ++n) {
            this.readUnsignedByte();
            this.readUnsignedByte();
            nArray[n] = this.readUnsignedByte();
            this.skip(9);
        }
        this.skip(2);
        n = this.readUnsignedByte();
        tGMeasureHeader.setRepeatOpen((n & 1) != 0);
        if ((n & 2) != 0) {
            tGMeasureHeader.setRepeatClose(this.readUnsignedByte());
        }
        if ((n & 4) != 0) {
            tGMeasureHeader.setRepeatAlternative(this.parseRepeatAlternative(tGSong, tGMeasureHeader.getNumber(), this.readUnsignedByte()));
        }
        tGSong.addMeasureHeader(tGMeasureHeader);
        for (int i = 0; i < 8; ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            TGMeasure tGMeasure = this.getFactory().newMeasure(tGMeasureHeader);
            long l = tGMeasure.getStart();
            for (int j = 0; j < nArray[i]; ++j) {
                long l2 = this.readBeat(tGTrack, tGMeasure, l, lArray[i]);
                lArray[i] = l;
                l += l2;
            }
            tGTrack.addMeasure(tGMeasure);
        }
    }

    private void readTimeSignature(TGTimeSignature tGTimeSignature) throws IOException {
        tGTimeSignature.setNumerator(this.readUnsignedByte());
        tGTimeSignature.getDenominator().setValue(this.readUnsignedByte());
    }

    private long readBeat(TGTrack tGTrack, TGMeasure tGMeasure, long l, long l2) throws IOException {
        this.readInt();
        TGBeat tGBeat = this.getFactory().newBeat();
        TGDuration tGDuration = this.readDuration();
        TGNoteEffect tGNoteEffect = this.getFactory().newEffect();
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        if ((n2 & 2) != 0) {
            this.readMixChange(tGMeasure.getTempo());
        }
        if ((n2 & 1) != 0) {
            this.readUnsignedByte();
            this.readUnsignedByte();
        }
        tGDuration.setDotted((n & 0x10) != 0);
        if ((n & 0x20) != 0) {
            tGDuration.getTupleto().setEnters(3);
            tGDuration.getTupleto().setTimes(2);
            this.skip(1);
        }
        if ((n & 4) != 0) {
            this.readBeatEffects(tGNoteEffect);
        }
        if ((n & 2) != 0) {
            this.readChord(tGTrack.stringCount(), tGBeat);
        }
        if ((n & 1) != 0) {
            this.readText(tGBeat);
        }
        if ((n & 0x40) != 0) {
            TGBeat tGBeat2;
            if (l2 < l && (tGBeat2 = this.getBeat(tGTrack, tGMeasure, l2)) != null) {
                Iterator iterator = tGBeat2.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNote tGNote = (TGNote)iterator.next();
                    TGNote tGNote2 = this.getFactory().newNote();
                    tGNote2.setValue(tGNote.getValue());
                    tGNote2.setString(tGNote.getString());
                    tGNote2.setVelocity(tGNote.getVelocity());
                    tGNote2.setTiedNote(true);
                    tGBeat.addNote(tGNote2);
                }
            }
        } else if ((n & 8) == 0) {
            int n3 = this.readUnsignedByte();
            int n4 = this.readUnsignedByte();
            int n5 = this.readUnsignedByte();
            for (int i = 5; i >= 0; --i) {
                if ((n3 & 1 << i) != 0) {
                    TGNote tGNote = this.getFactory().newNote();
                    int n6 = this.readUnsignedByte();
                    int n7 = this.readUnsignedByte();
                    if ((n4 & 1 << i) != 0) {
                        this.readNoteEffects(tGNoteEffect);
                    }
                    tGNote.setValue(n6 >= 0 && n6 < 100 ? n6 : 0);
                    tGNote.setVelocity(15 + 16 * n7 - 16);
                    tGNote.setString(tGTrack.stringCount() - i);
                    tGNote.setEffect(tGNoteEffect.clone(this.getFactory()));
                    tGNote.getEffect().setDeadNote(n6 < 0 || n6 >= 100);
                    tGBeat.addNote(tGNote);
                }
                if ((n5 & 1 << i) == 0) continue;
                this.readGraceNote();
            }
        }
        tGBeat.setStart(l);
        tGDuration.copy(tGBeat.getDuration());
        tGMeasure.addBeat(tGBeat);
        return tGDuration.getTime();
    }

    private void readText(TGBeat tGBeat) throws IOException {
        TGText tGText = this.getFactory().newText();
        tGText.setValue(this.readStringByte(0));
        tGBeat.setText(tGText);
    }

    private void readBeatEffects(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        tGNoteEffect.setVibrato(n == 1 || n == 2);
        tGNoteEffect.setFadeIn(n == 4);
        tGNoteEffect.setTapping(n == 5);
        tGNoteEffect.setSlapping(n == 6);
        tGNoteEffect.setPopping(n == 7);
        if (n == 3) {
            this.readBend(tGNoteEffect);
        } else if (n == 8 || n == 9) {
            TGEffectHarmonic tGEffectHarmonic = this.getFactory().newEffectHarmonic();
            tGEffectHarmonic.setType(n == 8 ? 1 : 2);
            tGEffectHarmonic.setData(0);
            tGNoteEffect.setHarmonic(tGEffectHarmonic);
        }
    }

    private void readNoteEffects(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        tGNoteEffect.setHammer(n == 1 || n == 2);
        tGNoteEffect.setSlide(n == 3 || n == 4);
        if (n == 5 || n == 6) {
            this.readBend(tGNoteEffect);
        }
    }

    private void readBend(TGNoteEffect tGNoteEffect) throws IOException {
        this.skip(6);
        int n = Math.max(this.readUnsignedByte() / 8 - 26, 1);
        TGEffectBend tGEffectBend = this.getFactory().newEffectBend();
        tGEffectBend.addPoint(0, 0);
        tGEffectBend.addPoint(6, n * 1);
        tGEffectBend.addPoint(12, n * 1);
        tGNoteEffect.setBend(tGEffectBend);
        this.skip(1);
    }

    private void readGraceNote() throws IOException {
        byte[] byArray = new byte[3];
        this.read(byArray);
    }

    private void readTrack(TGTrack tGTrack) throws IOException {
        tGTrack.getChannel().setInstrument((short)this.readInt());
        this.readInt();
        tGTrack.setName(this.readStringByteSizeOfByte());
        tGTrack.getChannel().setSolo(this.readBoolean());
        tGTrack.getChannel().setVolume((short)this.readInt());
        tGTrack.getChannel().setBalance((short)this.readInt());
        tGTrack.getChannel().setChorus((short)this.readInt());
        tGTrack.getChannel().setReverb((short)this.readInt());
        tGTrack.setOffset(this.readInt());
    }

    private void readChord(int n, TGBeat tGBeat) throws IOException {
        TGChord tGChord = this.getFactory().newChord(n);
        tGChord.setName(this.readStringByte(0));
        this.skip(1);
        int n2 = this.readInt();
        if (n2 <= 11 && n2 >= 0) {
            this.skip(32);
        }
        tGChord.setFirstFret(this.readInt());
        if (tGChord.getFirstFret() != 0) {
            for (int i = 0; i < 6; ++i) {
                int n3 = this.readInt();
                if (i >= tGChord.countStrings()) continue;
                tGChord.addFretValue(i, n3);
            }
        }
        if (tGChord.countNotes() > 0) {
            tGBeat.setChord(tGChord);
        }
    }

    private void readMixChange(TGTempo tGTempo) throws IOException {
        int n = this.readUnsignedByte();
        if ((n & 0x20) != 0) {
            tGTempo.setValue(this.readInt());
            this.readUnsignedByte();
        }
        if ((n & 0x10) != 0) {
            this.readUnsignedByte();
            this.readUnsignedByte();
        }
        if ((n & 8) != 0) {
            this.readUnsignedByte();
            this.readUnsignedByte();
        }
        if ((n & 4) != 0) {
            this.readUnsignedByte();
            this.readUnsignedByte();
        }
        if ((n & 2) != 0) {
            this.readUnsignedByte();
            this.readUnsignedByte();
        }
        if ((n & 1) != 0) {
            this.readUnsignedByte();
        }
    }

    private int parseRepeatAlternative(TGSong tGSong, int n, int n2) {
        TGMeasureHeader tGMeasureHeader;
        int n3 = 0;
        int n4 = 0;
        Iterator iterator = tGSong.getMeasureHeaders();
        while (iterator.hasNext() && (tGMeasureHeader = (TGMeasureHeader)iterator.next()).getNumber() != n) {
            if (tGMeasureHeader.isRepeatOpen()) {
                n4 = 0;
            }
            n4 |= tGMeasureHeader.getRepeatAlternative();
        }
        for (int i = 0; i < 8; ++i) {
            if (n2 <= i || (n4 & 1 << i) != 0) continue;
            n3 |= 1 << i;
        }
        return n3;
    }

    private TGBeat getBeat(TGTrack tGTrack, TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat == null) {
            for (int i = tGTrack.countMeasures() - 1; i >= 0 && (tGBeat = this.getBeat(tGTrack.getMeasure(i), l)) == null; --i) {
            }
        }
        return tGBeat;
    }

    private TGBeat getBeat(TGMeasure tGMeasure, long l) {
        if (l >= tGMeasure.getStart() && l < tGMeasure.getStart() + tGMeasure.getLength()) {
            Iterator iterator = tGMeasure.getBeats().iterator();
            while (iterator.hasNext()) {
                TGBeat tGBeat = (TGBeat)iterator.next();
                if (tGBeat.getStart() != l) continue;
                return tGBeat;
            }
        }
        return null;
    }
}

