/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class XML2Bookmarks
extends AbstractTool {
    static {
        XML2Bookmarks.addVersion("$Id: XML2Bookmarks.java,v 1.3 2006/08/24 10:51:06 blowagie Exp $");
    }

    public XML2Bookmarks() {
        this.arguments.add(new FileArgument((AbstractTool)this, "xmlfile", "the bookmarks in XML", false));
        this.arguments.add(new FileArgument(this, "pdffile", "the PDF to which you want to add bookmarks", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "the resulting PDF", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("XML + PDF = PDF", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== XML2Bookmarks OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("xmlfile") == null) {
                throw new InstantiationException("You need to choose an xml file");
            }
            if (this.getValue("pdffile") == null) {
                throw new InstantiationException("You need to choose a source PDF file");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination PDF file");
            }
            FileInputStream fileInputStream = new FileInputStream((File)this.getValue("xmlfile"));
            List list = SimpleBookmark.importFromXML(fileInputStream);
            fileInputStream.close();
            PdfReader pdfReader = new PdfReader(((File)this.getValue("pdffile")).getAbsolutePath());
            pdfReader.consolidateNamedDestinations();
            PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream((File)this.getValue("destfile")));
            pdfStamper.setOutlines(list);
            pdfStamper.setViewerPreferences(pdfReader.getViewerPreferences() | 0x20);
            pdfStamper.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        XML2Bookmarks xML2Bookmarks = new XML2Bookmarks();
        if (stringArray.length < 3) {
            System.err.println(xML2Bookmarks.getUsage());
        }
        xML2Bookmarks.setArguments(stringArray);
        xML2Bookmarks.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

