/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Anchor;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Header;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.tools.Executable;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class HtmlBookmarks
extends AbstractTool {
    static /* synthetic */ Class class$0;

    static {
        HtmlBookmarks.addVersion("$Id: HtmlBookmarks.java,v 1.12 2005/11/29 21:05:02 blowagie Exp $");
    }

    public HtmlBookmarks() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.arguments.add(new ToolArgument(this, "ownerpassword", "The owner password if the file is encrypt", clazz.getName()));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.arguments.add(new ToolArgument(this, "css", "The path to a CSS file", clazz2.getName()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Html Bookmarks", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Html Bookmarks OPENED ===");
    }

    public void execute() {
        try {
            List list;
            Object v;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            PdfReader pdfReader = this.getValue("ownerpassword") == null ? new PdfReader(file.getAbsolutePath()) : new PdfReader(file.getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            File file2 = file.getParentFile();
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf("."));
            File file3 = new File(file2, String.valueOf(string) + "_index.html");
            Document document = new Document();
            HtmlWriter.getInstance(document, new FileOutputStream(file3));
            Object object = this.getValue("css");
            if (object != null) {
                document.add(new Header("stylesheet", object.toString()));
            }
            if ((v = pdfReader.getInfo().get("Title")) == null) {
                document.addTitle("Index for " + file.getName());
            } else {
                document.addKeywords("Index for '" + v + "'");
            }
            Object v2 = pdfReader.getInfo().get("Keywords");
            if (v2 != null) {
                document.addKeywords((String)v2);
            }
            Object v3 = pdfReader.getInfo().get("Subject");
            if (v2 != null) {
                document.addSubject((String)v3);
            }
            document.open();
            Paragraph paragraph = v == null ? new Paragraph("Index for " + file.getName()) : new Paragraph("Index for '" + v + "'");
            paragraph.setMarkupAttribute("class", "title");
            document.add(paragraph);
            if (v3 != null) {
                list = new Paragraph((String)v3);
                ((Phrase)list).setMarkupAttribute("class", "description");
                document.add((Element)((Object)list));
            }
            if ((list = SimpleBookmark.getBookmark(pdfReader)) == null) {
                document.add(new Paragraph("This document has no bookmarks."));
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    HashMap hashMap = (HashMap)iterator.next();
                    Chapter chapter = (Chapter)HtmlBookmarks.createBookmark(file.getName(), null, hashMap);
                    ArrayList arrayList = (ArrayList)hashMap.get("Kids");
                    if (arrayList != null) {
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            HtmlBookmarks.addBookmark(file.getName(), chapter, (HashMap)iterator2.next());
                        }
                    }
                    document.add(chapter);
                }
            }
            document.close();
            Executable.launchBrowser(file3.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    private static void addBookmark(String string, Section section, HashMap hashMap) {
        Section section2 = HtmlBookmarks.createBookmark(string, section, hashMap);
        ArrayList arrayList = (ArrayList)hashMap.get("Kids");
        if (arrayList == null) {
            return;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            HtmlBookmarks.addBookmark(string, section2, (HashMap)iterator.next());
        }
    }

    private static Section createBookmark(String string, Section section, HashMap hashMap) {
        Paragraph paragraph = new Paragraph((String)hashMap.get("Title"));
        System.out.println((String)hashMap.get("Title"));
        String string2 = (String)hashMap.get("Action");
        if ("GoTo".equals(string2)) {
            if (hashMap.get("Page") != null) {
                String string3 = (String)hashMap.get("Page");
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                String string4 = stringTokenizer.nextToken();
                Anchor anchor = new Anchor(" page" + string4);
                anchor.setReference(String.valueOf(string) + "#page=" + string4);
                paragraph.add(anchor);
            }
        } else if ("URI".equals(string2)) {
            String string5 = (String)hashMap.get("URI");
            Anchor anchor = new Anchor(" Goto URL");
            anchor.setReference(string5);
            paragraph.add(anchor);
        } else if ("GoToR".equals(string2)) {
            String string6 = (String)hashMap.get("File");
            Anchor anchor = new Anchor(" goto " + string6);
            if (hashMap.get("Named") != null) {
                String string7 = (String)hashMap.get("Named");
                string6 = String.valueOf(string6) + "#nameddest=" + string7;
            } else if (hashMap.get("Page") != null) {
                String string8 = (String)hashMap.get("Page");
                StringTokenizer stringTokenizer = new StringTokenizer(string8);
                String string9 = stringTokenizer.nextToken();
                anchor.add(new Chunk(" page " + string9));
                string6 = String.valueOf(string6) + "#page=" + string9;
            }
            anchor.setReference(string6);
            paragraph.add(anchor);
        }
        Section section2 = section == null ? new Chapter(paragraph, 0) : section.addSection(paragraph);
        section2.setNumberDepth(0);
        return section2;
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        HtmlBookmarks htmlBookmarks = new HtmlBookmarks();
        if (stringArray.length < 1) {
            System.err.println(htmlBookmarks.getUsage());
        }
        htmlBookmarks.setArguments(stringArray);
        htmlBookmarks.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }
}

