/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml.xmp;

import com.lowagie.text.xml.xmp.XmpArray;
import java.util.Enumeration;
import java.util.Properties;

public abstract class XmpSchema
extends Properties {
    protected String xmlns;

    public XmpSchema(String string) {
        this.xmlns = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            this.process(stringBuffer, enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    protected void process(StringBuffer stringBuffer, Object object) {
        stringBuffer.append("<");
        stringBuffer.append(object);
        stringBuffer.append(">");
        stringBuffer.append(this.get(object));
        stringBuffer.append("</");
        stringBuffer.append(object);
        stringBuffer.append(">");
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public synchronized Object addProperty(String string, String string2) {
        return this.setProperty(string, string2);
    }

    public synchronized Object setProperty(String string, String string2) {
        return super.setProperty(string, XmpSchema.escape(string2));
    }

    public synchronized Object setProperty(String string, XmpArray xmpArray) {
        return super.setProperty(string, xmpArray.toString());
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(n));
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

