/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.rtf.RtfAddableElement;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfShapeProperty
extends RtfAddableElement {
    public static final String PROPERTY_VERTICIES = "pVerticies";
    public static final String PROPERTY_GEO_TOP = "geoTop";
    public static final String PROPERTY_GEO_LEFT = "geoLeft";
    public static final String PROPERTY_GEO_RIGHT = "geoRight";
    public static final String PROPERTY_GEO_BOTTOM = "geoBottom";
    public static final String PROPERTY_LAYOUT_IN_CELL = "fLayoutInCell";
    public static final String PROPERTY_FLIP_V = "fFlipV";
    public static final String PROPERTY_FLIP_H = "fFlipH";
    public static final String PROPERTY_FILL_COLOR = "fillColor";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    public static final String PROPERTY_ADJUST_VALUE = "adjustValue";
    private static final int PROPERTY_TYPE_LONG = 1;
    private static final int PROPERTY_TYPE_BOOLEAN = 2;
    private static final int PROPERTY_TYPE_DOUBLE = 3;
    private static final int PROPERTY_TYPE_COLOR = 4;
    private static final int PROPERTY_TYPE_ARRAY = 5;
    private int type = 0;
    private String name = "";
    private Object value = null;

    private RtfShapeProperty(String string, Object object) {
        this.name = string;
        this.value = object;
    }

    public RtfShapeProperty(String string, long l) {
        this(string, new Long(l));
        this.type = 1;
    }

    public RtfShapeProperty(String string, double d) {
        this(string, new Double(d));
        this.type = 3;
    }

    public RtfShapeProperty(String string, boolean bl) {
        this(string, new Boolean(bl));
        this.type = 2;
    }

    public RtfShapeProperty(String string, Color color) {
        this(string, (Object)color);
        this.type = 4;
    }

    public RtfShapeProperty(String string, int[] nArray) {
        this(string, (Object)nArray);
        this.type = 5;
    }

    public RtfShapeProperty(String string, Point[] pointArray) {
        this(string, (Object)pointArray);
        this.type = 5;
    }

    public String getName() {
        return this.name;
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write("\\sp".getBytes());
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write("\\sn".getBytes());
            byteArrayOutputStream.write(DELIMITER);
            byteArrayOutputStream.write(this.name.getBytes());
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write("\\sv".getBytes());
            byteArrayOutputStream.write(DELIMITER);
            switch (this.type) {
                case 1: 
                case 3: {
                    byteArrayOutputStream.write(this.value.toString().getBytes());
                    break;
                }
                case 2: {
                    if (((Boolean)this.value).booleanValue()) {
                        byteArrayOutputStream.write("1".getBytes());
                        break;
                    }
                    byteArrayOutputStream.write("0".getBytes());
                    break;
                }
                case 4: {
                    byteArrayOutputStream.write(this.intToByteArray(((Color)this.value).getRGB()));
                    break;
                }
                case 5: {
                    if (this.value instanceof int[]) {
                        int[] nArray = (int[])this.value;
                        byteArrayOutputStream.write("4;".getBytes());
                        byteArrayOutputStream.write(this.intToByteArray(nArray.length));
                        byteArrayOutputStream.write(COMMA_DELIMITER);
                        int n = 0;
                        while (n < nArray.length) {
                            byteArrayOutputStream.write(this.intToByteArray(nArray[n]));
                            if (n < nArray.length - 1) {
                                byteArrayOutputStream.write(COMMA_DELIMITER);
                            }
                            ++n;
                        }
                    } else {
                        if (!(this.value instanceof Point[])) break;
                        Point[] pointArray = (Point[])this.value;
                        byteArrayOutputStream.write("8;".getBytes());
                        byteArrayOutputStream.write(this.intToByteArray(pointArray.length));
                        byteArrayOutputStream.write(COMMA_DELIMITER);
                        int n = 0;
                        while (n < pointArray.length) {
                            byteArrayOutputStream.write("(".getBytes());
                            byteArrayOutputStream.write(this.intToByteArray(pointArray[n].x));
                            byteArrayOutputStream.write(",".getBytes());
                            byteArrayOutputStream.write(this.intToByteArray(pointArray[n].y));
                            byteArrayOutputStream.write(")".getBytes());
                            if (n < pointArray.length - 1) {
                                byteArrayOutputStream.write(COMMA_DELIMITER);
                            }
                            ++n;
                        }
                    }
                    break;
                }
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(CLOSE_GROUP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

