/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.direct;

import com.lowagie.text.DocumentException;
import com.lowagie.text.rtf.direct.RtfColorTableParser;
import com.lowagie.text.rtf.direct.RtfDirectContent;
import com.lowagie.text.rtf.direct.RtfFontTableParser;
import com.lowagie.text.rtf.direct.RtfImportHeader;
import com.lowagie.text.rtf.direct.RtfImportMappings;
import com.lowagie.text.rtf.direct.RtfTokeniser;
import com.lowagie.text.rtf.document.RtfDocument;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class RtfParser {
    private static final int PARSER_IN_HEADER = 0;
    private static final int PARSER_IN_FONT_TABLE = 1;
    private static final int PARSER_IN_COLOR_TABLE = 2;
    private static final int PARSER_IN_INFO_GROUP = 4;
    private static final int PARSER_IN_DOCUMENT = 8;
    private RtfDocument rtfDoc = null;
    private RtfTokeniser tokeniser = null;
    private RtfImportHeader importHeader = null;
    private RtfFontTableParser fontTableParser = null;
    private RtfColorTableParser colorTableParser = null;
    private int state = 0;

    public void importRtfDocument(Reader reader, RtfDocument rtfDocument) throws IOException, DocumentException {
        this.rtfDoc = rtfDocument;
        this.state = 0;
        this.importHeader = new RtfImportHeader(this.rtfDoc);
        this.fontTableParser = new RtfFontTableParser(this.importHeader);
        this.colorTableParser = new RtfColorTableParser(this.importHeader);
        this.tokeniser = new RtfTokeniser(this, 0);
        this.tokeniser.tokenise(reader);
    }

    public void importRtfFragment(Reader reader, RtfDocument rtfDocument, RtfImportMappings rtfImportMappings) throws IOException, DocumentException {
        this.rtfDoc = rtfDocument;
        this.state = 8;
        this.importHeader = new RtfImportHeader(this.rtfDoc);
        this.fontTableParser = new RtfFontTableParser(this.importHeader);
        this.colorTableParser = new RtfColorTableParser(this.importHeader);
        this.handleImportMappings(rtfImportMappings);
        this.tokeniser = new RtfTokeniser(this, 1);
        this.tokeniser.tokenise(reader);
    }

    private void handleImportMappings(RtfImportMappings rtfImportMappings) {
        String string;
        Iterator iterator = rtfImportMappings.getFontMappings().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.importHeader.importFont(string, (String)rtfImportMappings.getFontMappings().get(string));
        }
        iterator = rtfImportMappings.getColorMappings().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.importHeader.importColor(string, (Color)rtfImportMappings.getColorMappings().get(string));
        }
    }

    public void handleOpenGroup(int n) throws DocumentException {
        if (this.state == 8) {
            this.rtfDoc.add(new RtfDirectContent("{"));
        }
    }

    public void handleCloseGroup(int n) throws DocumentException {
        if (this.state == 8 && n > 1) {
            this.rtfDoc.add(new RtfDirectContent("}"));
        } else if (this.state == 4 && n == 2) {
            this.state = 8;
        } else if (this.state == 1) {
            this.fontTableParser.handleCloseGroup(n);
            if (n == 2) {
                this.state = 0;
            }
        } else if (this.state == 2) {
            this.state = 0;
        }
    }

    public void handleCtrlCharacter(String string, int n) throws DocumentException {
        if (this.state == 8) {
            this.rtfDoc.add(new RtfDirectContent(string));
        }
    }

    public void handleCtrlWord(String string, int n) throws DocumentException {
        if (this.state == 8) {
            if (RtfColorTableParser.stringMatches(string, "\\f")) {
                string = "\\f" + this.importHeader.mapFontNr(string.substring(2));
            } else if (RtfColorTableParser.stringMatches(string, "\\cf")) {
                string = "\\cf" + this.importHeader.mapColorNr(string.substring(3));
            } else if (RtfColorTableParser.stringMatches(string, "\\cb")) {
                string = "\\cb" + this.importHeader.mapColorNr(string.substring(3));
            }
            this.rtfDoc.add(new RtfDirectContent(string));
        } else if (this.state == 1) {
            this.fontTableParser.handleCtrlWord(string, n);
        } else if (this.state == 2) {
            this.colorTableParser.handleCtrlWord(string, n);
        } else if (this.state == 0) {
            if (string.equals("\\info")) {
                this.state = 4;
            } else if (string.equals("\\fonttbl")) {
                this.state = 1;
            } else if (string.equals("\\colortbl")) {
                this.state = 2;
            }
        }
    }

    public void handleText(String string, int n) throws DocumentException {
        if (this.state == 8) {
            this.rtfDoc.add(new RtfDirectContent(string));
        } else if (this.state == 1) {
            this.fontTableParser.handleText(string, n);
        } else if (this.state == 2) {
            this.colorTableParser.handleText(string, n);
        }
    }
}

