/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfRow;
import com.lowagie.text.rtf.RtfTable;
import com.lowagie.text.rtf.RtfTableCell;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class RtfCell {
    private static final int MERGE_HORIZ_FIRST = 1;
    private static final int MERGE_VERT_FIRST = 2;
    private static final int MERGE_BOTH_FIRST = 3;
    private static final int MERGE_HORIZ_PREV = 4;
    private static final int MERGE_VERT_PREV = 5;
    private static final int MERGE_BOTH_PREV = 6;
    private static final byte[] cellMergeFirst = "clmgf".getBytes();
    private static final byte[] cellVMergeFirst = "clvmgf".getBytes();
    private static final byte[] cellMergePrev = "clmrg".getBytes();
    private static final byte[] cellVMergePrev = "clvmrg".getBytes();
    private static final byte[] cellVerticalAlignBottom = "clvertalb".getBytes();
    private static final byte[] cellVerticalAlignCenter = "clvertalc".getBytes();
    private static final byte[] cellVerticalAlignTop = "clvertalt".getBytes();
    private static final byte[] cellBorderLeft = "clbrdrl".getBytes();
    private static final byte[] cellBorderRight = "clbrdrr".getBytes();
    private static final byte[] cellBorderTop = "clbrdrt".getBytes();
    private static final byte[] cellBorderBottom = "clbrdrb".getBytes();
    private static final byte[] cellBackgroundColor = "clcbpat".getBytes();
    private static final byte[] cellWidthStyle = "clftsWidth3".getBytes();
    private static final byte[] cellWidthTag = "clwWidth".getBytes();
    private static final byte[] cellRightBorder = "cellx".getBytes();
    protected static final byte[] cellInTable = "intbl".getBytes();
    private static final byte[] cellEnd = "cell".getBytes();
    private static final byte[] cellPaddingTop = "clpadt".getBytes();
    private static final byte[] cellPaddingTopUnit = "clpadft3".getBytes();
    private static final byte[] cellPaddingBottom = "clpadb".getBytes();
    private static final byte[] cellPaddingBottomUnit = "clpadfb3".getBytes();
    private static final byte[] cellPaddingLeft = "clpadl".getBytes();
    private static final byte[] cellPaddingLeftUnit = "clpadfl3".getBytes();
    private static final byte[] cellPaddingRight = "clpadr".getBytes();
    private static final byte[] cellPaddingRightUnit = "clpadfr3".getBytes();
    private RtfWriter writer = null;
    private RtfTable mainTable = null;
    private int cellWidth = 0;
    private int cellRight = 0;
    private Cell store = null;
    private boolean emptyCell = true;
    private int mergeType = 0;
    private int cellpadding = 0;

    public RtfCell(RtfWriter rtfWriter, RtfTable rtfTable) {
        this.writer = rtfWriter;
        this.mainTable = rtfTable;
    }

    public int importCell(Cell cell, int n, int n2, int n3, int n4, int n5) {
        block10: {
            block9: {
                this.cellpadding = n5;
                this.cellWidth = n2;
                if (cell == null) {
                    this.cellRight = n + n2;
                    return this.cellRight;
                }
                if (cell.cellWidth() != null && !cell.cellWidth().equals("")) {
                    this.cellWidth = (int)((double)Integer.parseInt(cell.cellWidth()) * 20.0);
                }
                this.cellRight = n + this.cellWidth;
                this.store = cell;
                this.emptyCell = false;
                if (cell.colspan() <= 1) break block9;
                if (cell.rowspan() > 1) {
                    this.mergeType = 3;
                    int n6 = n4;
                    while (n6 < n4 + cell.rowspan()) {
                        if (n6 > n4) {
                            this.mainTable.setMerge(n3, n6, 5, this);
                        }
                        int n7 = n3 + 1;
                        while (n7 < n3 + cell.colspan()) {
                            this.mainTable.setMerge(n7, n6, 6, this);
                            ++n7;
                        }
                        ++n6;
                    }
                } else {
                    this.mergeType = 1;
                    int n8 = n3 + 1;
                    while (n8 < n3 + cell.colspan()) {
                        this.mainTable.setMerge(n8, n4, 4, this);
                        ++n8;
                    }
                }
                break block10;
            }
            if (cell.rowspan() <= 1) break block10;
            this.mergeType = 2;
            int n9 = n4 + 1;
            while (n9 < n4 + cell.rowspan()) {
                this.mainTable.setMerge(n3, n9, 5, this);
                ++n9;
            }
        }
        return this.cellRight;
    }

    public boolean writeCellSettings(ByteArrayOutputStream byteArrayOutputStream) throws DocumentException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        float f;
        float f2;
        float f3;
        float f4;
        block32: {
            try {
                if (this.store instanceof RtfTableCell) {
                    RtfTableCell rtfTableCell = (RtfTableCell)this.store;
                    f4 = rtfTableCell.leftBorderWidth();
                    f3 = rtfTableCell.topBorderWidth();
                    f2 = rtfTableCell.rightBorderWidth();
                    f = rtfTableCell.bottomBorderWidth();
                    byArray4 = RtfTableCell.getStyleControlWord(rtfTableCell.leftBorderStyle());
                    byArray3 = RtfTableCell.getStyleControlWord(rtfTableCell.topBorderStyle());
                    byArray2 = RtfTableCell.getStyleControlWord(rtfTableCell.rightBorderStyle());
                    byArray = RtfTableCell.getStyleControlWord(rtfTableCell.bottomBorderStyle());
                } else {
                    f2 = f = this.store.borderWidth();
                    f3 = f;
                    f4 = f;
                    byArray = RtfRow.tableBorder;
                    byArray3 = byArray2 = RtfRow.tableBorder;
                    byArray4 = byArray2;
                }
                if (this.mergeType != 4 && this.mergeType != 6) break block32;
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        switch (this.mergeType) {
            case 2: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellVMergeFirst);
                break;
            }
            case 3: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellVMergeFirst);
                break;
            }
            case 4: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellMergePrev);
                break;
            }
            case 5: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellVMergePrev);
                break;
            }
            case 6: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellMergeFirst);
            }
        }
        switch (this.store.verticalAlignment()) {
            case 6: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellVerticalAlignBottom);
                break;
            }
            case 1: 
            case 5: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellVerticalAlignCenter);
                break;
            }
            case 4: {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellVerticalAlignTop);
            }
        }
        if ((this.store.border() & 4) == 4 && f4 > 0.0f) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellBorderLeft);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(byArray4);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfRow.tableBorderWidth);
            this.writeInt(byteArrayOutputStream, (int)((double)f4 * 20.0));
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfRow.tableBorderColor);
            if (this.store.borderColor() == null) {
                this.writeInt(byteArrayOutputStream, this.writer.addColor(new Color(0, 0, 0)));
            } else {
                this.writeInt(byteArrayOutputStream, this.writer.addColor(this.store.borderColor()));
            }
            byteArrayOutputStream.write(10);
        }
        if ((this.store.border() & 1) == 1 && f3 > 0.0f) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellBorderTop);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(byArray3);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfRow.tableBorderWidth);
            this.writeInt(byteArrayOutputStream, (int)((double)f3 * 20.0));
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfRow.tableBorderColor);
            if (this.store.borderColor() == null) {
                this.writeInt(byteArrayOutputStream, this.writer.addColor(new Color(0, 0, 0)));
            } else {
                this.writeInt(byteArrayOutputStream, this.writer.addColor(this.store.borderColor()));
            }
            byteArrayOutputStream.write(10);
        }
        if ((this.store.border() & 2) == 2 && f > 0.0f) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellBorderBottom);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfRow.tableBorderWidth);
            this.writeInt(byteArrayOutputStream, (int)((double)f * 20.0));
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfRow.tableBorderColor);
            if (this.store.borderColor() == null) {
                this.writeInt(byteArrayOutputStream, this.writer.addColor(new Color(0, 0, 0)));
            } else {
                this.writeInt(byteArrayOutputStream, this.writer.addColor(this.store.borderColor()));
            }
            byteArrayOutputStream.write(10);
        }
        if ((this.store.border() & 8) == 8 && f2 > 0.0f) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellBorderRight);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfRow.tableBorderWidth);
            this.writeInt(byteArrayOutputStream, (int)((double)f2 * 20.0));
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfRow.tableBorderColor);
            if (this.store.borderColor() == null) {
                this.writeInt(byteArrayOutputStream, this.writer.addColor(new Color(0, 0, 0)));
            } else {
                this.writeInt(byteArrayOutputStream, this.writer.addColor(this.store.borderColor()));
            }
            byteArrayOutputStream.write(10);
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(cellBackgroundColor);
        if (this.store.backgroundColor() == null) {
            this.writeInt(byteArrayOutputStream, this.writer.addColor(new Color(255, 255, 255)));
        } else {
            this.writeInt(byteArrayOutputStream, this.writer.addColor(this.store.backgroundColor()));
        }
        byteArrayOutputStream.write(10);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(cellWidthStyle);
        byteArrayOutputStream.write(10);
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(cellWidthTag);
        this.writeInt(byteArrayOutputStream, this.cellWidth);
        byteArrayOutputStream.write(10);
        if (this.cellpadding > 0) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellPaddingLeft);
            this.writeInt(byteArrayOutputStream, this.cellpadding / 2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellPaddingTop);
            this.writeInt(byteArrayOutputStream, this.cellpadding / 2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellPaddingRight);
            this.writeInt(byteArrayOutputStream, this.cellpadding / 2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellPaddingBottom);
            this.writeInt(byteArrayOutputStream, this.cellpadding / 2);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellPaddingLeftUnit);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellPaddingTopUnit);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellPaddingRightUnit);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellPaddingBottomUnit);
        }
        byteArrayOutputStream.write(92);
        byteArrayOutputStream.write(cellRightBorder);
        this.writeInt(byteArrayOutputStream, this.cellRight);
        return true;
    }

    public boolean writeCellContent(ByteArrayOutputStream byteArrayOutputStream) throws DocumentException {
        block11: {
            if (this.mergeType != 4 && this.mergeType != 6) break block11;
            return true;
        }
        try {
            if (!this.emptyCell) {
                Iterator iterator = this.store.getElements();
                Paragraph paragraph = null;
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    if (!(element instanceof Paragraph)) {
                        if (paragraph != null) {
                            paragraph.add(element);
                            continue;
                        }
                        paragraph = new Paragraph();
                        paragraph.setAlignment(this.store.horizontalAlignment());
                        paragraph.add(element);
                        continue;
                    }
                    if (paragraph != null) {
                        this.writer.addElement(paragraph, byteArrayOutputStream);
                        paragraph = null;
                        paragraph = null;
                    }
                    if (element instanceof Paragraph && ((Paragraph)element).alignment() == -1) {
                        ((Paragraph)element).setAlignment(this.store.horizontalAlignment());
                    }
                    this.writer.addElement(element, byteArrayOutputStream);
                    if (element.type() != 12 || !iterator.hasNext()) continue;
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(RtfWriter.paragraph);
                }
                if (paragraph != null) {
                    this.writer.addElement(paragraph, byteArrayOutputStream);
                    paragraph = null;
                }
            } else {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(RtfWriter.paragraphDefaults);
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(cellInTable);
            }
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(cellEnd);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void setMerge(int n, RtfCell rtfCell) {
        this.mergeType = n;
        this.store = rtfCell.getStore();
    }

    public Cell getStore() {
        return this.store;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int n) {
        this.cellWidth = n;
    }

    public int getCellRight() {
        return this.cellRight;
    }

    public void setCellRight(int n) {
        this.cellRight = n;
    }

    private void writeInt(ByteArrayOutputStream byteArrayOutputStream, int n) throws IOException {
        byteArrayOutputStream.write(Integer.toString(n).getBytes());
    }
}

