/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.StampContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class PdfStamperImp
extends PdfWriter {
    HashMap readers2intrefs = new HashMap();
    HashMap readers2file = new HashMap();
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected boolean flatFreeText = false;
    protected int[] namePtr = new int[1];
    protected boolean namedAsNames;
    protected List newBookmarks;
    protected HashSet partialFlattening = new HashSet();
    protected boolean useVp = false;
    protected int vp = 0;
    protected HashMap fieldTemplates = new HashMap();
    protected boolean fieldsAdded = false;
    protected int sigFlags = 0;
    protected boolean append;
    protected IntHashtable marked;
    protected int initialXrefSize;
    protected PdfAction openAction;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c, boolean bl) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        this.append = bl;
        if (bl) {
            int n;
            if (pdfReader.isRebuilt()) {
                throw new DocumentException("Append mode requires a document without errors even if recovery was possible.");
            }
            if (pdfReader.isEncrypted()) {
                this.crypto = new PdfEncryption(pdfReader.getDecrypt());
            }
            this.HEADER = PdfStamperImp.getISOBytes("\n");
            this.file.reOpen();
            byte[] byArray = new byte[8192];
            while ((n = this.file.read(byArray)) > 0) {
                this.os.write(byArray, 0, n);
            }
            this.file.close();
            this.prevxref = pdfReader.getLastXref();
            pdfReader.setAppendable(true);
        } else if (c == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c);
        }
        super.open();
        this.pdf.addWriter(this);
        if (bl) {
            this.body.setRefnum(pdfReader.getXrefSize());
            this.marked = new IntHashtable();
            if (pdfReader.isNewXrefType()) {
                this.fullCompression = true;
            }
            if (pdfReader.isHybridXref()) {
                this.fullCompression = false;
            }
        }
        this.initialXrefSize = pdfReader.getXrefSize();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(HashMap var1_1) throws DocumentException, IOException {
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.reader.setViewerPreferences(this.vp);
            this.markUsed(this.reader.getTrailer().get(PdfName.ROOT));
        }
        if (this.flat) {
            this.flatFields();
        }
        if (this.flatFreeText) {
            this.flatFreeTextFields();
        }
        this.addFieldResources();
        var2_2 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (this.acroFields != null && this.acroFields.getXfa().isChanged()) {
            this.markUsed(var2_2);
            if (!this.flat) {
                this.acroFields.getXfa().setXfa(this);
            }
        }
        if (this.sigFlags != 0 && var2_2 != null) {
            var2_2.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
            this.markUsed(var2_2);
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        this.addFileAttachments();
        if (this.openAction != null) {
            this.reader.getCatalog().put(PdfName.OPENACTION, this.openAction);
        }
        if (this.xmpMetadata != null) {
            var3_3 = this.reader.getCatalog();
            var4_4 = new PdfStream(this.xmpMetadata);
            var4_4.put(PdfName.TYPE, PdfName.METADATA);
            var4_4.put(PdfName.SUBTYPE, PdfName.XML);
            var3_3.put(PdfName.METADATA, this.body.add(var4_4).getIndirectReference());
            this.markUsed(var3_3);
        }
        var3_3 = null;
        try {
            block36: {
                this.file.reOpen();
                this.alterContents();
                var3_3 = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
                var4_5 = -1;
                if (var3_3 != null) {
                    var4_5 = var3_3.getNumber();
                }
                var5_7 = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
                if (!this.append) break block36;
                var6_9 = this.marked.getKeys();
                var7_11 = 0;
                if (true) ** GOTO lbl54
            }
            var6_10 = 1;
            if (true) ** GOTO lbl69
            do {
                if ((var9_17 = this.reader.getPdfObjectRelease(var8_14 = var6_9[var7_11])) != null && var4_5 != var8_14 && var8_14 < this.initialXrefSize) {
                    this.addToBody(var9_17, var8_14, var8_14 != var5_7);
                }
                ++var7_11;
lbl54:
                // 2 sources

            } while (var7_11 < ((int[])var6_9).length);
            var7_11 = this.initialXrefSize;
            while (var7_11 < this.reader.getXrefSize()) {
                var8_15 = this.reader.getPdfObject(var7_11);
                if (var8_15 != null) {
                    this.addToBody(var8_15, this.getNewObjectNumber(this.reader, var7_11, 0));
                }
                ++var7_11;
            }
            ** GOTO lbl-1000
            do {
                if ((var7_12 = this.reader.getPdfObjectRelease(var6_10)) != null && var4_5 != var6_10) {
                    this.addToBody(var7_12, this.getNewObjectNumber(this.reader, var6_10, 0), var6_10 != var5_7);
                }
                ++var6_10;
lbl69:
                // 2 sources

            } while (var6_10 < this.reader.getXrefSize());
        }
        catch (Throwable var11_18) {
            var10_20 = null;
            try {
                this.file.close();
                throw var11_18;
            }
            catch (Exception v0) {}
            throw var11_18;
        }
lbl-1000:
        // 2 sources

        {
            var10_21 = null;
        }
        try {}
        catch (Exception v1) {}
        this.file.close();
        var4_6 = null;
        var5_8 = null;
        if (this.crypto != null) {
            if (this.append) {
                var4_6 = this.reader.getCryptoRef();
            } else {
                var6_9 = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
                var4_6 = var6_9.getIndirectReference();
            }
            var5_8 = this.crypto.getFileID();
        }
        var6_9 = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        var7_13 = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, var6_9.getNumber(), 0));
        var8_16 = null;
        var9_17 = (PdfDictionary)PdfReader.getPdfObject(var3_3);
        var10_21 = new PdfDictionary();
        if (var9_17 != null) {
            var11_19 = var9_17.getKeys().iterator();
            while (var11_19.hasNext()) {
                var12_22 = (PdfName)var11_19.next();
                var13_23 = PdfReader.getPdfObject(var9_17.get((PdfName)var12_22));
                var10_21.put((PdfName)var12_22, var13_23);
            }
        }
        if (var1_1 != null) {
            var11_19 = var1_1.keySet().iterator();
            while (var11_19.hasNext()) {
                var12_22 = (String)var11_19.next();
                var13_23 = new PdfName((String)var12_22);
                var14_24 = (String)var1_1.get(var12_22);
                if (var14_24 == null) {
                    var10_21.remove((PdfName)var13_23);
                    continue;
                }
                var10_21.put((PdfName)var13_23, new PdfString(var14_24, "UnicodeBig"));
            }
        }
        if (this.append) {
            var8_16 = var3_3 == null ? this.addToBody((PdfObject)var10_21, false).getIndirectReference() : this.addToBody((PdfObject)var10_21, var3_3.getNumber(), false).getIndirectReference();
        } else if (!var10_21.getKeys().isEmpty()) {
            var8_16 = this.addToBody((PdfObject)var10_21, false).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os, var7_13, var8_16, var4_6, var5_8, this.prevxref);
        if (this.fullCompression) {
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            var11_19 = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), var7_13, var8_16, var4_6, var5_8, this.prevxref);
            var11_19.toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
        this.reader.close();
    }

    void applyRotation(PdfDictionary pdfDictionary, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
        int n = rectangle.getRotation();
        switch (n) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.top());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.right());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.top());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.right());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        Iterator iterator = this.pagesToContent.values().iterator();
        while (iterator.hasNext()) {
            PageStamp pageStamp = (PageStamp)iterator.next();
            PdfDictionary pdfDictionary = pageStamp.pageN;
            this.markUsed(pdfDictionary);
            PdfArray pdfArray = null;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS), pdfDictionary);
            if (pdfObject == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
                this.markUsed(pdfArray);
            } else if (pdfObject.isStream()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfDictionary.get(PdfName.CONTENTS));
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
            try {
                pdfStream.flateCompress();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            pdfArray.addFirst(this.addToBody(pdfStream).getIndirectReference());
            byteBuffer.reset();
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(pdfDictionary, byteBuffer);
                byteBuffer.append(pageStamp.over.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
                pdfStream = new PdfStream(byteBuffer.toByteArray());
                try {
                    pdfStream.flateCompress();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                pdfArray.add(this.addToBody(pdfStream).getIndirectReference());
            }
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        pageStamp.pageN.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        if (intHashtable != null) {
            int n3 = intHashtable.get(n);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                intHashtable.put(n, n3);
            }
            return n3;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append && n < this.initialXrefSize) {
                return n;
            }
            int n4 = this.myXref.get(n);
            if (n4 == 0) {
                n4 = this.getIndirectReferenceNumber();
                this.myXref.put(n, n4);
            }
            return n4;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
            if (randomAccessFileOrArray != null) {
                return randomAccessFileOrArray;
            }
            return pdfReader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    public void registerReader(PdfReader pdfReader, boolean bl) throws IOException {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        if (bl) {
            RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
            this.readers2file.put(pdfReader, randomAccessFileOrArray);
            randomAccessFileOrArray.reOpen();
        }
    }

    public void unRegisterReader(PdfReader pdfReader) {
        if (!this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.remove(pdfReader);
        RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
        if (randomAccessFileOrArray == null) {
            return;
        }
        this.readers2file.remove(pdfReader);
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
    }

    static void findAllObjects(PdfReader pdfReader, PdfObject pdfObject, IntHashtable intHashtable) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                if (pdfReader != pRIndirectReference.getReader()) {
                    return;
                }
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    return;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
                PdfStamperImp.findAllObjects(pdfReader, PdfReader.getPdfObject(pdfObject), intHashtable);
                return;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    PdfStamperImp.findAllObjects(pdfReader, (PdfObject)arrayList.get(n), intHashtable);
                    ++n;
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName = (PdfName)iterator.next();
                    PdfStamperImp.findAllObjects(pdfReader, pdfDictionary.get(pdfName), intHashtable);
                }
                return;
            }
        }
    }

    public void addComments(FdfReader fdfReader) throws IOException {
        PdfObject pdfObject;
        PdfObject pdfObject2;
        PdfObject pdfObject3;
        PdfObject pdfObject4;
        PdfObject pdfObject5;
        if (this.readers2intrefs.containsKey(fdfReader)) {
            return;
        }
        PdfDictionary pdfDictionary = fdfReader.getCatalog();
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FDF))) == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        this.registerReader(fdfReader, false);
        IntHashtable intHashtable = new IntHashtable();
        HashMap<String, PdfObject> hashMap = new HashMap<String, PdfObject>();
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList arrayList2 = pdfArray.getArrayList();
        int n = 0;
        while (n < arrayList2.size()) {
            PdfObject pdfObject6 = (PdfObject)arrayList2.get(n);
            pdfObject5 = (PdfDictionary)PdfReader.getPdfObject(pdfObject6);
            pdfObject4 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject5).get(PdfName.PAGE));
            if (pdfObject4 != null && ((PdfNumber)pdfObject4).intValue() < this.reader.getNumberOfPages()) {
                PdfStamperImp.findAllObjects(fdfReader, pdfObject6, intHashtable);
                arrayList.add(pdfObject6);
                if (pdfObject6.type() == 10 && (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject5).get(PdfName.NM))) != null && pdfObject3.type() == 3) {
                    hashMap.put(pdfObject3.toString(), pdfObject6);
                }
            }
            ++n;
        }
        int[] nArray = intHashtable.getKeys();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            pdfObject4 = fdfReader.getPdfObject(n3);
            if (pdfObject4.type() == 6 && (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.IRT))) != null && pdfObject3.type() == 3 && (pdfObject2 = (PdfObject)hashMap.get(pdfObject3.toString())) != null) {
                pdfObject = new PdfDictionary();
                ((PdfDictionary)pdfObject).merge((PdfDictionary)pdfObject4);
                ((PdfDictionary)pdfObject).put(PdfName.IRT, pdfObject2);
                pdfObject4 = pdfObject;
            }
            this.addToBody(pdfObject4, this.getNewObjectNumber(fdfReader, n3, 0));
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            pdfObject5 = (PdfObject)arrayList.get(n2);
            pdfObject4 = (PdfDictionary)PdfReader.getPdfObject(pdfObject5);
            pdfObject3 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject4).get(PdfName.PAGE));
            pdfObject2 = this.reader.getPageN(((PdfNumber)pdfObject3).intValue() + 1);
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS), pdfObject2);
            if (pdfObject == null) {
                pdfObject = new PdfArray();
                ((PdfDictionary)pdfObject2).put(PdfName.ANNOTS, pdfObject);
                this.markUsed(pdfObject2);
            }
            this.markUsed(pdfObject);
            ((PdfArray)pdfObject).add(pdfObject5);
            ++n2;
        }
    }

    PageStamp getPageStamp(int n) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(pdfDictionary);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, pdfDictionary);
            this.pagesToContent.put(pdfDictionary, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, pageStamp);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, pageStamp);
        }
        return pageStamp.over;
    }

    void correctAcroFieldPages(int n) {
        if (this.acroFields == null) {
            return;
        }
        if (n > this.reader.getNumberOfPages()) {
            return;
        }
        HashMap hashMap = this.acroFields.getFields();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            AcroFields.Item item = (AcroFields.Item)iterator.next();
            ArrayList arrayList = item.page;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                int n3 = (Integer)arrayList.get(n2);
                if (n3 >= n) {
                    arrayList.set(n2, new Integer(n3 + 1));
                }
                ++n2;
            }
        }
    }

    void insertPage(int n, Rectangle rectangle) {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary;
        PRIndirectReference pRIndirectReference;
        PdfObject pdfObject2;
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n2 = rectangle2.getRotation() % 360;
        PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.PAGE);
        PdfDictionary pdfDictionary3 = new PdfDictionary();
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(PdfName.PDF);
        pdfArray.add(PdfName.TEXT);
        pdfArray.add(PdfName.IMAGEB);
        pdfArray.add(PdfName.IMAGEC);
        pdfArray.add(PdfName.IMAGEI);
        pdfDictionary3.put(PdfName.PROCSET, pdfArray);
        pdfDictionary2.put(PdfName.RESOURCES, pdfDictionary3);
        pdfDictionary2.put(PdfName.ROTATE, new PdfNumber(n2));
        pdfDictionary2.put(PdfName.MEDIABOX, new PdfRectangle(rectangle2, n2));
        PRIndirectReference pRIndirectReference2 = this.reader.addPdfObject(pdfDictionary2);
        if (n > this.reader.getNumberOfPages()) {
            pdfObject2 = this.reader.getPageNRelease(this.reader.getNumberOfPages());
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject2).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            ((PdfArray)pdfObject).add(pRIndirectReference2);
            this.markUsed(pdfObject);
            this.reader.pageRefs.insertPage(n, pRIndirectReference2);
        } else {
            if (n < 1) {
                n = 1;
            }
            pdfObject2 = this.reader.getPageN(n);
            pdfObject = this.reader.getPageOrigRef(n);
            this.reader.releasePage(n);
            pRIndirectReference = (PRIndirectReference)((PdfDictionary)pdfObject2).get(PdfName.PARENT);
            pRIndirectReference = new PRIndirectReference(this.reader, pRIndirectReference.getNumber());
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS), pdfDictionary);
            ArrayList arrayList = pdfArray2.getArrayList();
            int n3 = arrayList.size();
            int n4 = ((PdfIndirectReference)pdfObject).getNumber();
            int n5 = 0;
            while (n5 < n3) {
                PRIndirectReference pRIndirectReference3 = (PRIndirectReference)arrayList.get(n5);
                if (n4 == pRIndirectReference3.getNumber()) {
                    arrayList.add(n5, pRIndirectReference2);
                    break;
                }
                ++n5;
            }
            if (n3 == arrayList.size()) {
                throw new RuntimeException("Internal inconsistence.");
            }
            this.markUsed(pdfArray2);
            this.reader.pageRefs.insertPage(n, pRIndirectReference2);
            this.correctAcroFieldPages(n);
        }
        pdfDictionary2.put(PdfName.PARENT, pRIndirectReference);
        while (pdfDictionary != null) {
            this.markUsed(pdfDictionary);
            pdfObject2 = (PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.COUNT));
            pdfDictionary.put(PdfName.COUNT, new PdfNumber(((PdfNumber)pdfObject2).intValue() + 1));
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.PARENT));
        }
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    void setFreeTextFlattening(boolean bl) {
        this.flatFreeText = bl;
    }

    boolean partialFormFlattening(String string) {
        this.getAcroFields();
        if (this.acroFields.getXfa().isXfaPresent()) {
            throw new UnsupportedOperationException("Partial form flattening is not supported with XFA forms.");
        }
        if (!this.acroFields.getFields().containsKey(string)) {
            return false;
        }
        this.partialFlattening.add(string);
        return true;
    }

    void flatFields() {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.append) {
            throw new IllegalArgumentException("Field flattening is not supported in append mode.");
        }
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            object4 = hashMap.keySet().iterator();
            while (object4.hasNext()) {
                this.partialFlattening.add(object4.next());
            }
        }
        object4 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        ArrayList arrayList = null;
        if (object4 != null && (object3 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.FIELDS), (PdfObject)object4)) != null) {
            arrayList = ((PdfArray)object3).getArrayList();
        }
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object2)) continue;
            object = (AcroFields.Item)hashMap.get(object2);
            int n = 0;
            while (n < ((AcroFields.Item)object).merged.size()) {
                PdfObject pdfObject2;
                Object object5;
                Object object6;
                PdfObject pdfObject3;
                PdfDictionary pdfDictionary = (PdfDictionary)((AcroFields.Item)object).merged.get(n);
                pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
                int n2 = 0;
                if (pdfObject != null) {
                    n2 = ((PdfNumber)pdfObject).intValue();
                }
                int n3 = (Integer)((AcroFields.Item)object).page.get(n);
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
                if (pdfDictionary2 != null && (n2 & 4) != 0 && (n2 & 2) == 0) {
                    Object object7;
                    pdfObject3 = pdfDictionary2.get(PdfName.N);
                    object6 = null;
                    if (pdfObject3 != null) {
                        object5 = PdfReader.getPdfObject(pdfObject3);
                        if (pdfObject3 instanceof PdfIndirectReference && !pdfObject3.isIndirect()) {
                            object6 = new PdfAppearance((PdfIndirectReference)pdfObject3);
                        } else if (object5 instanceof PdfStream) {
                            ((PdfDictionary)object5).put(PdfName.SUBTYPE, PdfName.FORM);
                            object6 = new PdfAppearance((PdfIndirectReference)pdfObject3);
                        } else if (((PdfObject)object5).isDictionary() && (object7 = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AS))) != null && (pdfObject2 = (PdfIndirectReference)((PdfDictionary)object5).get((PdfName)object7)) != null) {
                            object6 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                            if (pdfObject2.isIndirect()) {
                                object5 = PdfReader.getPdfObject(pdfObject2);
                                ((PdfDictionary)object5).put(PdfName.SUBTYPE, PdfName.FORM);
                            }
                        }
                    }
                    if (object6 != null) {
                        object5 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT)));
                        object7 = this.getOverContent(n3);
                        ((PdfContentByte)object7).setLiteral("Q ");
                        ((PdfContentByte)object7).addTemplate((PdfTemplate)object6, ((Rectangle)object5).left(), ((Rectangle)object5).bottom());
                        ((PdfContentByte)object7).setLiteral("q ");
                    }
                }
                if (!this.partialFlattening.isEmpty() && (object6 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)(pdfObject3 = this.reader.getPageN(n3))).get(PdfName.ANNOTS))) != null) {
                    object5 = ((PdfArray)object6).getArrayList();
                    int n4 = 0;
                    while (n4 < ((ArrayList)object5).size()) {
                        PdfObject pdfObject4;
                        pdfObject2 = (PdfObject)((ArrayList)object5).get(n4);
                        if (pdfObject2.isIndirect() && (pdfObject4 = (PdfObject)((AcroFields.Item)object).widget_refs.get(n)).isIndirect() && ((PRIndirectReference)pdfObject2).getNumber() == ((PRIndirectReference)pdfObject4).getNumber()) {
                            ((ArrayList)object5).remove(n4--);
                            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject4;
                            while (true) {
                                PdfObject pdfObject5;
                                PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                                PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary3.get(PdfName.PARENT);
                                PdfReader.killIndirect(pRIndirectReference);
                                if (pRIndirectReference2 == null) {
                                    int n5 = 0;
                                    while (n5 < arrayList.size()) {
                                        pdfObject5 = (PdfObject)arrayList.get(n5);
                                        if (pdfObject5.isIndirect() && ((PRIndirectReference)pdfObject5).getNumber() == pRIndirectReference.getNumber()) {
                                            arrayList.remove(n5);
                                            --n5;
                                        }
                                        ++n5;
                                    }
                                    break;
                                }
                                PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                                pdfObject5 = (PdfArray)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.KIDS));
                                ArrayList arrayList2 = ((PdfArray)pdfObject5).getArrayList();
                                int n6 = 0;
                                while (n6 < arrayList2.size()) {
                                    PdfObject pdfObject6 = (PdfObject)arrayList2.get(n6);
                                    if (pdfObject6.isIndirect() && ((PRIndirectReference)pdfObject6).getNumber() == pRIndirectReference.getNumber()) {
                                        arrayList2.remove(n6);
                                        --n6;
                                    }
                                    ++n6;
                                }
                                if (!arrayList2.isEmpty()) break;
                                pRIndirectReference = pRIndirectReference2;
                            }
                        }
                        ++n4;
                    }
                    if (((ArrayList)object5).size() == 0) {
                        PdfReader.killIndirect(((PdfDictionary)pdfObject3).get(PdfName.ANNOTS));
                        ((PdfDictionary)pdfObject3).remove(PdfName.ANNOTS);
                    }
                }
                ++n;
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            int n = 1;
            while (n <= this.reader.getNumberOfPages()) {
                object2 = this.reader.getPageN(n);
                object = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.ANNOTS));
                if (object != null) {
                    ArrayList arrayList3 = ((PdfArray)object).getArrayList();
                    int n7 = 0;
                    while (n7 < arrayList3.size()) {
                        PdfDictionary pdfDictionary;
                        pdfObject = PdfReader.getPdfObject((PdfObject)arrayList3.get(n7));
                        if ((!(pdfObject instanceof PdfIndirectReference) || pdfObject.isIndirect()) && PdfName.WIDGET.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) {
                            arrayList3.remove(n7);
                            --n7;
                        }
                        ++n7;
                    }
                    if (arrayList3.size() == 0) {
                        PdfReader.killIndirect(((PdfDictionary)object2).get(PdfName.ANNOTS));
                        ((PdfDictionary)object2).remove(PdfName.ANNOTS);
                    }
                }
                ++n;
            }
            this.eliminateAcroformObjects();
        }
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        this.reader.killXref(pdfDictionary.get(PdfName.XFA));
        pdfDictionary.remove(PdfName.XFA);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
            PdfReader.killIndirect(pdfObject2);
            pdfDictionary.put(PdfName.FIELDS, new PdfArray());
        }
    }

    void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (pdfObject2 == null || !pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            this.sweepKids((PdfObject)arrayList.get(n));
            ++n;
        }
    }

    private void flatFreeTextFields() {
        if (this.append) {
            throw new IllegalArgumentException("FreeText flattening is not supported in append mode.");
        }
        int n = 1;
        while (n <= this.reader.getNumberOfPages()) {
            block17: {
                PdfDictionary pdfDictionary;
                PdfObject pdfObject;
                PdfDictionary pdfDictionary2 = this.reader.getPageN(n);
                PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS));
                if (pdfArray == null) break block17;
                ArrayList arrayList = pdfArray.getArrayList();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    block18: {
                        block19: {
                            Object object;
                            Object object2;
                            int n3;
                            pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n2));
                            if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect() || !((PdfName)(pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE)).equals(PdfName.FREETEXT)) break block18;
                            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
                            int n4 = n3 = pdfNumber != null ? pdfNumber.intValue() : 0;
                            if ((n3 & 4) == 0 || (n3 & 2) != 0) break block19;
                            PdfObject pdfObject2 = pdfDictionary.get(PdfName.AP);
                            if (pdfObject2 == null) break block18;
                            PdfDictionary pdfDictionary3 = pdfObject2 instanceof PdfIndirectReference ? (PdfDictionary)PdfReader.getPdfObject(pdfObject2) : (PdfDictionary)pdfObject2;
                            PdfObject pdfObject3 = pdfDictionary3.get(PdfName.N);
                            PdfAppearance pdfAppearance = null;
                            PdfObject pdfObject4 = PdfReader.getPdfObject(pdfObject3);
                            if (pdfObject3 instanceof PdfIndirectReference && !pdfObject3.isIndirect()) {
                                pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                            } else if (pdfObject4 instanceof PdfStream) {
                                ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                                pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                            } else if (pdfObject4.isDictionary() && (object2 = (PdfName)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.AS))) != null && (object = (PdfIndirectReference)((PdfDictionary)pdfObject4).get((PdfName)object2)) != null) {
                                pdfAppearance = new PdfAppearance((PdfIndirectReference)object);
                                if (((PdfObject)object).isIndirect()) {
                                    pdfObject4 = PdfReader.getPdfObject((PdfObject)object);
                                    ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                                }
                            }
                            if (pdfAppearance != null) {
                                object2 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT)));
                                object = this.getOverContent(n);
                                ((PdfContentByte)object).setLiteral("Q ");
                                ((PdfContentByte)object).addTemplate(pdfAppearance, ((Rectangle)object2).left(), ((Rectangle)object2).bottom());
                                ((PdfContentByte)object).setLiteral("q ");
                            }
                        }
                        if (this.partialFlattening.size() == 0) {
                            // empty if block
                        }
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < arrayList.size()) {
                    pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n2));
                    if (pdfObject instanceof PdfIndirectReference && pdfObject.isIndirect() && PdfName.FREETEXT.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) {
                        arrayList.remove(n2);
                        --n2;
                    }
                    ++n2;
                }
                if (arrayList.size() == 0) {
                    PdfReader.killIndirect(pdfDictionary2.get(PdfName.ANNOTS));
                    pdfDictionary2.remove(PdfName.ANNOTS);
                }
            }
            ++n;
        }
    }

    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS), pdfDictionary2)) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
            this.markUsed(pdfDictionary2);
        }
        pdfArray.add(pdfIndirectReference);
        this.markUsed(pdfArray);
    }

    void addFieldResources() {
        PdfDictionary pdfDictionary;
        if (this.fieldTemplates.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ACROFORM), pdfDictionary2);
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.ACROFORM, pdfDictionary3);
            this.markUsed(pdfDictionary2);
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR), pdfDictionary3)) == null) {
            pdfDictionary = new PdfDictionary();
            pdfDictionary3.put(PdfName.DR, pdfDictionary);
            this.markUsed(pdfDictionary3);
        }
        this.markUsed(pdfDictionary);
        Object object = this.fieldTemplates.keySet().iterator();
        while (object.hasNext()) {
            PdfTemplate pdfTemplate = (PdfTemplate)object.next();
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)pdfTemplate.getResources(), this);
        }
        object = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONT));
        if (object != null && pdfDictionary3.get(PdfName.DA) == null) {
            pdfDictionary3.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary3);
        }
    }

    void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            int n = 0;
            while (n < arrayList2.size()) {
                this.expandFields((PdfFormField)arrayList2.get(n), arrayList);
                ++n;
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, PdfDictionary pdfDictionary) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            int n = 0;
            while (n < arrayList.size()) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(n);
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    pdfDictionary = this.reader.getPageN(pdfAnnotation.getPlaceInPage());
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS), pdfDictionary);
                    if (object == null) {
                        object = new PdfArray();
                        pdfDictionary.put(PdfName.ANNOTS, (PdfObject)object);
                        this.markUsed(pdfDictionary);
                    }
                    ((PdfArray)object).add(pdfAnnotation.getIndirectReference());
                    this.markUsed((PdfObject)object);
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)) == null || pdfRectangle.left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n2 = this.reader.getPageRotation(pdfDictionary);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(pdfDictionary);
                        switch (n2) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.top() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.top() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.right() - pdfRectangle.left(), rectangle.top() - pdfRectangle.bottom(), rectangle.right() - pdfRectangle.right(), rectangle.top() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.right() - pdfRectangle.left(), pdfRectangle.top(), rectangle.right() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (!pdfAnnotation.isUsed()) {
                    pdfAnnotation.setUsed();
                    this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        this.addAnnotation(pdfAnnotation, this.reader.getPageN(n));
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
        this.markUsed(pdfDictionary);
    }

    void setJavaScript() throws IOException {
        ArrayList arrayList = this.pdf.getDocumentJavaScript();
        if (arrayList.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        String string = String.valueOf(arrayList.size() - 1);
        int n = string.length();
        String string2 = "000000000000000";
        HashMap hashMap = new HashMap();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            string = String.valueOf(n2);
            string = String.valueOf(string2.substring(0, n - string.length())) + string;
            hashMap.put(string, arrayList.get(n2));
            ++n2;
        }
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap, this);
        pdfDictionary2.put(PdfName.JAVASCRIPT, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void addFileAttachments() throws IOException {
        HashMap hashMap = this.pdf.getDocumentFileAttachment();
        if (hashMap.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        HashMap hashMap2 = PdfNameTree.readTree((PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.EMBEDDEDFILES)));
        Object object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n = 0;
            String string2 = string;
            while (hashMap2.containsKey(string2)) {
                string2 = String.valueOf(string2) + " " + ++n;
            }
            hashMap2.put(string2, hashMap.get(string));
        }
        object = PdfNameTree.writeTree(hashMap2, this);
        pdfDictionary2.put(PdfName.EMBEDDEDFILES, this.addToBody((PdfObject)object).getIndirectReference());
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.size() == 0) {
            return;
        }
        this.namedAsNames = this.reader.getCatalog().get(PdfName.DESTS) != null;
        PdfDictionary pdfDictionary = new PdfDictionary();
        PdfIndirectReference pdfIndirectReference = this.getPdfIndirectReference();
        Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference, this.newBookmarks, this.namedAsNames);
        pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
        pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
        pdfDictionary.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
        this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
        this.reader.getCatalog().put(PdfName.OUTLINES, pdfIndirectReference);
        this.markUsed(this.reader.getCatalog());
    }

    void setOutlines(List list) {
        this.newBookmarks = list;
    }

    public void setViewerPreferences(int n) {
        this.useVp = true;
        this.vp |= n;
    }

    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setPageAction(PdfName pdfName, PdfAction pdfAction, int n) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AA), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.AA, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        pdfDictionary2.put(pdfName, pdfAction);
        this.markUsed(pdfDictionary2);
    }

    public void setDuration(int n) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    public void setTransition(PdfTransition pdfTransition) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setDuration(int n, int n2) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        if (n < 0) {
            pdfDictionary.remove(PdfName.DUR);
        } else {
            pdfDictionary.put(PdfName.DUR, new PdfNumber(n));
        }
        this.markUsed(pdfDictionary);
    }

    void setTransition(PdfTransition pdfTransition, int n) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        if (pdfTransition == null) {
            pdfDictionary.remove(PdfName.TRANS);
        } else {
            pdfDictionary.put(PdfName.TRANS, pdfTransition.getTransitionDictionary());
        }
        this.markUsed(pdfDictionary);
    }

    protected void markUsed(PdfObject pdfObject) {
        if (this.append && pdfObject != null) {
            PRIndirectReference pRIndirectReference = null;
            pRIndirectReference = pdfObject.type() == 10 ? (PRIndirectReference)pdfObject : pdfObject.getIndRef();
            if (pRIndirectReference != null) {
                this.marked.put(pRIndirectReference.getNumber(), 1);
            }
        }
    }

    protected void markUsed(int n) {
        if (this.append) {
            this.marked.put(n, 1);
        }
    }

    boolean isAppend() {
        return this.append;
    }

    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.AA));
        if (pdfDictionary == null) {
            if (pdfAction == null) {
                return;
            }
            pdfDictionary = new PdfDictionary();
            this.reader.getCatalog().put(PdfName.AA, pdfDictionary);
        }
        this.markUsed(pdfDictionary);
        if (pdfAction == null) {
            pdfDictionary.remove(pdfName);
        } else {
            pdfDictionary.put(pdfName, pdfAction);
        }
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.openAction = pdfAction;
    }

    public void setOpenAction(String string) {
        throw new UnsupportedOperationException("Open actions by name are not supported.");
    }

    public void setThumbnail(Image image) {
        throw new UnsupportedOperationException("Use PdfStamper.setThumbnail().");
    }

    void setThumbnail(Image image, int n) throws PdfException, DocumentException {
        PdfIndirectReference pdfIndirectReference = this.getImageReference(this.addDirectImageSimple(image));
        this.reader.resetReleasePage();
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        pdfDictionary.put(PdfName.THUMB, pdfIndirectReference);
        this.reader.resetReleasePage();
    }

    public PdfContentByte getDirectContentUnder() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    public PdfContentByte getDirectContent() {
        throw new UnsupportedOperationException("Use PdfStamper.getUnderContent() or PdfStamper.getOverContent()");
    }

    static class PageStamp {
        PdfDictionary pageN;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp pdfStamperImp, PdfReader pdfReader, PdfDictionary pdfDictionary) {
            this.pageN = pdfDictionary;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp.namePtr);
        }
    }
}

