/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PRStream
extends PdfStream {
    protected PdfReader reader;
    protected int offset;
    protected int length;
    protected int objNum = 0;
    protected int objGen = 0;

    public PRStream(PRStream pRStream, PdfDictionary pdfDictionary) {
        this.reader = pRStream.reader;
        this.offset = pRStream.offset;
        this.length = pRStream.length;
        this.compressed = pRStream.compressed;
        this.streamBytes = pRStream.streamBytes;
        this.bytes = pRStream.bytes;
        this.objNum = pRStream.objNum;
        this.objGen = pRStream.objGen;
        if (pdfDictionary != null) {
            this.putAll(pdfDictionary);
        } else {
            this.hashMap.putAll(pRStream.hashMap);
        }
    }

    public PRStream(PRStream pRStream, PdfDictionary pdfDictionary, PdfReader pdfReader) {
        this(pRStream, pdfDictionary);
        this.reader = pdfReader;
    }

    public PRStream(PdfReader pdfReader, int n) {
        this.reader = pdfReader;
        this.offset = n;
    }

    public PRStream(PdfReader pdfReader, byte[] byArray) {
        this.reader = pdfReader;
        this.offset = -1;
        if (Document.compress) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        this.setLength(this.bytes.length);
    }

    public void setData(byte[] byArray) {
        this.remove(PdfName.FILTER);
        this.offset = -1;
        if (Document.compress) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        this.setLength(this.bytes.length);
    }

    public void setLength(int n) {
        this.length = n;
        this.put(PdfName.LENGTH, new PdfNumber(n));
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setObjNum(int n, int n2) {
        this.objNum = n;
        this.objGen = n2;
    }

    int getObjNum() {
        return this.objNum;
    }

    int getObjGen() {
        return this.objGen;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toPdf(PdfWriter var1_1, OutputStream var2_2) throws IOException {
        block17: {
            this.superToPdf(var1_1, var2_2);
            var2_2.write(PRStream.STARTSTREAM);
            if (this.length > 0) {
                var3_3 = null;
                if (var1_1 != null) {
                    var3_3 = var1_1.getEncryption();
                }
                if (this.offset < 0) {
                    if (var3_3 == null) {
                        var2_2.write(this.bytes);
                        break block17;
                    } else {
                        var3_3.prepareKey();
                        var4_4 = new byte[this.length];
                        System.arraycopy(this.bytes, 0, var4_4, 0, this.length);
                        var3_3.encryptRC4(var4_4);
                        var2_2.write(var4_4);
                    }
                } else {
                    var4_5 = new byte[Math.min(this.length, 4092)];
                    var5_6 = var1_1.getReaderFile(this.reader);
                    var6_7 = var5_6.isOpen();
                    try {
                        var5_6.seek(this.offset);
                        var7_8 = this.length;
                        var8_9 = this.reader.getDecrypt();
                        if (var8_9 != null) {
                            var8_9.setHashKey(this.objNum, this.objGen);
                            var8_9.prepareKey();
                        }
                        if (var3_3 != null) {
                            var3_3.prepareKey();
                        }
                        while (var7_8 > 0) {
                            var9_10 = var5_6.read(var4_5, 0, Math.min(var7_8, var4_5.length));
                            var7_8 -= var9_10;
                            if (var8_9 != null) {
                                var8_9.encryptRC4(var4_5, 0, var9_10);
                            }
                            if (var3_3 != null) {
                                var3_3.encryptRC4(var4_5, 0, var9_10);
                            }
                            var2_2.write(var4_5, 0, var9_10);
                        }
                    }
                    catch (Throwable var11_11) {
                        var10_12 = null;
                        if (var6_7 != false) throw var11_11;
                        try {
                            var5_6.close();
                            throw var11_11;
                        }
                        catch (Exception v0) {}
                        throw var11_11;
                    }
                    {
                        var10_13 = null;
                        if (var6_7) break block17;
                    }
                    ** try [egrp 1[TRYBLOCK] [2 : 269->277)] { 
lbl51:
                    // 1 sources

                    var5_6.close();
                }
                break block17;
lbl53:
                // 1 sources

                catch (Exception v1) {}
            }
        }
        var2_2.write(PRStream.ENDSTREAM);
    }
}

