/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodePostnet
extends Barcode {
    static byte[][] BARS;

    static {
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[5];
        byArray[0] = 1;
        byArray[1] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[3] = 1;
        byArray2[4] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[2] = 1;
        byArray3[4] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[2] = 1;
        byArray4[3] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[1] = 1;
        byArray5[4] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[5];
        byArray6[1] = 1;
        byArray6[3] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[1] = 1;
        byArray7[2] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[5];
        byArray8[0] = 1;
        byArray8[4] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[5];
        byArray9[0] = 1;
        byArray9[3] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[5];
        byArray10[0] = 1;
        byArray10[2] = 1;
        byArrayArray[9] = byArray10;
        BARS = byArrayArray;
    }

    public BarcodePostnet() {
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = 7;
    }

    public static byte[] getBarsPostnet(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            n = string.charAt(n3) - 48;
            n2 += n;
            --n3;
        }
        string = String.valueOf(string) + (char)((10 - n2 % 10) % 10 + 48);
        byte[] byArray = new byte[string.length() * 5 + 2];
        byArray[0] = 1;
        byArray[byArray.length - 1] = 1;
        n = 0;
        while (n < string.length()) {
            int n4 = string.charAt(n) - 48;
            System.arraycopy(BARS[n4], 0, byArray, n * 5 + 1, 5);
            ++n;
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        float f = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(f, this.barHeight);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by = 1;
        if (this.codeType == 8) {
            by = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        float f = 0.0f;
        int n = 0;
        while (n < byArray.length) {
            pdfContentByte.rectangle(f, 0.0f, this.x - this.inkSpreading, byArray[n] == by ? this.barHeight : this.size);
            f += this.n;
            ++n;
        }
        pdfContentByte.fill();
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = color.getRGB();
        int n7 = color2.getRGB();
        Canvas canvas = new Canvas();
        int n8 = (int)this.x;
        if (n8 <= 0) {
            n8 = 1;
        }
        if ((n5 = (int)this.n) <= n8) {
            n5 = n8 + 1;
        }
        if ((n4 = (int)this.size) <= 0) {
            n4 = 1;
        }
        if ((n3 = (int)this.barHeight) <= n4) {
            n3 = n4 + 1;
        }
        int n9 = ((this.code.length() + 1) * 5 + 1) * n5 + n8;
        int[] nArray = new int[n9 * n3];
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by = 1;
        if (this.codeType == 8) {
            by = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        int n10 = 0;
        int n11 = 0;
        while (n11 < byArray.length) {
            n2 = byArray[n11] == by ? 1 : 0;
            n = 0;
            while (n < n5) {
                nArray[n10 + n] = n2 != 0 && n < n8 ? n6 : n7;
                ++n;
            }
            n10 += n5;
            ++n11;
        }
        n11 = n9 * (n3 - n4);
        n2 = n9;
        while (n2 < n11) {
            System.arraycopy(nArray, 0, nArray, n2, n9);
            n2 += n9;
        }
        n10 = n11;
        n2 = 0;
        while (n2 < byArray.length) {
            n = 0;
            while (n < n5) {
                nArray[n10 + n] = n < n8 ? n6 : n7;
                ++n;
            }
            n10 += n5;
            ++n2;
        }
        n2 = n11 + n9;
        while (n2 < nArray.length) {
            System.arraycopy(nArray, n11, nArray, n2, n9);
            n2 += n9;
        }
        Image image = canvas.createImage(new MemoryImageSource(n9, n3, nArray, 0, n9));
        return image;
    }
}

