/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Jpeg
extends Image
implements Element {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 74;
        byArray[1] = 70;
        byArray[2] = 73;
        byArray[3] = 70;
        JFIF_ID = byArray;
    }

    Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(URL uRL, float f, float f2) throws BadElementException, IOException {
        this(uRL);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    public Jpeg(String string) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string));
    }

    public Jpeg(String string, float f, float f2) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string), f, f2);
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    public Jpeg(byte[] byArray, float f, float f2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n) {
        int n2 = 0;
        while (n2 < VALID_MARKERS.length) {
            if (n == VALID_MARKERS[n2]) {
                return 0;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < NOPARAM_MARKERS.length) {
            if (n == NOPARAM_MARKERS[n2]) {
                return 2;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < UNSUPPORTED_MARKERS.length) {
            if (n == UNSUPPORTED_MARKERS[n2]) {
                return 1;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        block23: {
            this.type = 32;
            this.originalType = 1;
            InputStream inputStream = null;
            try {
                String string;
                if (this.rawData == null) {
                    inputStream = this.url.openStream();
                    string = this.url.toString();
                } else {
                    inputStream = new ByteArrayInputStream(this.rawData);
                    string = "Byte array";
                }
                if (inputStream.read() != 255) throw new BadElementException(String.valueOf(string) + " is not a valid JPEG-file.");
                if (inputStream.read() != 216) {
                    throw new BadElementException(String.valueOf(string) + " is not a valid JPEG-file.");
                }
                boolean bl = true;
                while (true) {
                    int n;
                    int n2;
                    block24: {
                        int n3;
                        byte[] byArray;
                        int n4;
                        int n5;
                        if ((n5 = inputStream.read()) < 0) {
                            throw new IOException("Premature EOF while reading JPG.");
                        }
                        if (n5 != 255) continue;
                        n2 = inputStream.read();
                        if (bl && n2 == 224) {
                            bl = false;
                            n4 = Jpeg.getShort(inputStream);
                            if (n4 < 16) {
                                Jpeg.skip(inputStream, n4 - 2);
                                continue;
                            }
                            byArray = new byte[JFIF_ID.length];
                            n3 = inputStream.read(byArray);
                            if (n3 != byArray.length) {
                                throw new BadElementException(String.valueOf(string) + " corrupted JFIF marker.");
                            }
                            boolean bl2 = true;
                            int n6 = 0;
                            while (n6 < byArray.length) {
                                if (byArray[n6] != JFIF_ID[n6]) {
                                    bl2 = false;
                                    break;
                                }
                                ++n6;
                            }
                            if (!bl2) {
                                Jpeg.skip(inputStream, n4 - 2 - byArray.length);
                                continue;
                            }
                            Jpeg.skip(inputStream, 2);
                            n6 = inputStream.read();
                            int n7 = Jpeg.getShort(inputStream);
                            int n8 = Jpeg.getShort(inputStream);
                            if (n6 == 1) {
                                this.dpiX = n7;
                                this.dpiY = n8;
                            } else if (n6 == 2) {
                                this.dpiX = (int)((float)n7 * 2.54f + 0.5f);
                                this.dpiY = (int)((float)n8 * 2.54f + 0.5f);
                            }
                            Jpeg.skip(inputStream, n4 - 2 - byArray.length - 7);
                            continue;
                        }
                        if (n2 == 238) {
                            n4 = Jpeg.getShort(inputStream);
                            byArray = new byte[n4];
                            n3 = 0;
                            while (true) {
                                if (n3 >= n4) {
                                    String string2;
                                    if (byArray.length <= 12 || !(string2 = new String(byArray, 0, 5, "ISO-8859-1")).equals("Adobe")) break;
                                    this.invert = true;
                                    break;
                                }
                                byArray[n3] = (byte)inputStream.read();
                                ++n3;
                            }
                        }
                        bl = false;
                        n = Jpeg.marker(n2);
                        if (n != 0) break block24;
                        Jpeg.skip(inputStream, 2);
                        if (inputStream.read() != 8) {
                            throw new BadElementException(String.valueOf(string) + " must have 8 bits per component.");
                        }
                        this.scaledHeight = Jpeg.getShort(inputStream);
                        this.setTop(this.scaledHeight);
                        this.scaledWidth = Jpeg.getShort(inputStream);
                        this.setRight(this.scaledWidth);
                        this.colorspace = inputStream.read();
                        this.bpc = 8;
                        break;
                    }
                    if (n == 1) {
                        throw new BadElementException(String.valueOf(string) + ": unsupported JPEG marker: " + n2);
                    }
                    if (n == 2) continue;
                    Jpeg.skip(inputStream, Jpeg.getShort(inputStream) - 2);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                this.plainWidth = this.width();
                this.plainHeight = this.height();
                throw throwable;
            }
            {
                Object var13_17 = null;
                if (inputStream == null) break block23;
            }
            inputStream.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }
}

