/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.utils;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.plugins.TGPluginConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class MidiConfigUtils {
    public static final String SOUNDBANK_KEY = "soundbank.custom.path";

    public static TGConfigManager getConfig() {
        TGPluginConfigManager tGPluginConfigManager = new TGPluginConfigManager("tuxguitar-jsa");
        tGPluginConfigManager.init();
        return tGPluginConfigManager;
    }

    public static String getSoundbankPath() {
        return MidiConfigUtils.getSoundbankPath(MidiConfigUtils.getConfig());
    }

    public static String getSoundbankPath(TGConfigManager tGConfigManager) {
        return tGConfigManager.getStringConfigValue(SOUNDBANK_KEY);
    }

    public static void setupDialog(Shell shell) {
        MidiConfigUtils.setupDialog(shell, MidiConfigUtils.getConfig());
    }

    public static void setupDialog(Shell shell, final TGConfigManager tGConfigManager) {
        final String string = MidiConfigUtils.getSoundbankPath(tGConfigManager);
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty((String)"jsa.settings.title"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.tip"));
        Button button = new Button((Composite)group, 16);
        button.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.default"));
        button.setSelection(string == null);
        final Button button2 = new Button((Composite)group, 16);
        button2.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.custom"));
        button2.setSelection(string != null);
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        final Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(350, -1));
        text.setText(string == null ? new String() : string);
        Button button3 = new Button(composite, 8);
        button3.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = FileChooser.instance().open(shell2, FileChooser.ALL_FORMATS);
                if (string != null) {
                    text.setText(string);
                }
            }
        });
        Composite composite2 = new Composite((Composite)shell2, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button4 = new Button(composite2, 8);
        button4.setText(TuxGuitar.getProperty((String)"ok"));
        button4.setLayoutData((Object)gridData);
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string2 = button2.getSelection() ? text.getText() : null;
                boolean bl = false;
                bl = string2 == null && string != null;
                bl = bl || string2 != null && string == null;
                boolean bl2 = bl = bl || string2 != null && !string2.equals(string);
                if (bl) {
                    if (string2 != null) {
                        tGConfigManager.setProperty(MidiConfigUtils.SOUNDBANK_KEY, string2);
                    } else {
                        tGConfigManager.removeProperty(MidiConfigUtils.SOUNDBANK_KEY);
                    }
                    tGConfigManager.save();
                    MessageDialog.infoMessage((String)TuxGuitar.getProperty((String)"warning"), (String)TuxGuitar.getProperty((String)"jsa.settings.soundbank-restart-message"));
                }
                shell2.dispose();
            }
        });
        Button button5 = new Button(composite2, 8);
        button5.setText(TuxGuitar.getProperty((String)"cancel"));
        button5.setLayoutData((Object)gridData);
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button4);
        DialogUtils.openDialog((Shell)shell2, (int)11);
    }
}

