/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.midiport;

import javax.sound.midi.MidiChannel;
import org.herac.tuxguitar.player.base.MidiOut;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;

class MidiSynthesizer
implements MidiOut {
    private MidiPortSynthesizer port;
    private MidiChannel[] channels;

    public MidiSynthesizer(MidiPortSynthesizer midiPortSynthesizer) {
        this.port = midiPortSynthesizer;
    }

    private MidiChannel[] getChannels() {
        if (this.channels == null && this.port.getSynthesizer() != null) {
            this.channels = this.port.getSynthesizer().getChannels();
        }
        return this.channels;
    }

    public void sendSystemReset() {
        if (this.getChannels() != null) {
            for (int i = 0; i < this.getChannels().length; ++i) {
                this.getChannels()[i].resetAllControllers();
            }
        }
    }

    public void sendAllNotesOff() {
        if (this.getChannels() != null) {
            for (int i = 0; i < this.getChannels().length; ++i) {
                this.sendControlChange(i, 123, 0);
            }
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        if (this.getChannels() != null && n >= 0 && n < this.getChannels().length) {
            this.getChannels()[n].noteOn(n2, n3);
        }
    }

    public void sendNoteOff(int n, int n2, int n3) {
        if (this.getChannels() != null && n >= 0 && n < this.getChannels().length) {
            this.getChannels()[n].noteOff(n2, n3);
        }
    }

    public void sendControlChange(int n, int n2, int n3) {
        if (this.getChannels() != null && n >= 0 && n < this.getChannels().length) {
            this.getChannels()[n].controlChange(n2, n3);
        }
    }

    public void sendProgramChange(int n, int n2) {
        if (this.getChannels() != null && n >= 0 && n < this.getChannels().length) {
            this.getChannels()[n].programChange(n2);
        }
    }

    public void sendPitchBend(int n, int n2) {
        if (this.getChannels() != null && n >= 0 && n < this.getChannels().length) {
            this.getChannels()[n].setPitchBend(n2 * 128);
        }
    }
}

