/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;

public class LilypondSettingsDialog {
    private static final int STATUS_NONE = 0;
    private static final int STATUS_CANCELLED = 1;
    private static final int STATUS_ACCEPTED = 2;
    protected int status;
    protected LilypondSettings settings = new LilypondSettings();

    public LilypondSettings open() {
        this.status = 0;
        final Shell shell = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)67680);
        shell.setLayout((Layout)new GridLayout());
        shell.setText("Options");
        Group group = new Group((Composite)shell, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)this.getGroupData());
        group.setText("Track options");
        final Label label = new Label((Composite)group, 0);
        label.setText("Export track:");
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 1; i <= TuxGuitar.instance().getSongManager().getSong().countTracks(); ++i) {
            combo.add(TuxGuitar.instance().getSongManager().getTrack(i).getName());
        }
        combo.select(TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber() - 1);
        final Button button = new Button((Composite)group, 32);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 2, 1));
        button.setText("Export all tracks");
        final Button button2 = new Button((Composite)group, 32);
        button2.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 2, 1));
        button2.setText("Export grouped tracks");
        button2.setEnabled(false);
        final Button button3 = new Button((Composite)group, 32);
        button3.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 2, 1));
        button3.setText("Export track names");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                label.setEnabled(!button.getSelection());
                combo.setEnabled(!button.getSelection());
                button2.setEnabled(button.getSelection());
            }
        });
        Group group2 = new Group((Composite)shell, 16);
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setLayoutData((Object)this.getGroupData());
        group2.setText("Measure range");
        final int n = TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders();
        Label label2 = new Label((Composite)group2, 0);
        label2.setText("From");
        final Spinner spinner = new Spinner((Composite)group2, 2048);
        spinner.setLayoutData((Object)this.getSpinnerData());
        spinner.setMaximum(n);
        spinner.setMinimum(1);
        spinner.setSelection(1);
        Label label3 = new Label((Composite)group2, 0);
        label3.setText("To");
        final Spinner spinner2 = new Spinner((Composite)group2, 2048);
        spinner2.setLayoutData((Object)this.getSpinnerData());
        spinner2.setMinimum(1);
        spinner2.setMaximum(n);
        spinner2.setSelection(n);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = spinner.getSelection();
                int n2 = spinner2.getSelection();
                if (n < 1) {
                    spinner.setSelection(1);
                } else if (n > n2) {
                    spinner.setSelection(n2);
                }
            }
        });
        spinner2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n3;
                int n2 = spinner2.getSelection();
                if (n2 < (n3 = spinner.getSelection())) {
                    spinner2.setSelection(n3);
                } else if (n2 > n) {
                    spinner2.setSelection(n);
                }
            }
        });
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button4 = new Button(composite, 8);
        button4.setText(TuxGuitar.getProperty((String)"ok"));
        button4.setLayoutData((Object)gridData);
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LilypondSettingsDialog.this.status = 2;
                LilypondSettingsDialog.this.settings.setTrack(button.getSelection() ? -1 : combo.getSelectionIndex() + 1);
                LilypondSettingsDialog.this.settings.setTrackGroupEnabled(button.getSelection() ? button2.getSelection() : false);
                LilypondSettingsDialog.this.settings.setTrackNameEnabled(button3.getSelection());
                LilypondSettingsDialog.this.settings.setMeasureFrom(spinner.getSelection());
                LilypondSettingsDialog.this.settings.setMeasureTo(spinner2.getSelection());
                shell.dispose();
            }
        });
        Button button5 = new Button(composite, 8);
        button5.setText(TuxGuitar.getProperty((String)"cancel"));
        button5.setLayoutData((Object)gridData);
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LilypondSettingsDialog.this.status = 1;
                shell.dispose();
            }
        });
        shell.setDefaultButton(button4);
        DialogUtils.openDialog((Shell)shell, (int)11);
        return this.status == 2 ? this.settings : null;
    }

    private GridData getSpinnerData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 60;
        return gridData;
    }

    private GridData getGroupData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 300;
        return gridData;
    }
}

