/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;

public class LilypondOutputStream {
    private static final String LILYPOND_VERSION = "2.10.5";
    private static final String[] LILYPOND_SHARP_NOTES = new String[]{"c", "cis", "d", "dis", "e", "f", "fis", "g", "gis", "a", "ais", "b"};
    private static final String[] LILYPOND_FLAT_NOTES = new String[]{"c", "des", "d", "ees", "e", "f", "ges", "g", "aes", "a", "bes", "b"};
    private static final String[] LILYPOND_KEY_SIGNATURES = new String[]{"c", "g", "d", "a", "e", "b", "fis", "cis", "f", "bes", "ees", "aes", "des", "ges", "ces"};
    private static final String INDENT = new String("   ");
    private TGSongManager manager;
    private PrintWriter writer;
    private LilypondSettings settings;
    private LilypondTempData temp;

    public LilypondOutputStream(OutputStream outputStream, LilypondSettings lilypondSettings) {
        this.writer = new PrintWriter(outputStream);
        this.temp = new LilypondTempData();
        this.settings = lilypondSettings;
    }

    public void writeSong(TGSong tGSong) {
        this.manager = new TGSongManager();
        this.manager.setSong(tGSong);
        this.addVersion();
        this.addHeader(tGSong);
        this.addLayout();
        this.addSongDefinitions(tGSong);
        this.addSong(tGSong);
        this.writer.flush();
        this.writer.close();
    }

    private void addVersion() {
        this.writer.println("\\version \"2.10.5\"");
    }

    private void addHeader(TGSong tGSong) {
        this.writer.println("\\header {");
        this.writer.println(this.indent(1) + "title = \"" + tGSong.getName() + "\" ");
        this.writer.println(this.indent(1) + "composer = \"" + tGSong.getAuthor() + "\" ");
        this.writer.println("}");
    }

    private void addLayout() {
        this.writer.println("\\layout {");
        this.writer.println(this.indent(1) + "\\context { \\Score");
        this.writer.println(this.indent(2) + "\\override MetronomeMark #'padding = #'5");
        this.writer.println(this.indent(1) + "}");
        this.writer.println(this.indent(1) + "\\context { \\Staff");
        this.writer.println(this.indent(2) + "\\override TimeSignature #'style = #'numbered");
        this.writer.println(this.indent(2) + "\\override StringNumber #'transparent = ##t");
        this.writer.println(this.indent(1) + "}");
        this.writer.println(this.indent(1) + "\\context { \\TabStaff");
        this.writer.println(this.indent(2) + "\\override TimeSignature #'style = #'numbered");
        this.writer.println(this.indent(2) + "\\override Stem #'transparent = ##t");
        this.writer.println(this.indent(2) + "\\override Beam #'transparent = ##t");
        this.writer.println(this.indent(1) + "}");
        this.writer.println(this.indent(1) + "\\context { \\StaffGroup");
        this.writer.println(this.indent(2) + "\\consists \"Instrument_name_engraver\"");
        this.writer.println(this.indent(1) + "}");
        this.writer.println("}");
    }

    private void addSongDefinitions(TGSong tGSong) {
        for (int i = 0; i < tGSong.countTracks(); ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            String string = this.trackID(tGTrack.getName(), i, "");
            this.addMusic(tGTrack, string);
            this.addStaff(string);
            this.addTabStaff(tGTrack, string);
            this.addStaffGroup(tGTrack, string);
        }
    }

    private void addSong(TGSong tGSong) {
        if (this.settings.isTrackGroupEnabled()) {
            this.writer.println("<<");
        } else {
            this.writer.println("{");
        }
        for (int i = 0; i < tGSong.countTracks(); ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            if (this.settings.getTrack() != -1 && this.settings.getTrack() != tGTrack.getNumber()) continue;
            this.writer.println(this.indent(1) + "\\" + this.trackID(tGTrack.getName(), i, "StaffGroup"));
        }
        if (this.settings.isTrackGroupEnabled()) {
            this.writer.println(">>");
        } else {
            this.writer.println("}");
        }
    }

    private void addMusic(TGTrack tGTrack, String string) {
        this.writer.println(string + "Music = #(define-music-function (parser location inTab) (boolean?)");
        this.writer.println("#{");
        TGMeasure tGMeasure = null;
        int n = tGTrack.countMeasures();
        for (int i = 0; i < n; ++i) {
            TGMeasure tGMeasure2 = tGTrack.getMeasure(i);
            if (this.settings.getMeasureFrom() > tGMeasure2.getNumber() || this.settings.getMeasureTo() < tGMeasure2.getNumber()) continue;
            this.addMeasure(tGMeasure2, tGMeasure, 1, i == n - 1);
            tGMeasure = tGMeasure2;
        }
        this.writer.println("#})");
    }

    private void addStaff(String string) {
        this.writer.println(string + "Staff = \\new Staff {");
        this.writer.println(this.indent(1) + "\\" + string + "Music ##f");
        this.writer.println("}");
    }

    private void addTabStaff(TGTrack tGTrack, String string) {
        this.writer.println(string + "TabStaff = \\new TabStaff {");
        this.addTuning(tGTrack, 1);
        this.writer.println(this.indent(1) + "\\" + string + "Music ##t");
        this.writer.println("}");
    }

    private void addTuning(TGTrack tGTrack, int n) {
        this.writer.print(this.indent(n) + "\\set TabStaff.StringTuning = #'(");
        Iterator iterator = tGTrack.getStrings().iterator();
        while (iterator.hasNext()) {
            TGString tGString = (TGString)iterator.next();
            int n2 = tGString.getValue() - 60;
            this.writer.print(n2 + " ");
        }
        this.writer.println(")");
    }

    private void addStaffGroup(TGTrack tGTrack, String string) {
        this.writer.println(string + "StaffGroup = \\new StaffGroup <<");
        if (this.settings.isTrackNameEnabled()) {
            this.writer.println(this.indent(1) + "\\set StaffGroup.instrumentName = #\"" + tGTrack.getName() + "\"");
        }
        this.writer.println(this.indent(1) + "\\" + string + "Staff");
        this.writer.println(this.indent(1) + "\\" + string + "TabStaff");
        this.writer.println(">>");
    }

    private void addMeasure(TGMeasure tGMeasure, TGMeasure tGMeasure2, int n, boolean bl) {
        if (tGMeasure2 == null || tGMeasure.getTempo().getValue() != tGMeasure2.getTempo().getValue()) {
            this.addTempo(tGMeasure.getTempo(), n);
        }
        if (tGMeasure2 == null || tGMeasure.getClef() != tGMeasure2.getClef()) {
            this.addClef(tGMeasure.getClef(), n);
        }
        if (tGMeasure2 == null || tGMeasure.getKeySignature() != tGMeasure2.getKeySignature()) {
            this.addKeySignature(tGMeasure.getKeySignature(), n);
        }
        if (tGMeasure2 == null || !tGMeasure.getTimeSignature().isEqual(tGMeasure2.getTimeSignature())) {
            this.addTimeSignature(tGMeasure.getTimeSignature(), n);
        }
        if (tGMeasure.isRepeatOpen()) {
            this.addRepeatOpen(n);
        }
        this.addMeasureComponents(tGMeasure, n);
        if (tGMeasure.getRepeatClose() > 0 || bl) {
            this.addRepeatClose(n);
        }
    }

    private void addRepeatOpen(int n) {
        if (this.temp.isRepeatOpen()) {
            this.writer.print(" }");
        }
        this.writer.println(this.indent(n) + "\\repeat volta 2 {");
        this.temp.setRepeatOpen(true);
    }

    private void addRepeatClose(int n) {
        if (this.temp.isRepeatOpen()) {
            this.writer.println(this.indent(n) + "}");
        }
        this.temp.setRepeatOpen(false);
    }

    private void addTempo(TGTempo tGTempo, int n) {
        this.writer.println(this.indent(n) + "\\tempo 4=" + tGTempo.getValue());
    }

    private void addTimeSignature(TGTimeSignature tGTimeSignature, int n) {
        this.writer.println(this.indent(n) + "\\time " + tGTimeSignature.getNumerator() + "/" + tGTimeSignature.getDenominator().getValue());
    }

    private void addKeySignature(int n, int n2) {
        if (n >= 0 && n < LILYPOND_KEY_SIGNATURES.length) {
            this.writer.println(this.indent(n2) + "\\key " + LILYPOND_KEY_SIGNATURES[n] + " \\major");
        }
    }

    private void addClef(int n, int n2) {
        String string = "";
        if (n == 1) {
            string = "treble";
        } else if (n == 2) {
            string = "bass";
        } else if (n == 4) {
            string = "alto";
        } else if (n == 3) {
            string = "tenor";
        }
        if (string != "") {
            this.writer.println(this.indent(n2) + "\\clef #(if $inTab \"tab\" \"" + string + "_8\")");
        }
    }

    private void addMeasureComponents(TGMeasure tGMeasure, int n) {
        this.writer.print(this.indent(n));
        this.addComponents(tGMeasure);
        this.writer.println();
    }

    private void addComponents(TGMeasure tGMeasure) {
        int n = tGMeasure.getKeySignature();
        TGBeat tGBeat = null;
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat2 = tGMeasure.getBeat(i);
            TGTupleto tGTupleto = tGBeat2.getDuration().getTupleto();
            if (tGBeat != null && this.temp.isTupletOpen() && !tGTupleto.isEqual(tGBeat.getDuration().getTupleto())) {
                this.writer.print("} ");
                this.temp.setTupletOpen(false);
            }
            if (!this.temp.isTupletOpen() && !tGTupleto.isEqual(TGTupleto.NORMAL)) {
                this.writer.print("\\times " + tGTupleto.getTimes() + "/" + tGTupleto.getEnters() + " {");
                this.temp.setTupletOpen(true);
            }
            this.addBeat(n, tGBeat2);
            tGBeat = tGBeat2;
        }
        if (this.temp.isTupletOpen()) {
            this.writer.print("} ");
            this.temp.setTupletOpen(false);
        }
    }

    private void addBeat(int n, TGBeat tGBeat) {
        if (tGBeat.isRestBeat()) {
            this.writer.print("r");
            this.addDuration(tGBeat.getDuration());
        } else {
            int n2 = tGBeat.countNotes();
            if (n2 > 1) {
                this.writer.print("<");
            }
            for (int i = 0; i < n2; ++i) {
                TGNote tGNote = tGBeat.getNote(i);
                int n3 = tGNote.getBeat().getMeasure().getTrack().getString(tGNote.getString()).getValue() + tGNote.getValue();
                this.addKey(n, n3);
                if (n2 <= 1) {
                    this.addDuration(tGBeat.getDuration());
                }
                this.addString(tGNote.getString());
                if (this.noteIsTiedTo(tGNote)) {
                    this.writer.print("~");
                }
                if (n2 <= 1) continue;
                this.writer.print(" ");
            }
            if (n2 > 1) {
                this.writer.print(">");
                this.addDuration(tGBeat.getDuration());
            }
            this.writer.print(" ");
        }
    }

    private void addKey(int n, int n2) {
        int n3;
        String[] stringArray = n <= 7 ? LILYPOND_SHARP_NOTES : LILYPOND_FLAT_NOTES;
        this.writer.print(stringArray[n2 % 12]);
        for (n3 = 4; n3 < n2 / 12; ++n3) {
            this.writer.print("'");
        }
        for (n3 = n2 / 12; n3 < 4; ++n3) {
            this.writer.print(",");
        }
    }

    private void addString(int n) {
        this.writer.print("\\" + n);
    }

    private void addDuration(TGDuration tGDuration) {
        this.writer.print(tGDuration.getValue());
        if (tGDuration.isDotted()) {
            this.writer.print(".");
        } else if (tGDuration.isDoubleDotted()) {
            this.writer.print("..");
        }
    }

    private boolean noteIsTiedTo(TGNote tGNote) {
        TGMeasure tGMeasure = tGNote.getBeat().getMeasure();
        TGTrack tGTrack = tGMeasure.getTrack();
        TGNote tGNote2 = null;
        tGNote2 = this.manager.getMeasureManager().getNextNote(tGMeasure, tGNote.getBeat().getStart(), tGNote.getString());
        if (tGNote2 != null) {
            return tGNote2.isTiedNote();
        }
        tGMeasure = this.manager.getTrackManager().getMeasure(tGTrack, tGMeasure.getNumber() + 1);
        if (tGMeasure != null && (tGNote2 = this.manager.getMeasureManager().getNextNote(tGMeasure, tGNote.getBeat().getStart(), tGNote.getString())) != null) {
            return tGNote2.isTiedNote();
        }
        return false;
    }

    private String indent(int n) {
        String string = new String();
        for (int i = 0; i < n; ++i) {
            string = string + INDENT;
        }
        return string;
    }

    private String toBase26(int n) {
        String string = "";
        int n2 = n;
        while (n2 > 25) {
            int n3 = n2 % 26;
            n2 = n2 / 26 - 1;
            string = (char)(n3 + 65) + string;
        }
        string = (char)(n2 + 65) + string;
        return string;
    }

    private String stripNonAscii(String string) {
        return string.replaceAll("[^A-Za-z]+", "");
    }

    private String trackID(String string, int n, String string2) {
        return this.stripNonAscii(string) + this.toBase26(n) + this.stripNonAscii(string2);
    }

    protected class LilypondTempData {
        private boolean repeatOpen = false;
        private boolean tupletOpen = false;

        protected LilypondTempData() {
        }

        public boolean isRepeatOpen() {
            return this.repeatOpen;
        }

        public void setRepeatOpen(boolean bl) {
            this.repeatOpen = bl;
        }

        public boolean isTupletOpen() {
            return this.tupletOpen;
        }

        public void setTupletOpen(boolean bl) {
            this.tupletOpen = bl;
        }
    }
}

