/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import org.herac.tuxguitar.io.midi.base.MidiMessage;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public class MidiMessageUtils {
    public static final byte TICK_MOVE = 1;

    private static int fixValue(int n) {
        int n2 = n;
        n2 = Math.min(n2, 127);
        n2 = Math.max(n2, 0);
        return n2;
    }

    private static int fixChannel(int n) {
        int n2 = n;
        n2 = Math.min(n2, 15);
        n2 = Math.max(n2, 0);
        return n2;
    }

    public static MidiMessage noteOn(int n, int n2, int n3) {
        return MidiMessage.shortMessage(144, MidiMessageUtils.fixChannel(n), MidiMessageUtils.fixValue(n2), MidiMessageUtils.fixValue(n3));
    }

    public static MidiMessage noteOff(int n, int n2, int n3) {
        return MidiMessage.shortMessage(128, MidiMessageUtils.fixChannel(n), MidiMessageUtils.fixValue(n2), MidiMessageUtils.fixValue(n3));
    }

    public static MidiMessage controlChange(int n, int n2, int n3) {
        return MidiMessage.shortMessage(176, MidiMessageUtils.fixChannel(n), MidiMessageUtils.fixValue(n2), MidiMessageUtils.fixValue(n3));
    }

    public static MidiMessage programChange(int n, int n2) {
        return MidiMessage.shortMessage(192, MidiMessageUtils.fixChannel(n), MidiMessageUtils.fixValue(n2));
    }

    public static MidiMessage pitchBend(int n, int n2) {
        return MidiMessage.shortMessage(224, MidiMessageUtils.fixChannel(n), 0, MidiMessageUtils.fixValue(n2));
    }

    public static MidiMessage systemReset() {
        return MidiMessage.shortMessage(255);
    }

    public static MidiMessage tempoInUSQ(int n) {
        MidiMessage midiMessage = new MidiMessage(2, 81);
        midiMessage.setData(new byte[]{(byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)});
        return midiMessage;
    }

    public static MidiMessage timeSignature(TGTimeSignature tGTimeSignature) {
        MidiMessage midiMessage = new MidiMessage(2, 88);
        midiMessage.setData(new byte[]{(byte)tGTimeSignature.getNumerator(), (byte)tGTimeSignature.getDenominator().getIndex(), (byte)(96 / tGTimeSignature.getDenominator().getValue()), 8});
        return midiMessage;
    }

    public static MidiMessage endOfTrack() {
        return MidiMessage.metaMessage(47, new byte[0]);
    }
}

