/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;

public abstract class TGTrack {
    public static final int MAX_OFFSET = 24;
    public static final int MIN_OFFSET = -24;
    private int number = 0;
    private int offset = 0;
    private String name = new String();
    private List measures = new ArrayList();
    private List strings = new ArrayList();
    private TGChannel channel;
    private TGColor color;
    private TGLyric lyrics;
    private TGSong song;

    public TGTrack(TGFactory tGFactory) {
        this.channel = tGFactory.newChannel();
        this.color = tGFactory.newColor();
        this.lyrics = tGFactory.newLyric();
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public Iterator getMeasures() {
        return this.measures.iterator();
    }

    public void addMeasure(TGMeasure tGMeasure) {
        tGMeasure.setTrack(this);
        this.measures.add(tGMeasure);
    }

    public void addMeasure(int n, TGMeasure tGMeasure) {
        tGMeasure.setTrack(this);
        this.measures.add(n, tGMeasure);
    }

    public TGMeasure getMeasure(int n) {
        if (n >= 0 && n < this.countMeasures()) {
            return (TGMeasure)this.measures.get(n);
        }
        return null;
    }

    public void removeMeasure(int n) {
        this.measures.remove(n);
    }

    public int countMeasures() {
        return this.measures.size();
    }

    public TGChannel getChannel() {
        return this.channel;
    }

    public void setChannel(TGChannel tGChannel) {
        this.channel = tGChannel;
    }

    public List getStrings() {
        return this.strings;
    }

    public void setStrings(List list) {
        this.strings = list;
    }

    public TGColor getColor() {
        return this.color;
    }

    public void setColor(TGColor tGColor) {
        this.color = tGColor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public TGLyric getLyrics() {
        return this.lyrics;
    }

    public void setLyrics(TGLyric tGLyric) {
        this.lyrics = tGLyric;
    }

    public TGString getString(int n) {
        return (TGString)this.strings.get(n - 1);
    }

    public int stringCount() {
        return this.strings.size();
    }

    public boolean isPercussionTrack() {
        return this.getChannel().isPercussionChannel();
    }

    public TGSong getSong() {
        return this.song;
    }

    public void setSong(TGSong tGSong) {
        this.song = tGSong;
    }

    public void clear() {
        this.strings.clear();
        this.measures.clear();
    }

    public TGTrack clone(TGFactory tGFactory, TGSong tGSong) {
        TGTrack tGTrack = tGFactory.newTrack();
        this.copy(tGFactory, tGSong, tGTrack);
        return tGTrack;
    }

    public void copy(TGFactory tGFactory, TGSong tGSong, TGTrack tGTrack) {
        Object object;
        int n;
        tGTrack.clear();
        tGTrack.setNumber(this.getNumber());
        tGTrack.setName(this.getName());
        tGTrack.setOffset(this.getOffset());
        this.getChannel().copy(tGTrack.getChannel());
        this.getColor().copy(tGTrack.getColor());
        this.getLyrics().copy(tGTrack.getLyrics());
        for (n = 0; n < this.getStrings().size(); ++n) {
            object = (TGString)this.getStrings().get(n);
            tGTrack.getStrings().add(((TGString)object).clone(tGFactory));
        }
        for (n = 0; n < this.countMeasures(); ++n) {
            object = this.getMeasure(n);
            tGTrack.addMeasure(((TGMeasure)object).clone(tGFactory, tGSong.getMeasureHeader(n)));
        }
    }
}

